<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/telcoautomation/v1/telcoautomation.proto

namespace Google\Cloud\TelcoAutomation\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Blueprint contains a collection of kubernetes resources in the form of
 * YAML files. The file contents of a blueprint are collectively known as
 * package. A blueprint can be
 * a) imported from TNA's public catalog
 * b) modified as per a user's need
 * c) proposed and approved.
 * On approval, a revision of blueprint is created which can be used to
 * create a deployment on Orchestration or Workload Cluster.
 *
 * Generated from protobuf message <code>google.cloud.telcoautomation.v1.Blueprint</code>
 */
class Blueprint extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the blueprint. If unspecified, the name will be autogenerated
     * from server side. Name of the blueprint must not contain `&#64;` character.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. Immutable. The revision ID of the blueprint.
     * A new revision is committed whenever a blueprint is approved.
     *
     * Generated from protobuf field <code>string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_id = '';
    /**
     * Required. Immutable. The public blueprint ID from which this blueprint was
     * created.
     *
     * Generated from protobuf field <code>string source_blueprint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $source_blueprint = '';
    /**
     * Output only. The timestamp that the revision was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $revision_create_time = null;
    /**
     * Output only. Approval state of the blueprint (DRAFT, PROPOSED, APPROVED)
     *
     * Generated from protobuf field <code>.google.cloud.telcoautomation.v1.Blueprint.ApprovalState approval_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $approval_state = 0;
    /**
     * Optional. Human readable name of a Blueprint.
     *
     * Generated from protobuf field <code>string display_name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Output only. Name of the repository where the blueprint files are stored.
     *
     * Generated from protobuf field <code>string repository = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $repository = '';
    /**
     * Optional. Files present in a blueprint.
     * When invoking UpdateBlueprint API, only the modified files should be
     * included in this. Files that are not included in the update of a blueprint
     * will not be changed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.telcoautomation.v1.File files = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $files;
    /**
     * Optional. Labels are key-value attributes that can be set on a blueprint
     * resource by the user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. Blueprint creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the blueprint was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. Source provider is the author of a public blueprint, from
     * which this blueprint is created.
     *
     * Generated from protobuf field <code>string source_provider = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $source_provider = '';
    /**
     * Output only. DeploymentLevel of a blueprint signifies where the blueprint
     * will be applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
     *
     * Generated from protobuf field <code>.google.cloud.telcoautomation.v1.DeploymentLevel deployment_level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $deployment_level = 0;
    /**
     * Output only. Indicates if the deployment created from this blueprint can be
     * rolled back.
     *
     * Generated from protobuf field <code>bool rollback_support = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $rollback_support = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name of the blueprint. If unspecified, the name will be autogenerated
     *           from server side. Name of the blueprint must not contain `&#64;` character.
     *     @type string $revision_id
     *           Output only. Immutable. The revision ID of the blueprint.
     *           A new revision is committed whenever a blueprint is approved.
     *     @type string $source_blueprint
     *           Required. Immutable. The public blueprint ID from which this blueprint was
     *           created.
     *     @type \Google\Protobuf\Timestamp $revision_create_time
     *           Output only. The timestamp that the revision was created.
     *     @type int $approval_state
     *           Output only. Approval state of the blueprint (DRAFT, PROPOSED, APPROVED)
     *     @type string $display_name
     *           Optional. Human readable name of a Blueprint.
     *     @type string $repository
     *           Output only. Name of the repository where the blueprint files are stored.
     *     @type array<\Google\Cloud\TelcoAutomation\V1\File>|\Google\Protobuf\Internal\RepeatedField $files
     *           Optional. Files present in a blueprint.
     *           When invoking UpdateBlueprint API, only the modified files should be
     *           included in this. Files that are not included in the update of a blueprint
     *           will not be changed.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels are key-value attributes that can be set on a blueprint
     *           resource by the user.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Blueprint creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the blueprint was updated.
     *     @type string $source_provider
     *           Output only. Source provider is the author of a public blueprint, from
     *           which this blueprint is created.
     *     @type int $deployment_level
     *           Output only. DeploymentLevel of a blueprint signifies where the blueprint
     *           will be applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
     *     @type bool $rollback_support
     *           Output only. Indicates if the deployment created from this blueprint can be
     *           rolled back.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Telcoautomation\V1\Telcoautomation::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the blueprint. If unspecified, the name will be autogenerated
     * from server side. Name of the blueprint must not contain `&#64;` character.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the blueprint. If unspecified, the name will be autogenerated
     * from server side. Name of the blueprint must not contain `&#64;` character.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Immutable. The revision ID of the blueprint.
     * A new revision is committed whenever a blueprint is approved.
     *
     * Generated from protobuf field <code>string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRevisionId()
    {
        return $this->revision_id;
    }

    /**
     * Output only. Immutable. The revision ID of the blueprint.
     * A new revision is committed whenever a blueprint is approved.
     *
     * Generated from protobuf field <code>string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRevisionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->revision_id = $var;

        return $this;
    }

    /**
     * Required. Immutable. The public blueprint ID from which this blueprint was
     * created.
     *
     * Generated from protobuf field <code>string source_blueprint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getSourceBlueprint()
    {
        return $this->source_blueprint;
    }

    /**
     * Required. Immutable. The public blueprint ID from which this blueprint was
     * created.
     *
     * Generated from protobuf field <code>string source_blueprint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceBlueprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_blueprint = $var;

        return $this;
    }

    /**
     * Output only. The timestamp that the revision was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRevisionCreateTime()
    {
        return $this->revision_create_time;
    }

    public function hasRevisionCreateTime()
    {
        return isset($this->revision_create_time);
    }

    public function clearRevisionCreateTime()
    {
        unset($this->revision_create_time);
    }

    /**
     * Output only. The timestamp that the revision was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp revision_create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRevisionCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->revision_create_time = $var;

        return $this;
    }

    /**
     * Output only. Approval state of the blueprint (DRAFT, PROPOSED, APPROVED)
     *
     * Generated from protobuf field <code>.google.cloud.telcoautomation.v1.Blueprint.ApprovalState approval_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getApprovalState()
    {
        return $this->approval_state;
    }

    /**
     * Output only. Approval state of the blueprint (DRAFT, PROPOSED, APPROVED)
     *
     * Generated from protobuf field <code>.google.cloud.telcoautomation.v1.Blueprint.ApprovalState approval_state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setApprovalState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\TelcoAutomation\V1\Blueprint\ApprovalState::class);
        $this->approval_state = $var;

        return $this;
    }

    /**
     * Optional. Human readable name of a Blueprint.
     *
     * Generated from protobuf field <code>string display_name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. Human readable name of a Blueprint.
     *
     * Generated from protobuf field <code>string display_name = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. Name of the repository where the blueprint files are stored.
     *
     * Generated from protobuf field <code>string repository = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getRepository()
    {
        return $this->repository;
    }

    /**
     * Output only. Name of the repository where the blueprint files are stored.
     *
     * Generated from protobuf field <code>string repository = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRepository($var)
    {
        GPBUtil::checkString($var, True);
        $this->repository = $var;

        return $this;
    }

    /**
     * Optional. Files present in a blueprint.
     * When invoking UpdateBlueprint API, only the modified files should be
     * included in this. Files that are not included in the update of a blueprint
     * will not be changed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.telcoautomation.v1.File files = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFiles()
    {
        return $this->files;
    }

    /**
     * Optional. Files present in a blueprint.
     * When invoking UpdateBlueprint API, only the modified files should be
     * included in this. Files that are not included in the update of a blueprint
     * will not be changed.
     *
     * Generated from protobuf field <code>repeated .google.cloud.telcoautomation.v1.File files = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\TelcoAutomation\V1\File>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFiles($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\TelcoAutomation\V1\File::class);
        $this->files = $arr;

        return $this;
    }

    /**
     * Optional. Labels are key-value attributes that can be set on a blueprint
     * resource by the user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels are key-value attributes that can be set on a blueprint
     * resource by the user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Blueprint creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Blueprint creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the blueprint was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the blueprint was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Source provider is the author of a public blueprint, from
     * which this blueprint is created.
     *
     * Generated from protobuf field <code>string source_provider = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSourceProvider()
    {
        return $this->source_provider;
    }

    /**
     * Output only. Source provider is the author of a public blueprint, from
     * which this blueprint is created.
     *
     * Generated from protobuf field <code>string source_provider = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceProvider($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_provider = $var;

        return $this;
    }

    /**
     * Output only. DeploymentLevel of a blueprint signifies where the blueprint
     * will be applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
     *
     * Generated from protobuf field <code>.google.cloud.telcoautomation.v1.DeploymentLevel deployment_level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDeploymentLevel()
    {
        return $this->deployment_level;
    }

    /**
     * Output only. DeploymentLevel of a blueprint signifies where the blueprint
     * will be applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
     *
     * Generated from protobuf field <code>.google.cloud.telcoautomation.v1.DeploymentLevel deployment_level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDeploymentLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\TelcoAutomation\V1\DeploymentLevel::class);
        $this->deployment_level = $var;

        return $this;
    }

    /**
     * Output only. Indicates if the deployment created from this blueprint can be
     * rolled back.
     *
     * Generated from protobuf field <code>bool rollback_support = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getRollbackSupport()
    {
        return $this->rollback_support;
    }

    /**
     * Output only. Indicates if the deployment created from this blueprint can be
     * rolled back.
     *
     * Generated from protobuf field <code>bool rollback_support = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setRollbackSupport($var)
    {
        GPBUtil::checkBool($var);
        $this->rollback_support = $var;

        return $this;
    }

}

