<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/reports/v1beta/reports.proto

namespace Google\Shopping\Merchant\Reports\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Fields available for query in `best_sellers_product_cluster_view` table.
 * [Best sellers](https://support.google.com/merchants/answer/9488679) report
 * with top product clusters. A product cluster is a grouping for different
 * offers and variants that represent the same product, for example, Google
 * Pixel 7.
 * Values are only set for fields requested explicitly in the request's search
 * query.
 *
 * Generated from protobuf message <code>google.shopping.merchant.reports.v1beta.BestSellersProductClusterView</code>
 */
class BestSellersProductClusterView extends \Google\Protobuf\Internal\Message
{
    /**
     * Report date. The value of this field can only be one of the following:
     * *   The first day of the week (Monday) for weekly reports,
     * *   The first day of the month for monthly reports.
     * Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
     * not specified in the query, the latest available weekly or monthly report
     * is returned.
     *
     * Generated from protobuf field <code>.google.type.Date report_date = 1;</code>
     */
    protected $report_date = null;
    /**
     * Granularity of the report. The ranking can be done over a week or a month
     * timeframe.
     * Required in the `SELECT` clause. Condition on `report_granularity` is
     * required in the `WHERE` clause.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.ReportGranularity.ReportGranularityEnum report_granularity = 2;</code>
     */
    protected $report_granularity = null;
    /**
     * Country where the ranking is calculated. Represented in the ISO 3166
     * format.
     * Required in the `SELECT` clause. Condition on `report_country_code` is
     * required in the `WHERE` clause.
     *
     * Generated from protobuf field <code>optional string report_country_code = 3;</code>
     */
    protected $report_country_code = null;
    /**
     * Google product category ID to calculate the ranking for, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     * Required in the `SELECT` clause. If a `WHERE` condition on
     * `report_category_id` is not specified in the query, rankings for all
     * top-level categories are returned.
     *
     * Generated from protobuf field <code>optional int64 report_category_id = 4;</code>
     */
    protected $report_category_id = null;
    /**
     * Title of the product cluster.
     *
     * Generated from protobuf field <code>optional string title = 6;</code>
     */
    protected $title = null;
    /**
     * Brand of the product cluster.
     *
     * Generated from protobuf field <code>optional string brand = 7;</code>
     */
    protected $brand = null;
    /**
     * Product category (1st level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l1 = 8;</code>
     */
    protected $category_l1 = null;
    /**
     * Product category (2nd level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l2 = 9;</code>
     */
    protected $category_l2 = null;
    /**
     * Product category (3rd level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l3 = 10;</code>
     */
    protected $category_l3 = null;
    /**
     * Product category (4th level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l4 = 11;</code>
     */
    protected $category_l4 = null;
    /**
     * Product category (5th level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l5 = 12;</code>
     */
    protected $category_l5 = null;
    /**
     * GTINs of example variants of the product cluster.
     *
     * Generated from protobuf field <code>repeated string variant_gtins = 13;</code>
     */
    private $variant_gtins;
    /**
     * Whether the product cluster is `IN_STOCK` in your product data source in at
     * least one of the countries, `OUT_OF_STOCK` in your product data source in
     * all countries, or `NOT_IN_INVENTORY` at all.
     * The field doesn't take the Best sellers report country filter into account.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus inventory_status = 14;</code>
     */
    protected $inventory_status = null;
    /**
     * Whether there is at least one product of the brand currently `IN_STOCK` in
     * your product data source in at least one of the countries, all products are
     * `OUT_OF_STOCK` in your product data source in all countries, or
     * `NOT_IN_INVENTORY`.
     * The field doesn't take the Best sellers report country filter into account.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus brand_inventory_status = 15;</code>
     */
    protected $brand_inventory_status = null;
    /**
     * Popularity of the product cluster on Ads and organic surfaces, in the
     * selected category and country, based on the estimated number of units sold.
     *
     * Generated from protobuf field <code>optional int64 rank = 16;</code>
     */
    protected $rank = null;
    /**
     * Popularity rank in the previous week or month.
     *
     * Generated from protobuf field <code>optional int64 previous_rank = 17;</code>
     */
    protected $previous_rank = null;
    /**
     * Estimated demand in relation to the product cluster with the highest
     * popularity rank in the same category and country.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum relative_demand = 18;</code>
     */
    protected $relative_demand = null;
    /**
     * Estimated demand in relation to the product cluster with the highest
     * popularity rank in the same category and country in the previous week or
     * month.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum previous_relative_demand = 19;</code>
     */
    protected $previous_relative_demand = null;
    /**
     * Change in the estimated demand. Whether it rose, sank or remained flat.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemandChangeType.RelativeDemandChangeTypeEnum relative_demand_change = 20;</code>
     */
    protected $relative_demand_change = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Type\Date $report_date
     *           Report date. The value of this field can only be one of the following:
     *           *   The first day of the week (Monday) for weekly reports,
     *           *   The first day of the month for monthly reports.
     *           Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
     *           not specified in the query, the latest available weekly or monthly report
     *           is returned.
     *     @type int $report_granularity
     *           Granularity of the report. The ranking can be done over a week or a month
     *           timeframe.
     *           Required in the `SELECT` clause. Condition on `report_granularity` is
     *           required in the `WHERE` clause.
     *     @type string $report_country_code
     *           Country where the ranking is calculated. Represented in the ISO 3166
     *           format.
     *           Required in the `SELECT` clause. Condition on `report_country_code` is
     *           required in the `WHERE` clause.
     *     @type int|string $report_category_id
     *           Google product category ID to calculate the ranking for, represented in
     *           [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *           Required in the `SELECT` clause. If a `WHERE` condition on
     *           `report_category_id` is not specified in the query, rankings for all
     *           top-level categories are returned.
     *     @type string $title
     *           Title of the product cluster.
     *     @type string $brand
     *           Brand of the product cluster.
     *     @type string $category_l1
     *           Product category (1st level) of the product cluster, represented in
     *           [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l2
     *           Product category (2nd level) of the product cluster, represented in
     *           [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l3
     *           Product category (3rd level) of the product cluster, represented in
     *           [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l4
     *           Product category (4th level) of the product cluster, represented in
     *           [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l5
     *           Product category (5th level) of the product cluster, represented in
     *           [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $variant_gtins
     *           GTINs of example variants of the product cluster.
     *     @type int $inventory_status
     *           Whether the product cluster is `IN_STOCK` in your product data source in at
     *           least one of the countries, `OUT_OF_STOCK` in your product data source in
     *           all countries, or `NOT_IN_INVENTORY` at all.
     *           The field doesn't take the Best sellers report country filter into account.
     *     @type int $brand_inventory_status
     *           Whether there is at least one product of the brand currently `IN_STOCK` in
     *           your product data source in at least one of the countries, all products are
     *           `OUT_OF_STOCK` in your product data source in all countries, or
     *           `NOT_IN_INVENTORY`.
     *           The field doesn't take the Best sellers report country filter into account.
     *     @type int|string $rank
     *           Popularity of the product cluster on Ads and organic surfaces, in the
     *           selected category and country, based on the estimated number of units sold.
     *     @type int|string $previous_rank
     *           Popularity rank in the previous week or month.
     *     @type int $relative_demand
     *           Estimated demand in relation to the product cluster with the highest
     *           popularity rank in the same category and country.
     *     @type int $previous_relative_demand
     *           Estimated demand in relation to the product cluster with the highest
     *           popularity rank in the same category and country in the previous week or
     *           month.
     *     @type int $relative_demand_change
     *           Change in the estimated demand. Whether it rose, sank or remained flat.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Reports\V1Beta\Reports::initOnce();
        parent::__construct($data);
    }

    /**
     * Report date. The value of this field can only be one of the following:
     * *   The first day of the week (Monday) for weekly reports,
     * *   The first day of the month for monthly reports.
     * Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
     * not specified in the query, the latest available weekly or monthly report
     * is returned.
     *
     * Generated from protobuf field <code>.google.type.Date report_date = 1;</code>
     * @return \Google\Type\Date|null
     */
    public function getReportDate()
    {
        return $this->report_date;
    }

    public function hasReportDate()
    {
        return isset($this->report_date);
    }

    public function clearReportDate()
    {
        unset($this->report_date);
    }

    /**
     * Report date. The value of this field can only be one of the following:
     * *   The first day of the week (Monday) for weekly reports,
     * *   The first day of the month for monthly reports.
     * Required in the `SELECT` clause. If a `WHERE` condition on `report_date` is
     * not specified in the query, the latest available weekly or monthly report
     * is returned.
     *
     * Generated from protobuf field <code>.google.type.Date report_date = 1;</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setReportDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->report_date = $var;

        return $this;
    }

    /**
     * Granularity of the report. The ranking can be done over a week or a month
     * timeframe.
     * Required in the `SELECT` clause. Condition on `report_granularity` is
     * required in the `WHERE` clause.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.ReportGranularity.ReportGranularityEnum report_granularity = 2;</code>
     * @return int
     */
    public function getReportGranularity()
    {
        return isset($this->report_granularity) ? $this->report_granularity : 0;
    }

    public function hasReportGranularity()
    {
        return isset($this->report_granularity);
    }

    public function clearReportGranularity()
    {
        unset($this->report_granularity);
    }

    /**
     * Granularity of the report. The ranking can be done over a week or a month
     * timeframe.
     * Required in the `SELECT` clause. Condition on `report_granularity` is
     * required in the `WHERE` clause.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.ReportGranularity.ReportGranularityEnum report_granularity = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setReportGranularity($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\ReportGranularity\ReportGranularityEnum::class);
        $this->report_granularity = $var;

        return $this;
    }

    /**
     * Country where the ranking is calculated. Represented in the ISO 3166
     * format.
     * Required in the `SELECT` clause. Condition on `report_country_code` is
     * required in the `WHERE` clause.
     *
     * Generated from protobuf field <code>optional string report_country_code = 3;</code>
     * @return string
     */
    public function getReportCountryCode()
    {
        return isset($this->report_country_code) ? $this->report_country_code : '';
    }

    public function hasReportCountryCode()
    {
        return isset($this->report_country_code);
    }

    public function clearReportCountryCode()
    {
        unset($this->report_country_code);
    }

    /**
     * Country where the ranking is calculated. Represented in the ISO 3166
     * format.
     * Required in the `SELECT` clause. Condition on `report_country_code` is
     * required in the `WHERE` clause.
     *
     * Generated from protobuf field <code>optional string report_country_code = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setReportCountryCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->report_country_code = $var;

        return $this;
    }

    /**
     * Google product category ID to calculate the ranking for, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     * Required in the `SELECT` clause. If a `WHERE` condition on
     * `report_category_id` is not specified in the query, rankings for all
     * top-level categories are returned.
     *
     * Generated from protobuf field <code>optional int64 report_category_id = 4;</code>
     * @return int|string
     */
    public function getReportCategoryId()
    {
        return isset($this->report_category_id) ? $this->report_category_id : 0;
    }

    public function hasReportCategoryId()
    {
        return isset($this->report_category_id);
    }

    public function clearReportCategoryId()
    {
        unset($this->report_category_id);
    }

    /**
     * Google product category ID to calculate the ranking for, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     * Required in the `SELECT` clause. If a `WHERE` condition on
     * `report_category_id` is not specified in the query, rankings for all
     * top-level categories are returned.
     *
     * Generated from protobuf field <code>optional int64 report_category_id = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setReportCategoryId($var)
    {
        GPBUtil::checkInt64($var);
        $this->report_category_id = $var;

        return $this;
    }

    /**
     * Title of the product cluster.
     *
     * Generated from protobuf field <code>optional string title = 6;</code>
     * @return string
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : '';
    }

    public function hasTitle()
    {
        return isset($this->title);
    }

    public function clearTitle()
    {
        unset($this->title);
    }

    /**
     * Title of the product cluster.
     *
     * Generated from protobuf field <code>optional string title = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Brand of the product cluster.
     *
     * Generated from protobuf field <code>optional string brand = 7;</code>
     * @return string
     */
    public function getBrand()
    {
        return isset($this->brand) ? $this->brand : '';
    }

    public function hasBrand()
    {
        return isset($this->brand);
    }

    public function clearBrand()
    {
        unset($this->brand);
    }

    /**
     * Brand of the product cluster.
     *
     * Generated from protobuf field <code>optional string brand = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setBrand($var)
    {
        GPBUtil::checkString($var, True);
        $this->brand = $var;

        return $this;
    }

    /**
     * Product category (1st level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l1 = 8;</code>
     * @return string
     */
    public function getCategoryL1()
    {
        return isset($this->category_l1) ? $this->category_l1 : '';
    }

    public function hasCategoryL1()
    {
        return isset($this->category_l1);
    }

    public function clearCategoryL1()
    {
        unset($this->category_l1);
    }

    /**
     * Product category (1st level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l1 = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL1($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l1 = $var;

        return $this;
    }

    /**
     * Product category (2nd level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l2 = 9;</code>
     * @return string
     */
    public function getCategoryL2()
    {
        return isset($this->category_l2) ? $this->category_l2 : '';
    }

    public function hasCategoryL2()
    {
        return isset($this->category_l2);
    }

    public function clearCategoryL2()
    {
        unset($this->category_l2);
    }

    /**
     * Product category (2nd level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l2 = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL2($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l2 = $var;

        return $this;
    }

    /**
     * Product category (3rd level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l3 = 10;</code>
     * @return string
     */
    public function getCategoryL3()
    {
        return isset($this->category_l3) ? $this->category_l3 : '';
    }

    public function hasCategoryL3()
    {
        return isset($this->category_l3);
    }

    public function clearCategoryL3()
    {
        unset($this->category_l3);
    }

    /**
     * Product category (3rd level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l3 = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL3($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l3 = $var;

        return $this;
    }

    /**
     * Product category (4th level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l4 = 11;</code>
     * @return string
     */
    public function getCategoryL4()
    {
        return isset($this->category_l4) ? $this->category_l4 : '';
    }

    public function hasCategoryL4()
    {
        return isset($this->category_l4);
    }

    public function clearCategoryL4()
    {
        unset($this->category_l4);
    }

    /**
     * Product category (4th level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l4 = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL4($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l4 = $var;

        return $this;
    }

    /**
     * Product category (5th level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l5 = 12;</code>
     * @return string
     */
    public function getCategoryL5()
    {
        return isset($this->category_l5) ? $this->category_l5 : '';
    }

    public function hasCategoryL5()
    {
        return isset($this->category_l5);
    }

    public function clearCategoryL5()
    {
        unset($this->category_l5);
    }

    /**
     * Product category (5th level) of the product cluster, represented in
     * [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l5 = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL5($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l5 = $var;

        return $this;
    }

    /**
     * GTINs of example variants of the product cluster.
     *
     * Generated from protobuf field <code>repeated string variant_gtins = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVariantGtins()
    {
        return $this->variant_gtins;
    }

    /**
     * GTINs of example variants of the product cluster.
     *
     * Generated from protobuf field <code>repeated string variant_gtins = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVariantGtins($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->variant_gtins = $arr;

        return $this;
    }

    /**
     * Whether the product cluster is `IN_STOCK` in your product data source in at
     * least one of the countries, `OUT_OF_STOCK` in your product data source in
     * all countries, or `NOT_IN_INVENTORY` at all.
     * The field doesn't take the Best sellers report country filter into account.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus inventory_status = 14;</code>
     * @return int
     */
    public function getInventoryStatus()
    {
        return isset($this->inventory_status) ? $this->inventory_status : 0;
    }

    public function hasInventoryStatus()
    {
        return isset($this->inventory_status);
    }

    public function clearInventoryStatus()
    {
        unset($this->inventory_status);
    }

    /**
     * Whether the product cluster is `IN_STOCK` in your product data source in at
     * least one of the countries, `OUT_OF_STOCK` in your product data source in
     * all countries, or `NOT_IN_INVENTORY` at all.
     * The field doesn't take the Best sellers report country filter into account.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus inventory_status = 14;</code>
     * @param int $var
     * @return $this
     */
    public function setInventoryStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\BestSellersProductClusterView\InventoryStatus::class);
        $this->inventory_status = $var;

        return $this;
    }

    /**
     * Whether there is at least one product of the brand currently `IN_STOCK` in
     * your product data source in at least one of the countries, all products are
     * `OUT_OF_STOCK` in your product data source in all countries, or
     * `NOT_IN_INVENTORY`.
     * The field doesn't take the Best sellers report country filter into account.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus brand_inventory_status = 15;</code>
     * @return int
     */
    public function getBrandInventoryStatus()
    {
        return isset($this->brand_inventory_status) ? $this->brand_inventory_status : 0;
    }

    public function hasBrandInventoryStatus()
    {
        return isset($this->brand_inventory_status);
    }

    public function clearBrandInventoryStatus()
    {
        unset($this->brand_inventory_status);
    }

    /**
     * Whether there is at least one product of the brand currently `IN_STOCK` in
     * your product data source in at least one of the countries, all products are
     * `OUT_OF_STOCK` in your product data source in all countries, or
     * `NOT_IN_INVENTORY`.
     * The field doesn't take the Best sellers report country filter into account.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.BestSellersProductClusterView.InventoryStatus brand_inventory_status = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setBrandInventoryStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\BestSellersProductClusterView\InventoryStatus::class);
        $this->brand_inventory_status = $var;

        return $this;
    }

    /**
     * Popularity of the product cluster on Ads and organic surfaces, in the
     * selected category and country, based on the estimated number of units sold.
     *
     * Generated from protobuf field <code>optional int64 rank = 16;</code>
     * @return int|string
     */
    public function getRank()
    {
        return isset($this->rank) ? $this->rank : 0;
    }

    public function hasRank()
    {
        return isset($this->rank);
    }

    public function clearRank()
    {
        unset($this->rank);
    }

    /**
     * Popularity of the product cluster on Ads and organic surfaces, in the
     * selected category and country, based on the estimated number of units sold.
     *
     * Generated from protobuf field <code>optional int64 rank = 16;</code>
     * @param int|string $var
     * @return $this
     */
    public function setRank($var)
    {
        GPBUtil::checkInt64($var);
        $this->rank = $var;

        return $this;
    }

    /**
     * Popularity rank in the previous week or month.
     *
     * Generated from protobuf field <code>optional int64 previous_rank = 17;</code>
     * @return int|string
     */
    public function getPreviousRank()
    {
        return isset($this->previous_rank) ? $this->previous_rank : 0;
    }

    public function hasPreviousRank()
    {
        return isset($this->previous_rank);
    }

    public function clearPreviousRank()
    {
        unset($this->previous_rank);
    }

    /**
     * Popularity rank in the previous week or month.
     *
     * Generated from protobuf field <code>optional int64 previous_rank = 17;</code>
     * @param int|string $var
     * @return $this
     */
    public function setPreviousRank($var)
    {
        GPBUtil::checkInt64($var);
        $this->previous_rank = $var;

        return $this;
    }

    /**
     * Estimated demand in relation to the product cluster with the highest
     * popularity rank in the same category and country.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum relative_demand = 18;</code>
     * @return int
     */
    public function getRelativeDemand()
    {
        return isset($this->relative_demand) ? $this->relative_demand : 0;
    }

    public function hasRelativeDemand()
    {
        return isset($this->relative_demand);
    }

    public function clearRelativeDemand()
    {
        unset($this->relative_demand);
    }

    /**
     * Estimated demand in relation to the product cluster with the highest
     * popularity rank in the same category and country.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum relative_demand = 18;</code>
     * @param int $var
     * @return $this
     */
    public function setRelativeDemand($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\RelativeDemand\RelativeDemandEnum::class);
        $this->relative_demand = $var;

        return $this;
    }

    /**
     * Estimated demand in relation to the product cluster with the highest
     * popularity rank in the same category and country in the previous week or
     * month.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum previous_relative_demand = 19;</code>
     * @return int
     */
    public function getPreviousRelativeDemand()
    {
        return isset($this->previous_relative_demand) ? $this->previous_relative_demand : 0;
    }

    public function hasPreviousRelativeDemand()
    {
        return isset($this->previous_relative_demand);
    }

    public function clearPreviousRelativeDemand()
    {
        unset($this->previous_relative_demand);
    }

    /**
     * Estimated demand in relation to the product cluster with the highest
     * popularity rank in the same category and country in the previous week or
     * month.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemand.RelativeDemandEnum previous_relative_demand = 19;</code>
     * @param int $var
     * @return $this
     */
    public function setPreviousRelativeDemand($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\RelativeDemand\RelativeDemandEnum::class);
        $this->previous_relative_demand = $var;

        return $this;
    }

    /**
     * Change in the estimated demand. Whether it rose, sank or remained flat.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemandChangeType.RelativeDemandChangeTypeEnum relative_demand_change = 20;</code>
     * @return int
     */
    public function getRelativeDemandChange()
    {
        return isset($this->relative_demand_change) ? $this->relative_demand_change : 0;
    }

    public function hasRelativeDemandChange()
    {
        return isset($this->relative_demand_change);
    }

    public function clearRelativeDemandChange()
    {
        unset($this->relative_demand_change);
    }

    /**
     * Change in the estimated demand. Whether it rose, sank or remained flat.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.RelativeDemandChangeType.RelativeDemandChangeTypeEnum relative_demand_change = 20;</code>
     * @param int $var
     * @return $this
     */
    public function setRelativeDemandChange($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\RelativeDemandChangeType\RelativeDemandChangeTypeEnum::class);
        $this->relative_demand_change = $var;

        return $this;
    }

}

