<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/promotions/v1/promotions_common.proto

namespace Google\Shopping\Merchant\Promotions\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Attributes.
 *
 * Generated from protobuf message <code>google.shopping.merchant.promotions.v1.Attributes</code>
 */
class Attributes extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Applicability of the promotion to either all products or
     * [only specific
     * products](https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.ProductApplicability product_applicability = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $product_applicability = 0;
    /**
     * Required.
     * [Type](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
     * of the promotion. Use this attribute to indicate whether or not customers
     * need a coupon code to redeem your promotion.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.OfferType offer_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $offer_type = 0;
    /**
     * Optional. Generic redemption code for the promotion. To be used with the
     * `offerType` field and must meet the [minimum
     * requirements](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>string generic_redemption_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $generic_redemption_code = '';
    /**
     * Required. [Long
     * title](https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string long_title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $long_title = '';
    /**
     * Required. The [coupon value type]
     * (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
     * attribute to signal the type of promotion that you are running. Depending
     * on type of the selected coupon value [some attributes are
     * required](https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.CouponValueType coupon_value_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $coupon_value_type = 0;
    /**
     * Required. The list of destinations (also known as [Marketing
     * methods](https://support.google.com/merchants/answer/15130232)) where the
     * promotion applies to. If you don't specify a destination by including a
     * supported value in your data source, your promotion will display in
     * Shopping ads and free listings by default.
     * You may have previously submitted the following values as destinations for
     * your products: Shopping Actions, Surfaces across Google, Local surfaces
     * across Google.  To represent these values use `FREE_LISTINGS`,
     * `FREE_LOCAL_LISTINGS`, `LOCAL_INVENTORY_ADS`. For more details see
     * [Promotion
     * destination](https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum promotion_destinations = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $promotion_destinations;
    /**
     * Optional. Product filter by [item
     * ID](https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_id_inclusion = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $item_id_inclusion;
    /**
     * Optional. Product filter by brand for the promotion. The product filter
     * attributes only applies when the products eligible for promotion product
     * applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string brand_inclusion = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $brand_inclusion;
    /**
     * Optional. Product filter by item group ID for the promotion. The product
     * filter attributes only applies when the products eligible for promotion
     * product applicability [product_applicability] attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_group_id_inclusion = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $item_group_id_inclusion;
    /**
     * Optional. Product filter by product type for the promotion. The product
     * filter attributes only applies when the products eligible for promotion
     * product applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string product_type_inclusion = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $product_type_inclusion;
    /**
     * Optional. Product filter by [item ID
     * exclusion](https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_id_exclusion = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $item_id_exclusion;
    /**
     * Optional. Product filter by [brand
     * exclusion](https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string brand_exclusion = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $brand_exclusion;
    /**
     * Optional. Product filter by [item group
     * ID](https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
     * The product filter attributes only applies when the products eligible for
     * promotion product applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     * exclusion for the promotion.
     *
     * Generated from protobuf field <code>repeated string item_group_id_exclusion = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $item_group_id_exclusion;
    /**
     * Optional. Product filter by [product type
     * exclusion](https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string product_type_exclusion = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $product_type_exclusion;
    /**
     * Optional. [Minimum purchase
     * amount](https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price minimum_purchase_amount = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $minimum_purchase_amount = null;
    /**
     * Generated from protobuf field <code>int64 minimum_purchase_quantity = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $minimum_purchase_quantity = 0;
    /**
     * Optional. [Maximum purchase
     * quantity](https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>int64 limit_quantity = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $limit_quantity = 0;
    /**
     * Optional. [Maximum product
     * price](https://support.google.com/merchants/answer/2906014) for
     * promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price limit_value = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $limit_value = null;
    /**
     * Optional. The [percentage
     * discount](https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
     * offered in the promotion.
     *
     * Generated from protobuf field <code>int64 percent_off = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $percent_off = 0;
    /**
     * Optional. The [money off
     * amount](https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
     * offered in the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price money_off_amount = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $money_off_amount = null;
    /**
     * Optional. The number of items discounted in the promotion. The attribute is
     * set when `couponValueType` is equal to `buy_m_get_n_money_off` or
     * `buy_m_get_n_percent_off`.
     *
     * Generated from protobuf field <code>int64 get_this_quantity_discounted = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $get_this_quantity_discounted = 0;
    /**
     * Optional. [Free gift
     * value](https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price free_gift_value = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $free_gift_value = null;
    /**
     * Optional. [Free gift
     * description](https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string free_gift_description = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $free_gift_description = '';
    /**
     * Optional. [Free gift item
     * ID](https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string free_gift_item_id = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $free_gift_item_id = '';
    /**
     * Required. `TimePeriod` representation of the promotion's effective dates.
     * This attribute specifies that the promotion can be tested on your online
     * store during this time period.
     *
     * Generated from protobuf field <code>.google.type.Interval promotion_effective_time_period = 25 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $promotion_effective_time_period = null;
    /**
     * Optional. `TimePeriod` representation of the promotion's display dates.
     * This attribute specifies the date and time frame when the promotion will be
     * live on Google.com and Shopping ads. If the display time period for
     * promotion `promotion_display_time_period` attribute is not specified, the
     * promotion effective time period `promotion_effective_time_period`
     * determines the date and time frame when the promotion will be live on
     * Google.com and Shopping ads.
     *
     * Generated from protobuf field <code>.google.type.Interval promotion_display_time_period = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $promotion_display_time_period = null;
    /**
     * Optional. Whether the promotion applies to [all stores, or only specified
     * stores](https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
     * Local Inventory ads promotions throw an error if no store applicability is
     * included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
     * set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion`
     * is set to a value.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.StoreApplicability store_applicability = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $store_applicability = 0;
    /**
     * Optional. [Store codes to
     * include](https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The store filter attributes only applies when the
     * `store_applicability` attribute is set to
     * [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     * Store code (the store ID from
     * your Business Profile) of the physical store the product is sold in. See
     * the [Local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342) for
     * more information.
     *
     * Generated from protobuf field <code>repeated string store_codes_inclusion = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $store_codes_inclusion;
    /**
     * Optional. [Store codes to
     * exclude](https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The store filter attributes only applies when the
     * `store_applicability` attribute is set to
     * [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string store_codes_exclusion = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $store_codes_exclusion;
    /**
     * Optional. URL to the page on the merchant's site where the promotion shows.
     * Local Inventory ads promotions throw an error if no `promotion_url` is
     * included. URL is used to confirm that the promotion is valid and can be
     * redeemed.
     *
     * Generated from protobuf field <code>string promotion_url = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $promotion_url = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $product_applicability
     *           Required. Applicability of the promotion to either all products or
     *           [only specific
     *           products](https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
     *     @type int $offer_type
     *           Required.
     *           [Type](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           of the promotion. Use this attribute to indicate whether or not customers
     *           need a coupon code to redeem your promotion.
     *     @type string $generic_redemption_code
     *           Optional. Generic redemption code for the promotion. To be used with the
     *           `offerType` field and must meet the [minimum
     *           requirements](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type string $long_title
     *           Required. [Long
     *           title](https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion.
     *     @type int $coupon_value_type
     *           Required. The [coupon value type]
     *           (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           attribute to signal the type of promotion that you are running. Depending
     *           on type of the selected coupon value [some attributes are
     *           required](https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $promotion_destinations
     *           Required. The list of destinations (also known as [Marketing
     *           methods](https://support.google.com/merchants/answer/15130232)) where the
     *           promotion applies to. If you don't specify a destination by including a
     *           supported value in your data source, your promotion will display in
     *           Shopping ads and free listings by default.
     *           You may have previously submitted the following values as destinations for
     *           your products: Shopping Actions, Surfaces across Google, Local surfaces
     *           across Google.  To represent these values use `FREE_LISTINGS`,
     *           `FREE_LOCAL_LISTINGS`, `LOCAL_INVENTORY_ADS`. For more details see
     *           [Promotion
     *           destination](https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $item_id_inclusion
     *           Optional. Product filter by [item
     *           ID](https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion. The product filter attributes only applies when the
     *           products eligible for promotion product applicability
     *           `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $brand_inclusion
     *           Optional. Product filter by brand for the promotion. The product filter
     *           attributes only applies when the products eligible for promotion product
     *           applicability `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $item_group_id_inclusion
     *           Optional. Product filter by item group ID for the promotion. The product
     *           filter attributes only applies when the products eligible for promotion
     *           product applicability [product_applicability] attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_type_inclusion
     *           Optional. Product filter by product type for the promotion. The product
     *           filter attributes only applies when the products eligible for promotion
     *           product applicability `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $item_id_exclusion
     *           Optional. Product filter by [item ID
     *           exclusion](https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion. The product filter attributes only applies when the
     *           products eligible for promotion product applicability
     *           `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $brand_exclusion
     *           Optional. Product filter by [brand
     *           exclusion](https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion. The product filter attributes only applies when the
     *           products eligible for promotion product applicability
     *           `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $item_group_id_exclusion
     *           Optional. Product filter by [item group
     *           ID](https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
     *           The product filter attributes only applies when the products eligible for
     *           promotion product applicability `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *           exclusion for the promotion.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_type_exclusion
     *           Optional. Product filter by [product type
     *           exclusion](https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion. The product filter attributes only applies when the
     *           products eligible for promotion product applicability
     *           `product_applicability` attribute is set to
     *           [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type \Google\Shopping\Type\Price $minimum_purchase_amount
     *           Optional. [Minimum purchase
     *           amount](https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion.
     *     @type int|string $minimum_purchase_quantity
     *     @type int|string $limit_quantity
     *           Optional. [Maximum purchase
     *           quantity](https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion.
     *     @type \Google\Shopping\Type\Price $limit_value
     *           Optional. [Maximum product
     *           price](https://support.google.com/merchants/answer/2906014) for
     *           promotion.
     *     @type int|string $percent_off
     *           Optional. The [percentage
     *           discount](https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
     *           offered in the promotion.
     *     @type \Google\Shopping\Type\Price $money_off_amount
     *           Optional. The [money off
     *           amount](https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           offered in the promotion.
     *     @type int|string $get_this_quantity_discounted
     *           Optional. The number of items discounted in the promotion. The attribute is
     *           set when `couponValueType` is equal to `buy_m_get_n_money_off` or
     *           `buy_m_get_n_percent_off`.
     *     @type \Google\Shopping\Type\Price $free_gift_value
     *           Optional. [Free gift
     *           value](https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion.
     *     @type string $free_gift_description
     *           Optional. [Free gift
     *           description](https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion.
     *     @type string $free_gift_item_id
     *           Optional. [Free gift item
     *           ID](https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion.
     *     @type \Google\Type\Interval $promotion_effective_time_period
     *           Required. `TimePeriod` representation of the promotion's effective dates.
     *           This attribute specifies that the promotion can be tested on your online
     *           store during this time period.
     *     @type \Google\Type\Interval $promotion_display_time_period
     *           Optional. `TimePeriod` representation of the promotion's display dates.
     *           This attribute specifies the date and time frame when the promotion will be
     *           live on Google.com and Shopping ads. If the display time period for
     *           promotion `promotion_display_time_period` attribute is not specified, the
     *           promotion effective time period `promotion_effective_time_period`
     *           determines the date and time frame when the promotion will be live on
     *           Google.com and Shopping ads.
     *     @type int $store_applicability
     *           Optional. Whether the promotion applies to [all stores, or only specified
     *           stores](https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
     *           Local Inventory ads promotions throw an error if no store applicability is
     *           included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
     *           set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion`
     *           is set to a value.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $store_codes_inclusion
     *           Optional. [Store codes to
     *           include](https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion. The store filter attributes only applies when the
     *           `store_applicability` attribute is set to
     *           [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     *           Store code (the store ID from
     *           your Business Profile) of the physical store the product is sold in. See
     *           the [Local product inventory data
     *           specification](https://support.google.com/merchants/answer/3061342) for
     *           more information.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $store_codes_exclusion
     *           Optional. [Store codes to
     *           exclude](https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
     *           for the promotion. The store filter attributes only applies when the
     *           `store_applicability` attribute is set to
     *           [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     *     @type string $promotion_url
     *           Optional. URL to the page on the merchant's site where the promotion shows.
     *           Local Inventory ads promotions throw an error if no `promotion_url` is
     *           included. URL is used to confirm that the promotion is valid and can be
     *           redeemed.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Promotions\V1\PromotionsCommon::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Applicability of the promotion to either all products or
     * [only specific
     * products](https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.ProductApplicability product_applicability = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getProductApplicability()
    {
        return $this->product_applicability;
    }

    /**
     * Required. Applicability of the promotion to either all products or
     * [only specific
     * products](https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.ProductApplicability product_applicability = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setProductApplicability($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Promotions\V1\ProductApplicability::class);
        $this->product_applicability = $var;

        return $this;
    }

    /**
     * Required.
     * [Type](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
     * of the promotion. Use this attribute to indicate whether or not customers
     * need a coupon code to redeem your promotion.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.OfferType offer_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getOfferType()
    {
        return $this->offer_type;
    }

    /**
     * Required.
     * [Type](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
     * of the promotion. Use this attribute to indicate whether or not customers
     * need a coupon code to redeem your promotion.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.OfferType offer_type = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setOfferType($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Promotions\V1\OfferType::class);
        $this->offer_type = $var;

        return $this;
    }

    /**
     * Optional. Generic redemption code for the promotion. To be used with the
     * `offerType` field and must meet the [minimum
     * requirements](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>string generic_redemption_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getGenericRedemptionCode()
    {
        return $this->generic_redemption_code;
    }

    /**
     * Optional. Generic redemption code for the promotion. To be used with the
     * `offerType` field and must meet the [minimum
     * requirements](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>string generic_redemption_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setGenericRedemptionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->generic_redemption_code = $var;

        return $this;
    }

    /**
     * Required. [Long
     * title](https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string long_title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getLongTitle()
    {
        return $this->long_title;
    }

    /**
     * Required. [Long
     * title](https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string long_title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setLongTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->long_title = $var;

        return $this;
    }

    /**
     * Required. The [coupon value type]
     * (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
     * attribute to signal the type of promotion that you are running. Depending
     * on type of the selected coupon value [some attributes are
     * required](https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.CouponValueType coupon_value_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getCouponValueType()
    {
        return $this->coupon_value_type;
    }

    /**
     * Required. The [coupon value type]
     * (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
     * attribute to signal the type of promotion that you are running. Depending
     * on type of the selected coupon value [some attributes are
     * required](https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.CouponValueType coupon_value_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setCouponValueType($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Promotions\V1\CouponValueType::class);
        $this->coupon_value_type = $var;

        return $this;
    }

    /**
     * Required. The list of destinations (also known as [Marketing
     * methods](https://support.google.com/merchants/answer/15130232)) where the
     * promotion applies to. If you don't specify a destination by including a
     * supported value in your data source, your promotion will display in
     * Shopping ads and free listings by default.
     * You may have previously submitted the following values as destinations for
     * your products: Shopping Actions, Surfaces across Google, Local surfaces
     * across Google.  To represent these values use `FREE_LISTINGS`,
     * `FREE_LOCAL_LISTINGS`, `LOCAL_INVENTORY_ADS`. For more details see
     * [Promotion
     * destination](https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum promotion_destinations = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPromotionDestinations()
    {
        return $this->promotion_destinations;
    }

    /**
     * Required. The list of destinations (also known as [Marketing
     * methods](https://support.google.com/merchants/answer/15130232)) where the
     * promotion applies to. If you don't specify a destination by including a
     * supported value in your data source, your promotion will display in
     * Shopping ads and free listings by default.
     * You may have previously submitted the following values as destinations for
     * your products: Shopping Actions, Surfaces across Google, Local surfaces
     * across Google.  To represent these values use `FREE_LISTINGS`,
     * `FREE_LOCAL_LISTINGS`, `LOCAL_INVENTORY_ADS`. For more details see
     * [Promotion
     * destination](https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.Destination.DestinationEnum promotion_destinations = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPromotionDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Shopping\Type\Destination\DestinationEnum::class);
        $this->promotion_destinations = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by [item
     * ID](https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_id_inclusion = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getItemIdInclusion()
    {
        return $this->item_id_inclusion;
    }

    /**
     * Optional. Product filter by [item
     * ID](https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_id_inclusion = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setItemIdInclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->item_id_inclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by brand for the promotion. The product filter
     * attributes only applies when the products eligible for promotion product
     * applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string brand_inclusion = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBrandInclusion()
    {
        return $this->brand_inclusion;
    }

    /**
     * Optional. Product filter by brand for the promotion. The product filter
     * attributes only applies when the products eligible for promotion product
     * applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string brand_inclusion = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBrandInclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->brand_inclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by item group ID for the promotion. The product
     * filter attributes only applies when the products eligible for promotion
     * product applicability [product_applicability] attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_group_id_inclusion = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getItemGroupIdInclusion()
    {
        return $this->item_group_id_inclusion;
    }

    /**
     * Optional. Product filter by item group ID for the promotion. The product
     * filter attributes only applies when the products eligible for promotion
     * product applicability [product_applicability] attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_group_id_inclusion = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setItemGroupIdInclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->item_group_id_inclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by product type for the promotion. The product
     * filter attributes only applies when the products eligible for promotion
     * product applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string product_type_inclusion = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductTypeInclusion()
    {
        return $this->product_type_inclusion;
    }

    /**
     * Optional. Product filter by product type for the promotion. The product
     * filter attributes only applies when the products eligible for promotion
     * product applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string product_type_inclusion = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductTypeInclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_type_inclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by [item ID
     * exclusion](https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_id_exclusion = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getItemIdExclusion()
    {
        return $this->item_id_exclusion;
    }

    /**
     * Optional. Product filter by [item ID
     * exclusion](https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string item_id_exclusion = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setItemIdExclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->item_id_exclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by [brand
     * exclusion](https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string brand_exclusion = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBrandExclusion()
    {
        return $this->brand_exclusion;
    }

    /**
     * Optional. Product filter by [brand
     * exclusion](https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string brand_exclusion = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBrandExclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->brand_exclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by [item group
     * ID](https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
     * The product filter attributes only applies when the products eligible for
     * promotion product applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     * exclusion for the promotion.
     *
     * Generated from protobuf field <code>repeated string item_group_id_exclusion = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getItemGroupIdExclusion()
    {
        return $this->item_group_id_exclusion;
    }

    /**
     * Optional. Product filter by [item group
     * ID](https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
     * The product filter attributes only applies when the products eligible for
     * promotion product applicability `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     * exclusion for the promotion.
     *
     * Generated from protobuf field <code>repeated string item_group_id_exclusion = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setItemGroupIdExclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->item_group_id_exclusion = $arr;

        return $this;
    }

    /**
     * Optional. Product filter by [product type
     * exclusion](https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string product_type_exclusion = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductTypeExclusion()
    {
        return $this->product_type_exclusion;
    }

    /**
     * Optional. Product filter by [product type
     * exclusion](https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The product filter attributes only applies when the
     * products eligible for promotion product applicability
     * `product_applicability` attribute is set to
     * [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string product_type_exclusion = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductTypeExclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_type_exclusion = $arr;

        return $this;
    }

    /**
     * Optional. [Minimum purchase
     * amount](https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price minimum_purchase_amount = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getMinimumPurchaseAmount()
    {
        return $this->minimum_purchase_amount;
    }

    public function hasMinimumPurchaseAmount()
    {
        return isset($this->minimum_purchase_amount);
    }

    public function clearMinimumPurchaseAmount()
    {
        unset($this->minimum_purchase_amount);
    }

    /**
     * Optional. [Minimum purchase
     * amount](https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price minimum_purchase_amount = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setMinimumPurchaseAmount($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->minimum_purchase_amount = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>int64 minimum_purchase_quantity = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getMinimumPurchaseQuantity()
    {
        return $this->minimum_purchase_quantity;
    }

    /**
     * Generated from protobuf field <code>int64 minimum_purchase_quantity = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMinimumPurchaseQuantity($var)
    {
        GPBUtil::checkInt64($var);
        $this->minimum_purchase_quantity = $var;

        return $this;
    }

    /**
     * Optional. [Maximum purchase
     * quantity](https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>int64 limit_quantity = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getLimitQuantity()
    {
        return $this->limit_quantity;
    }

    /**
     * Optional. [Maximum purchase
     * quantity](https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>int64 limit_quantity = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setLimitQuantity($var)
    {
        GPBUtil::checkInt64($var);
        $this->limit_quantity = $var;

        return $this;
    }

    /**
     * Optional. [Maximum product
     * price](https://support.google.com/merchants/answer/2906014) for
     * promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price limit_value = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getLimitValue()
    {
        return $this->limit_value;
    }

    public function hasLimitValue()
    {
        return isset($this->limit_value);
    }

    public function clearLimitValue()
    {
        unset($this->limit_value);
    }

    /**
     * Optional. [Maximum product
     * price](https://support.google.com/merchants/answer/2906014) for
     * promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price limit_value = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setLimitValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->limit_value = $var;

        return $this;
    }

    /**
     * Optional. The [percentage
     * discount](https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
     * offered in the promotion.
     *
     * Generated from protobuf field <code>int64 percent_off = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getPercentOff()
    {
        return $this->percent_off;
    }

    /**
     * Optional. The [percentage
     * discount](https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
     * offered in the promotion.
     *
     * Generated from protobuf field <code>int64 percent_off = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setPercentOff($var)
    {
        GPBUtil::checkInt64($var);
        $this->percent_off = $var;

        return $this;
    }

    /**
     * Optional. The [money off
     * amount](https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
     * offered in the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price money_off_amount = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getMoneyOffAmount()
    {
        return $this->money_off_amount;
    }

    public function hasMoneyOffAmount()
    {
        return isset($this->money_off_amount);
    }

    public function clearMoneyOffAmount()
    {
        unset($this->money_off_amount);
    }

    /**
     * Optional. The [money off
     * amount](https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
     * offered in the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price money_off_amount = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setMoneyOffAmount($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->money_off_amount = $var;

        return $this;
    }

    /**
     * Optional. The number of items discounted in the promotion. The attribute is
     * set when `couponValueType` is equal to `buy_m_get_n_money_off` or
     * `buy_m_get_n_percent_off`.
     *
     * Generated from protobuf field <code>int64 get_this_quantity_discounted = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getGetThisQuantityDiscounted()
    {
        return $this->get_this_quantity_discounted;
    }

    /**
     * Optional. The number of items discounted in the promotion. The attribute is
     * set when `couponValueType` is equal to `buy_m_get_n_money_off` or
     * `buy_m_get_n_percent_off`.
     *
     * Generated from protobuf field <code>int64 get_this_quantity_discounted = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setGetThisQuantityDiscounted($var)
    {
        GPBUtil::checkInt64($var);
        $this->get_this_quantity_discounted = $var;

        return $this;
    }

    /**
     * Optional. [Free gift
     * value](https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price free_gift_value = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getFreeGiftValue()
    {
        return $this->free_gift_value;
    }

    public function hasFreeGiftValue()
    {
        return isset($this->free_gift_value);
    }

    public function clearFreeGiftValue()
    {
        unset($this->free_gift_value);
    }

    /**
     * Optional. [Free gift
     * value](https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price free_gift_value = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setFreeGiftValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->free_gift_value = $var;

        return $this;
    }

    /**
     * Optional. [Free gift
     * description](https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string free_gift_description = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFreeGiftDescription()
    {
        return $this->free_gift_description;
    }

    /**
     * Optional. [Free gift
     * description](https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string free_gift_description = 23 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFreeGiftDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->free_gift_description = $var;

        return $this;
    }

    /**
     * Optional. [Free gift item
     * ID](https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string free_gift_item_id = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFreeGiftItemId()
    {
        return $this->free_gift_item_id;
    }

    /**
     * Optional. [Free gift item
     * ID](https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion.
     *
     * Generated from protobuf field <code>string free_gift_item_id = 24 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFreeGiftItemId($var)
    {
        GPBUtil::checkString($var, True);
        $this->free_gift_item_id = $var;

        return $this;
    }

    /**
     * Required. `TimePeriod` representation of the promotion's effective dates.
     * This attribute specifies that the promotion can be tested on your online
     * store during this time period.
     *
     * Generated from protobuf field <code>.google.type.Interval promotion_effective_time_period = 25 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\Interval|null
     */
    public function getPromotionEffectiveTimePeriod()
    {
        return $this->promotion_effective_time_period;
    }

    public function hasPromotionEffectiveTimePeriod()
    {
        return isset($this->promotion_effective_time_period);
    }

    public function clearPromotionEffectiveTimePeriod()
    {
        unset($this->promotion_effective_time_period);
    }

    /**
     * Required. `TimePeriod` representation of the promotion's effective dates.
     * This attribute specifies that the promotion can be tested on your online
     * store during this time period.
     *
     * Generated from protobuf field <code>.google.type.Interval promotion_effective_time_period = 25 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setPromotionEffectiveTimePeriod($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->promotion_effective_time_period = $var;

        return $this;
    }

    /**
     * Optional. `TimePeriod` representation of the promotion's display dates.
     * This attribute specifies the date and time frame when the promotion will be
     * live on Google.com and Shopping ads. If the display time period for
     * promotion `promotion_display_time_period` attribute is not specified, the
     * promotion effective time period `promotion_effective_time_period`
     * determines the date and time frame when the promotion will be live on
     * Google.com and Shopping ads.
     *
     * Generated from protobuf field <code>.google.type.Interval promotion_display_time_period = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Type\Interval|null
     */
    public function getPromotionDisplayTimePeriod()
    {
        return $this->promotion_display_time_period;
    }

    public function hasPromotionDisplayTimePeriod()
    {
        return isset($this->promotion_display_time_period);
    }

    public function clearPromotionDisplayTimePeriod()
    {
        unset($this->promotion_display_time_period);
    }

    /**
     * Optional. `TimePeriod` representation of the promotion's display dates.
     * This attribute specifies the date and time frame when the promotion will be
     * live on Google.com and Shopping ads. If the display time period for
     * promotion `promotion_display_time_period` attribute is not specified, the
     * promotion effective time period `promotion_effective_time_period`
     * determines the date and time frame when the promotion will be live on
     * Google.com and Shopping ads.
     *
     * Generated from protobuf field <code>.google.type.Interval promotion_display_time_period = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setPromotionDisplayTimePeriod($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->promotion_display_time_period = $var;

        return $this;
    }

    /**
     * Optional. Whether the promotion applies to [all stores, or only specified
     * stores](https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
     * Local Inventory ads promotions throw an error if no store applicability is
     * included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
     * set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion`
     * is set to a value.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.StoreApplicability store_applicability = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getStoreApplicability()
    {
        return $this->store_applicability;
    }

    /**
     * Optional. Whether the promotion applies to [all stores, or only specified
     * stores](https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
     * Local Inventory ads promotions throw an error if no store applicability is
     * included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
     * set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion`
     * is set to a value.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.promotions.v1.StoreApplicability store_applicability = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setStoreApplicability($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Promotions\V1\StoreApplicability::class);
        $this->store_applicability = $var;

        return $this;
    }

    /**
     * Optional. [Store codes to
     * include](https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The store filter attributes only applies when the
     * `store_applicability` attribute is set to
     * [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     * Store code (the store ID from
     * your Business Profile) of the physical store the product is sold in. See
     * the [Local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342) for
     * more information.
     *
     * Generated from protobuf field <code>repeated string store_codes_inclusion = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStoreCodesInclusion()
    {
        return $this->store_codes_inclusion;
    }

    /**
     * Optional. [Store codes to
     * include](https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The store filter attributes only applies when the
     * `store_applicability` attribute is set to
     * [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     * Store code (the store ID from
     * your Business Profile) of the physical store the product is sold in. See
     * the [Local product inventory data
     * specification](https://support.google.com/merchants/answer/3061342) for
     * more information.
     *
     * Generated from protobuf field <code>repeated string store_codes_inclusion = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStoreCodesInclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->store_codes_inclusion = $arr;

        return $this;
    }

    /**
     * Optional. [Store codes to
     * exclude](https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The store filter attributes only applies when the
     * `store_applicability` attribute is set to
     * [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string store_codes_exclusion = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStoreCodesExclusion()
    {
        return $this->store_codes_exclusion;
    }

    /**
     * Optional. [Store codes to
     * exclude](https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
     * for the promotion. The store filter attributes only applies when the
     * `store_applicability` attribute is set to
     * [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
     *
     * Generated from protobuf field <code>repeated string store_codes_exclusion = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStoreCodesExclusion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->store_codes_exclusion = $arr;

        return $this;
    }

    /**
     * Optional. URL to the page on the merchant's site where the promotion shows.
     * Local Inventory ads promotions throw an error if no `promotion_url` is
     * included. URL is used to confirm that the promotion is valid and can be
     * redeemed.
     *
     * Generated from protobuf field <code>string promotion_url = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPromotionUrl()
    {
        return $this->promotion_url;
    }

    /**
     * Optional. URL to the page on the merchant's site where the promotion shows.
     * Local Inventory ads promotions throw an error if no `promotion_url` is
     * included. URL is used to confirm that the promotion is valid and can be
     * redeemed.
     *
     * Generated from protobuf field <code>string promotion_url = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPromotionUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->promotion_url = $var;

        return $this;
    }

}

