<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/ordertracking/v1beta/order_tracking_signals.proto

namespace Google\Shopping\Merchant\OrderTracking\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a business trade from which signals are extracted, such as
 * shipping.
 *
 * Generated from protobuf message <code>google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal</code>
 */
class OrderTrackingSignal extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The ID that uniquely identifies this order tracking signal.
     *
     * Generated from protobuf field <code>int64 order_tracking_signal_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $order_tracking_signal_id = 0;
    /**
     * Optional. The Google Merchant Center ID of this order tracking signal. This
     * value is optional. If left unset, the caller's Merchant Center ID is used.
     * You must request access in order to provide data on behalf of another
     * business. For more information, see [Submitting Order Tracking
     * Signals](/shopping-content/guides/order-tracking-signals).
     *
     * Generated from protobuf field <code>int64 merchant_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $merchant_id = 0;
    /**
     * Required. The time when the order was created on the businesses side.
     * Include the year and timezone string, if available.
     *
     * Generated from protobuf field <code>.google.type.DateTime order_created_time = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $order_created_time = null;
    /**
     * Required. The ID of the order on the businesses side. This field will be
     * hashed in returned OrderTrackingSignal creation response.
     *
     * Generated from protobuf field <code>string order_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $order_id = '';
    /**
     * Required. The shipping information for the order.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.ShippingInfo shipping_info = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $shipping_info;
    /**
     * Required. Information about line items in the order.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.LineItemDetails line_items = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $line_items;
    /**
     * Optional. The mapping of the line items to the shipment information.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.ShipmentLineItemMapping shipment_line_item_mapping = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $shipment_line_item_mapping;
    /**
     * Optional. The shipping fee of the order;
     * this value should be set to zero in the case of free shipping.
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price customer_shipping_fee = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $customer_shipping_fee = null;
    /**
     * Optional. The delivery postal code, as a continuous string without spaces
     * or dashes, for example "95016". This field will be anonymized in returned
     * OrderTrackingSignal creation response.
     *
     * Generated from protobuf field <code>string delivery_postal_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $delivery_postal_code = '';
    /**
     * Optional. The [CLDR territory code]
     * (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for
     * the shipping destination.
     *
     * Generated from protobuf field <code>string delivery_region_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $delivery_region_code = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $order_tracking_signal_id
     *           Output only. The ID that uniquely identifies this order tracking signal.
     *     @type int|string $merchant_id
     *           Optional. The Google Merchant Center ID of this order tracking signal. This
     *           value is optional. If left unset, the caller's Merchant Center ID is used.
     *           You must request access in order to provide data on behalf of another
     *           business. For more information, see [Submitting Order Tracking
     *           Signals](/shopping-content/guides/order-tracking-signals).
     *     @type \Google\Type\DateTime $order_created_time
     *           Required. The time when the order was created on the businesses side.
     *           Include the year and timezone string, if available.
     *     @type string $order_id
     *           Required. The ID of the order on the businesses side. This field will be
     *           hashed in returned OrderTrackingSignal creation response.
     *     @type array<\Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\ShippingInfo>|\Google\Protobuf\Internal\RepeatedField $shipping_info
     *           Required. The shipping information for the order.
     *     @type array<\Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\LineItemDetails>|\Google\Protobuf\Internal\RepeatedField $line_items
     *           Required. Information about line items in the order.
     *     @type array<\Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\ShipmentLineItemMapping>|\Google\Protobuf\Internal\RepeatedField $shipment_line_item_mapping
     *           Optional. The mapping of the line items to the shipment information.
     *     @type \Google\Shopping\Type\Price $customer_shipping_fee
     *           Optional. The shipping fee of the order;
     *           this value should be set to zero in the case of free shipping.
     *     @type string $delivery_postal_code
     *           Optional. The delivery postal code, as a continuous string without spaces
     *           or dashes, for example "95016". This field will be anonymized in returned
     *           OrderTrackingSignal creation response.
     *     @type string $delivery_region_code
     *           Optional. The [CLDR territory code]
     *           (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for
     *           the shipping destination.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Ordertracking\V1Beta\OrderTrackingSignals::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The ID that uniquely identifies this order tracking signal.
     *
     * Generated from protobuf field <code>int64 order_tracking_signal_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getOrderTrackingSignalId()
    {
        return $this->order_tracking_signal_id;
    }

    /**
     * Output only. The ID that uniquely identifies this order tracking signal.
     *
     * Generated from protobuf field <code>int64 order_tracking_signal_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setOrderTrackingSignalId($var)
    {
        GPBUtil::checkInt64($var);
        $this->order_tracking_signal_id = $var;

        return $this;
    }

    /**
     * Optional. The Google Merchant Center ID of this order tracking signal. This
     * value is optional. If left unset, the caller's Merchant Center ID is used.
     * You must request access in order to provide data on behalf of another
     * business. For more information, see [Submitting Order Tracking
     * Signals](/shopping-content/guides/order-tracking-signals).
     *
     * Generated from protobuf field <code>int64 merchant_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getMerchantId()
    {
        return $this->merchant_id;
    }

    /**
     * Optional. The Google Merchant Center ID of this order tracking signal. This
     * value is optional. If left unset, the caller's Merchant Center ID is used.
     * You must request access in order to provide data on behalf of another
     * business. For more information, see [Submitting Order Tracking
     * Signals](/shopping-content/guides/order-tracking-signals).
     *
     * Generated from protobuf field <code>int64 merchant_id = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMerchantId($var)
    {
        GPBUtil::checkInt64($var);
        $this->merchant_id = $var;

        return $this;
    }

    /**
     * Required. The time when the order was created on the businesses side.
     * Include the year and timezone string, if available.
     *
     * Generated from protobuf field <code>.google.type.DateTime order_created_time = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\DateTime|null
     */
    public function getOrderCreatedTime()
    {
        return $this->order_created_time;
    }

    public function hasOrderCreatedTime()
    {
        return isset($this->order_created_time);
    }

    public function clearOrderCreatedTime()
    {
        unset($this->order_created_time);
    }

    /**
     * Required. The time when the order was created on the businesses side.
     * Include the year and timezone string, if available.
     *
     * Generated from protobuf field <code>.google.type.DateTime order_created_time = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\DateTime $var
     * @return $this
     */
    public function setOrderCreatedTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\DateTime::class);
        $this->order_created_time = $var;

        return $this;
    }

    /**
     * Required. The ID of the order on the businesses side. This field will be
     * hashed in returned OrderTrackingSignal creation response.
     *
     * Generated from protobuf field <code>string order_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getOrderId()
    {
        return $this->order_id;
    }

    /**
     * Required. The ID of the order on the businesses side. This field will be
     * hashed in returned OrderTrackingSignal creation response.
     *
     * Generated from protobuf field <code>string order_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setOrderId($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_id = $var;

        return $this;
    }

    /**
     * Required. The shipping information for the order.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.ShippingInfo shipping_info = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShippingInfo()
    {
        return $this->shipping_info;
    }

    /**
     * Required. The shipping information for the order.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.ShippingInfo shipping_info = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\ShippingInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShippingInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\ShippingInfo::class);
        $this->shipping_info = $arr;

        return $this;
    }

    /**
     * Required. Information about line items in the order.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.LineItemDetails line_items = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLineItems()
    {
        return $this->line_items;
    }

    /**
     * Required. Information about line items in the order.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.LineItemDetails line_items = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\LineItemDetails>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLineItems($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\LineItemDetails::class);
        $this->line_items = $arr;

        return $this;
    }

    /**
     * Optional. The mapping of the line items to the shipment information.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.ShipmentLineItemMapping shipment_line_item_mapping = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getShipmentLineItemMapping()
    {
        return $this->shipment_line_item_mapping;
    }

    /**
     * Optional. The mapping of the line items to the shipment information.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.ordertracking.v1beta.OrderTrackingSignal.ShipmentLineItemMapping shipment_line_item_mapping = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\ShipmentLineItemMapping>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setShipmentLineItemMapping($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\OrderTracking\V1beta\OrderTrackingSignal\ShipmentLineItemMapping::class);
        $this->shipment_line_item_mapping = $arr;

        return $this;
    }

    /**
     * Optional. The shipping fee of the order;
     * this value should be set to zero in the case of free shipping.
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price customer_shipping_fee = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getCustomerShippingFee()
    {
        return $this->customer_shipping_fee;
    }

    public function hasCustomerShippingFee()
    {
        return isset($this->customer_shipping_fee);
    }

    public function clearCustomerShippingFee()
    {
        unset($this->customer_shipping_fee);
    }

    /**
     * Optional. The shipping fee of the order;
     * this value should be set to zero in the case of free shipping.
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Price customer_shipping_fee = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setCustomerShippingFee($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->customer_shipping_fee = $var;

        return $this;
    }

    /**
     * Optional. The delivery postal code, as a continuous string without spaces
     * or dashes, for example "95016". This field will be anonymized in returned
     * OrderTrackingSignal creation response.
     *
     * Generated from protobuf field <code>string delivery_postal_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDeliveryPostalCode()
    {
        return $this->delivery_postal_code;
    }

    /**
     * Optional. The delivery postal code, as a continuous string without spaces
     * or dashes, for example "95016". This field will be anonymized in returned
     * OrderTrackingSignal creation response.
     *
     * Generated from protobuf field <code>string delivery_postal_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDeliveryPostalCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->delivery_postal_code = $var;

        return $this;
    }

    /**
     * Optional. The [CLDR territory code]
     * (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for
     * the shipping destination.
     *
     * Generated from protobuf field <code>string delivery_region_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDeliveryRegionCode()
    {
        return $this->delivery_region_code;
    }

    /**
     * Optional. The [CLDR territory code]
     * (http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) for
     * the shipping destination.
     *
     * Generated from protobuf field <code>string delivery_region_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDeliveryRegionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->delivery_region_code = $var;

        return $this;
    }

}

