<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/notifications/v1beta/notificationsapi.proto

namespace Google\Shopping\Merchant\Notifications\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The message that the merchant will receive to notify about product status
 * change event
 *
 * Generated from protobuf message <code>google.shopping.merchant.notifications.v1beta.ProductStatusChangeMessage</code>
 */
class ProductStatusChangeMessage extends \Google\Protobuf\Internal\Message
{
    /**
     * The target account that owns the entity that changed.
     * Format : `accounts/{merchant_id}`
     *
     * Generated from protobuf field <code>optional string account = 1;</code>
     */
    protected $account = null;
    /**
     * The account that manages the merchant's account. can be the same as
     * merchant id if it is standalone account. Format :
     * `accounts/{service_provider_id}`
     *
     * Generated from protobuf field <code>optional string managing_account = 2;</code>
     */
    protected $managing_account = null;
    /**
     * The resource that changed, in this case it will always be `Product`.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.notifications.v1beta.Resource resource_type = 3;</code>
     */
    protected $resource_type = null;
    /**
     * The attribute in the resource that changed, in this case it will be always
     * `Status`.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.notifications.v1beta.Attribute attribute = 4;</code>
     */
    protected $attribute = null;
    /**
     * A message to describe the change that happened to the product
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.notifications.v1beta.ProductChange changes = 5;</code>
     */
    private $changes;
    /**
     * The product id.
     *
     * Generated from protobuf field <code>optional string resource_id = 6;</code>
     */
    protected $resource_id = null;
    /**
     * The product name.
     * Format: `{product.name=accounts/{account}/products/{product}}`
     *
     * Generated from protobuf field <code>optional string resource = 7;</code>
     */
    protected $resource = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $account
     *           The target account that owns the entity that changed.
     *           Format : `accounts/{merchant_id}`
     *     @type string $managing_account
     *           The account that manages the merchant's account. can be the same as
     *           merchant id if it is standalone account. Format :
     *           `accounts/{service_provider_id}`
     *     @type int $resource_type
     *           The resource that changed, in this case it will always be `Product`.
     *     @type int $attribute
     *           The attribute in the resource that changed, in this case it will be always
     *           `Status`.
     *     @type array<\Google\Shopping\Merchant\Notifications\V1beta\ProductChange>|\Google\Protobuf\Internal\RepeatedField $changes
     *           A message to describe the change that happened to the product
     *     @type string $resource_id
     *           The product id.
     *     @type string $resource
     *           The product name.
     *           Format: `{product.name=accounts/{account}/products/{product}}`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Notifications\V1Beta\Notificationsapi::initOnce();
        parent::__construct($data);
    }

    /**
     * The target account that owns the entity that changed.
     * Format : `accounts/{merchant_id}`
     *
     * Generated from protobuf field <code>optional string account = 1;</code>
     * @return string
     */
    public function getAccount()
    {
        return isset($this->account) ? $this->account : '';
    }

    public function hasAccount()
    {
        return isset($this->account);
    }

    public function clearAccount()
    {
        unset($this->account);
    }

    /**
     * The target account that owns the entity that changed.
     * Format : `accounts/{merchant_id}`
     *
     * Generated from protobuf field <code>optional string account = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->account = $var;

        return $this;
    }

    /**
     * The account that manages the merchant's account. can be the same as
     * merchant id if it is standalone account. Format :
     * `accounts/{service_provider_id}`
     *
     * Generated from protobuf field <code>optional string managing_account = 2;</code>
     * @return string
     */
    public function getManagingAccount()
    {
        return isset($this->managing_account) ? $this->managing_account : '';
    }

    public function hasManagingAccount()
    {
        return isset($this->managing_account);
    }

    public function clearManagingAccount()
    {
        unset($this->managing_account);
    }

    /**
     * The account that manages the merchant's account. can be the same as
     * merchant id if it is standalone account. Format :
     * `accounts/{service_provider_id}`
     *
     * Generated from protobuf field <code>optional string managing_account = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setManagingAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->managing_account = $var;

        return $this;
    }

    /**
     * The resource that changed, in this case it will always be `Product`.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.notifications.v1beta.Resource resource_type = 3;</code>
     * @return int
     */
    public function getResourceType()
    {
        return isset($this->resource_type) ? $this->resource_type : 0;
    }

    public function hasResourceType()
    {
        return isset($this->resource_type);
    }

    public function clearResourceType()
    {
        unset($this->resource_type);
    }

    /**
     * The resource that changed, in this case it will always be `Product`.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.notifications.v1beta.Resource resource_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setResourceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Notifications\V1beta\Resource::class);
        $this->resource_type = $var;

        return $this;
    }

    /**
     * The attribute in the resource that changed, in this case it will be always
     * `Status`.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.notifications.v1beta.Attribute attribute = 4;</code>
     * @return int
     */
    public function getAttribute()
    {
        return isset($this->attribute) ? $this->attribute : 0;
    }

    public function hasAttribute()
    {
        return isset($this->attribute);
    }

    public function clearAttribute()
    {
        unset($this->attribute);
    }

    /**
     * The attribute in the resource that changed, in this case it will be always
     * `Status`.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.notifications.v1beta.Attribute attribute = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setAttribute($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Notifications\V1beta\Attribute::class);
        $this->attribute = $var;

        return $this;
    }

    /**
     * A message to describe the change that happened to the product
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.notifications.v1beta.ProductChange changes = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getChanges()
    {
        return $this->changes;
    }

    /**
     * A message to describe the change that happened to the product
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.notifications.v1beta.ProductChange changes = 5;</code>
     * @param array<\Google\Shopping\Merchant\Notifications\V1beta\ProductChange>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setChanges($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Notifications\V1beta\ProductChange::class);
        $this->changes = $arr;

        return $this;
    }

    /**
     * The product id.
     *
     * Generated from protobuf field <code>optional string resource_id = 6;</code>
     * @return string
     */
    public function getResourceId()
    {
        return isset($this->resource_id) ? $this->resource_id : '';
    }

    public function hasResourceId()
    {
        return isset($this->resource_id);
    }

    public function clearResourceId()
    {
        unset($this->resource_id);
    }

    /**
     * The product id.
     *
     * Generated from protobuf field <code>optional string resource_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_id = $var;

        return $this;
    }

    /**
     * The product name.
     * Format: `{product.name=accounts/{account}/products/{product}}`
     *
     * Generated from protobuf field <code>optional string resource = 7;</code>
     * @return string
     */
    public function getResource()
    {
        return isset($this->resource) ? $this->resource : '';
    }

    public function hasResource()
    {
        return isset($this->resource);
    }

    public function clearResource()
    {
        unset($this->resource);
    }

    /**
     * The product name.
     * Format: `{product.name=accounts/{account}/products/{product}}`
     *
     * Generated from protobuf field <code>optional string resource = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource = $var;

        return $this;
    }

}

