<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securesourcemanager/v1/secure_source_manager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecureSourceManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\SecureSourceManager\V1\BatchCreatePullRequestCommentsRequest;
use Google\Cloud\SecureSourceManager\V1\BatchCreatePullRequestCommentsResponse;
use Google\Cloud\SecureSourceManager\V1\BranchRule;
use Google\Cloud\SecureSourceManager\V1\CloseIssueRequest;
use Google\Cloud\SecureSourceManager\V1\ClosePullRequestRequest;
use Google\Cloud\SecureSourceManager\V1\CreateBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\CreateHookRequest;
use Google\Cloud\SecureSourceManager\V1\CreateInstanceRequest;
use Google\Cloud\SecureSourceManager\V1\CreateIssueCommentRequest;
use Google\Cloud\SecureSourceManager\V1\CreateIssueRequest;
use Google\Cloud\SecureSourceManager\V1\CreatePullRequestCommentRequest;
use Google\Cloud\SecureSourceManager\V1\CreatePullRequestRequest;
use Google\Cloud\SecureSourceManager\V1\CreateRepositoryRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteHookRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteInstanceRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteIssueCommentRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteIssueRequest;
use Google\Cloud\SecureSourceManager\V1\DeletePullRequestCommentRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteRepositoryRequest;
use Google\Cloud\SecureSourceManager\V1\FetchBlobRequest;
use Google\Cloud\SecureSourceManager\V1\FetchBlobResponse;
use Google\Cloud\SecureSourceManager\V1\FetchTreeRequest;
use Google\Cloud\SecureSourceManager\V1\GetBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\GetHookRequest;
use Google\Cloud\SecureSourceManager\V1\GetInstanceRequest;
use Google\Cloud\SecureSourceManager\V1\GetIssueCommentRequest;
use Google\Cloud\SecureSourceManager\V1\GetIssueRequest;
use Google\Cloud\SecureSourceManager\V1\GetPullRequestCommentRequest;
use Google\Cloud\SecureSourceManager\V1\GetPullRequestRequest;
use Google\Cloud\SecureSourceManager\V1\GetRepositoryRequest;
use Google\Cloud\SecureSourceManager\V1\Hook;
use Google\Cloud\SecureSourceManager\V1\Instance;
use Google\Cloud\SecureSourceManager\V1\Issue;
use Google\Cloud\SecureSourceManager\V1\IssueComment;
use Google\Cloud\SecureSourceManager\V1\ListBranchRulesRequest;
use Google\Cloud\SecureSourceManager\V1\ListHooksRequest;
use Google\Cloud\SecureSourceManager\V1\ListInstancesRequest;
use Google\Cloud\SecureSourceManager\V1\ListIssueCommentsRequest;
use Google\Cloud\SecureSourceManager\V1\ListIssuesRequest;
use Google\Cloud\SecureSourceManager\V1\ListPullRequestCommentsRequest;
use Google\Cloud\SecureSourceManager\V1\ListPullRequestFileDiffsRequest;
use Google\Cloud\SecureSourceManager\V1\ListPullRequestsRequest;
use Google\Cloud\SecureSourceManager\V1\ListRepositoriesRequest;
use Google\Cloud\SecureSourceManager\V1\MergePullRequestRequest;
use Google\Cloud\SecureSourceManager\V1\OpenIssueRequest;
use Google\Cloud\SecureSourceManager\V1\OpenPullRequestRequest;
use Google\Cloud\SecureSourceManager\V1\PullRequest;
use Google\Cloud\SecureSourceManager\V1\PullRequestComment;
use Google\Cloud\SecureSourceManager\V1\Repository;
use Google\Cloud\SecureSourceManager\V1\ResolvePullRequestCommentsRequest;
use Google\Cloud\SecureSourceManager\V1\ResolvePullRequestCommentsResponse;
use Google\Cloud\SecureSourceManager\V1\UnresolvePullRequestCommentsRequest;
use Google\Cloud\SecureSourceManager\V1\UnresolvePullRequestCommentsResponse;
use Google\Cloud\SecureSourceManager\V1\UpdateBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\UpdateHookRequest;
use Google\Cloud\SecureSourceManager\V1\UpdateIssueCommentRequest;
use Google\Cloud\SecureSourceManager\V1\UpdateIssueRequest;
use Google\Cloud\SecureSourceManager\V1\UpdatePullRequestCommentRequest;
use Google\Cloud\SecureSourceManager\V1\UpdatePullRequestRequest;
use Google\Cloud\SecureSourceManager\V1\UpdateRepositoryRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Secure Source Manager API
 *
 * Access Secure Source Manager instances, resources, and repositories.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> batchCreatePullRequestCommentsAsync(BatchCreatePullRequestCommentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> closeIssueAsync(CloseIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> closePullRequestAsync(ClosePullRequestRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBranchRuleAsync(CreateBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createHookAsync(CreateHookRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createInstanceAsync(CreateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createIssueAsync(CreateIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createIssueCommentAsync(CreateIssueCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createPullRequestAsync(CreatePullRequestRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createPullRequestCommentAsync(CreatePullRequestCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createRepositoryAsync(CreateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBranchRuleAsync(DeleteBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteHookAsync(DeleteHookRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteInstanceAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteIssueAsync(DeleteIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteIssueCommentAsync(DeleteIssueCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deletePullRequestCommentAsync(DeletePullRequestCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteRepositoryAsync(DeleteRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchBlobResponse> fetchBlobAsync(FetchBlobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> fetchTreeAsync(FetchTreeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BranchRule> getBranchRuleAsync(GetBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Hook> getHookAsync(GetHookRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyRepoAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Instance> getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Issue> getIssueAsync(GetIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IssueComment> getIssueCommentAsync(GetIssueCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PullRequest> getPullRequestAsync(GetPullRequestRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PullRequestComment> getPullRequestCommentAsync(GetPullRequestCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Repository> getRepositoryAsync(GetRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBranchRulesAsync(ListBranchRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listHooksAsync(ListHooksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listIssueCommentsAsync(ListIssueCommentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listIssuesAsync(ListIssuesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPullRequestCommentsAsync(ListPullRequestCommentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPullRequestFileDiffsAsync(ListPullRequestFileDiffsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPullRequestsAsync(ListPullRequestsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRepositoriesAsync(ListRepositoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> mergePullRequestAsync(MergePullRequestRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> openIssueAsync(OpenIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> openPullRequestAsync(OpenPullRequestRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> resolvePullRequestCommentsAsync(ResolvePullRequestCommentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyRepoAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsRepoAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> unresolvePullRequestCommentsAsync(UnresolvePullRequestCommentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBranchRuleAsync(UpdateBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateHookAsync(UpdateHookRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateIssueAsync(UpdateIssueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateIssueCommentAsync(UpdateIssueCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updatePullRequestAsync(UpdatePullRequestRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updatePullRequestCommentAsync(UpdatePullRequestCommentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateRepositoryAsync(UpdateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class SecureSourceManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.securesourcemanager.v1.SecureSourceManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'securesourcemanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'securesourcemanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/secure_source_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/secure_source_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/secure_source_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/secure_source_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a branch_rule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $branchRule
     *
     * @return string The formatted branch_rule resource.
     */
    public static function branchRuleName(string $project, string $location, string $repository, string $branchRule): string
    {
        return self::getPathTemplate('branchRule')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'branch_rule' => $branchRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ca_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     *
     * @return string The formatted ca_pool resource.
     */
    public static function caPoolName(string $project, string $location, string $caPool): string
    {
        return self::getPathTemplate('caPool')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a hook
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $hook
     *
     * @return string The formatted hook resource.
     */
    public static function hookName(string $project, string $location, string $repository, string $hook): string
    {
        return self::getPathTemplate('hook')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'hook' => $hook,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a issue
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $issue
     *
     * @return string The formatted issue resource.
     */
    public static function issueName(string $project, string $location, string $repository, string $issue): string
    {
        return self::getPathTemplate('issue')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'issue' => $issue,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * issue_comment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $issue
     * @param string $comment
     *
     * @return string The formatted issue_comment resource.
     */
    public static function issueCommentName(string $project, string $location, string $repository, string $issue, string $comment): string
    {
        return self::getPathTemplate('issueComment')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'issue' => $issue,
            'comment' => $comment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pull_request
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $pullRequest
     *
     * @return string The formatted pull_request resource.
     */
    public static function pullRequestName(string $project, string $location, string $repository, string $pullRequest): string
    {
        return self::getPathTemplate('pullRequest')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'pull_request' => $pullRequest,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * pull_request_comment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $pullRequest
     * @param string $comment
     *
     * @return string The formatted pull_request_comment resource.
     */
    public static function pullRequestCommentName(string $project, string $location, string $repository, string $pullRequest, string $comment): string
    {
        return self::getPathTemplate('pullRequestComment')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'pull_request' => $pullRequest,
            'comment' => $comment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     *
     * @return string The formatted repository resource.
     */
    public static function repositoryName(string $project, string $location, string $repository): string
    {
        return self::getPathTemplate('repository')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $serviceAttachment
     *
     * @return string The formatted service_attachment resource.
     */
    public static function serviceAttachmentName(string $project, string $region, string $serviceAttachment): string
    {
        return self::getPathTemplate('serviceAttachment')->render([
            'project' => $project,
            'region' => $region,
            'service_attachment' => $serviceAttachment,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - branchRule: projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}
     * - caPool: projects/{project}/locations/{location}/caPools/{ca_pool}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - hook: projects/{project}/locations/{location}/repositories/{repository}/hooks/{hook}
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - issue: projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}
     * - issueComment: projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}/issueComments/{comment}
     * - location: projects/{project}/locations/{location}
     * - pullRequest: projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}
     * - pullRequestComment: projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}/pullRequestComments/{comment}
     * - repository: projects/{project}/locations/{location}/repositories/{repository}
     * - serviceAttachment: projects/{project}/regions/{region}/serviceAttachments/{service_attachment}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securesourcemanager.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\SecureSourceManager\V1\SecureSourceManagerClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new SecureSourceManagerClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Batch creates pull request comments. This function is used to create
     * multiple PullRequestComments for code review. There needs to be exactly one
     * PullRequestComment of type Review, and at most 100 PullRequestComments of
     * type Code per request. The Postition of the code comments must be unique
     * within the request.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::batchCreatePullRequestCommentsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/batch_create_pull_request_comments.php
     *
     * @param BatchCreatePullRequestCommentsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BatchCreatePullRequestCommentsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreatePullRequestComments(BatchCreatePullRequestCommentsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BatchCreatePullRequestComments', $request, $callOptions)->wait();
    }

    /**
     * Closes an issue.
     *
     * The async variant is {@see SecureSourceManagerClient::closeIssueAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/close_issue.php
     *
     * @param CloseIssueRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Issue>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function closeIssue(CloseIssueRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CloseIssue', $request, $callOptions)->wait();
    }

    /**
     * Closes a pull request without merging.
     *
     * The async variant is {@see SecureSourceManagerClient::closePullRequestAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/close_pull_request.php
     *
     * @param ClosePullRequestRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequest>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function closePullRequest(ClosePullRequestRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ClosePullRequest', $request, $callOptions)->wait();
    }

    /**
     * CreateBranchRule creates a branch rule in a given repository.
     *
     * The async variant is {@see SecureSourceManagerClient::createBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_branch_rule.php
     *
     * @param CreateBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BranchRule>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBranchRule(CreateBranchRuleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Creates a new hook in a given repository.
     *
     * The async variant is {@see SecureSourceManagerClient::createHookAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_hook.php
     *
     * @param CreateHookRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Hook>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createHook(CreateHookRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateHook', $request, $callOptions)->wait();
    }

    /**
     * Creates a new instance in a given project and location.
     *
     * The async variant is {@see SecureSourceManagerClient::createInstanceAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_instance.php
     *
     * @param CreateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Instance>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstance(CreateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates an issue.
     *
     * The async variant is {@see SecureSourceManagerClient::createIssueAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_issue.php
     *
     * @param CreateIssueRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Issue>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createIssue(CreateIssueRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateIssue', $request, $callOptions)->wait();
    }

    /**
     * Creates an issue comment.
     *
     * The async variant is {@see SecureSourceManagerClient::createIssueCommentAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/create_issue_comment.php
     *
     * @param CreateIssueCommentRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<IssueComment>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createIssueComment(CreateIssueCommentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateIssueComment', $request, $callOptions)->wait();
    }

    /**
     * Creates a pull request.
     *
     * The async variant is {@see SecureSourceManagerClient::createPullRequestAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/create_pull_request.php
     *
     * @param CreatePullRequestRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequest>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPullRequest(CreatePullRequestRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePullRequest', $request, $callOptions)->wait();
    }

    /**
     * Creates a pull request comment. This function is used to create a single
     * PullRequestComment of type Comment, or a single PullRequestComment of type
     * Code that's replying to another PullRequestComment of type Code. Use
     * BatchCreatePullRequestComments to create multiple PullRequestComments for
     * code reviews.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::createPullRequestCommentAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_pull_request_comment.php
     *
     * @param CreatePullRequestCommentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequestComment>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPullRequestComment(CreatePullRequestCommentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePullRequestComment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new repository in a given project and location.
     *
     * The Repository.Instance field is required in the request body for requests
     * using the securesourcemanager.googleapis.com endpoint.
     *
     * The async variant is {@see SecureSourceManagerClient::createRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_repository.php
     *
     * @param CreateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Repository>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRepository(CreateRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRepository', $request, $callOptions)->wait();
    }

    /**
     * DeleteBranchRule deletes a branch rule.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_branch_rule.php
     *
     * @param DeleteBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBranchRule(DeleteBranchRuleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Hook.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteHookAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_hook.php
     *
     * @param DeleteHookRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteHook(DeleteHookRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteHook', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single instance.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteInstanceAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_instance.php
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstance(DeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstance', $request, $callOptions)->wait();
    }

    /**
     * Deletes an issue.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteIssueAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_issue.php
     *
     * @param DeleteIssueRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteIssue(DeleteIssueRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteIssue', $request, $callOptions)->wait();
    }

    /**
     * Deletes an issue comment.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteIssueCommentAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_issue_comment.php
     *
     * @param DeleteIssueCommentRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteIssueComment(DeleteIssueCommentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteIssueComment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a pull request comment.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::deletePullRequestCommentAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_pull_request_comment.php
     *
     * @param DeletePullRequestCommentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePullRequestComment(DeletePullRequestCommentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePullRequestComment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Repository.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_repository.php
     *
     * @param DeleteRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRepository(DeleteRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRepository', $request, $callOptions)->wait();
    }

    /**
     * Fetches a blob from a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::fetchBlobAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/fetch_blob.php
     *
     * @param FetchBlobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchBlobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchBlob(FetchBlobRequest $request, array $callOptions = []): FetchBlobResponse
    {
        return $this->startApiCall('FetchBlob', $request, $callOptions)->wait();
    }

    /**
     * Fetches a tree from a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::fetchTreeAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/fetch_tree.php
     *
     * @param FetchTreeRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchTree(FetchTreeRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('FetchTree', $request, $callOptions);
    }

    /**
     * GetBranchRule gets a branch rule.
     *
     * The async variant is {@see SecureSourceManagerClient::getBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_branch_rule.php
     *
     * @param GetBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BranchRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBranchRule(GetBranchRuleRequest $request, array $callOptions = []): BranchRule
    {
        return $this->startApiCall('GetBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata of a hook.
     *
     * The async variant is {@see SecureSourceManagerClient::getHookAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_hook.php
     *
     * @param GetHookRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Hook
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getHook(GetHookRequest $request, array $callOptions = []): Hook
    {
        return $this->startApiCall('GetHook', $request, $callOptions)->wait();
    }

    /**
     * Get IAM policy for a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::getIamPolicyRepoAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_iam_policy_repo.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicyRepo(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicyRepo', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single instance.
     *
     * The async variant is {@see SecureSourceManagerClient::getInstanceAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets an issue.
     *
     * The async variant is {@see SecureSourceManagerClient::getIssueAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_issue.php
     *
     * @param GetIssueRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Issue
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIssue(GetIssueRequest $request, array $callOptions = []): Issue
    {
        return $this->startApiCall('GetIssue', $request, $callOptions)->wait();
    }

    /**
     * Gets an issue comment.
     *
     * The async variant is {@see SecureSourceManagerClient::getIssueCommentAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_issue_comment.php
     *
     * @param GetIssueCommentRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IssueComment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIssueComment(GetIssueCommentRequest $request, array $callOptions = []): IssueComment
    {
        return $this->startApiCall('GetIssueComment', $request, $callOptions)->wait();
    }

    /**
     * Gets a pull request.
     *
     * The async variant is {@see SecureSourceManagerClient::getPullRequestAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_pull_request.php
     *
     * @param GetPullRequestRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PullRequest
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPullRequest(GetPullRequestRequest $request, array $callOptions = []): PullRequest
    {
        return $this->startApiCall('GetPullRequest', $request, $callOptions)->wait();
    }

    /**
     * Gets a pull request comment.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::getPullRequestCommentAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_pull_request_comment.php
     *
     * @param GetPullRequestCommentRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PullRequestComment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPullRequestComment(GetPullRequestCommentRequest $request, array $callOptions = []): PullRequestComment
    {
        return $this->startApiCall('GetPullRequestComment', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata of a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::getRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_repository.php
     *
     * @param GetRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRepository(GetRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('GetRepository', $request, $callOptions)->wait();
    }

    /**
     * ListBranchRules lists branch rules in a given repository.
     *
     * The async variant is {@see SecureSourceManagerClient::listBranchRulesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_branch_rules.php
     *
     * @param ListBranchRulesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBranchRules(ListBranchRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBranchRules', $request, $callOptions);
    }

    /**
     * Lists hooks in a given repository.
     *
     * The async variant is {@see SecureSourceManagerClient::listHooksAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_hooks.php
     *
     * @param ListHooksRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHooks(ListHooksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListHooks', $request, $callOptions);
    }

    /**
     * Lists Instances in a given project and location.
     *
     * The async variant is {@see SecureSourceManagerClient::listInstancesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions);
    }

    /**
     * Lists comments in an issue.
     *
     * The async variant is {@see SecureSourceManagerClient::listIssueCommentsAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/list_issue_comments.php
     *
     * @param ListIssueCommentsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listIssueComments(ListIssueCommentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListIssueComments', $request, $callOptions);
    }

    /**
     * Lists issues in a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::listIssuesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_issues.php
     *
     * @param ListIssuesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listIssues(ListIssuesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListIssues', $request, $callOptions);
    }

    /**
     * Lists pull request comments.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::listPullRequestCommentsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_pull_request_comments.php
     *
     * @param ListPullRequestCommentsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPullRequestComments(ListPullRequestCommentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPullRequestComments', $request, $callOptions);
    }

    /**
     * Lists a pull request's file diffs.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::listPullRequestFileDiffsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_pull_request_file_diffs.php
     *
     * @param ListPullRequestFileDiffsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPullRequestFileDiffs(ListPullRequestFileDiffsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPullRequestFileDiffs', $request, $callOptions);
    }

    /**
     * Lists pull requests in a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::listPullRequestsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_pull_requests.php
     *
     * @param ListPullRequestsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPullRequests(ListPullRequestsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPullRequests', $request, $callOptions);
    }

    /**
     * Lists Repositories in a given project and location.
     *
     * The instance field is required in the query parameter for requests using
     * the securesourcemanager.googleapis.com endpoint.
     *
     * The async variant is {@see SecureSourceManagerClient::listRepositoriesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_repositories.php
     *
     * @param ListRepositoriesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRepositories(ListRepositoriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRepositories', $request, $callOptions);
    }

    /**
     * Merges a pull request.
     *
     * The async variant is {@see SecureSourceManagerClient::mergePullRequestAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/merge_pull_request.php
     *
     * @param MergePullRequestRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequest>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function mergePullRequest(MergePullRequestRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('MergePullRequest', $request, $callOptions)->wait();
    }

    /**
     * Opens an issue.
     *
     * The async variant is {@see SecureSourceManagerClient::openIssueAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/open_issue.php
     *
     * @param OpenIssueRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Issue>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function openIssue(OpenIssueRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('OpenIssue', $request, $callOptions)->wait();
    }

    /**
     * Opens a pull request.
     *
     * The async variant is {@see SecureSourceManagerClient::openPullRequestAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/open_pull_request.php
     *
     * @param OpenPullRequestRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequest>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function openPullRequest(OpenPullRequestRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('OpenPullRequest', $request, $callOptions)->wait();
    }

    /**
     * Resolves pull request comments. A list of PullRequestComment names must be
     * provided. The PullRequestComment names must be in the same conversation
     * thread. If auto_fill is set, all comments in the conversation thread will
     * be resolved.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::resolvePullRequestCommentsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/resolve_pull_request_comments.php
     *
     * @param ResolvePullRequestCommentsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ResolvePullRequestCommentsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resolvePullRequestComments(ResolvePullRequestCommentsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResolvePullRequestComments', $request, $callOptions)->wait();
    }

    /**
     * Set IAM policy on a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::setIamPolicyRepoAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/set_iam_policy_repo.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicyRepo(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicyRepo', $request, $callOptions)->wait();
    }

    /**
     * Test IAM permissions on a repository.
     * IAM permission checks are not required on this method.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::testIamPermissionsRepoAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/test_iam_permissions_repo.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissionsRepo(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissionsRepo', $request, $callOptions)->wait();
    }

    /**
     * Unresolves pull request comments. A list of PullRequestComment names must
     * be provided. The PullRequestComment names must be in the same conversation
     * thread. If auto_fill is set, all comments in the conversation thread will
     * be unresolved.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::unresolvePullRequestCommentsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/unresolve_pull_request_comments.php
     *
     * @param UnresolvePullRequestCommentsRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<UnresolvePullRequestCommentsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function unresolvePullRequestComments(UnresolvePullRequestCommentsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UnresolvePullRequestComments', $request, $callOptions)->wait();
    }

    /**
     * UpdateBranchRule updates a branch rule.
     *
     * The async variant is {@see SecureSourceManagerClient::updateBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/update_branch_rule.php
     *
     * @param UpdateBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<BranchRule>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBranchRule(UpdateBranchRuleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Updates the metadata of a hook.
     *
     * The async variant is {@see SecureSourceManagerClient::updateHookAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/update_hook.php
     *
     * @param UpdateHookRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Hook>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateHook(UpdateHookRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateHook', $request, $callOptions)->wait();
    }

    /**
     * Updates a issue.
     *
     * The async variant is {@see SecureSourceManagerClient::updateIssueAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/update_issue.php
     *
     * @param UpdateIssueRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Issue>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateIssue(UpdateIssueRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateIssue', $request, $callOptions)->wait();
    }

    /**
     * Updates an issue comment.
     *
     * The async variant is {@see SecureSourceManagerClient::updateIssueCommentAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/update_issue_comment.php
     *
     * @param UpdateIssueCommentRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<IssueComment>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateIssueComment(UpdateIssueCommentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateIssueComment', $request, $callOptions)->wait();
    }

    /**
     * Updates a pull request.
     *
     * The async variant is {@see SecureSourceManagerClient::updatePullRequestAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/update_pull_request.php
     *
     * @param UpdatePullRequestRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequest>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePullRequest(UpdatePullRequestRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePullRequest', $request, $callOptions)->wait();
    }

    /**
     * Updates a pull request comment.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::updatePullRequestCommentAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/update_pull_request_comment.php
     *
     * @param UpdatePullRequestCommentRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<PullRequestComment>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePullRequestComment(UpdatePullRequestCommentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePullRequestComment', $request, $callOptions)->wait();
    }

    /**
     * Updates the metadata of a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::updateRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/update_repository.php
     *
     * @param UpdateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Repository>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRepository(UpdateRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateRepository', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see SecureSourceManagerClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see SecureSourceManagerClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see SecureSourceManagerClient::testIamPermissionsAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see SecureSourceManagerClient::getLocationAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see SecureSourceManagerClient::listLocationsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
