<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/generative_question.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for overall generative question feature state.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.GenerativeQuestionsFeatureConfig</code>
 */
class GenerativeQuestionsFeatureConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Resource name of the affected catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     *
     * Generated from protobuf field <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $catalog = '';
    /**
     * Optional. Determines whether questions will be used at serving time.
     * Note: This feature cannot be enabled until initial data requirements are
     * satisfied.
     *
     * Generated from protobuf field <code>bool feature_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $feature_enabled = false;
    /**
     * Optional. Minimum number of products in the response to trigger follow-up
     * questions. Value must be 0 or positive.
     *
     * Generated from protobuf field <code>int32 minimum_products = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $minimum_products = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $catalog
     *           Required. Resource name of the affected catalog.
     *           Format: projects/{project}/locations/{location}/catalogs/{catalog}
     *     @type bool $feature_enabled
     *           Optional. Determines whether questions will be used at serving time.
     *           Note: This feature cannot be enabled until initial data requirements are
     *           satisfied.
     *     @type int $minimum_products
     *           Optional. Minimum number of products in the response to trigger follow-up
     *           questions. Value must be 0 or positive.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\GenerativeQuestion::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Resource name of the affected catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     *
     * Generated from protobuf field <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCatalog()
    {
        return $this->catalog;
    }

    /**
     * Required. Resource name of the affected catalog.
     * Format: projects/{project}/locations/{location}/catalogs/{catalog}
     *
     * Generated from protobuf field <code>string catalog = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCatalog($var)
    {
        GPBUtil::checkString($var, True);
        $this->catalog = $var;

        return $this;
    }

    /**
     * Optional. Determines whether questions will be used at serving time.
     * Note: This feature cannot be enabled until initial data requirements are
     * satisfied.
     *
     * Generated from protobuf field <code>bool feature_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getFeatureEnabled()
    {
        return $this->feature_enabled;
    }

    /**
     * Optional. Determines whether questions will be used at serving time.
     * Note: This feature cannot be enabled until initial data requirements are
     * satisfied.
     *
     * Generated from protobuf field <code>bool feature_enabled = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setFeatureEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->feature_enabled = $var;

        return $this;
    }

    /**
     * Optional. Minimum number of products in the response to trigger follow-up
     * questions. Value must be 0 or positive.
     *
     * Generated from protobuf field <code>int32 minimum_products = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMinimumProducts()
    {
        return $this->minimum_products;
    }

    /**
     * Optional. Minimum number of products in the response to trigger follow-up
     * questions. Value must be 0 or positive.
     *
     * Generated from protobuf field <code>int32 minimum_products = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMinimumProducts($var)
    {
        GPBUtil::checkInt32($var);
        $this->minimum_products = $var;

        return $this;
    }

}

