<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/admin/v1/backup.proto

namespace Google\Cloud\Firestore\Admin\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Backup of a Cloud Firestore Database.
 * The backup contains all documents and index configurations for the given
 * database at a specific point in time.
 *
 * Generated from protobuf message <code>google.firestore.admin.v1.Backup</code>
 */
class Backup extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The unique resource name of the Backup.
     * Format is `projects/{project}/locations/{location}/backups/{backup}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Output only. Name of the Firestore database that the backup is from.
     * Format is `projects/{project}/databases/{database}`.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $database = '';
    /**
     * Output only. The system-generated UUID4 for the Firestore database that the
     * backup is from.
     *
     * Generated from protobuf field <code>string database_uid = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $database_uid = '';
    /**
     * Output only. The backup contains an externally consistent copy of the
     * database at this time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $snapshot_time = null;
    /**
     * Output only. The timestamp at which this backup expires.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $expire_time = null;
    /**
     * Output only. Statistics about the backup.
     * This data only becomes available after the backup is fully materialized to
     * secondary storage. This field will be empty till then.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.Backup.Stats stats = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $stats = null;
    /**
     * Output only. The current state of the backup.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.Backup.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The unique resource name of the Backup.
     *           Format is `projects/{project}/locations/{location}/backups/{backup}`.
     *     @type string $database
     *           Output only. Name of the Firestore database that the backup is from.
     *           Format is `projects/{project}/databases/{database}`.
     *     @type string $database_uid
     *           Output only. The system-generated UUID4 for the Firestore database that the
     *           backup is from.
     *     @type \Google\Protobuf\Timestamp $snapshot_time
     *           Output only. The backup contains an externally consistent copy of the
     *           database at this time.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. The timestamp at which this backup expires.
     *     @type \Google\Cloud\Firestore\Admin\V1\Backup\Stats $stats
     *           Output only. Statistics about the backup.
     *           This data only becomes available after the backup is fully materialized to
     *           secondary storage. This field will be empty till then.
     *     @type int $state
     *           Output only. The current state of the backup.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\Admin\V1\Backup::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The unique resource name of the Backup.
     * Format is `projects/{project}/locations/{location}/backups/{backup}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The unique resource name of the Backup.
     * Format is `projects/{project}/locations/{location}/backups/{backup}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Name of the Firestore database that the backup is from.
     * Format is `projects/{project}/databases/{database}`.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Output only. Name of the Firestore database that the backup is from.
     * Format is `projects/{project}/databases/{database}`.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Output only. The system-generated UUID4 for the Firestore database that the
     * backup is from.
     *
     * Generated from protobuf field <code>string database_uid = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDatabaseUid()
    {
        return $this->database_uid;
    }

    /**
     * Output only. The system-generated UUID4 for the Firestore database that the
     * backup is from.
     *
     * Generated from protobuf field <code>string database_uid = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabaseUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->database_uid = $var;

        return $this;
    }

    /**
     * Output only. The backup contains an externally consistent copy of the
     * database at this time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getSnapshotTime()
    {
        return $this->snapshot_time;
    }

    public function hasSnapshotTime()
    {
        return isset($this->snapshot_time);
    }

    public function clearSnapshotTime()
    {
        unset($this->snapshot_time);
    }

    /**
     * Output only. The backup contains an externally consistent copy of the
     * database at this time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setSnapshotTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->snapshot_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp at which this backup expires.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. The timestamp at which this backup expires.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. Statistics about the backup.
     * This data only becomes available after the backup is fully materialized to
     * secondary storage. This field will be empty till then.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.Backup.Stats stats = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Firestore\Admin\V1\Backup\Stats|null
     */
    public function getStats()
    {
        return $this->stats;
    }

    public function hasStats()
    {
        return isset($this->stats);
    }

    public function clearStats()
    {
        unset($this->stats);
    }

    /**
     * Output only. Statistics about the backup.
     * This data only becomes available after the backup is fully materialized to
     * secondary storage. This field will be empty till then.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.Backup.Stats stats = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Firestore\Admin\V1\Backup\Stats $var
     * @return $this
     */
    public function setStats($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Firestore\Admin\V1\Backup\Stats::class);
        $this->stats = $var;

        return $this;
    }

    /**
     * Output only. The current state of the backup.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.Backup.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current state of the backup.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.Backup.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Firestore\Admin\V1\Backup\State::class);
        $this->state = $var;

        return $this;
    }

}

