<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/clouddms/v1/clouddms_resources.proto

namespace Google\Cloud\CloudDms\V1\AlloyDbSettings;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings for the cluster's primary instance
 *
 * Generated from protobuf message <code>google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings</code>
 */
class PrimaryInstanceSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $id = '';
    /**
     * Configuration for the machines that host the underlying
     * database engine.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;</code>
     */
    protected $machine_config = null;
    /**
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     *
     * Generated from protobuf field <code>map<string, string> database_flags = 6;</code>
     */
    private $database_flags;
    /**
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    /**
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     *
     * Generated from protobuf field <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $private_ip = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     *           regex expression "[a-z0-9-]+".
     *     @type \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings\MachineConfig $machine_config
     *           Configuration for the machines that host the underlying
     *           database engine.
     *     @type array|\Google\Protobuf\Internal\MapField $database_flags
     *           Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     *           cluster and instances. See the AlloyDB documentation for how these can be
     *           used.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels for the AlloyDB primary instance created by DMS. An object
     *           containing a list of 'key', 'value' pairs.
     *     @type string $private_ip
     *           Output only. The private IP address for the Instance.
     *           This is the connection endpoint for an end-user application.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Clouddms\V1\ClouddmsResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Required. The ID of the AlloyDB primary instance. The ID must satisfy the
     * regex expression "[a-z0-9-]+".
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Configuration for the machines that host the underlying
     * database engine.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;</code>
     * @return \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings\MachineConfig|null
     */
    public function getMachineConfig()
    {
        return $this->machine_config;
    }

    public function hasMachineConfig()
    {
        return isset($this->machine_config);
    }

    public function clearMachineConfig()
    {
        unset($this->machine_config);
    }

    /**
     * Configuration for the machines that host the underlying
     * database engine.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings.MachineConfig machine_config = 2;</code>
     * @param \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings\MachineConfig $var
     * @return $this
     */
    public function setMachineConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings\MachineConfig::class);
        $this->machine_config = $var;

        return $this;
    }

    /**
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     *
     * Generated from protobuf field <code>map<string, string> database_flags = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getDatabaseFlags()
    {
        return $this->database_flags;
    }

    /**
     * Database flags to pass to AlloyDB when DMS is creating the AlloyDB
     * cluster and instances. See the AlloyDB documentation for how these can be
     * used.
     *
     * Generated from protobuf field <code>map<string, string> database_flags = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setDatabaseFlags($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->database_flags = $arr;

        return $this;
    }

    /**
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels for the AlloyDB primary instance created by DMS. An object
     * containing a list of 'key', 'value' pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     *
     * Generated from protobuf field <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPrivateIp()
    {
        return $this->private_ip;
    }

    /**
     * Output only. The private IP address for the Instance.
     * This is the connection endpoint for an end-user application.
     *
     * Generated from protobuf field <code>string private_ip = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateIp($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_ip = $var;

        return $this;
    }

}


