<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/templates.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to retrieve a Cloud Dataflow job template.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.GetTemplateRequest</code>
 */
class GetTemplateRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     */
    protected $project_id = '';
    /**
     * The view to retrieve. Defaults to METADATA_ONLY.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.GetTemplateRequest.TemplateView view = 3;</code>
     */
    protected $view = 0;
    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     */
    protected $location = '';
    protected $template;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project_id
     *           Required. The ID of the Cloud Platform project that the job belongs to.
     *     @type string $gcs_path
     *           Required. A Cloud Storage path to the template from which to
     *           create the job.
     *           Must be valid Cloud Storage URL, beginning with 'gs://'.
     *     @type int $view
     *           The view to retrieve. Defaults to METADATA_ONLY.
     *     @type string $location
     *           The [regional endpoint]
     *           (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     *           which to direct the request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Templates::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Required. A Cloud Storage path to the template from which to
     * create the job.
     * Must be valid Cloud Storage URL, beginning with 'gs://'.
     *
     * Generated from protobuf field <code>string gcs_path = 2;</code>
     * @return string
     */
    public function getGcsPath()
    {
        return $this->readOneof(2);
    }

    public function hasGcsPath()
    {
        return $this->hasOneof(2);
    }

    /**
     * Required. A Cloud Storage path to the template from which to
     * create the job.
     * Must be valid Cloud Storage URL, beginning with 'gs://'.
     *
     * Generated from protobuf field <code>string gcs_path = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The view to retrieve. Defaults to METADATA_ONLY.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.GetTemplateRequest.TemplateView view = 3;</code>
     * @return int
     */
    public function getView()
    {
        return $this->view;
    }

    /**
     * The view to retrieve. Defaults to METADATA_ONLY.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.GetTemplateRequest.TemplateView view = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setView($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\GetTemplateRequest\TemplateView::class);
        $this->view = $var;

        return $this;
    }

    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplate()
    {
        return $this->whichOneof("template");
    }

}

