<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/chronicle/v1/rule.proto

namespace Google\Cloud\Chronicle\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The RuleDeployment resource represents the deployment state of a Rule.
 *
 * Generated from protobuf message <code>google.cloud.chronicle.v1.RuleDeployment</code>
 */
class RuleDeployment extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the rule deployment.
     * Note that RuleDeployment is a child of the overall Rule, not any individual
     * revision, so the resource ID segment for the Rule resource must not
     * reference a specific revision.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Whether the rule is currently deployed continuously against incoming data.
     *
     * Generated from protobuf field <code>bool enabled = 2;</code>
     */
    protected $enabled = false;
    /**
     * Whether detections resulting from this deployment should be considered
     * alerts.
     *
     * Generated from protobuf field <code>bool alerting = 3;</code>
     */
    protected $alerting = false;
    /**
     * The archive state of the rule deployment.
     * Cannot be set to true unless enabled is set to false.
     * If set to true, alerting will automatically be set to false.
     * If currently set to true, enabled, alerting, and run_frequency cannot be
     * updated.
     *
     * Generated from protobuf field <code>bool archived = 4;</code>
     */
    protected $archived = false;
    /**
     * Output only. The timestamp when the rule deployment archive state was last
     * set to true. If the rule deployment's current archive state is not set to
     * true, the field will be empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp archive_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $archive_time = null;
    /**
     * The run frequency of the rule deployment.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RunFrequency run_frequency = 6;</code>
     */
    protected $run_frequency = 0;
    /**
     * Output only. The execution state of the rule deployment.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RuleDeployment.ExecutionState execution_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $execution_state = 0;
    /**
     * Output only. The names of the associated/chained producer rules. Rules are
     * considered producers for this rule if this rule explicitly filters on their
     * ruleid. Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>repeated string producer_rules = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $producer_rules;
    /**
     * Output only. The names of the associated/chained consumer rules. Rules are
     * considered consumers of this rule if their rule text explicitly filters on
     * this rule's ruleid. Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>repeated string consumer_rules = 9 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $consumer_rules;
    /**
     * Output only. The timestamp when the rule deployment alert state was lastly
     * changed. This is filled regardless of the current alert state. E.g. if the
     * current alert status is false, this timestamp will be the timestamp when
     * the alert status was changed to false.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_alert_status_change_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_alert_status_change_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The resource name of the rule deployment.
     *           Note that RuleDeployment is a child of the overall Rule, not any individual
     *           revision, so the resource ID segment for the Rule resource must not
     *           reference a specific revision.
     *           Format:
     *           `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
     *     @type bool $enabled
     *           Whether the rule is currently deployed continuously against incoming data.
     *     @type bool $alerting
     *           Whether detections resulting from this deployment should be considered
     *           alerts.
     *     @type bool $archived
     *           The archive state of the rule deployment.
     *           Cannot be set to true unless enabled is set to false.
     *           If set to true, alerting will automatically be set to false.
     *           If currently set to true, enabled, alerting, and run_frequency cannot be
     *           updated.
     *     @type \Google\Protobuf\Timestamp $archive_time
     *           Output only. The timestamp when the rule deployment archive state was last
     *           set to true. If the rule deployment's current archive state is not set to
     *           true, the field will be empty.
     *     @type int $run_frequency
     *           The run frequency of the rule deployment.
     *     @type int $execution_state
     *           Output only. The execution state of the rule deployment.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $producer_rules
     *           Output only. The names of the associated/chained producer rules. Rules are
     *           considered producers for this rule if this rule explicitly filters on their
     *           ruleid. Format:
     *           `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $consumer_rules
     *           Output only. The names of the associated/chained consumer rules. Rules are
     *           considered consumers of this rule if their rule text explicitly filters on
     *           this rule's ruleid. Format:
     *           `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *     @type \Google\Protobuf\Timestamp $last_alert_status_change_time
     *           Output only. The timestamp when the rule deployment alert state was lastly
     *           changed. This is filled regardless of the current alert state. E.g. if the
     *           current alert status is false, this timestamp will be the timestamp when
     *           the alert status was changed to false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Chronicle\V1\Rule::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the rule deployment.
     * Note that RuleDeployment is a child of the overall Rule, not any individual
     * revision, so the resource ID segment for the Rule resource must not
     * reference a specific revision.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The resource name of the rule deployment.
     * Note that RuleDeployment is a child of the overall Rule, not any individual
     * revision, so the resource ID segment for the Rule resource must not
     * reference a specific revision.
     * Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Whether the rule is currently deployed continuously against incoming data.
     *
     * Generated from protobuf field <code>bool enabled = 2;</code>
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * Whether the rule is currently deployed continuously against incoming data.
     *
     * Generated from protobuf field <code>bool enabled = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * Whether detections resulting from this deployment should be considered
     * alerts.
     *
     * Generated from protobuf field <code>bool alerting = 3;</code>
     * @return bool
     */
    public function getAlerting()
    {
        return $this->alerting;
    }

    /**
     * Whether detections resulting from this deployment should be considered
     * alerts.
     *
     * Generated from protobuf field <code>bool alerting = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setAlerting($var)
    {
        GPBUtil::checkBool($var);
        $this->alerting = $var;

        return $this;
    }

    /**
     * The archive state of the rule deployment.
     * Cannot be set to true unless enabled is set to false.
     * If set to true, alerting will automatically be set to false.
     * If currently set to true, enabled, alerting, and run_frequency cannot be
     * updated.
     *
     * Generated from protobuf field <code>bool archived = 4;</code>
     * @return bool
     */
    public function getArchived()
    {
        return $this->archived;
    }

    /**
     * The archive state of the rule deployment.
     * Cannot be set to true unless enabled is set to false.
     * If set to true, alerting will automatically be set to false.
     * If currently set to true, enabled, alerting, and run_frequency cannot be
     * updated.
     *
     * Generated from protobuf field <code>bool archived = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setArchived($var)
    {
        GPBUtil::checkBool($var);
        $this->archived = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the rule deployment archive state was last
     * set to true. If the rule deployment's current archive state is not set to
     * true, the field will be empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp archive_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getArchiveTime()
    {
        return $this->archive_time;
    }

    public function hasArchiveTime()
    {
        return isset($this->archive_time);
    }

    public function clearArchiveTime()
    {
        unset($this->archive_time);
    }

    /**
     * Output only. The timestamp when the rule deployment archive state was last
     * set to true. If the rule deployment's current archive state is not set to
     * true, the field will be empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp archive_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setArchiveTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->archive_time = $var;

        return $this;
    }

    /**
     * The run frequency of the rule deployment.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RunFrequency run_frequency = 6;</code>
     * @return int
     */
    public function getRunFrequency()
    {
        return $this->run_frequency;
    }

    /**
     * The run frequency of the rule deployment.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RunFrequency run_frequency = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setRunFrequency($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Chronicle\V1\RunFrequency::class);
        $this->run_frequency = $var;

        return $this;
    }

    /**
     * Output only. The execution state of the rule deployment.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RuleDeployment.ExecutionState execution_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getExecutionState()
    {
        return $this->execution_state;
    }

    /**
     * Output only. The execution state of the rule deployment.
     *
     * Generated from protobuf field <code>.google.cloud.chronicle.v1.RuleDeployment.ExecutionState execution_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setExecutionState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Chronicle\V1\RuleDeployment\ExecutionState::class);
        $this->execution_state = $var;

        return $this;
    }

    /**
     * Output only. The names of the associated/chained producer rules. Rules are
     * considered producers for this rule if this rule explicitly filters on their
     * ruleid. Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>repeated string producer_rules = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProducerRules()
    {
        return $this->producer_rules;
    }

    /**
     * Output only. The names of the associated/chained producer rules. Rules are
     * considered producers for this rule if this rule explicitly filters on their
     * ruleid. Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>repeated string producer_rules = 8 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProducerRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->producer_rules = $arr;

        return $this;
    }

    /**
     * Output only. The names of the associated/chained consumer rules. Rules are
     * considered consumers of this rule if their rule text explicitly filters on
     * this rule's ruleid. Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>repeated string consumer_rules = 9 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConsumerRules()
    {
        return $this->consumer_rules;
    }

    /**
     * Output only. The names of the associated/chained consumer rules. Rules are
     * considered consumers of this rule if their rule text explicitly filters on
     * this rule's ruleid. Format:
     * `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
     *
     * Generated from protobuf field <code>repeated string consumer_rules = 9 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConsumerRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->consumer_rules = $arr;

        return $this;
    }

    /**
     * Output only. The timestamp when the rule deployment alert state was lastly
     * changed. This is filled regardless of the current alert state. E.g. if the
     * current alert status is false, this timestamp will be the timestamp when
     * the alert status was changed to false.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_alert_status_change_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getLastAlertStatusChangeTime()
    {
        return $this->last_alert_status_change_time;
    }

    public function hasLastAlertStatusChangeTime()
    {
        return isset($this->last_alert_status_change_time);
    }

    public function clearLastAlertStatusChangeTime()
    {
        unset($this->last_alert_status_change_time);
    }

    /**
     * Output only. The timestamp when the rule deployment alert state was lastly
     * changed. This is filled regardless of the current alert state. E.g. if the
     * current alert status is false, this timestamp will be the timestamp when
     * the alert status was changed to false.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_alert_status_change_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastAlertStatusChangeTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_alert_status_change_time = $var;

        return $this;
    }

}

