<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v2/repositories.proto

namespace Google\Cloud\Build\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for connections to Bitbucket Data Center.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v2.BitbucketDataCenterConfig</code>
 */
class BitbucketDataCenterConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The URI of the Bitbucket Data Center instance or cluster this
     * connection is for.
     *
     * Generated from protobuf field <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $host_uri = '';
    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * used to verify webhook events, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $webhook_secret_secret_version = '';
    /**
     * Required. A http access token with the `REPO_READ` access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $read_authorizer_credential = null;
    /**
     * Required. A http access token with the `REPO_ADMIN` scope access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $authorizer_credential = null;
    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a Bitbucket Data Center. This should only be set if the Bitbucket Data
     * Center is hosted on-premises and not reachable by public internet. If this
     * field is left empty, calls to the Bitbucket Data Center will be made over
     * the public internet.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $service_directory_config = null;
    /**
     * Optional. SSL certificate to use for requests to the Bitbucket Data Center.
     *
     * Generated from protobuf field <code>string ssl_ca = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ssl_ca = '';
    /**
     * Output only. Version of the Bitbucket Data Center running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $server_version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host_uri
     *           Required. The URI of the Bitbucket Data Center instance or cluster this
     *           connection is for.
     *     @type string $webhook_secret_secret_version
     *           Required. Immutable. SecretManager resource containing the webhook secret
     *           used to verify webhook events, formatted as
     *           `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *     @type \Google\Cloud\Build\V2\UserCredential $read_authorizer_credential
     *           Required. A http access token with the `REPO_READ` access.
     *     @type \Google\Cloud\Build\V2\UserCredential $authorizer_credential
     *           Required. A http access token with the `REPO_ADMIN` scope access.
     *     @type \Google\Cloud\Build\V2\ServiceDirectoryConfig $service_directory_config
     *           Optional. Configuration for using Service Directory to privately connect to
     *           a Bitbucket Data Center. This should only be set if the Bitbucket Data
     *           Center is hosted on-premises and not reachable by public internet. If this
     *           field is left empty, calls to the Bitbucket Data Center will be made over
     *           the public internet.
     *     @type string $ssl_ca
     *           Optional. SSL certificate to use for requests to the Bitbucket Data Center.
     *     @type string $server_version
     *           Output only. Version of the Bitbucket Data Center running on the
     *           `host_uri`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V2\Repositories::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The URI of the Bitbucket Data Center instance or cluster this
     * connection is for.
     *
     * Generated from protobuf field <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getHostUri()
    {
        return $this->host_uri;
    }

    /**
     * Required. The URI of the Bitbucket Data Center instance or cluster this
     * connection is for.
     *
     * Generated from protobuf field <code>string host_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setHostUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_uri = $var;

        return $this;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * used to verify webhook events, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWebhookSecretSecretVersion()
    {
        return $this->webhook_secret_secret_version;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * used to verify webhook events, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWebhookSecretSecretVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->webhook_secret_secret_version = $var;

        return $this;
    }

    /**
     * Required. A http access token with the `REPO_READ` access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Build\V2\UserCredential|null
     */
    public function getReadAuthorizerCredential()
    {
        return $this->read_authorizer_credential;
    }

    public function hasReadAuthorizerCredential()
    {
        return isset($this->read_authorizer_credential);
    }

    public function clearReadAuthorizerCredential()
    {
        unset($this->read_authorizer_credential);
    }

    /**
     * Required. A http access token with the `REPO_READ` access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Build\V2\UserCredential $var
     * @return $this
     */
    public function setReadAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V2\UserCredential::class);
        $this->read_authorizer_credential = $var;

        return $this;
    }

    /**
     * Required. A http access token with the `REPO_ADMIN` scope access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Build\V2\UserCredential|null
     */
    public function getAuthorizerCredential()
    {
        return $this->authorizer_credential;
    }

    public function hasAuthorizerCredential()
    {
        return isset($this->authorizer_credential);
    }

    public function clearAuthorizerCredential()
    {
        unset($this->authorizer_credential);
    }

    /**
     * Required. A http access token with the `REPO_ADMIN` scope access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Build\V2\UserCredential $var
     * @return $this
     */
    public function setAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V2\UserCredential::class);
        $this->authorizer_credential = $var;

        return $this;
    }

    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a Bitbucket Data Center. This should only be set if the Bitbucket Data
     * Center is hosted on-premises and not reachable by public internet. If this
     * field is left empty, calls to the Bitbucket Data Center will be made over
     * the public internet.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Build\V2\ServiceDirectoryConfig|null
     */
    public function getServiceDirectoryConfig()
    {
        return $this->service_directory_config;
    }

    public function hasServiceDirectoryConfig()
    {
        return isset($this->service_directory_config);
    }

    public function clearServiceDirectoryConfig()
    {
        unset($this->service_directory_config);
    }

    /**
     * Optional. Configuration for using Service Directory to privately connect to
     * a Bitbucket Data Center. This should only be set if the Bitbucket Data
     * Center is hosted on-premises and not reachable by public internet. If this
     * field is left empty, calls to the Bitbucket Data Center will be made over
     * the public internet.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Build\V2\ServiceDirectoryConfig $var
     * @return $this
     */
    public function setServiceDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V2\ServiceDirectoryConfig::class);
        $this->service_directory_config = $var;

        return $this;
    }

    /**
     * Optional. SSL certificate to use for requests to the Bitbucket Data Center.
     *
     * Generated from protobuf field <code>string ssl_ca = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSslCa()
    {
        return $this->ssl_ca;
    }

    /**
     * Optional. SSL certificate to use for requests to the Bitbucket Data Center.
     *
     * Generated from protobuf field <code>string ssl_ca = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSslCa($var)
    {
        GPBUtil::checkString($var, True);
        $this->ssl_ca = $var;

        return $this;
    }

    /**
     * Output only. Version of the Bitbucket Data Center running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getServerVersion()
    {
        return $this->server_version;
    }

    /**
     * Output only. Version of the Bitbucket Data Center running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setServerVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_version = $var;

        return $this;
    }

}

