<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/batch/v1/job.proto

namespace Google\Cloud\Batch\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A TaskGroup defines one or more Tasks that all share the same TaskSpec.
 *
 * Generated from protobuf message <code>google.cloud.batch.v1.TaskGroup</code>
 */
class TaskGroup extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Required. Tasks in the group share the same task spec.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $task_spec = null;
    /**
     * Number of Tasks in the TaskGroup.
     * Default is 1.
     *
     * Generated from protobuf field <code>int64 task_count = 4;</code>
     */
    protected $task_count = 0;
    /**
     * Max number of tasks that can run in parallel.
     * Default to min(task_count, parallel tasks per job limit).
     * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     *
     * Generated from protobuf field <code>int64 parallelism = 5;</code>
     */
    protected $parallelism = 0;
    /**
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     */
    protected $scheduling_policy = 0;
    /**
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     *
     * Generated from protobuf field <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     */
    private $task_environments;
    /**
     * Max number of tasks that can be run on a VM at the same time.
     * If not specified, the system will decide a value based on available
     * compute resources on a VM and task requirements.
     *
     * Generated from protobuf field <code>int64 task_count_per_node = 10;</code>
     */
    protected $task_count_per_node = 0;
    /**
     * When true, Batch will populate a file with a list of all VMs assigned to
     * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     * of that file. Defaults to false. The host file supports up to 1000 VMs.
     *
     * Generated from protobuf field <code>bool require_hosts_file = 11;</code>
     */
    protected $require_hosts_file = false;
    /**
     * When true, Batch will configure SSH to allow passwordless login between
     * VMs running the Batch tasks in the same TaskGroup.
     *
     * Generated from protobuf field <code>bool permissive_ssh = 12;</code>
     */
    protected $permissive_ssh = false;
    /**
     * Optional. If not set or set to false, Batch uses the root user to execute
     * runnables. If set to true, Batch runs the runnables using a non-root user.
     * Currently, the non-root user Batch used is generated by OS Login. For more
     * information, see [About OS
     * Login](https://cloud.google.com/compute/docs/oslogin).
     *
     * Generated from protobuf field <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $run_as_non_root = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. TaskGroup name.
     *           The system generates this field based on parent Job name.
     *           For example:
     *           "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     *     @type \Google\Cloud\Batch\V1\TaskSpec $task_spec
     *           Required. Tasks in the group share the same task spec.
     *     @type int|string $task_count
     *           Number of Tasks in the TaskGroup.
     *           Default is 1.
     *     @type int|string $parallelism
     *           Max number of tasks that can run in parallel.
     *           Default to min(task_count, parallel tasks per job limit).
     *           See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     *           Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     *     @type int $scheduling_policy
     *           Scheduling policy for Tasks in the TaskGroup.
     *           The default value is AS_SOON_AS_POSSIBLE.
     *     @type array<\Google\Cloud\Batch\V1\Environment>|\Google\Protobuf\Internal\RepeatedField $task_environments
     *           An array of environment variable mappings, which are passed to Tasks with
     *           matching indices. If task_environments is used then task_count should
     *           not be specified in the request (and will be ignored). Task count will be
     *           the length of task_environments.
     *           Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     *           addition to any environment variables set in task_environments, specifying
     *           the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     *           index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     *     @type int|string $task_count_per_node
     *           Max number of tasks that can be run on a VM at the same time.
     *           If not specified, the system will decide a value based on available
     *           compute resources on a VM and task requirements.
     *     @type bool $require_hosts_file
     *           When true, Batch will populate a file with a list of all VMs assigned to
     *           the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     *           of that file. Defaults to false. The host file supports up to 1000 VMs.
     *     @type bool $permissive_ssh
     *           When true, Batch will configure SSH to allow passwordless login between
     *           VMs running the Batch tasks in the same TaskGroup.
     *     @type bool $run_as_non_root
     *           Optional. If not set or set to false, Batch uses the root user to execute
     *           runnables. If set to true, Batch runs the runnables using a non-root user.
     *           Currently, the non-root user Batch used is generated by OS Login. For more
     *           information, see [About OS
     *           Login](https://cloud.google.com/compute/docs/oslogin).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Batch\V1\Job::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. TaskGroup name.
     * The system generates this field based on parent Job name.
     * For example:
     * "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Tasks in the group share the same task spec.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Batch\V1\TaskSpec|null
     */
    public function getTaskSpec()
    {
        return $this->task_spec;
    }

    public function hasTaskSpec()
    {
        return isset($this->task_spec);
    }

    public function clearTaskSpec()
    {
        unset($this->task_spec);
    }

    /**
     * Required. Tasks in the group share the same task spec.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.TaskSpec task_spec = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Batch\V1\TaskSpec $var
     * @return $this
     */
    public function setTaskSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Batch\V1\TaskSpec::class);
        $this->task_spec = $var;

        return $this;
    }

    /**
     * Number of Tasks in the TaskGroup.
     * Default is 1.
     *
     * Generated from protobuf field <code>int64 task_count = 4;</code>
     * @return int|string
     */
    public function getTaskCount()
    {
        return $this->task_count;
    }

    /**
     * Number of Tasks in the TaskGroup.
     * Default is 1.
     *
     * Generated from protobuf field <code>int64 task_count = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTaskCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->task_count = $var;

        return $this;
    }

    /**
     * Max number of tasks that can run in parallel.
     * Default to min(task_count, parallel tasks per job limit).
     * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     *
     * Generated from protobuf field <code>int64 parallelism = 5;</code>
     * @return int|string
     */
    public function getParallelism()
    {
        return $this->parallelism;
    }

    /**
     * Max number of tasks that can run in parallel.
     * Default to min(task_count, parallel tasks per job limit).
     * See: [Job Limits](https://cloud.google.com/batch/quotas#job_limits).
     * Field parallelism must be 1 if the scheduling_policy is IN_ORDER.
     *
     * Generated from protobuf field <code>int64 parallelism = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setParallelism($var)
    {
        GPBUtil::checkInt64($var);
        $this->parallelism = $var;

        return $this;
    }

    /**
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     * @return int
     */
    public function getSchedulingPolicy()
    {
        return $this->scheduling_policy;
    }

    /**
     * Scheduling policy for Tasks in the TaskGroup.
     * The default value is AS_SOON_AS_POSSIBLE.
     *
     * Generated from protobuf field <code>.google.cloud.batch.v1.TaskGroup.SchedulingPolicy scheduling_policy = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setSchedulingPolicy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Batch\V1\TaskGroup\SchedulingPolicy::class);
        $this->scheduling_policy = $var;

        return $this;
    }

    /**
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     *
     * Generated from protobuf field <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTaskEnvironments()
    {
        return $this->task_environments;
    }

    /**
     * An array of environment variable mappings, which are passed to Tasks with
     * matching indices. If task_environments is used then task_count should
     * not be specified in the request (and will be ignored). Task count will be
     * the length of task_environments.
     * Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in
     * addition to any environment variables set in task_environments, specifying
     * the number of Tasks in the Task's parent TaskGroup, and the specific Task's
     * index in the TaskGroup (0 through BATCH_TASK_COUNT - 1).
     *
     * Generated from protobuf field <code>repeated .google.cloud.batch.v1.Environment task_environments = 9;</code>
     * @param array<\Google\Cloud\Batch\V1\Environment>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTaskEnvironments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Batch\V1\Environment::class);
        $this->task_environments = $arr;

        return $this;
    }

    /**
     * Max number of tasks that can be run on a VM at the same time.
     * If not specified, the system will decide a value based on available
     * compute resources on a VM and task requirements.
     *
     * Generated from protobuf field <code>int64 task_count_per_node = 10;</code>
     * @return int|string
     */
    public function getTaskCountPerNode()
    {
        return $this->task_count_per_node;
    }

    /**
     * Max number of tasks that can be run on a VM at the same time.
     * If not specified, the system will decide a value based on available
     * compute resources on a VM and task requirements.
     *
     * Generated from protobuf field <code>int64 task_count_per_node = 10;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTaskCountPerNode($var)
    {
        GPBUtil::checkInt64($var);
        $this->task_count_per_node = $var;

        return $this;
    }

    /**
     * When true, Batch will populate a file with a list of all VMs assigned to
     * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     * of that file. Defaults to false. The host file supports up to 1000 VMs.
     *
     * Generated from protobuf field <code>bool require_hosts_file = 11;</code>
     * @return bool
     */
    public function getRequireHostsFile()
    {
        return $this->require_hosts_file;
    }

    /**
     * When true, Batch will populate a file with a list of all VMs assigned to
     * the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path
     * of that file. Defaults to false. The host file supports up to 1000 VMs.
     *
     * Generated from protobuf field <code>bool require_hosts_file = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setRequireHostsFile($var)
    {
        GPBUtil::checkBool($var);
        $this->require_hosts_file = $var;

        return $this;
    }

    /**
     * When true, Batch will configure SSH to allow passwordless login between
     * VMs running the Batch tasks in the same TaskGroup.
     *
     * Generated from protobuf field <code>bool permissive_ssh = 12;</code>
     * @return bool
     */
    public function getPermissiveSsh()
    {
        return $this->permissive_ssh;
    }

    /**
     * When true, Batch will configure SSH to allow passwordless login between
     * VMs running the Batch tasks in the same TaskGroup.
     *
     * Generated from protobuf field <code>bool permissive_ssh = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setPermissiveSsh($var)
    {
        GPBUtil::checkBool($var);
        $this->permissive_ssh = $var;

        return $this;
    }

    /**
     * Optional. If not set or set to false, Batch uses the root user to execute
     * runnables. If set to true, Batch runs the runnables using a non-root user.
     * Currently, the non-root user Batch used is generated by OS Login. For more
     * information, see [About OS
     * Login](https://cloud.google.com/compute/docs/oslogin).
     *
     * Generated from protobuf field <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getRunAsNonRoot()
    {
        return $this->run_as_non_root;
    }

    /**
     * Optional. If not set or set to false, Batch uses the root user to execute
     * runnables. If set to true, Batch runs the runnables using a non-root user.
     * Currently, the non-root user Batch used is generated by OS Login. For more
     * information, see [About OS
     * Login](https://cloud.google.com/compute/docs/oslogin).
     *
     * Generated from protobuf field <code>bool run_as_non_root = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setRunAsNonRoot($var)
    {
        GPBUtil::checkBool($var);
        $this->run_as_non_root = $var;

        return $this;
    }

}

