<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/baremetalsolution/v2/baremetalsolution.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BareMetalSolution\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BareMetalSolution\V2\CreateNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\CreateProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\CreateSSHKeyRequest;
use Google\Cloud\BareMetalSolution\V2\CreateVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\DeleteNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\DeleteSSHKeyRequest;
use Google\Cloud\BareMetalSolution\V2\DeleteVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\DetachLunRequest;
use Google\Cloud\BareMetalSolution\V2\DisableInteractiveSerialConsoleRequest;
use Google\Cloud\BareMetalSolution\V2\DisableInteractiveSerialConsoleResponse;
use Google\Cloud\BareMetalSolution\V2\EnableInteractiveSerialConsoleRequest;
use Google\Cloud\BareMetalSolution\V2\EnableInteractiveSerialConsoleResponse;
use Google\Cloud\BareMetalSolution\V2\EvictLunRequest;
use Google\Cloud\BareMetalSolution\V2\EvictVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\GetInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\GetLunRequest;
use Google\Cloud\BareMetalSolution\V2\GetNetworkRequest;
use Google\Cloud\BareMetalSolution\V2\GetNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\GetProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\GetVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\GetVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\Instance;
use Google\Cloud\BareMetalSolution\V2\ListInstancesRequest;
use Google\Cloud\BareMetalSolution\V2\ListLunsRequest;
use Google\Cloud\BareMetalSolution\V2\ListNetworkUsageRequest;
use Google\Cloud\BareMetalSolution\V2\ListNetworkUsageResponse;
use Google\Cloud\BareMetalSolution\V2\ListNetworksRequest;
use Google\Cloud\BareMetalSolution\V2\ListNfsSharesRequest;
use Google\Cloud\BareMetalSolution\V2\ListOSImagesRequest;
use Google\Cloud\BareMetalSolution\V2\ListProvisioningQuotasRequest;
use Google\Cloud\BareMetalSolution\V2\ListSSHKeysRequest;
use Google\Cloud\BareMetalSolution\V2\ListVolumeSnapshotsRequest;
use Google\Cloud\BareMetalSolution\V2\ListVolumesRequest;
use Google\Cloud\BareMetalSolution\V2\Lun;
use Google\Cloud\BareMetalSolution\V2\Network;
use Google\Cloud\BareMetalSolution\V2\NfsShare;
use Google\Cloud\BareMetalSolution\V2\ProvisioningConfig;
use Google\Cloud\BareMetalSolution\V2\RenameInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\RenameNetworkRequest;
use Google\Cloud\BareMetalSolution\V2\RenameNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\RenameVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\ResetInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\ResetInstanceResponse;
use Google\Cloud\BareMetalSolution\V2\ResizeVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\RestoreVolumeSnapshotRequest;
use Google\Cloud\BareMetalSolution\V2\SSHKey;
use Google\Cloud\BareMetalSolution\V2\StartInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\StartInstanceResponse;
use Google\Cloud\BareMetalSolution\V2\StopInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\StopInstanceResponse;
use Google\Cloud\BareMetalSolution\V2\SubmitProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\SubmitProvisioningConfigResponse;
use Google\Cloud\BareMetalSolution\V2\UpdateInstanceRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateNetworkRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateNfsShareRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateProvisioningConfigRequest;
use Google\Cloud\BareMetalSolution\V2\UpdateVolumeRequest;
use Google\Cloud\BareMetalSolution\V2\Volume;
use Google\Cloud\BareMetalSolution\V2\VolumeSnapshot;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Performs management operations on Bare Metal Solution servers.
 *
 * The `baremetalsolution.googleapis.com` service provides management
 * capabilities for Bare Metal Solution servers. To access the API methods, you
 * must assign Bare Metal Solution IAM roles containing the desired permissions
 * to your staff in your Google Cloud project. You must also enable the Bare
 * Metal Solution API. Once enabled, the methods act
 * upon specific servers in your Bare Metal Solution environment.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createNfsShareAsync(CreateNfsShareRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProvisioningConfig> createProvisioningConfigAsync(CreateProvisioningConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SSHKey> createSSHKeyAsync(CreateSSHKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<VolumeSnapshot> createVolumeSnapshotAsync(CreateVolumeSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteNfsShareAsync(DeleteNfsShareRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSSHKeyAsync(DeleteSSHKeyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteVolumeSnapshotAsync(DeleteVolumeSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> detachLunAsync(DetachLunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> disableInteractiveSerialConsoleAsync(DisableInteractiveSerialConsoleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> enableInteractiveSerialConsoleAsync(EnableInteractiveSerialConsoleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> evictLunAsync(EvictLunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> evictVolumeAsync(EvictVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Instance> getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Lun> getLunAsync(GetLunRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Network> getNetworkAsync(GetNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NfsShare> getNfsShareAsync(GetNfsShareRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProvisioningConfig> getProvisioningConfigAsync(GetProvisioningConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Volume> getVolumeAsync(GetVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<VolumeSnapshot> getVolumeSnapshotAsync(GetVolumeSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLunsAsync(ListLunsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListNetworkUsageResponse> listNetworkUsageAsync(ListNetworkUsageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNetworksAsync(ListNetworksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listNfsSharesAsync(ListNfsSharesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listOSImagesAsync(ListOSImagesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProvisioningQuotasAsync(ListProvisioningQuotasRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSSHKeysAsync(ListSSHKeysRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listVolumeSnapshotsAsync(ListVolumeSnapshotsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listVolumesAsync(ListVolumesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Instance> renameInstanceAsync(RenameInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Network> renameNetworkAsync(RenameNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<NfsShare> renameNfsShareAsync(RenameNfsShareRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Volume> renameVolumeAsync(RenameVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> resetInstanceAsync(ResetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> resizeVolumeAsync(ResizeVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> restoreVolumeSnapshotAsync(RestoreVolumeSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> startInstanceAsync(StartInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> stopInstanceAsync(StopInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SubmitProvisioningConfigResponse> submitProvisioningConfigAsync(SubmitProvisioningConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateInstanceAsync(UpdateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateNetworkAsync(UpdateNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateNfsShareAsync(UpdateNfsShareRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ProvisioningConfig> updateProvisioningConfigAsync(UpdateProvisioningConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateVolumeAsync(UpdateVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class BareMetalSolutionClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.baremetalsolution.v2.BareMetalSolution';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'baremetalsolution.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'baremetalsolution.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/bare_metal_solution_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/bare_metal_solution_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/bare_metal_solution_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/bare_metal_solution_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * instance_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instanceConfig
     *
     * @return string The formatted instance_config resource.
     */
    public static function instanceConfigName(string $project, string $location, string $instanceConfig): string
    {
        return self::getPathTemplate('instanceConfig')->render([
            'project' => $project,
            'location' => $location,
            'instance_config' => $instanceConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * interconnect_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $interconnectAttachment
     *
     * @return string The formatted interconnect_attachment resource.
     */
    public static function interconnectAttachmentName(string $project, string $region, string $interconnectAttachment): string
    {
        return self::getPathTemplate('interconnectAttachment')->render([
            'project' => $project,
            'region' => $region,
            'interconnect_attachment' => $interconnectAttachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a lun
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $lun
     *
     * @return string The formatted lun resource.
     */
    public static function lunName(string $project, string $location, string $volume, string $lun): string
    {
        return self::getPathTemplate('lun')->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'lun' => $lun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a nfs_share
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $nfsShare
     *
     * @return string The formatted nfs_share resource.
     */
    public static function nFSShareName(string $project, string $location, string $nfsShare): string
    {
        return self::getPathTemplate('nFSShare')->render([
            'project' => $project,
            'location' => $location,
            'nfs_share' => $nfsShare,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $location, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'location' => $location,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkConfig
     *
     * @return string The formatted network_config resource.
     */
    public static function networkConfigName(string $project, string $location, string $networkConfig): string
    {
        return self::getPathTemplate('networkConfig')->render([
            'project' => $project,
            'location' => $location,
            'network_config' => $networkConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * provisioning_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $provisioningConfig
     *
     * @return string The formatted provisioning_config resource.
     */
    public static function provisioningConfigName(string $project, string $location, string $provisioningConfig): string
    {
        return self::getPathTemplate('provisioningConfig')->render([
            'project' => $project,
            'location' => $location,
            'provisioning_config' => $provisioningConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * server_network_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serverNetworkTemplate
     *
     * @return string The formatted server_network_template resource.
     */
    public static function serverNetworkTemplateName(string $project, string $location, string $serverNetworkTemplate): string
    {
        return self::getPathTemplate('serverNetworkTemplate')->render([
            'project' => $project,
            'location' => $location,
            'server_network_template' => $serverNetworkTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ssh_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $sshKey
     *
     * @return string The formatted ssh_key resource.
     */
    public static function sshKeyName(string $project, string $location, string $sshKey): string
    {
        return self::getPathTemplate('sshKey')->render([
            'project' => $project,
            'location' => $location,
            'ssh_key' => $sshKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a volume
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     *
     * @return string The formatted volume resource.
     */
    public static function volumeName(string $project, string $location, string $volume): string
    {
        return self::getPathTemplate('volume')->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volumeConfig
     *
     * @return string The formatted volume_config resource.
     */
    public static function volumeConfigName(string $project, string $location, string $volumeConfig): string
    {
        return self::getPathTemplate('volumeConfig')->render([
            'project' => $project,
            'location' => $location,
            'volume_config' => $volumeConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_snapshot resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $snapshot
     *
     * @return string The formatted volume_snapshot resource.
     */
    public static function volumeSnapshotName(string $project, string $location, string $volume, string $snapshot): string
    {
        return self::getPathTemplate('volumeSnapshot')->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'snapshot' => $snapshot,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - instanceConfig: projects/{project}/locations/{location}/instanceConfigs/{instance_config}
     * - interconnectAttachment: projects/{project}/regions/{region}/interconnectAttachments/{interconnect_attachment}
     * - location: projects/{project}/locations/{location}
     * - lun: projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}
     * - nFSShare: projects/{project}/locations/{location}/nfsShares/{nfs_share}
     * - network: projects/{project}/locations/{location}/networks/{network}
     * - networkConfig: projects/{project}/locations/{location}/networkConfigs/{network_config}
     * - provisioningConfig: projects/{project}/locations/{location}/provisioningConfigs/{provisioning_config}
     * - serverNetworkTemplate: projects/{project}/locations/{location}/serverNetworkTemplate/{server_network_template}
     * - sshKey: projects/{project}/locations/{location}/sshKeys/{ssh_key}
     * - volume: projects/{project}/locations/{location}/volumes/{volume}
     * - volumeConfig: projects/{project}/locations/{location}/volumeConfigs/{volume_config}
     * - volumeSnapshot: projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'baremetalsolution.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\BareMetalSolution\V2\BareMetalSolutionClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new BareMetalSolutionClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create an NFS share.
     *
     * The async variant is {@see BareMetalSolutionClient::createNfsShareAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/create_nfs_share.php
     *
     * @param CreateNfsShareRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<NfsShare>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNfsShare(CreateNfsShareRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateNfsShare', $request, $callOptions)->wait();
    }

    /**
     * Create new ProvisioningConfig.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::createProvisioningConfigAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/create_provisioning_config.php
     *
     * @param CreateProvisioningConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProvisioningConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createProvisioningConfig(CreateProvisioningConfigRequest $request, array $callOptions = []): ProvisioningConfig
    {
        return $this->startApiCall('CreateProvisioningConfig', $request, $callOptions)->wait();
    }

    /**
     * Register a public SSH key in the specified project for use with the
     * interactive serial console feature.
     *
     * The async variant is {@see BareMetalSolutionClient::createSSHKeyAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/create_ssh_key.php
     *
     * @param CreateSSHKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SSHKey
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSSHKey(CreateSSHKeyRequest $request, array $callOptions = []): SSHKey
    {
        return $this->startApiCall('CreateSSHKey', $request, $callOptions)->wait();
    }

    /**
     * Takes a snapshot of a boot volume.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * The async variant is {@see BareMetalSolutionClient::createVolumeSnapshotAsync()}
     * .
     *
     * @example samples/V2/BareMetalSolutionClient/create_volume_snapshot.php
     *
     * @param CreateVolumeSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VolumeSnapshot
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVolumeSnapshot(CreateVolumeSnapshotRequest $request, array $callOptions = []): VolumeSnapshot
    {
        return $this->startApiCall('CreateVolumeSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Delete an NFS share. The underlying volume is automatically deleted.
     *
     * The async variant is {@see BareMetalSolutionClient::deleteNfsShareAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/delete_nfs_share.php
     *
     * @param DeleteNfsShareRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNfsShare(DeleteNfsShareRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteNfsShare', $request, $callOptions)->wait();
    }

    /**
     * Deletes a public SSH key registered in the specified project.
     *
     * The async variant is {@see BareMetalSolutionClient::deleteSSHKeyAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/delete_ssh_key.php
     *
     * @param DeleteSSHKeyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSSHKey(DeleteSSHKeyRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSSHKey', $request, $callOptions)->wait();
    }

    /**
     * Deletes a volume snapshot.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * The async variant is {@see BareMetalSolutionClient::deleteVolumeSnapshotAsync()}
     * .
     *
     * @example samples/V2/BareMetalSolutionClient/delete_volume_snapshot.php
     *
     * @param DeleteVolumeSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVolumeSnapshot(DeleteVolumeSnapshotRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteVolumeSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Detach LUN from Instance.
     *
     * The async variant is {@see BareMetalSolutionClient::detachLunAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/detach_lun.php
     *
     * @param DetachLunRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Instance>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function detachLun(DetachLunRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DetachLun', $request, $callOptions)->wait();
    }

    /**
     * Disable the interactive serial console feature on an instance.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::disableInteractiveSerialConsoleAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/disable_interactive_serial_console.php
     *
     * @param DisableInteractiveSerialConsoleRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<DisableInteractiveSerialConsoleResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disableInteractiveSerialConsole(DisableInteractiveSerialConsoleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DisableInteractiveSerialConsole', $request, $callOptions)->wait();
    }

    /**
     * Enable the interactive serial console feature on an instance.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::enableInteractiveSerialConsoleAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/enable_interactive_serial_console.php
     *
     * @param EnableInteractiveSerialConsoleRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<EnableInteractiveSerialConsoleResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enableInteractiveSerialConsole(EnableInteractiveSerialConsoleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EnableInteractiveSerialConsole', $request, $callOptions)->wait();
    }

    /**
     * Skips lun's cooloff and deletes it now.
     * Lun must be in cooloff state.
     *
     * The async variant is {@see BareMetalSolutionClient::evictLunAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/evict_lun.php
     *
     * @param EvictLunRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function evictLun(EvictLunRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EvictLun', $request, $callOptions)->wait();
    }

    /**
     * Skips volume's cooloff and deletes it now.
     * Volume must be in cooloff state.
     *
     * The async variant is {@see BareMetalSolutionClient::evictVolumeAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/evict_volume.php
     *
     * @param EvictVolumeRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<null>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function evictVolume(EvictVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EvictVolume', $request, $callOptions)->wait();
    }

    /**
     * Get details about a single server.
     *
     * The async variant is {@see BareMetalSolutionClient::getInstanceAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Get details of a single storage logical unit number(LUN).
     *
     * The async variant is {@see BareMetalSolutionClient::getLunAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_lun.php
     *
     * @param GetLunRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Lun
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLun(GetLunRequest $request, array $callOptions = []): Lun
    {
        return $this->startApiCall('GetLun', $request, $callOptions)->wait();
    }

    /**
     * Get details of a single network.
     *
     * The async variant is {@see BareMetalSolutionClient::getNetworkAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_network.php
     *
     * @param GetNetworkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Network
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNetwork(GetNetworkRequest $request, array $callOptions = []): Network
    {
        return $this->startApiCall('GetNetwork', $request, $callOptions)->wait();
    }

    /**
     * Get details of a single NFS share.
     *
     * The async variant is {@see BareMetalSolutionClient::getNfsShareAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_nfs_share.php
     *
     * @param GetNfsShareRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NfsShare
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNfsShare(GetNfsShareRequest $request, array $callOptions = []): NfsShare
    {
        return $this->startApiCall('GetNfsShare', $request, $callOptions)->wait();
    }

    /**
     * Get ProvisioningConfig by name.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::getProvisioningConfigAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_provisioning_config.php
     *
     * @param GetProvisioningConfigRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProvisioningConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProvisioningConfig(GetProvisioningConfigRequest $request, array $callOptions = []): ProvisioningConfig
    {
        return $this->startApiCall('GetProvisioningConfig', $request, $callOptions)->wait();
    }

    /**
     * Get details of a single storage volume.
     *
     * The async variant is {@see BareMetalSolutionClient::getVolumeAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_volume.php
     *
     * @param GetVolumeRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Volume
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVolume(GetVolumeRequest $request, array $callOptions = []): Volume
    {
        return $this->startApiCall('GetVolume', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified snapshot resource.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * The async variant is {@see BareMetalSolutionClient::getVolumeSnapshotAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_volume_snapshot.php
     *
     * @param GetVolumeSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VolumeSnapshot
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVolumeSnapshot(GetVolumeSnapshotRequest $request, array $callOptions = []): VolumeSnapshot
    {
        return $this->startApiCall('GetVolumeSnapshot', $request, $callOptions)->wait();
    }

    /**
     * List servers in a given project and location.
     *
     * The async variant is {@see BareMetalSolutionClient::listInstancesAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions);
    }

    /**
     * List storage volume luns for given storage volume.
     *
     * The async variant is {@see BareMetalSolutionClient::listLunsAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_luns.php
     *
     * @param ListLunsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLuns(ListLunsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLuns', $request, $callOptions);
    }

    /**
     * List all Networks (and used IPs for each Network) in the vendor account
     * associated with the specified project.
     *
     * The async variant is {@see BareMetalSolutionClient::listNetworkUsageAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_network_usage.php
     *
     * @param ListNetworkUsageRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListNetworkUsageResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNetworkUsage(ListNetworkUsageRequest $request, array $callOptions = []): ListNetworkUsageResponse
    {
        return $this->startApiCall('ListNetworkUsage', $request, $callOptions)->wait();
    }

    /**
     * List network in a given project and location.
     *
     * The async variant is {@see BareMetalSolutionClient::listNetworksAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_networks.php
     *
     * @param ListNetworksRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNetworks(ListNetworksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNetworks', $request, $callOptions);
    }

    /**
     * List NFS shares.
     *
     * The async variant is {@see BareMetalSolutionClient::listNfsSharesAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_nfs_shares.php
     *
     * @param ListNfsSharesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNfsShares(ListNfsSharesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNfsShares', $request, $callOptions);
    }

    /**
     * Retrieves the list of OS images which are currently approved.
     *
     * The async variant is {@see BareMetalSolutionClient::listOSImagesAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_os_images.php
     *
     * @param ListOSImagesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listOSImages(ListOSImagesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListOSImages', $request, $callOptions);
    }

    /**
     * List the budget details to provision resources on a given project.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::listProvisioningQuotasAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_provisioning_quotas.php
     *
     * @param ListProvisioningQuotasRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProvisioningQuotas(ListProvisioningQuotasRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProvisioningQuotas', $request, $callOptions);
    }

    /**
     * Lists the public SSH keys registered for the specified project.
     * These SSH keys are used only for the interactive serial console feature.
     *
     * The async variant is {@see BareMetalSolutionClient::listSSHKeysAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_ssh_keys.php
     *
     * @param ListSSHKeysRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSSHKeys(ListSSHKeysRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSSHKeys', $request, $callOptions);
    }

    /**
     * Retrieves the list of snapshots for the specified volume.
     * Returns a response with an empty list of snapshots if called
     * for a non-boot volume.
     *
     * The async variant is {@see BareMetalSolutionClient::listVolumeSnapshotsAsync()}
     * .
     *
     * @example samples/V2/BareMetalSolutionClient/list_volume_snapshots.php
     *
     * @param ListVolumeSnapshotsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVolumeSnapshots(ListVolumeSnapshotsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVolumeSnapshots', $request, $callOptions);
    }

    /**
     * List storage volumes in a given project and location.
     *
     * The async variant is {@see BareMetalSolutionClient::listVolumesAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_volumes.php
     *
     * @param ListVolumesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVolumes(ListVolumesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVolumes', $request, $callOptions);
    }

    /**
     * RenameInstance sets a new name for an instance.
     * Use with caution, previous names become immediately invalidated.
     *
     * The async variant is {@see BareMetalSolutionClient::renameInstanceAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/rename_instance.php
     *
     * @param RenameInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameInstance(RenameInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('RenameInstance', $request, $callOptions)->wait();
    }

    /**
     * RenameNetwork sets a new name for a network.
     * Use with caution, previous names become immediately invalidated.
     *
     * The async variant is {@see BareMetalSolutionClient::renameNetworkAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/rename_network.php
     *
     * @param RenameNetworkRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Network
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameNetwork(RenameNetworkRequest $request, array $callOptions = []): Network
    {
        return $this->startApiCall('RenameNetwork', $request, $callOptions)->wait();
    }

    /**
     * RenameNfsShare sets a new name for an nfsshare.
     * Use with caution, previous names become immediately invalidated.
     *
     * The async variant is {@see BareMetalSolutionClient::renameNfsShareAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/rename_nfs_share.php
     *
     * @param RenameNfsShareRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NfsShare
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameNfsShare(RenameNfsShareRequest $request, array $callOptions = []): NfsShare
    {
        return $this->startApiCall('RenameNfsShare', $request, $callOptions)->wait();
    }

    /**
     * RenameVolume sets a new name for a volume.
     * Use with caution, previous names become immediately invalidated.
     *
     * The async variant is {@see BareMetalSolutionClient::renameVolumeAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/rename_volume.php
     *
     * @param RenameVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Volume
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameVolume(RenameVolumeRequest $request, array $callOptions = []): Volume
    {
        return $this->startApiCall('RenameVolume', $request, $callOptions)->wait();
    }

    /**
     * Perform an ungraceful, hard reset on a server. Equivalent to shutting the
     * power off and then turning it back on.
     *
     * The async variant is {@see BareMetalSolutionClient::resetInstanceAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/reset_instance.php
     *
     * @param ResetInstanceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ResetInstanceResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resetInstance(ResetInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResetInstance', $request, $callOptions)->wait();
    }

    /**
     * Emergency Volume resize.
     *
     * The async variant is {@see BareMetalSolutionClient::resizeVolumeAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/resize_volume.php
     *
     * @param ResizeVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Volume>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resizeVolume(ResizeVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResizeVolume', $request, $callOptions)->wait();
    }

    /**
     * Uses the specified snapshot to restore its parent volume.
     * Returns INVALID_ARGUMENT if called for a non-boot volume.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::restoreVolumeSnapshotAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/restore_volume_snapshot.php
     *
     * @param RestoreVolumeSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<VolumeSnapshot>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreVolumeSnapshot(RestoreVolumeSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreVolumeSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Starts a server that was shutdown.
     *
     * The async variant is {@see BareMetalSolutionClient::startInstanceAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/start_instance.php
     *
     * @param StartInstanceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<StartInstanceResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startInstance(StartInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StartInstance', $request, $callOptions)->wait();
    }

    /**
     * Stop a running server.
     *
     * The async variant is {@see BareMetalSolutionClient::stopInstanceAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/stop_instance.php
     *
     * @param StopInstanceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<StopInstanceResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopInstance(StopInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StopInstance', $request, $callOptions)->wait();
    }

    /**
     * Submit a provisiong configuration for a given project.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::submitProvisioningConfigAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/submit_provisioning_config.php
     *
     * @param SubmitProvisioningConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SubmitProvisioningConfigResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function submitProvisioningConfig(SubmitProvisioningConfigRequest $request, array $callOptions = []): SubmitProvisioningConfigResponse
    {
        return $this->startApiCall('SubmitProvisioningConfig', $request, $callOptions)->wait();
    }

    /**
     * Update details of a single server.
     *
     * The async variant is {@see BareMetalSolutionClient::updateInstanceAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/update_instance.php
     *
     * @param UpdateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Instance>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInstance(UpdateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateInstance', $request, $callOptions)->wait();
    }

    /**
     * Update details of a single network.
     *
     * The async variant is {@see BareMetalSolutionClient::updateNetworkAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/update_network.php
     *
     * @param UpdateNetworkRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Network>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNetwork(UpdateNetworkRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateNetwork', $request, $callOptions)->wait();
    }

    /**
     * Update details of a single NFS share.
     *
     * The async variant is {@see BareMetalSolutionClient::updateNfsShareAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/update_nfs_share.php
     *
     * @param UpdateNfsShareRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<NfsShare>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNfsShare(UpdateNfsShareRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateNfsShare', $request, $callOptions)->wait();
    }

    /**
     * Update existing ProvisioningConfig.
     *
     * The async variant is
     * {@see BareMetalSolutionClient::updateProvisioningConfigAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/update_provisioning_config.php
     *
     * @param UpdateProvisioningConfigRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProvisioningConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateProvisioningConfig(UpdateProvisioningConfigRequest $request, array $callOptions = []): ProvisioningConfig
    {
        return $this->startApiCall('UpdateProvisioningConfig', $request, $callOptions)->wait();
    }

    /**
     * Update details of a single storage volume.
     *
     * The async variant is {@see BareMetalSolutionClient::updateVolumeAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/update_volume.php
     *
     * @param UpdateVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Volume>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVolume(UpdateVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateVolume', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see BareMetalSolutionClient::getLocationAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see BareMetalSolutionClient::listLocationsAsync()} .
     *
     * @example samples/V2/BareMetalSolutionClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
