<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/asset_service.proto

namespace Google\Cloud\Asset\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * QueryAssets request.
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.QueryAssetsRequest</code>
 */
class QueryAssetsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The relative name of the root asset. This can only be an
     * organization number (such as "organizations/123"), a project ID (such as
     * "projects/my-project-id"), or a project number (such as "projects/12345"),
     * or a folder number (such as "folders/123").
     * Only assets belonging to the `parent` will be returned.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Optional. The maximum number of rows to return in the results. Responses
     * are limited to 10 MB and 1000 rows.
     * By default, the maximum row count is 1000. When the byte or row count limit
     * is reached, the rest of the query results will be paginated.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. A page token received from previous `QueryAssets`.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';
    /**
     * Optional. Specifies the maximum amount of time that the client is willing
     * to wait for the query to complete. By default, this limit is 5 min for the
     * first query, and 1 minute for the following queries. If the query is
     * complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
     * false.
     * Like BigQuery [jobs.query
     * API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
     * The call is not guaranteed to wait for the specified timeout; it typically
     * returns after around 200 seconds (200,000 milliseconds), even if the query
     * is not complete.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $timeout = null;
    /**
     * Optional. Destination where the query results will be saved.
     * When this field is specified, the query results won't be saved in the
     * [QueryAssetsResponse.query_result]. Instead
     * [QueryAssetsResponse.output_config] will be set.
     * Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
     * to check the status of the query job when passed to a following
     * [QueryAssets] API call.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.QueryAssetsOutputConfig output_config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $output_config = null;
    protected $query;
    protected $time;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The relative name of the root asset. This can only be an
     *           organization number (such as "organizations/123"), a project ID (such as
     *           "projects/my-project-id"), or a project number (such as "projects/12345"),
     *           or a folder number (such as "folders/123").
     *           Only assets belonging to the `parent` will be returned.
     *     @type string $statement
     *           Optional. A SQL statement that's compatible with [BigQuery
     *           SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
     *     @type string $job_reference
     *           Optional. Reference to the query job, which is from the
     *           `QueryAssetsResponse` of previous `QueryAssets` call.
     *     @type int $page_size
     *           Optional. The maximum number of rows to return in the results. Responses
     *           are limited to 10 MB and 1000 rows.
     *           By default, the maximum row count is 1000. When the byte or row count limit
     *           is reached, the rest of the query results will be paginated.
     *           The field will be ignored when [output_config] is specified.
     *     @type string $page_token
     *           Optional. A page token received from previous `QueryAssets`.
     *           The field will be ignored when [output_config] is specified.
     *     @type \Google\Protobuf\Duration $timeout
     *           Optional. Specifies the maximum amount of time that the client is willing
     *           to wait for the query to complete. By default, this limit is 5 min for the
     *           first query, and 1 minute for the following queries. If the query is
     *           complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
     *           false.
     *           Like BigQuery [jobs.query
     *           API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
     *           The call is not guaranteed to wait for the specified timeout; it typically
     *           returns after around 200 seconds (200,000 milliseconds), even if the query
     *           is not complete.
     *           The field will be ignored when [output_config] is specified.
     *     @type \Google\Cloud\Asset\V1\TimeWindow $read_time_window
     *           Optional. [start_time] is required. [start_time] must be less than
     *           [end_time] Defaults [end_time] to now if [start_time] is set and
     *           [end_time] isn't. Maximum permitted time range is 7 days.
     *     @type \Google\Protobuf\Timestamp $read_time
     *           Optional. Queries cloud assets as they appeared at the specified point in
     *           time.
     *     @type \Google\Cloud\Asset\V1\QueryAssetsOutputConfig $output_config
     *           Optional. Destination where the query results will be saved.
     *           When this field is specified, the query results won't be saved in the
     *           [QueryAssetsResponse.query_result]. Instead
     *           [QueryAssetsResponse.output_config] will be set.
     *           Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
     *           to check the status of the query job when passed to a following
     *           [QueryAssets] API call.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\AssetService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The relative name of the root asset. This can only be an
     * organization number (such as "organizations/123"), a project ID (such as
     * "projects/my-project-id"), or a project number (such as "projects/12345"),
     * or a folder number (such as "folders/123").
     * Only assets belonging to the `parent` will be returned.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The relative name of the root asset. This can only be an
     * organization number (such as "organizations/123"), a project ID (such as
     * "projects/my-project-id"), or a project number (such as "projects/12345"),
     * or a folder number (such as "folders/123").
     * Only assets belonging to the `parent` will be returned.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Optional. A SQL statement that's compatible with [BigQuery
     * SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
     *
     * Generated from protobuf field <code>string statement = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getStatement()
    {
        return $this->readOneof(2);
    }

    public function hasStatement()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. A SQL statement that's compatible with [BigQuery
     * SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
     *
     * Generated from protobuf field <code>string statement = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setStatement($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. Reference to the query job, which is from the
     * `QueryAssetsResponse` of previous `QueryAssets` call.
     *
     * Generated from protobuf field <code>string job_reference = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getJobReference()
    {
        return $this->readOneof(3);
    }

    public function hasJobReference()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. Reference to the query job, which is from the
     * `QueryAssetsResponse` of previous `QueryAssets` call.
     *
     * Generated from protobuf field <code>string job_reference = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setJobReference($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Optional. The maximum number of rows to return in the results. Responses
     * are limited to 10 MB and 1000 rows.
     * By default, the maximum row count is 1000. When the byte or row count limit
     * is reached, the rest of the query results will be paginated.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of rows to return in the results. Responses
     * are limited to 10 MB and 1000 rows.
     * By default, the maximum row count is 1000. When the byte or row count limit
     * is reached, the rest of the query results will be paginated.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. A page token received from previous `QueryAssets`.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. A page token received from previous `QueryAssets`.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * Optional. Specifies the maximum amount of time that the client is willing
     * to wait for the query to complete. By default, this limit is 5 min for the
     * first query, and 1 minute for the following queries. If the query is
     * complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
     * false.
     * Like BigQuery [jobs.query
     * API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
     * The call is not guaranteed to wait for the specified timeout; it typically
     * returns after around 200 seconds (200,000 milliseconds), even if the query
     * is not complete.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * Optional. Specifies the maximum amount of time that the client is willing
     * to wait for the query to complete. By default, this limit is 5 min for the
     * first query, and 1 minute for the following queries. If the query is
     * complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
     * false.
     * Like BigQuery [jobs.query
     * API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
     * The call is not guaranteed to wait for the specified timeout; it typically
     * returns after around 200 seconds (200,000 milliseconds), even if the query
     * is not complete.
     * The field will be ignored when [output_config] is specified.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Optional. [start_time] is required. [start_time] must be less than
     * [end_time] Defaults [end_time] to now if [start_time] is set and
     * [end_time] isn't. Maximum permitted time range is 7 days.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.TimeWindow read_time_window = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Asset\V1\TimeWindow|null
     */
    public function getReadTimeWindow()
    {
        return $this->readOneof(7);
    }

    public function hasReadTimeWindow()
    {
        return $this->hasOneof(7);
    }

    /**
     * Optional. [start_time] is required. [start_time] must be less than
     * [end_time] Defaults [end_time] to now if [start_time] is set and
     * [end_time] isn't. Maximum permitted time range is 7 days.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.TimeWindow read_time_window = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Asset\V1\TimeWindow $var
     * @return $this
     */
    public function setReadTimeWindow($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Asset\V1\TimeWindow::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Optional. Queries cloud assets as they appeared at the specified point in
     * time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp read_time = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getReadTime()
    {
        return $this->readOneof(8);
    }

    public function hasReadTime()
    {
        return $this->hasOneof(8);
    }

    /**
     * Optional. Queries cloud assets as they appeared at the specified point in
     * time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp read_time = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setReadTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Optional. Destination where the query results will be saved.
     * When this field is specified, the query results won't be saved in the
     * [QueryAssetsResponse.query_result]. Instead
     * [QueryAssetsResponse.output_config] will be set.
     * Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
     * to check the status of the query job when passed to a following
     * [QueryAssets] API call.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.QueryAssetsOutputConfig output_config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Asset\V1\QueryAssetsOutputConfig|null
     */
    public function getOutputConfig()
    {
        return $this->output_config;
    }

    public function hasOutputConfig()
    {
        return isset($this->output_config);
    }

    public function clearOutputConfig()
    {
        unset($this->output_config);
    }

    /**
     * Optional. Destination where the query results will be saved.
     * When this field is specified, the query results won't be saved in the
     * [QueryAssetsResponse.query_result]. Instead
     * [QueryAssetsResponse.output_config] will be set.
     * Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
     * to check the status of the query job when passed to a following
     * [QueryAssets] API call.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.QueryAssetsOutputConfig output_config = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Asset\V1\QueryAssetsOutputConfig $var
     * @return $this
     */
    public function setOutputConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Asset\V1\QueryAssetsOutputConfig::class);
        $this->output_config = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getQuery()
    {
        return $this->whichOneof("query");
    }

    /**
     * @return string
     */
    public function getTime()
    {
        return $this->whichOneof("time");
    }

}

