<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/appengine/v1/certificate.proto

namespace Google\Cloud\AppEngine\V1;

use UnexpectedValueException;

/**
 * State of certificate management. Refers to the most recent certificate
 * acquisition or renewal attempt.
 *
 * Protobuf type <code>google.appengine.v1.ManagementStatus</code>
 */
class ManagementStatus
{
    /**
     * Generated from protobuf enum <code>MANAGEMENT_STATUS_UNSPECIFIED = 0;</code>
     */
    const MANAGEMENT_STATUS_UNSPECIFIED = 0;
    /**
     * Certificate was successfully obtained and inserted into the serving
     * system.
     *
     * Generated from protobuf enum <code>OK = 1;</code>
     */
    const OK = 1;
    /**
     * Certificate is under active attempts to acquire or renew.
     *
     * Generated from protobuf enum <code>PENDING = 2;</code>
     */
    const PENDING = 2;
    /**
     * Most recent renewal failed due to an invalid DNS setup and will be
     * retried. Renewal attempts will continue to fail until the certificate
     * domain's DNS configuration is fixed. The last successfully provisioned
     * certificate may still be serving.
     *
     * Generated from protobuf enum <code>FAILED_RETRYING_NOT_VISIBLE = 4;</code>
     */
    const FAILED_RETRYING_NOT_VISIBLE = 4;
    /**
     * All renewal attempts have been exhausted, likely due to an invalid DNS
     * setup.
     *
     * Generated from protobuf enum <code>FAILED_PERMANENT = 6;</code>
     */
    const FAILED_PERMANENT = 6;
    /**
     * Most recent renewal failed due to an explicit CAA record that does not
     * include one of the in-use CAs (Google CA and Let's Encrypt). Renewals will
     * continue to fail until the CAA is reconfigured. The last successfully
     * provisioned certificate may still be serving.
     *
     * Generated from protobuf enum <code>FAILED_RETRYING_CAA_FORBIDDEN = 7;</code>
     */
    const FAILED_RETRYING_CAA_FORBIDDEN = 7;
    /**
     * Most recent renewal failed due to a CAA retrieval failure. This means that
     * the domain's DNS provider does not properly handle CAA records, failing
     * requests for CAA records when no CAA records are defined. Renewals will
     * continue to fail until the DNS provider is changed or a CAA record is
     * added for the given domain. The last successfully provisioned certificate
     * may still be serving.
     *
     * Generated from protobuf enum <code>FAILED_RETRYING_CAA_CHECKING = 8;</code>
     */
    const FAILED_RETRYING_CAA_CHECKING = 8;

    private static $valueToName = [
        self::MANAGEMENT_STATUS_UNSPECIFIED => 'MANAGEMENT_STATUS_UNSPECIFIED',
        self::OK => 'OK',
        self::PENDING => 'PENDING',
        self::FAILED_RETRYING_NOT_VISIBLE => 'FAILED_RETRYING_NOT_VISIBLE',
        self::FAILED_PERMANENT => 'FAILED_PERMANENT',
        self::FAILED_RETRYING_CAA_FORBIDDEN => 'FAILED_RETRYING_CAA_FORBIDDEN',
        self::FAILED_RETRYING_CAA_CHECKING => 'FAILED_RETRYING_CAA_CHECKING',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

