<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/vmwareengine/v1/vmwareengine.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VmwareEngine\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\VmwareEngine\V1\Cluster;
use Google\Cloud\VmwareEngine\V1\CreateClusterRequest;
use Google\Cloud\VmwareEngine\V1\CreateExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\CreateExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\CreateHcxActivationKeyRequest;
use Google\Cloud\VmwareEngine\V1\CreateLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\CreateManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\CreateNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\CreateNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\CreatePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\CreatePrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\CreateVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\Credentials;
use Google\Cloud\VmwareEngine\V1\DeleteClusterRequest;
use Google\Cloud\VmwareEngine\V1\DeleteExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\DeleteExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\DeleteLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\DeleteManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\DeleteNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\DeleteNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\DeletePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\DeletePrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\DeleteVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\DnsBindPermission;
use Google\Cloud\VmwareEngine\V1\DnsForwarding;
use Google\Cloud\VmwareEngine\V1\ExternalAccessRule;
use Google\Cloud\VmwareEngine\V1\ExternalAddress;
use Google\Cloud\VmwareEngine\V1\FetchNetworkPolicyExternalAddressesRequest;
use Google\Cloud\VmwareEngine\V1\FetchNetworkPolicyExternalAddressesResponse;
use Google\Cloud\VmwareEngine\V1\GetClusterRequest;
use Google\Cloud\VmwareEngine\V1\GetDnsBindPermissionRequest;
use Google\Cloud\VmwareEngine\V1\GetDnsForwardingRequest;
use Google\Cloud\VmwareEngine\V1\GetExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\GetExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\GetHcxActivationKeyRequest;
use Google\Cloud\VmwareEngine\V1\GetLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\GetManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\GetNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\GetNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\GetNodeRequest;
use Google\Cloud\VmwareEngine\V1\GetNodeTypeRequest;
use Google\Cloud\VmwareEngine\V1\GetPrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\GetPrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\GetSubnetRequest;
use Google\Cloud\VmwareEngine\V1\GetVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\GrantDnsBindPermissionRequest;
use Google\Cloud\VmwareEngine\V1\HcxActivationKey;
use Google\Cloud\VmwareEngine\V1\ListClustersRequest;
use Google\Cloud\VmwareEngine\V1\ListClustersResponse;
use Google\Cloud\VmwareEngine\V1\ListExternalAccessRulesRequest;
use Google\Cloud\VmwareEngine\V1\ListExternalAccessRulesResponse;
use Google\Cloud\VmwareEngine\V1\ListExternalAddressesRequest;
use Google\Cloud\VmwareEngine\V1\ListExternalAddressesResponse;
use Google\Cloud\VmwareEngine\V1\ListHcxActivationKeysRequest;
use Google\Cloud\VmwareEngine\V1\ListHcxActivationKeysResponse;
use Google\Cloud\VmwareEngine\V1\ListLoggingServersRequest;
use Google\Cloud\VmwareEngine\V1\ListLoggingServersResponse;
use Google\Cloud\VmwareEngine\V1\ListManagementDnsZoneBindingsRequest;
use Google\Cloud\VmwareEngine\V1\ListManagementDnsZoneBindingsResponse;
use Google\Cloud\VmwareEngine\V1\ListNetworkPeeringsRequest;
use Google\Cloud\VmwareEngine\V1\ListNetworkPeeringsResponse;
use Google\Cloud\VmwareEngine\V1\ListNetworkPoliciesRequest;
use Google\Cloud\VmwareEngine\V1\ListNetworkPoliciesResponse;
use Google\Cloud\VmwareEngine\V1\ListNodeTypesRequest;
use Google\Cloud\VmwareEngine\V1\ListNodeTypesResponse;
use Google\Cloud\VmwareEngine\V1\ListNodesRequest;
use Google\Cloud\VmwareEngine\V1\ListNodesResponse;
use Google\Cloud\VmwareEngine\V1\ListPeeringRoutesRequest;
use Google\Cloud\VmwareEngine\V1\ListPeeringRoutesResponse;
use Google\Cloud\VmwareEngine\V1\ListPrivateCloudsRequest;
use Google\Cloud\VmwareEngine\V1\ListPrivateCloudsResponse;
use Google\Cloud\VmwareEngine\V1\ListPrivateConnectionPeeringRoutesRequest;
use Google\Cloud\VmwareEngine\V1\ListPrivateConnectionPeeringRoutesResponse;
use Google\Cloud\VmwareEngine\V1\ListPrivateConnectionsRequest;
use Google\Cloud\VmwareEngine\V1\ListPrivateConnectionsResponse;
use Google\Cloud\VmwareEngine\V1\ListSubnetsRequest;
use Google\Cloud\VmwareEngine\V1\ListSubnetsResponse;
use Google\Cloud\VmwareEngine\V1\ListVmwareEngineNetworksRequest;
use Google\Cloud\VmwareEngine\V1\ListVmwareEngineNetworksResponse;
use Google\Cloud\VmwareEngine\V1\LoggingServer;
use Google\Cloud\VmwareEngine\V1\ManagementDnsZoneBinding;
use Google\Cloud\VmwareEngine\V1\NetworkPeering;
use Google\Cloud\VmwareEngine\V1\NetworkPolicy;
use Google\Cloud\VmwareEngine\V1\Node;
use Google\Cloud\VmwareEngine\V1\NodeType;
use Google\Cloud\VmwareEngine\V1\Principal;
use Google\Cloud\VmwareEngine\V1\PrivateCloud;
use Google\Cloud\VmwareEngine\V1\PrivateConnection;
use Google\Cloud\VmwareEngine\V1\RepairManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\ResetNsxCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\ResetVcenterCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\RevokeDnsBindPermissionRequest;
use Google\Cloud\VmwareEngine\V1\ShowNsxCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\ShowVcenterCredentialsRequest;
use Google\Cloud\VmwareEngine\V1\Subnet;
use Google\Cloud\VmwareEngine\V1\UndeletePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\UpdateClusterRequest;
use Google\Cloud\VmwareEngine\V1\UpdateDnsForwardingRequest;
use Google\Cloud\VmwareEngine\V1\UpdateExternalAccessRuleRequest;
use Google\Cloud\VmwareEngine\V1\UpdateExternalAddressRequest;
use Google\Cloud\VmwareEngine\V1\UpdateLoggingServerRequest;
use Google\Cloud\VmwareEngine\V1\UpdateManagementDnsZoneBindingRequest;
use Google\Cloud\VmwareEngine\V1\UpdateNetworkPeeringRequest;
use Google\Cloud\VmwareEngine\V1\UpdateNetworkPolicyRequest;
use Google\Cloud\VmwareEngine\V1\UpdatePrivateCloudRequest;
use Google\Cloud\VmwareEngine\V1\UpdatePrivateConnectionRequest;
use Google\Cloud\VmwareEngine\V1\UpdateSubnetRequest;
use Google\Cloud\VmwareEngine\V1\UpdateVmwareEngineNetworkRequest;
use Google\Cloud\VmwareEngine\V1\VmwareEngineNetwork;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: VMwareEngine manages VMware's private clusters in the Cloud.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $vmwareEngineClient = new VmwareEngineClient();
 * try {
 *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
 *     $clusterId = 'cluster_id';
 *     $cluster = new Cluster();
 *     $operationResponse = $vmwareEngineClient->createCluster($formattedParent, $clusterId, $cluster);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $vmwareEngineClient->createCluster($formattedParent, $clusterId, $cluster);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createCluster');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $vmwareEngineClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\VmwareEngine\V1\Client\VmwareEngineClient}.
 */
class VmwareEngineGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.vmwareengine.v1.VmwareEngine';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'vmwareengine.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'vmwareengine.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $clusterNameTemplate;

    private static $dnsBindPermissionNameTemplate;

    private static $dnsForwardingNameTemplate;

    private static $externalAccessRuleNameTemplate;

    private static $externalAddressNameTemplate;

    private static $hcxActivationKeyNameTemplate;

    private static $locationNameTemplate;

    private static $loggingServerNameTemplate;

    private static $managementDnsZoneBindingNameTemplate;

    private static $networkNameTemplate;

    private static $networkPeeringNameTemplate;

    private static $networkPolicyNameTemplate;

    private static $nodeNameTemplate;

    private static $nodeTypeNameTemplate;

    private static $privateCloudNameTemplate;

    private static $privateConnectionNameTemplate;

    private static $subnetNameTemplate;

    private static $vmwareEngineNetworkNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/vmware_engine_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/vmware_engine_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/vmware_engine_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/vmware_engine_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getClusterNameTemplate()
    {
        if (self::$clusterNameTemplate == null) {
            self::$clusterNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}'
            );
        }

        return self::$clusterNameTemplate;
    }

    private static function getDnsBindPermissionNameTemplate()
    {
        if (self::$dnsBindPermissionNameTemplate == null) {
            self::$dnsBindPermissionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dnsBindPermission'
            );
        }

        return self::$dnsBindPermissionNameTemplate;
    }

    private static function getDnsForwardingNameTemplate()
    {
        if (self::$dnsForwardingNameTemplate == null) {
            self::$dnsForwardingNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/dnsForwarding'
            );
        }

        return self::$dnsForwardingNameTemplate;
    }

    private static function getExternalAccessRuleNameTemplate()
    {
        if (self::$externalAccessRuleNameTemplate == null) {
            self::$externalAccessRuleNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/networkPolicies/{network_policy}/externalAccessRules/{external_access_rule}'
            );
        }

        return self::$externalAccessRuleNameTemplate;
    }

    private static function getExternalAddressNameTemplate()
    {
        if (self::$externalAddressNameTemplate == null) {
            self::$externalAddressNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/externalAddresses/{external_address}'
            );
        }

        return self::$externalAddressNameTemplate;
    }

    private static function getHcxActivationKeyNameTemplate()
    {
        if (self::$hcxActivationKeyNameTemplate == null) {
            self::$hcxActivationKeyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/hcxActivationKeys/{hcx_activation_key}'
            );
        }

        return self::$hcxActivationKeyNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getLoggingServerNameTemplate()
    {
        if (self::$loggingServerNameTemplate == null) {
            self::$loggingServerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/loggingServers/{logging_server}'
            );
        }

        return self::$loggingServerNameTemplate;
    }

    private static function getManagementDnsZoneBindingNameTemplate()
    {
        if (self::$managementDnsZoneBindingNameTemplate == null) {
            self::$managementDnsZoneBindingNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/managementDnsZoneBindings/{management_dns_zone_binding}'
            );
        }

        return self::$managementDnsZoneBindingNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getNetworkPeeringNameTemplate()
    {
        if (self::$networkPeeringNameTemplate == null) {
            self::$networkPeeringNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/networkPeerings/{network_peering}'
            );
        }

        return self::$networkPeeringNameTemplate;
    }

    private static function getNetworkPolicyNameTemplate()
    {
        if (self::$networkPolicyNameTemplate == null) {
            self::$networkPolicyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/networkPolicies/{network_policy}'
            );
        }

        return self::$networkPolicyNameTemplate;
    }

    private static function getNodeNameTemplate()
    {
        if (self::$nodeNameTemplate == null) {
            self::$nodeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}'
            );
        }

        return self::$nodeNameTemplate;
    }

    private static function getNodeTypeNameTemplate()
    {
        if (self::$nodeTypeNameTemplate == null) {
            self::$nodeTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/nodeTypes/{node_type}'
            );
        }

        return self::$nodeTypeNameTemplate;
    }

    private static function getPrivateCloudNameTemplate()
    {
        if (self::$privateCloudNameTemplate == null) {
            self::$privateCloudNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}'
            );
        }

        return self::$privateCloudNameTemplate;
    }

    private static function getPrivateConnectionNameTemplate()
    {
        if (self::$privateConnectionNameTemplate == null) {
            self::$privateConnectionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateConnections/{private_connection}'
            );
        }

        return self::$privateConnectionNameTemplate;
    }

    private static function getSubnetNameTemplate()
    {
        if (self::$subnetNameTemplate == null) {
            self::$subnetNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/privateClouds/{private_cloud}/subnets/{subnet}'
            );
        }

        return self::$subnetNameTemplate;
    }

    private static function getVmwareEngineNetworkNameTemplate()
    {
        if (self::$vmwareEngineNetworkNameTemplate == null) {
            self::$vmwareEngineNetworkNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network}'
            );
        }

        return self::$vmwareEngineNetworkNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'cluster' => self::getClusterNameTemplate(),
                'dnsBindPermission' => self::getDnsBindPermissionNameTemplate(),
                'dnsForwarding' => self::getDnsForwardingNameTemplate(),
                'externalAccessRule' => self::getExternalAccessRuleNameTemplate(),
                'externalAddress' => self::getExternalAddressNameTemplate(),
                'hcxActivationKey' => self::getHcxActivationKeyNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'loggingServer' => self::getLoggingServerNameTemplate(),
                'managementDnsZoneBinding' => self::getManagementDnsZoneBindingNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'networkPeering' => self::getNetworkPeeringNameTemplate(),
                'networkPolicy' => self::getNetworkPolicyNameTemplate(),
                'node' => self::getNodeNameTemplate(),
                'nodeType' => self::getNodeTypeNameTemplate(),
                'privateCloud' => self::getPrivateCloudNameTemplate(),
                'privateConnection' => self::getPrivateConnectionNameTemplate(),
                'subnet' => self::getSubnetNameTemplate(),
                'vmwareEngineNetwork' => self::getVmwareEngineNetworkNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(
        $project,
        $location,
        $privateCloud,
        $cluster
    ) {
        return self::getClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dns_bind_permission resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted dns_bind_permission resource.
     */
    public static function dnsBindPermissionName($project, $location)
    {
        return self::getDnsBindPermissionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dns_forwarding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     *
     * @return string The formatted dns_forwarding resource.
     */
    public static function dnsForwardingName($project, $location, $privateCloud)
    {
        return self::getDnsForwardingNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_access_rule resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkPolicy
     * @param string $externalAccessRule
     *
     * @return string The formatted external_access_rule resource.
     */
    public static function externalAccessRuleName(
        $project,
        $location,
        $networkPolicy,
        $externalAccessRule
    ) {
        return self::getExternalAccessRuleNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'network_policy' => $networkPolicy,
            'external_access_rule' => $externalAccessRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * external_address resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $externalAddress
     *
     * @return string The formatted external_address resource.
     */
    public static function externalAddressName(
        $project,
        $location,
        $privateCloud,
        $externalAddress
    ) {
        return self::getExternalAddressNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'external_address' => $externalAddress,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * hcx_activation_key resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $hcxActivationKey
     *
     * @return string The formatted hcx_activation_key resource.
     */
    public static function hcxActivationKeyName(
        $project,
        $location,
        $privateCloud,
        $hcxActivationKey
    ) {
        return self::getHcxActivationKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'hcx_activation_key' => $hcxActivationKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * logging_server resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $loggingServer
     *
     * @return string The formatted logging_server resource.
     */
    public static function loggingServerName(
        $project,
        $location,
        $privateCloud,
        $loggingServer
    ) {
        return self::getLoggingServerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'logging_server' => $loggingServer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * management_dns_zone_binding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $managementDnsZoneBinding
     *
     * @return string The formatted management_dns_zone_binding resource.
     */
    public static function managementDnsZoneBindingName(
        $project,
        $location,
        $privateCloud,
        $managementDnsZoneBinding
    ) {
        return self::getManagementDnsZoneBindingNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'management_dns_zone_binding' => $managementDnsZoneBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_peering resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkPeering
     *
     * @return string The formatted network_peering resource.
     */
    public static function networkPeeringName(
        $project,
        $location,
        $networkPeering
    ) {
        return self::getNetworkPeeringNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'network_peering' => $networkPeering,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $networkPolicy
     *
     * @return string The formatted network_policy resource.
     */
    public static function networkPolicyName(
        $project,
        $location,
        $networkPolicy
    ) {
        return self::getNetworkPolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'network_policy' => $networkPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a node
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $cluster
     * @param string $node
     *
     * @return string The formatted node resource.
     */
    public static function nodeName(
        $project,
        $location,
        $privateCloud,
        $cluster,
        $node
    ) {
        return self::getNodeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'cluster' => $cluster,
            'node' => $node,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a node_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $nodeType
     *
     * @return string The formatted node_type resource.
     */
    public static function nodeTypeName($project, $location, $nodeType)
    {
        return self::getNodeTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'node_type' => $nodeType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_cloud resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     *
     * @return string The formatted private_cloud resource.
     */
    public static function privateCloudName($project, $location, $privateCloud)
    {
        return self::getPrivateCloudNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     *
     * @return string The formatted private_connection resource.
     */
    public static function privateConnectionName(
        $project,
        $location,
        $privateConnection
    ) {
        return self::getPrivateConnectionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnet
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateCloud
     * @param string $subnet
     *
     * @return string The formatted subnet resource.
     */
    public static function subnetName(
        $project,
        $location,
        $privateCloud,
        $subnet
    ) {
        return self::getSubnetNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_cloud' => $privateCloud,
            'subnet' => $subnet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * vmware_engine_network resource.
     *
     * @param string $project
     * @param string $location
     * @param string $vmwareEngineNetwork
     *
     * @return string The formatted vmware_engine_network resource.
     */
    public static function vmwareEngineNetworkName(
        $project,
        $location,
        $vmwareEngineNetwork
    ) {
        return self::getVmwareEngineNetworkNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'vmware_engine_network' => $vmwareEngineNetwork,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cluster: projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}
     * - dnsBindPermission: projects/{project}/locations/{location}/dnsBindPermission
     * - dnsForwarding: projects/{project}/locations/{location}/privateClouds/{private_cloud}/dnsForwarding
     * - externalAccessRule: projects/{project}/locations/{location}/networkPolicies/{network_policy}/externalAccessRules/{external_access_rule}
     * - externalAddress: projects/{project}/locations/{location}/privateClouds/{private_cloud}/externalAddresses/{external_address}
     * - hcxActivationKey: projects/{project}/locations/{location}/privateClouds/{private_cloud}/hcxActivationKeys/{hcx_activation_key}
     * - location: projects/{project}/locations/{location}
     * - loggingServer: projects/{project}/locations/{location}/privateClouds/{private_cloud}/loggingServers/{logging_server}
     * - managementDnsZoneBinding: projects/{project}/locations/{location}/privateClouds/{private_cloud}/managementDnsZoneBindings/{management_dns_zone_binding}
     * - network: projects/{project}/global/networks/{network}
     * - networkPeering: projects/{project}/locations/{location}/networkPeerings/{network_peering}
     * - networkPolicy: projects/{project}/locations/{location}/networkPolicies/{network_policy}
     * - node: projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}
     * - nodeType: projects/{project}/locations/{location}/nodeTypes/{node_type}
     * - privateCloud: projects/{project}/locations/{location}/privateClouds/{private_cloud}
     * - privateConnection: projects/{project}/locations/{location}/privateConnections/{private_connection}
     * - subnet: projects/{project}/locations/{location}/privateClouds/{private_cloud}/subnets/{subnet}
     * - vmwareEngineNetwork: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'vmwareengine.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new cluster in a given private cloud.
     * Creating a new cluster provides additional nodes for
     * use in the parent private cloud and requires sufficient [node
     * quota](https://cloud.google.com/vmware-engine/quotas).
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $clusterId = 'cluster_id';
     *     $cluster = new Cluster();
     *     $operationResponse = $vmwareEngineClient->createCluster($formattedParent, $clusterId, $cluster);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createCluster($formattedParent, $clusterId, $cluster);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The resource name of the private cloud to create a new cluster
     *                              in. Resource names are schemeless URIs that follow the conventions in
     *                              https://cloud.google.com/apis/design/resource_names.
     *                              For example:
     *                              `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param string  $clusterId    Required. The user-provided identifier of the new `Cluster`.
     *                              This identifier must be unique among clusters within the parent and becomes
     *                              the final token in the name URI.
     *                              The identifier must meet the following requirements:
     *
     *                              * Only contains 1-63 alphanumeric characters and hyphens
     *                              * Begins with an alphabetical character
     *                              * Ends with a non-hyphen character
     *                              * Not formatted as a UUID
     *                              * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                              (section 3.5)
     * @param Cluster $cluster      Required. The initial description of the new cluster.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that zero
     *           UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. True if you want the request to be validated and not executed;
     *           false otherwise.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCluster(
        $parent,
        $clusterId,
        $cluster,
        array $optionalArgs = []
    ) {
        $request = new CreateClusterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setClusterId($clusterId);
        $request->setCluster($cluster);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new external access rule in a given network policy.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->networkPolicyName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]');
     *     $externalAccessRule = new ExternalAccessRule();
     *     $externalAccessRuleId = 'external_access_rule_id';
     *     $operationResponse = $vmwareEngineClient->createExternalAccessRule($formattedParent, $externalAccessRule, $externalAccessRuleId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createExternalAccessRule($formattedParent, $externalAccessRule, $externalAccessRuleId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createExternalAccessRule');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string             $parent               Required. The resource name of the network policy
     *                                                 to create a new external access firewall rule in.
     *                                                 Resource names are schemeless URIs that follow the conventions in
     *                                                 https://cloud.google.com/apis/design/resource_names.
     *                                                 For example:
     *                                                 `projects/my-project/locations/us-central1/networkPolicies/my-policy`
     * @param ExternalAccessRule $externalAccessRule   Required. The initial description of a new external access rule.
     * @param string             $externalAccessRuleId Required. The user-provided identifier of the `ExternalAccessRule` to be
     *                                                 created. This identifier must be unique among `ExternalAccessRule`
     *                                                 resources within the parent and becomes the final token in the name URI.
     *                                                 The identifier must meet the following requirements:
     *
     *                                                 * Only contains 1-63 alphanumeric characters and hyphens
     *                                                 * Begins with an alphabetical character
     *                                                 * Ends with a non-hyphen character
     *                                                 * Not formatted as a UUID
     *                                                 * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                                 (section 3.5)
     * @param array              $optionalArgs         {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createExternalAccessRule(
        $parent,
        $externalAccessRule,
        $externalAccessRuleId,
        array $optionalArgs = []
    ) {
        $request = new CreateExternalAccessRuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setExternalAccessRule($externalAccessRule);
        $request->setExternalAccessRuleId($externalAccessRuleId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateExternalAccessRule',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new `ExternalAddress` resource in a given private cloud. The
     * network policy that corresponds to the private cloud must have the external
     * IP address network service enabled (`NetworkPolicy.external_ip`).
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $externalAddress = new ExternalAddress();
     *     $externalAddressId = 'external_address_id';
     *     $operationResponse = $vmwareEngineClient->createExternalAddress($formattedParent, $externalAddress, $externalAddressId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createExternalAddress($formattedParent, $externalAddress, $externalAddressId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createExternalAddress');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string          $parent            Required. The resource name of the private cloud
     *                                           to create a new external IP address in.
     *                                           Resource names are schemeless URIs that follow the conventions in
     *                                           https://cloud.google.com/apis/design/resource_names.
     *                                           For example:
     *                                           `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param ExternalAddress $externalAddress   Required. The initial description of a new external IP address.
     * @param string          $externalAddressId Required. The user-provided identifier of the `ExternalAddress` to be
     *                                           created. This identifier must be unique among `ExternalAddress` resources
     *                                           within the parent and becomes the final token in the name URI. The
     *                                           identifier must meet the following requirements:
     *
     *                                           * Only contains 1-63 alphanumeric characters and hyphens
     *                                           * Begins with an alphabetical character
     *                                           * Ends with a non-hyphen character
     *                                           * Not formatted as a UUID
     *                                           * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                           (section 3.5)
     * @param array           $optionalArgs      {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createExternalAddress(
        $parent,
        $externalAddress,
        $externalAddressId,
        array $optionalArgs = []
    ) {
        $request = new CreateExternalAddressRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setExternalAddress($externalAddress);
        $request->setExternalAddressId($externalAddressId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateExternalAddress',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new HCX activation key in a given private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $hcxActivationKey = new HcxActivationKey();
     *     $hcxActivationKeyId = 'hcx_activation_key_id';
     *     $operationResponse = $vmwareEngineClient->createHcxActivationKey($formattedParent, $hcxActivationKey, $hcxActivationKeyId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createHcxActivationKey($formattedParent, $hcxActivationKey, $hcxActivationKeyId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createHcxActivationKey');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string           $parent             Required. The resource name of the private cloud to create the key for.
     *                                             Resource names are schemeless URIs that follow the conventions in
     *                                             https://cloud.google.com/apis/design/resource_names.
     *                                             For example:
     *                                             `projects/my-project/locations/us-central1/privateClouds/my-cloud`
     * @param HcxActivationKey $hcxActivationKey   Required. The initial description of a new HCX activation key. When
     *                                             creating a new key, this field must be an empty object.
     * @param string           $hcxActivationKeyId Required. The user-provided identifier of the `HcxActivationKey` to be
     *                                             created. This identifier must be unique among `HcxActivationKey` resources
     *                                             within the parent and becomes the final token in the name URI.
     *                                             The identifier must meet the following requirements:
     *
     *                                             * Only contains 1-63 alphanumeric characters and hyphens
     *                                             * Begins with an alphabetical character
     *                                             * Ends with a non-hyphen character
     *                                             * Not formatted as a UUID
     *                                             * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                             (section 3.5)
     * @param array            $optionalArgs       {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createHcxActivationKey(
        $parent,
        $hcxActivationKey,
        $hcxActivationKeyId,
        array $optionalArgs = []
    ) {
        $request = new CreateHcxActivationKeyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setHcxActivationKey($hcxActivationKey);
        $request->setHcxActivationKeyId($hcxActivationKeyId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateHcxActivationKey',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create a new logging server for a given private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $loggingServer = new LoggingServer();
     *     $loggingServerId = 'logging_server_id';
     *     $operationResponse = $vmwareEngineClient->createLoggingServer($formattedParent, $loggingServer, $loggingServerId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createLoggingServer($formattedParent, $loggingServer, $loggingServerId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createLoggingServer');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string        $parent          Required. The resource name of the private cloud
     *                                       to create a new Logging Server in.
     *                                       Resource names are schemeless URIs that follow the conventions in
     *                                       https://cloud.google.com/apis/design/resource_names.
     *                                       For example:
     *                                       `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param LoggingServer $loggingServer   Required. The initial description of a new logging server.
     * @param string        $loggingServerId Required. The user-provided identifier of the `LoggingServer` to be
     *                                       created. This identifier must be unique among `LoggingServer` resources
     *                                       within the parent and becomes the final token in the name URI.
     *                                       The identifier must meet the following requirements:
     *
     *                                       * Only contains 1-63 alphanumeric characters and hyphens
     *                                       * Begins with an alphabetical character
     *                                       * Ends with a non-hyphen character
     *                                       * Not formatted as a UUID
     *                                       * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                       (section 3.5)
     * @param array         $optionalArgs    {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createLoggingServer(
        $parent,
        $loggingServer,
        $loggingServerId,
        array $optionalArgs = []
    ) {
        $request = new CreateLoggingServerRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLoggingServer($loggingServer);
        $request->setLoggingServerId($loggingServerId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateLoggingServer',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
     * This RPC creates the DNS binding and the resource that represents the
     * DNS binding of the consumer VPC network to the management DNS zone. A
     * management DNS zone is the Cloud DNS cross-project binding zone that
     * VMware Engine creates for each private cloud. It contains FQDNs and
     * corresponding IP addresses for the private cloud's ESXi hosts and
     * management VM appliances like vCenter and NSX Manager.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $managementDnsZoneBinding = new ManagementDnsZoneBinding();
     *     $managementDnsZoneBindingId = 'management_dns_zone_binding_id';
     *     $operationResponse = $vmwareEngineClient->createManagementDnsZoneBinding($formattedParent, $managementDnsZoneBinding, $managementDnsZoneBindingId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createManagementDnsZoneBinding($formattedParent, $managementDnsZoneBinding, $managementDnsZoneBindingId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createManagementDnsZoneBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string                   $parent                     Required. The resource name of the private cloud
     *                                                             to create a new management DNS zone binding for.
     *                                                             Resource names are schemeless URIs that follow the conventions in
     *                                                             https://cloud.google.com/apis/design/resource_names.
     *                                                             For example:
     *                                                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param ManagementDnsZoneBinding $managementDnsZoneBinding   Required. The initial values for a new management DNS zone binding.
     * @param string                   $managementDnsZoneBindingId Required. The user-provided identifier of the `ManagementDnsZoneBinding`
     *                                                             resource to be created. This identifier must be unique among
     *                                                             `ManagementDnsZoneBinding` resources within the parent and becomes the
     *                                                             final token in the name URI. The identifier must meet the following
     *                                                             requirements:
     *
     *                                                             * Only contains 1-63 alphanumeric characters and hyphens
     *                                                             * Begins with an alphabetical character
     *                                                             * Ends with a non-hyphen character
     *                                                             * Not formatted as a UUID
     *                                                             * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                                             (section 3.5)
     * @param array                    $optionalArgs               {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createManagementDnsZoneBinding(
        $parent,
        $managementDnsZoneBinding,
        $managementDnsZoneBindingId,
        array $optionalArgs = []
    ) {
        $request = new CreateManagementDnsZoneBindingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setManagementDnsZoneBinding($managementDnsZoneBinding);
        $request->setManagementDnsZoneBindingId($managementDnsZoneBindingId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateManagementDnsZoneBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new network peering between the peer network and VMware Engine
     * network provided in a `NetworkPeering` resource. NetworkPeering is a
     * global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     $networkPeeringId = 'network_peering_id';
     *     $networkPeering = new NetworkPeering();
     *     $operationResponse = $vmwareEngineClient->createNetworkPeering($formattedParent, $networkPeeringId, $networkPeering);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createNetworkPeering($formattedParent, $networkPeeringId, $networkPeering);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createNetworkPeering');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string         $parent           Required. The resource name of the location to create the new network
     *                                         peering in. This value is always `global`, because `NetworkPeering` is a
     *                                         global resource. Resource names are schemeless URIs that follow the
     *                                         conventions in https://cloud.google.com/apis/design/resource_names. For
     *                                         example: `projects/my-project/locations/global`
     * @param string         $networkPeeringId Required. The user-provided identifier of the new `NetworkPeering`.
     *                                         This identifier must be unique among `NetworkPeering` resources within the
     *                                         parent and becomes the final token in the name URI.
     *                                         The identifier must meet the following requirements:
     *
     *                                         * Only contains 1-63 alphanumeric characters and hyphens
     *                                         * Begins with an alphabetical character
     *                                         * Ends with a non-hyphen character
     *                                         * Not formatted as a UUID
     *                                         * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                         (section 3.5)
     * @param NetworkPeering $networkPeering   Required. The initial description of the new network peering.
     * @param array          $optionalArgs     {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createNetworkPeering(
        $parent,
        $networkPeeringId,
        $networkPeering,
        array $optionalArgs = []
    ) {
        $request = new CreateNetworkPeeringRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNetworkPeeringId($networkPeeringId);
        $request->setNetworkPeering($networkPeering);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateNetworkPeering',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new network policy in a given VMware Engine network of a
     * project and location (region). A new network policy cannot be created if
     * another network policy already exists in the same scope.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     $networkPolicyId = 'network_policy_id';
     *     $networkPolicy = new NetworkPolicy();
     *     $operationResponse = $vmwareEngineClient->createNetworkPolicy($formattedParent, $networkPolicyId, $networkPolicy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createNetworkPolicy($formattedParent, $networkPolicyId, $networkPolicy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createNetworkPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string        $parent          Required. The resource name of the location (region)
     *                                       to create the new network policy in.
     *                                       Resource names are schemeless URIs that follow the conventions in
     *                                       https://cloud.google.com/apis/design/resource_names.
     *                                       For example:
     *                                       `projects/my-project/locations/us-central1`
     * @param string        $networkPolicyId Required. The user-provided identifier of the network policy to be created.
     *                                       This identifier must be unique within parent
     *                                       `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
     *                                       the final token in the name URI.
     *                                       The identifier must meet the following requirements:
     *
     *                                       * Only contains 1-63 alphanumeric characters and hyphens
     *                                       * Begins with an alphabetical character
     *                                       * Ends with a non-hyphen character
     *                                       * Not formatted as a UUID
     *                                       * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                       (section 3.5)
     * @param NetworkPolicy $networkPolicy   Required. The network policy configuration to use in the request.
     * @param array         $optionalArgs    {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createNetworkPolicy(
        $parent,
        $networkPolicyId,
        $networkPolicy,
        array $optionalArgs = []
    ) {
        $request = new CreateNetworkPolicyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNetworkPolicyId($networkPolicyId);
        $request->setNetworkPolicy($networkPolicy);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateNetworkPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new `PrivateCloud` resource in a given project and location.
     * Private clouds of type `STANDARD` and
     * `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
     * regional.
     * Creating a private cloud also creates a [management
     * cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
     * for that private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     $privateCloudId = 'private_cloud_id';
     *     $privateCloud = new PrivateCloud();
     *     $operationResponse = $vmwareEngineClient->createPrivateCloud($formattedParent, $privateCloudId, $privateCloud);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createPrivateCloud($formattedParent, $privateCloudId, $privateCloud);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createPrivateCloud');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The resource name of the location to create the new
     *                                     private cloud in. Resource names are schemeless URIs that follow the
     *                                     conventions in https://cloud.google.com/apis/design/resource_names.
     *                                     For example:
     *                                     `projects/my-project/locations/us-central1-a`
     * @param string       $privateCloudId Required. The user-provided identifier of the private cloud to be created.
     *                                     This identifier must be unique among each `PrivateCloud` within the parent
     *                                     and becomes the final token in the name URI.
     *                                     The identifier must meet the following requirements:
     *
     *                                     * Only contains 1-63 alphanumeric characters and hyphens
     *                                     * Begins with an alphabetical character
     *                                     * Ends with a non-hyphen character
     *                                     * Not formatted as a UUID
     *                                     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                     (section 3.5)
     * @param PrivateCloud $privateCloud   Required. The initial description of the new private cloud.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that zero
     *           UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. True if you want the request to be validated and not executed;
     *           false otherwise.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createPrivateCloud(
        $parent,
        $privateCloudId,
        $privateCloud,
        array $optionalArgs = []
    ) {
        $request = new CreatePrivateCloudRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPrivateCloudId($privateCloudId);
        $request->setPrivateCloud($privateCloud);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreatePrivateCloud',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new private connection that can be used for accessing private
     * Clouds.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     $privateConnectionId = 'private_connection_id';
     *     $privateConnection = new PrivateConnection();
     *     $operationResponse = $vmwareEngineClient->createPrivateConnection($formattedParent, $privateConnectionId, $privateConnection);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createPrivateConnection($formattedParent, $privateConnectionId, $privateConnection);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createPrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The resource name of the location to create the new private
     *                                               connection in. Private connection is a regional resource.
     *                                               Resource names are schemeless URIs that follow the conventions in
     *                                               https://cloud.google.com/apis/design/resource_names. For example:
     *                                               `projects/my-project/locations/us-central1`
     * @param string            $privateConnectionId Required. The user-provided identifier of the new private connection.
     *                                               This identifier must be unique among private connection resources
     *                                               within the parent and becomes the final token in the name URI. The
     *                                               identifier must meet the following requirements:
     *
     *                                               * Only contains 1-63 alphanumeric characters and hyphens
     *                                               * Begins with an alphabetical character
     *                                               * Ends with a non-hyphen character
     *                                               * Not formatted as a UUID
     *                                               * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                               (section 3.5)
     * @param PrivateConnection $privateConnection   Required. The initial description of the new private connection.
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createPrivateConnection(
        $parent,
        $privateConnectionId,
        $privateConnection,
        array $optionalArgs = []
    ) {
        $request = new CreatePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPrivateConnectionId($privateConnectionId);
        $request->setPrivateConnection($privateConnection);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreatePrivateConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new VMware Engine network that can be used by a private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     $vmwareEngineNetworkId = 'vmware_engine_network_id';
     *     $vmwareEngineNetwork = new VmwareEngineNetwork();
     *     $operationResponse = $vmwareEngineClient->createVmwareEngineNetwork($formattedParent, $vmwareEngineNetworkId, $vmwareEngineNetwork);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->createVmwareEngineNetwork($formattedParent, $vmwareEngineNetworkId, $vmwareEngineNetwork);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'createVmwareEngineNetwork');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string              $parent                Required. The resource name of the location to create the new VMware Engine
     *                                                   network in. A VMware Engine network of type
     *                                                   `LEGACY` is a regional resource, and a VMware
     *                                                   Engine network of type `STANDARD` is a global resource.
     *                                                   Resource names are schemeless URIs that follow the conventions in
     *                                                   https://cloud.google.com/apis/design/resource_names. For example:
     *                                                   `projects/my-project/locations/global`
     * @param string              $vmwareEngineNetworkId Required. The user-provided identifier of the new VMware Engine network.
     *                                                   This identifier must be unique among VMware Engine network resources
     *                                                   within the parent and becomes the final token in the name URI. The
     *                                                   identifier must meet the following requirements:
     *
     *                                                   * For networks of type LEGACY, adheres to the format:
     *                                                   `{region-id}-default`. Replace `{region-id}` with the region where you want
     *                                                   to create the VMware Engine network. For example, "us-central1-default".
     *                                                   * Only contains 1-63 alphanumeric characters and hyphens
     *                                                   * Begins with an alphabetical character
     *                                                   * Ends with a non-hyphen character
     *                                                   * Not formatted as a UUID
     *                                                   * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
     *                                                   (section 3.5)
     * @param VmwareEngineNetwork $vmwareEngineNetwork   Required. The initial description of the new VMware Engine network.
     * @param array               $optionalArgs          {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createVmwareEngineNetwork(
        $parent,
        $vmwareEngineNetworkId,
        $vmwareEngineNetwork,
        array $optionalArgs = []
    ) {
        $request = new CreateVmwareEngineNetworkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setVmwareEngineNetworkId($vmwareEngineNetworkId);
        $request->setVmwareEngineNetwork($vmwareEngineNetwork);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateVmwareEngineNetwork',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
     * gracefully shut down any workloads running on the cluster before deletion.
     * You cannot delete the management cluster of a private cloud using this
     * method.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->clusterName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[CLUSTER]');
     *     $operationResponse = $vmwareEngineClient->deleteCluster($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteCluster($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the cluster to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that zero
     *           UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCluster($name, array $optionalArgs = [])
    {
        $request = new DeleteClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single external access rule.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->externalAccessRuleName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]', '[EXTERNAL_ACCESS_RULE]');
     *     $operationResponse = $vmwareEngineClient->deleteExternalAccessRule($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteExternalAccessRule($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteExternalAccessRule');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the external access firewall rule to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if the original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteExternalAccessRule($name, array $optionalArgs = [])
    {
        $request = new DeleteExternalAccessRuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteExternalAccessRule',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single external IP address. When you delete an external IP
     * address, connectivity between the external IP address and the corresponding
     * internal IP address is lost.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->externalAddressName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[EXTERNAL_ADDRESS]');
     *     $operationResponse = $vmwareEngineClient->deleteExternalAddress($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteExternalAddress($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteExternalAddress');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the external IP address to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if the original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteExternalAddress($name, array $optionalArgs = [])
    {
        $request = new DeleteExternalAddressRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteExternalAddress',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single logging server.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->loggingServerName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[LOGGING_SERVER]');
     *     $operationResponse = $vmwareEngineClient->deleteLoggingServer($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteLoggingServer($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteLoggingServer');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the logging server to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteLoggingServer($name, array $optionalArgs = [])
    {
        $request = new DeleteLoggingServerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteLoggingServer',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
     * binding is deleted, the corresponding consumer VPC network is no longer
     * bound to the management DNS zone.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->managementDnsZoneBindingName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[MANAGEMENT_DNS_ZONE_BINDING]');
     *     $operationResponse = $vmwareEngineClient->deleteManagementDnsZoneBinding($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteManagementDnsZoneBinding($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteManagementDnsZoneBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the management DNS zone binding to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if the original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteManagementDnsZoneBinding(
        $name,
        array $optionalArgs = []
    ) {
        $request = new DeleteManagementDnsZoneBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteManagementDnsZoneBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a `NetworkPeering` resource. When a network peering is deleted for
     * a VMware Engine network, the peer network becomes inaccessible to that
     * VMware Engine network. NetworkPeering is a global resource and location can
     * only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->networkPeeringName('[PROJECT]', '[LOCATION]', '[NETWORK_PEERING]');
     *     $operationResponse = $vmwareEngineClient->deleteNetworkPeering($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteNetworkPeering($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteNetworkPeering');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the network peering to be deleted.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/global/networkPeerings/my-peering`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteNetworkPeering($name, array $optionalArgs = [])
    {
        $request = new DeleteNetworkPeeringRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteNetworkPeering',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
     * when `NetworkService.state` is set to `RECONCILING` for either its external
     * IP or internet access service.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->networkPolicyName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]');
     *     $operationResponse = $vmwareEngineClient->deleteNetworkPolicy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteNetworkPolicy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteNetworkPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the network policy to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteNetworkPolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteNetworkPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteNetworkPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Schedules a `PrivateCloud` resource for deletion.
     *
     * A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
     * set to `DELETED` and `expireTime` set to the time when deletion is final
     * and can no longer be reversed. The delete operation is marked as done
     * as soon as the `PrivateCloud` is successfully scheduled for deletion
     * (this also applies when `delayHours` is set to zero), and the operation is
     * not kept in pending state until `PrivateCloud` is purged.
     * `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
     * the `expireTime` elapses. When `expireTime` is reached, deletion is final
     * and all private cloud resources are irreversibly removed and billing stops.
     * During the final removal process, `PrivateCloud.state` is set to `PURGING`.
     * `PrivateCloud` can be polled using standard `GET` method for the whole
     * period of deletion and purging. It will not be returned only
     * when it is completely purged.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $operationResponse = $vmwareEngineClient->deletePrivateCloud($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deletePrivateCloud($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deletePrivateCloud');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the private cloud to delete.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that zero
     *           UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $force
     *           Optional. If set to true, cascade delete is enabled and all children of
     *           this private cloud resource are also deleted. When this flag is set to
     *           false, the private cloud will not be deleted if there are any children
     *           other than the management cluster. The management cluster is always
     *           deleted.
     *     @type int $delayHours
     *           Optional. Time delay of the deletion specified in hours. The default value
     *           is `3`. Specifying a non-zero value for this field changes the value of
     *           `PrivateCloud.state` to `DELETED` and sets `expire_time` to the planned
     *           deletion time. Deletion can be cancelled before `expire_time` elapses using
     *           [VmwareEngine.UndeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud].
     *           Specifying a value of `0` for this field instead begins the deletion
     *           process and ceases billing immediately. During the final deletion process,
     *           the value of `PrivateCloud.state` becomes `PURGING`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deletePrivateCloud($name, array $optionalArgs = [])
    {
        $request = new DeletePrivateCloudRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        if (isset($optionalArgs['delayHours'])) {
            $request->setDelayHours($optionalArgs['delayHours']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeletePrivateCloud',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a `PrivateConnection` resource. When a private connection is
     * deleted for a VMware Engine network, the connected network becomes
     * inaccessible to that VMware Engine network.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $operationResponse = $vmwareEngineClient->deletePrivateConnection($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deletePrivateConnection($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deletePrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the private connection to be deleted.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/privateConnections/my-connection`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deletePrivateConnection($name, array $optionalArgs = [])
    {
        $request = new DeletePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeletePrivateConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
     * Engine network after all resources that refer to it are deleted. For
     * example, a private cloud, a network peering, and a network policy can all
     * refer to the same VMware Engine network.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->vmwareEngineNetworkName('[PROJECT]', '[LOCATION]', '[VMWARE_ENGINE_NETWORK]');
     *     $operationResponse = $vmwareEngineClient->deleteVmwareEngineNetwork($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->deleteVmwareEngineNetwork($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'deleteVmwareEngineNetwork');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the VMware Engine network to be deleted.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type string $etag
     *           Optional. Checksum used to ensure that the user-provided value is up to
     *           date before the server processes the request. The server compares provided
     *           checksum with the current checksum of the resource. If the user-provided
     *           value is out of date, this request returns an `ABORTED` error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteVmwareEngineNetwork($name, array $optionalArgs = [])
    {
        $request = new DeleteVmwareEngineNetworkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteVmwareEngineNetwork',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Lists external IP addresses assigned to VMware workload VMs within the
     * scope of the given network policy.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedNetworkPolicy = $vmwareEngineClient->networkPolicyName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->fetchNetworkPolicyExternalAddresses($formattedNetworkPolicy);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->fetchNetworkPolicyExternalAddresses($formattedNetworkPolicy);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $networkPolicy Required. The resource name of the network policy to query for assigned
     *                              external IP addresses. Resource names are schemeless URIs that follow the
     *                              conventions in https://cloud.google.com/apis/design/resource_names. For
     *                              example:
     *                              `projects/my-project/locations/us-central1/networkPolicies/my-policy`
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function fetchNetworkPolicyExternalAddresses(
        $networkPolicy,
        array $optionalArgs = []
    ) {
        $request = new FetchNetworkPolicyExternalAddressesRequest();
        $requestParamHeaders = [];
        $request->setNetworkPolicy($networkPolicy);
        $requestParamHeaders['network_policy'] = $networkPolicy;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'FetchNetworkPolicyExternalAddresses',
            $optionalArgs,
            FetchNetworkPolicyExternalAddressesResponse::class,
            $request
        );
    }

    /**
     * Retrieves a `Cluster` resource by its resource name.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->clusterName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[CLUSTER]');
     *     $response = $vmwareEngineClient->getCluster($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The cluster resource name to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\Cluster
     *
     * @throws ApiException if the remote call fails
     */
    public function getCluster($name, array $optionalArgs = [])
    {
        $request = new GetClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCluster',
            Cluster::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets all the principals having bind permission on the intranet VPC
     * associated with the consumer project granted by the Grant API.
     * DnsBindPermission is a global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->dnsBindPermissionName('[PROJECT]', '[LOCATION]');
     *     $response = $vmwareEngineClient->getDnsBindPermission($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the resource which stores the users/service accounts
     *                             having the permission to bind to the corresponding intranet VPC of the
     *                             consumer project. DnsBindPermission is a global resource. Resource names
     *                             are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names. For example:
     *                             `projects/my-project/locations/global/dnsBindPermission`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\DnsBindPermission
     *
     * @throws ApiException if the remote call fails
     */
    public function getDnsBindPermission($name, array $optionalArgs = [])
    {
        $request = new GetDnsBindPermissionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDnsBindPermission',
            DnsBindPermission::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of the `DnsForwarding` config.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->dnsForwardingName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $response = $vmwareEngineClient->getDnsForwarding($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of a `DnsForwarding` to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\DnsForwarding
     *
     * @throws ApiException if the remote call fails
     */
    public function getDnsForwarding($name, array $optionalArgs = [])
    {
        $request = new GetDnsForwardingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDnsForwarding',
            DnsForwarding::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single external access rule.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->externalAccessRuleName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]', '[EXTERNAL_ACCESS_RULE]');
     *     $response = $vmwareEngineClient->getExternalAccessRule($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the external access firewall rule to
     *                             retrieve. Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\ExternalAccessRule
     *
     * @throws ApiException if the remote call fails
     */
    public function getExternalAccessRule($name, array $optionalArgs = [])
    {
        $request = new GetExternalAccessRuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetExternalAccessRule',
            ExternalAccessRule::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single external IP address.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->externalAddressName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[EXTERNAL_ADDRESS]');
     *     $response = $vmwareEngineClient->getExternalAddress($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the external IP address to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\ExternalAddress
     *
     * @throws ApiException if the remote call fails
     */
    public function getExternalAddress($name, array $optionalArgs = [])
    {
        $request = new GetExternalAddressRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetExternalAddress',
            ExternalAddress::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a `HcxActivationKey` resource by its resource name.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->hcxActivationKeyName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[HCX_ACTIVATION_KEY]');
     *     $response = $vmwareEngineClient->getHcxActivationKey($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the HCX activation key to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\HcxActivationKey
     *
     * @throws ApiException if the remote call fails
     */
    public function getHcxActivationKey($name, array $optionalArgs = [])
    {
        $request = new GetHcxActivationKeyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetHcxActivationKey',
            HcxActivationKey::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a logging server.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->loggingServerName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[LOGGING_SERVER]');
     *     $response = $vmwareEngineClient->getLoggingServer($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Logging Server to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\LoggingServer
     *
     * @throws ApiException if the remote call fails
     */
    public function getLoggingServer($name, array $optionalArgs = [])
    {
        $request = new GetLoggingServerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLoggingServer',
            LoggingServer::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->managementDnsZoneBindingName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[MANAGEMENT_DNS_ZONE_BINDING]');
     *     $response = $vmwareEngineClient->getManagementDnsZoneBinding($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the management DNS zone binding to
     *                             retrieve. Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\ManagementDnsZoneBinding
     *
     * @throws ApiException if the remote call fails
     */
    public function getManagementDnsZoneBinding($name, array $optionalArgs = [])
    {
        $request = new GetManagementDnsZoneBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetManagementDnsZoneBinding',
            ManagementDnsZoneBinding::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a `NetworkPeering` resource by its resource name. The resource
     * contains details of the network peering, such as peered
     * networks, import and export custom route configurations, and peering state.
     * NetworkPeering is a global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->networkPeeringName('[PROJECT]', '[LOCATION]', '[NETWORK_PEERING]');
     *     $response = $vmwareEngineClient->getNetworkPeering($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the network peering to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/global/networkPeerings/my-peering`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\NetworkPeering
     *
     * @throws ApiException if the remote call fails
     */
    public function getNetworkPeering($name, array $optionalArgs = [])
    {
        $request = new GetNetworkPeeringRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNetworkPeering',
            NetworkPeering::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a `NetworkPolicy` resource by its resource name.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->networkPolicyName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]');
     *     $response = $vmwareEngineClient->getNetworkPolicy($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the network policy to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\NetworkPolicy
     *
     * @throws ApiException if the remote call fails
     */
    public function getNetworkPolicy($name, array $optionalArgs = [])
    {
        $request = new GetNetworkPolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNetworkPolicy',
            NetworkPolicy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single node.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->nodeName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[CLUSTER]', '[NODE]');
     *     $response = $vmwareEngineClient->getNode($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the node to retrieve.
     *                             For example:
     *                             `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\Node
     *
     * @throws ApiException if the remote call fails
     */
    public function getNode($name, array $optionalArgs = [])
    {
        $request = new GetNodeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNode',
            Node::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single `NodeType`.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->nodeTypeName('[PROJECT]', '[LOCATION]', '[NODE_TYPE]');
     *     $response = $vmwareEngineClient->getNodeType($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the node type to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\NodeType
     *
     * @throws ApiException if the remote call fails
     */
    public function getNodeType($name, array $optionalArgs = [])
    {
        $request = new GetNodeTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNodeType',
            NodeType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a `PrivateCloud` resource by its resource name.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $response = $vmwareEngineClient->getPrivateCloud($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the private cloud to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\PrivateCloud
     *
     * @throws ApiException if the remote call fails
     */
    public function getPrivateCloud($name, array $optionalArgs = [])
    {
        $request = new GetPrivateCloudRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetPrivateCloud',
            PrivateCloud::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a `PrivateConnection` resource by its resource name. The resource
     * contains details of the private connection, such as connected
     * network, routing mode and state.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $response = $vmwareEngineClient->getPrivateConnection($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the private connection to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/privateConnections/my-connection`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\PrivateConnection
     *
     * @throws ApiException if the remote call fails
     */
    public function getPrivateConnection($name, array $optionalArgs = [])
    {
        $request = new GetPrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetPrivateConnection',
            PrivateConnection::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single subnet.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->subnetName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[SUBNET]');
     *     $response = $vmwareEngineClient->getSubnet($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the subnet to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\Subnet
     *
     * @throws ApiException if the remote call fails
     */
    public function getSubnet($name, array $optionalArgs = [])
    {
        $request = new GetSubnetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSubnet',
            Subnet::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a `VmwareEngineNetwork` resource by its resource name. The
     * resource contains details of the VMware Engine network, such as its VMware
     * Engine network type, peered networks in a service project, and state
     * (for example, `CREATING`, `ACTIVE`, `DELETING`).
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->vmwareEngineNetworkName('[PROJECT]', '[LOCATION]', '[VMWARE_ENGINE_NETWORK]');
     *     $response = $vmwareEngineClient->getVmwareEngineNetwork($formattedName);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the VMware Engine network to retrieve.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\VmwareEngineNetwork
     *
     * @throws ApiException if the remote call fails
     */
    public function getVmwareEngineNetwork($name, array $optionalArgs = [])
    {
        $request = new GetVmwareEngineNetworkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetVmwareEngineNetwork',
            VmwareEngineNetwork::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Grants the bind permission to the customer provided principal(user /
     * service account) to bind their DNS zone with the intranet VPC associated
     * with the project. DnsBindPermission is a global resource and location can
     * only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->dnsBindPermissionName('[PROJECT]', '[LOCATION]');
     *     $principal = new Principal();
     *     $operationResponse = $vmwareEngineClient->grantDnsBindPermission($formattedName, $principal);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->grantDnsBindPermission($formattedName, $principal);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'grantDnsBindPermission');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string    $name         Required. The name of the resource which stores the users/service accounts
     *                                having the permission to bind to the corresponding intranet VPC of the
     *                                consumer project. DnsBindPermission is a global resource. Resource names
     *                                are schemeless URIs that follow the conventions in
     *                                https://cloud.google.com/apis/design/resource_names. For example:
     *                                `projects/my-project/locations/global/dnsBindPermission`
     * @param Principal $principal    Required. The consumer provided user/service account which needs to be
     *                                granted permission to bind with the intranet VPC corresponding to the
     *                                consumer project.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function grantDnsBindPermission(
        $name,
        $principal,
        array $optionalArgs = []
    ) {
        $request = new GrantDnsBindPermissionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setPrincipal($principal);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'GrantDnsBindPermission',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Lists `Cluster` resources in a given private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listClusters($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listClusters($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud to query for clusters.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-cluster")
     *           (nodeCount = "3")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you can
     *           include `AND` and `OR` expressions explicitly. For example:
     *           ```
     *           (name = "example-cluster-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-cluster-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results are
     *           ordered by `name` in ascending order. You can also sort results in
     *           descending order based on the `name` value using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listClusters($parent, array $optionalArgs = [])
    {
        $request = new ListClustersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListClusters',
            $optionalArgs,
            ListClustersResponse::class,
            $request
        );
    }

    /**
     * Lists `ExternalAccessRule` resources in the specified network policy.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->networkPolicyName('[PROJECT]', '[LOCATION]', '[NETWORK_POLICY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listExternalAccessRules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listExternalAccessRules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the network policy to query for external
     *                             access firewall rules. Resource names are schemeless URIs that follow the
     *                             conventions in https://cloud.google.com/apis/design/resource_names. For
     *                             example:
     *                             `projects/my-project/locations/us-central1/networkPolicies/my-policy`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of external access rules, you can
     *           exclude the ones named `example-rule` by specifying
     *           `name != "example-rule"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-rule")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-rule-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-rule-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listExternalAccessRules($parent, array $optionalArgs = [])
    {
        $request = new ListExternalAccessRulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListExternalAccessRules',
            $optionalArgs,
            ListExternalAccessRulesResponse::class,
            $request
        );
    }

    /**
     * Lists external IP addresses assigned to VMware workload VMs in a given
     * private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listExternalAddresses($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listExternalAddresses($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud to be queried for
     *                             external IP addresses.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of IP addresses, you can
     *           exclude the ones named `example-ip` by specifying
     *           `name != "example-ip"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-ip")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-ip-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-ip-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listExternalAddresses($parent, array $optionalArgs = [])
    {
        $request = new ListExternalAddressesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListExternalAddresses',
            $optionalArgs,
            ListExternalAddressesResponse::class,
            $request
        );
    }

    /**
     * Lists `HcxActivationKey` resources in a given private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listHcxActivationKeys($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listHcxActivationKeys($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud
     *                             to be queried for HCX activation keys.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listHcxActivationKeys($parent, array $optionalArgs = [])
    {
        $request = new ListHcxActivationKeysRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListHcxActivationKeys',
            $optionalArgs,
            ListHcxActivationKeysResponse::class,
            $request
        );
    }

    /**
     * Lists logging servers configured for a given private
     * cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listLoggingServers($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listLoggingServers($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud to be queried for
     *                             logging servers.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of logging servers, you can
     *           exclude the ones named `example-server` by specifying
     *           `name != "example-server"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-server")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-server-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-server-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLoggingServers($parent, array $optionalArgs = [])
    {
        $request = new ListLoggingServersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLoggingServers',
            $optionalArgs,
            ListLoggingServersResponse::class,
            $request
        );
    }

    /**
     * Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listManagementDnsZoneBindings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listManagementDnsZoneBindings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud to be queried for
     *                             management DNS zone bindings.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of Management DNS Zone Bindings,
     *           you can exclude the ones named `example-management-dns-zone-binding` by
     *           specifying `name != "example-management-dns-zone-binding"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-management-dns-zone-binding")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-management-dns-zone-binding-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-management-dns-zone-binding-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listManagementDnsZoneBindings(
        $parent,
        array $optionalArgs = []
    ) {
        $request = new ListManagementDnsZoneBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListManagementDnsZoneBindings',
            $optionalArgs,
            ListManagementDnsZoneBindingsResponse::class,
            $request
        );
    }

    /**
     * Lists `NetworkPeering` resources in a given project. NetworkPeering is a
     * global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listNetworkPeerings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listNetworkPeerings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the location (global) to query for
     *                             network peerings. Resource names are schemeless URIs that follow the
     *                             conventions in https://cloud.google.com/apis/design/resource_names. For
     *                             example: `projects/my-project/locations/global`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of network peerings, you can
     *           exclude the ones named `example-peering` by specifying
     *           `name != "example-peering"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-peering")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-peering-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-peering-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNetworkPeerings($parent, array $optionalArgs = [])
    {
        $request = new ListNetworkPeeringsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNetworkPeerings',
            $optionalArgs,
            ListNetworkPeeringsResponse::class,
            $request
        );
    }

    /**
     * Lists `NetworkPolicy` resources in a specified project and location.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listNetworkPolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listNetworkPolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the location (region) to query for
     *                             network policies. Resource names are schemeless URIs that follow the
     *                             conventions in https://cloud.google.com/apis/design/resource_names. For
     *                             example: `projects/my-project/locations/us-central1`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of network policies, you can
     *           exclude the ones named `example-policy` by specifying
     *           `name != "example-policy"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-policy")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-policy-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-policy-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNetworkPolicies($parent, array $optionalArgs = [])
    {
        $request = new ListNetworkPoliciesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNetworkPolicies',
            $optionalArgs,
            ListNetworkPoliciesResponse::class,
            $request
        );
    }

    /**
     * Lists node types
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listNodeTypes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listNodeTypes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the location to be queried for node types.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of node types, you can
     *           exclude the ones named `standard-72` by specifying
     *           `name != "standard-72"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "standard-72")
     *           (virtual_cpu_count > 2)
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "standard-96") AND
     *           (virtual_cpu_count > 2) OR
     *           (name = "standard-72")
     *           ```
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNodeTypes($parent, array $optionalArgs = [])
    {
        $request = new ListNodeTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNodeTypes',
            $optionalArgs,
            ListNodeTypesResponse::class,
            $request
        );
    }

    /**
     * Lists nodes in a given cluster.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->clusterName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listNodes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listNodes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the cluster to be queried for nodes.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNodes($parent, array $optionalArgs = [])
    {
        $request = new ListNodesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNodes',
            $optionalArgs,
            ListNodesResponse::class,
            $request
        );
    }

    /**
     * Lists the network peering routes exchanged over a peering connection.
     * NetworkPeering is a global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->networkPeeringName('[PROJECT]', '[LOCATION]', '[NETWORK_PEERING]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listPeeringRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listPeeringRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the network peering to retrieve peering
     *                             routes from. Resource names are schemeless URIs that follow the conventions
     *                             in https://cloud.google.com/apis/design/resource_names. For example:
     *                             `projects/my-project/locations/global/networkPeerings/my-peering`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           Currently, only filtering on the `direction` field is supported. To return
     *           routes imported from the peer network, provide "direction=INCOMING". To
     *           return routes exported from the VMware Engine network, provide
     *           "direction=OUTGOING". Other filter expressions return an error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPeeringRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListPeeringRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPeeringRoutes',
            $optionalArgs,
            ListPeeringRoutesResponse::class,
            $request
        );
    }

    /**
     * Lists `PrivateCloud` resources in a given project and location.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listPrivateClouds($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listPrivateClouds($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud to be queried for
     *                             clusters. Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison operator, and the
     *           value that you want to use for filtering. The value must be a string, a
     *           number, or a boolean. The comparison operator must be `=`, `!=`, `>`, or
     *           `<`.
     *
     *           For example, if you are filtering a list of private clouds, you can exclude
     *           the ones named `example-pc` by specifying `name != "example-pc"`.
     *
     *           You can also filter nested fields. For example, you could specify
     *           `networkConfig.managementCidr = "192.168.0.0/24"` to include private clouds
     *           only if they have a matching address in their network configuration.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-pc")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you can
     *           include `AND` and `OR` expressions explicitly. For example:
     *           ```
     *           (name = "private-cloud-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "private-cloud-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results are
     *           ordered by `name` in ascending order. You can also sort results in
     *           descending order based on the `name` value using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPrivateClouds($parent, array $optionalArgs = [])
    {
        $request = new ListPrivateCloudsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPrivateClouds',
            $optionalArgs,
            ListPrivateCloudsResponse::class,
            $request
        );
    }

    /**
     * Lists the private connection routes exchanged over a peering connection.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listPrivateConnectionPeeringRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listPrivateConnectionPeeringRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private connection to retrieve peering
     *                             routes from. Resource names are schemeless URIs that follow the conventions
     *                             in https://cloud.google.com/apis/design/resource_names. For example:
     *                             `projects/my-project/locations/us-west1/privateConnections/my-connection`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPrivateConnectionPeeringRoutes(
        $parent,
        array $optionalArgs = []
    ) {
        $request = new ListPrivateConnectionPeeringRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPrivateConnectionPeeringRoutes',
            $optionalArgs,
            ListPrivateConnectionPeeringRoutesResponse::class,
            $request
        );
    }

    /**
     * Lists `PrivateConnection` resources in a given project and location.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listPrivateConnections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listPrivateConnections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the location to query for
     *                             private connections. Resource names are schemeless URIs that follow the
     *                             conventions in https://cloud.google.com/apis/design/resource_names. For
     *                             example: `projects/my-project/locations/us-central1`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of private connections, you can
     *           exclude the ones named `example-connection` by specifying
     *           `name != "example-connection"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-connection")
     *           (createTime > "2022-09-22T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-connection-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-connection-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPrivateConnections($parent, array $optionalArgs = [])
    {
        $request = new ListPrivateConnectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPrivateConnections',
            $optionalArgs,
            ListPrivateConnectionsResponse::class,
            $request
        );
    }

    /**
     * Lists subnets in a given private cloud.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listSubnets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listSubnets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the private cloud to be queried for
     *                             subnets.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSubnets($parent, array $optionalArgs = [])
    {
        $request = new ListSubnetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSubnets',
            $optionalArgs,
            ListSubnetsResponse::class,
            $request
        );
    }

    /**
     * Lists `VmwareEngineNetwork` resources in a given project and location.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedParent = $vmwareEngineClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listVmwareEngineNetworks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listVmwareEngineNetworks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the location to query for
     *                             VMware Engine networks. Resource names are schemeless URIs that follow the
     *                             conventions in https://cloud.google.com/apis/design/resource_names. For
     *                             example: `projects/my-project/locations/global`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that matches resources returned in the response.
     *           The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value
     *           must be a string, a number, or a boolean. The comparison operator
     *           must be `=`, `!=`, `>`, or `<`.
     *
     *           For example, if you are filtering a list of network peerings, you can
     *           exclude the ones named `example-network` by specifying
     *           `name != "example-network"`.
     *
     *           To filter on multiple expressions, provide each separate expression within
     *           parentheses. For example:
     *           ```
     *           (name = "example-network")
     *           (createTime > "2021-04-12T08:15:10.40Z")
     *           ```
     *
     *           By default, each expression is an `AND` expression. However, you
     *           can include `AND` and `OR` expressions explicitly.
     *           For example:
     *           ```
     *           (name = "example-network-1") AND
     *           (createTime > "2021-04-12T08:15:10.40Z") OR
     *           (name = "example-network-2")
     *           ```
     *     @type string $orderBy
     *           Sorts list results by a certain order. By default, returned results
     *           are ordered by `name` in ascending order.
     *           You can also sort results in descending order based on the `name` value
     *           using `orderBy="name desc"`.
     *           Currently, only ordering by `name` is supported.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVmwareEngineNetworks($parent, array $optionalArgs = [])
    {
        $request = new ListVmwareEngineNetworksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListVmwareEngineNetworks',
            $optionalArgs,
            ListVmwareEngineNetworksResponse::class,
            $request
        );
    }

    /**
     * Retries to create a `ManagementDnsZoneBinding` resource that is
     * in failed state.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->managementDnsZoneBindingName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]', '[MANAGEMENT_DNS_ZONE_BINDING]');
     *     $operationResponse = $vmwareEngineClient->repairManagementDnsZoneBinding($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->repairManagementDnsZoneBinding($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'repairManagementDnsZoneBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the management DNS zone binding to repair.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function repairManagementDnsZoneBinding(
        $name,
        array $optionalArgs = []
    ) {
        $request = new RepairManagementDnsZoneBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RepairManagementDnsZoneBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Resets credentials of the NSX appliance.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedPrivateCloud = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $operationResponse = $vmwareEngineClient->resetNsxCredentials($formattedPrivateCloud);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->resetNsxCredentials($formattedPrivateCloud);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'resetNsxCredentials');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $privateCloud Required. The resource name of the private cloud
     *                             to reset credentials for.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resetNsxCredentials($privateCloud, array $optionalArgs = [])
    {
        $request = new ResetNsxCredentialsRequest();
        $requestParamHeaders = [];
        $request->setPrivateCloud($privateCloud);
        $requestParamHeaders['private_cloud'] = $privateCloud;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ResetNsxCredentials',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Resets credentials of the Vcenter appliance.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedPrivateCloud = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $operationResponse = $vmwareEngineClient->resetVcenterCredentials($formattedPrivateCloud);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->resetVcenterCredentials($formattedPrivateCloud);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'resetVcenterCredentials');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $privateCloud Required. The resource name of the private cloud
     *                             to reset credentials for.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type string $username
     *           Optional. The username of the user to be to reset the credentials.
     *           The default value of this field is CloudOwner&#64;gve.local.
     *           The provided value should be one of the following:
     *           solution-user-01&#64;gve.local,
     *           solution-user-02&#64;gve.local,
     *           solution-user-03&#64;gve.local,
     *           solution-user-04&#64;gve.local,
     *           solution-user-05&#64;gve.local,
     *           zertoadmin&#64;gve.local.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resetVcenterCredentials(
        $privateCloud,
        array $optionalArgs = []
    ) {
        $request = new ResetVcenterCredentialsRequest();
        $requestParamHeaders = [];
        $request->setPrivateCloud($privateCloud);
        $requestParamHeaders['private_cloud'] = $privateCloud;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['username'])) {
            $request->setUsername($optionalArgs['username']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ResetVcenterCredentials',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Revokes the bind permission from the customer provided principal(user /
     * service account) on the intranet VPC associated with the consumer project.
     * DnsBindPermission is a global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->dnsBindPermissionName('[PROJECT]', '[LOCATION]');
     *     $principal = new Principal();
     *     $operationResponse = $vmwareEngineClient->revokeDnsBindPermission($formattedName, $principal);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->revokeDnsBindPermission($formattedName, $principal);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'revokeDnsBindPermission');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string    $name         Required. The name of the resource which stores the users/service accounts
     *                                having the permission to bind to the corresponding intranet VPC of the
     *                                consumer project. DnsBindPermission is a global resource. Resource names
     *                                are schemeless URIs that follow the conventions in
     *                                https://cloud.google.com/apis/design/resource_names. For example:
     *                                `projects/my-project/locations/global/dnsBindPermission`
     * @param Principal $principal    Required. The consumer provided user/service account which needs to be
     *                                granted permission to bind with the intranet VPC corresponding to the
     *                                consumer project.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function revokeDnsBindPermission(
        $name,
        $principal,
        array $optionalArgs = []
    ) {
        $request = new RevokeDnsBindPermissionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setPrincipal($principal);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RevokeDnsBindPermission',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of credentials for NSX appliance.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedPrivateCloud = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $response = $vmwareEngineClient->showNsxCredentials($formattedPrivateCloud);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $privateCloud Required. The resource name of the private cloud
     *                             to be queried for credentials.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\Credentials
     *
     * @throws ApiException if the remote call fails
     */
    public function showNsxCredentials($privateCloud, array $optionalArgs = [])
    {
        $request = new ShowNsxCredentialsRequest();
        $requestParamHeaders = [];
        $request->setPrivateCloud($privateCloud);
        $requestParamHeaders['private_cloud'] = $privateCloud;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ShowNsxCredentials',
            Credentials::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of credentials for Vcenter appliance.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedPrivateCloud = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $response = $vmwareEngineClient->showVcenterCredentials($formattedPrivateCloud);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $privateCloud Required. The resource name of the private cloud
     *                             to be queried for credentials.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $username
     *           Optional. The username of the user to be queried for credentials.
     *           The default value of this field is CloudOwner&#64;gve.local.
     *           The provided value must be one of the following:
     *           CloudOwner&#64;gve.local,
     *           solution-user-01&#64;gve.local,
     *           solution-user-02&#64;gve.local,
     *           solution-user-03&#64;gve.local,
     *           solution-user-04&#64;gve.local,
     *           solution-user-05&#64;gve.local,
     *           zertoadmin&#64;gve.local.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VmwareEngine\V1\Credentials
     *
     * @throws ApiException if the remote call fails
     */
    public function showVcenterCredentials(
        $privateCloud,
        array $optionalArgs = []
    ) {
        $request = new ShowVcenterCredentialsRequest();
        $requestParamHeaders = [];
        $request->setPrivateCloud($privateCloud);
        $requestParamHeaders['private_cloud'] = $privateCloud;
        if (isset($optionalArgs['username'])) {
            $request->setUsername($optionalArgs['username']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ShowVcenterCredentials',
            Credentials::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Restores a private cloud that was previously scheduled for deletion by
     * `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
     * `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
     * the time when deletion can no longer be reversed.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $formattedName = $vmwareEngineClient->privateCloudName('[PROJECT]', '[LOCATION]', '[PRIVATE_CLOUD]');
     *     $operationResponse = $vmwareEngineClient->undeletePrivateCloud($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->undeletePrivateCloud($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'undeletePrivateCloud');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the private cloud scheduled for deletion.
     *                             Resource names are schemeless URIs that follow the conventions in
     *                             https://cloud.google.com/apis/design/resource_names.
     *                             For example:
     *                             `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that zero
     *           UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeletePrivateCloud($name, array $optionalArgs = [])
    {
        $request = new UndeletePrivateCloudRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UndeletePrivateCloud',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Modifies a `Cluster` resource. Only fields specified in `updateMask` are
     * applied.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $cluster = new Cluster();
     *     $operationResponse = $vmwareEngineClient->updateCluster($updateMask, $cluster);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateCluster($updateMask, $cluster);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                `Cluster` resource by the update. The fields specified in the `updateMask`
     *                                are relative to the resource, not the full request. A field will be
     *                                overwritten if it is in the mask. If the user does not provide a mask then
     *                                all fields will be overwritten.
     * @param Cluster   $cluster      Required. The description of the cluster.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that
     *           zero UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type bool $validateOnly
     *           Optional. True if you want the request to be validated and not executed;
     *           false otherwise.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCluster(
        $updateMask,
        $cluster,
        array $optionalArgs = []
    ) {
        $request = new UpdateClusterRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setCluster($cluster);
        $requestParamHeaders['cluster.name'] = $cluster->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of the `DnsForwarding` config, like associated
     * domains. Only fields specified in `update_mask` are applied.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $dnsForwarding = new DnsForwarding();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $vmwareEngineClient->updateDnsForwarding($dnsForwarding, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateDnsForwarding($dnsForwarding, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateDnsForwarding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param DnsForwarding $dnsForwarding Required. DnsForwarding config details.
     * @param FieldMask     $updateMask    Required. Field mask is used to specify the fields to be overwritten in the
     *                                     `DnsForwarding` resource by the update.
     *                                     The fields specified in the `update_mask` are relative to the resource, not
     *                                     the full request. A field will be overwritten if it is in the mask. If the
     *                                     user does not provide a mask then all fields will be overwritten.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDnsForwarding(
        $dnsForwarding,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateDnsForwardingRequest();
        $requestParamHeaders = [];
        $request->setDnsForwarding($dnsForwarding);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['dns_forwarding.name'] = $dnsForwarding->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateDnsForwarding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single external access rule.
     * Only fields specified in `update_mask` are applied.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $externalAccessRule = new ExternalAccessRule();
     *     $operationResponse = $vmwareEngineClient->updateExternalAccessRule($updateMask, $externalAccessRule);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateExternalAccessRule($updateMask, $externalAccessRule);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateExternalAccessRule');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param FieldMask          $updateMask         Required. Field mask is used to specify the fields to be overwritten in the
     *                                               `ExternalAccessRule` resource by the update.
     *                                               The fields specified in the `update_mask` are relative to the resource, not
     *                                               the full request. A field will be overwritten if it is in the mask. If the
     *                                               user does not provide a mask then all fields will be overwritten.
     * @param ExternalAccessRule $externalAccessRule Required. Description of the external access rule.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateExternalAccessRule(
        $updateMask,
        $externalAccessRule,
        array $optionalArgs = []
    ) {
        $request = new UpdateExternalAccessRuleRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setExternalAccessRule($externalAccessRule);
        $requestParamHeaders[
            'external_access_rule.name'
        ] = $externalAccessRule->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateExternalAccessRule',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single external IP address.
     * Only fields specified in `update_mask` are applied.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $externalAddress = new ExternalAddress();
     *     $operationResponse = $vmwareEngineClient->updateExternalAddress($updateMask, $externalAddress);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateExternalAddress($updateMask, $externalAddress);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateExternalAddress');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param FieldMask       $updateMask      Required. Field mask is used to specify the fields to be overwritten in the
     *                                         `ExternalAddress` resource by the update.
     *                                         The fields specified in the `update_mask` are relative to the resource, not
     *                                         the full request. A field will be overwritten if it is in the mask. If the
     *                                         user does not provide a mask then all fields will be overwritten.
     * @param ExternalAddress $externalAddress Required. External IP address description.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateExternalAddress(
        $updateMask,
        $externalAddress,
        array $optionalArgs = []
    ) {
        $request = new UpdateExternalAddressRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setExternalAddress($externalAddress);
        $requestParamHeaders[
            'external_address.name'
        ] = $externalAddress->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateExternalAddress',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single logging server.
     * Only fields specified in `update_mask` are applied.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $loggingServer = new LoggingServer();
     *     $operationResponse = $vmwareEngineClient->updateLoggingServer($updateMask, $loggingServer);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateLoggingServer($updateMask, $loggingServer);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateLoggingServer');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param FieldMask     $updateMask    Required. Field mask is used to specify the fields to be overwritten in the
     *                                     `LoggingServer` resource by the update.
     *                                     The fields specified in the `update_mask` are relative to the resource, not
     *                                     the full request. A field will be overwritten if it is in the mask. If the
     *                                     user does not provide a mask then all fields will be overwritten.
     * @param LoggingServer $loggingServer Required. Logging server description.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateLoggingServer(
        $updateMask,
        $loggingServer,
        array $optionalArgs = []
    ) {
        $request = new UpdateLoggingServerRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setLoggingServer($loggingServer);
        $requestParamHeaders['logging_server.name'] = $loggingServer->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateLoggingServer',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a `ManagementDnsZoneBinding` resource.
     * Only fields specified in `update_mask` are applied.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $managementDnsZoneBinding = new ManagementDnsZoneBinding();
     *     $operationResponse = $vmwareEngineClient->updateManagementDnsZoneBinding($updateMask, $managementDnsZoneBinding);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateManagementDnsZoneBinding($updateMask, $managementDnsZoneBinding);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateManagementDnsZoneBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param FieldMask                $updateMask               Required. Field mask is used to specify the fields to be overwritten in the
     *                                                           `ManagementDnsZoneBinding` resource by the update.
     *                                                           The fields specified in the `update_mask` are relative to the resource, not
     *                                                           the full request. A field will be overwritten if it is in the mask. If the
     *                                                           user does not provide a mask then all fields will be overwritten.
     * @param ManagementDnsZoneBinding $managementDnsZoneBinding Required. New values to update the management DNS zone binding with.
     * @param array                    $optionalArgs             {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if the original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateManagementDnsZoneBinding(
        $updateMask,
        $managementDnsZoneBinding,
        array $optionalArgs = []
    ) {
        $request = new UpdateManagementDnsZoneBindingRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setManagementDnsZoneBinding($managementDnsZoneBinding);
        $requestParamHeaders[
            'management_dns_zone_binding.name'
        ] = $managementDnsZoneBinding->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateManagementDnsZoneBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Modifies a `NetworkPeering` resource. Only the `description` field can be
     * updated. Only fields specified in `updateMask` are applied. NetworkPeering
     * is a global resource and location can only be global.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $networkPeering = new NetworkPeering();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $vmwareEngineClient->updateNetworkPeering($networkPeering, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateNetworkPeering($networkPeering, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateNetworkPeering');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param NetworkPeering $networkPeering Required. Network peering description.
     * @param FieldMask      $updateMask     Required. Field mask is used to specify the fields to be overwritten in the
     *                                       `NetworkPeering` resource by the update.
     *                                       The fields specified in the `update_mask` are relative to the resource, not
     *                                       the full request. A field will be overwritten if it is in the mask. If the
     *                                       user does not provide a mask then all fields will be overwritten.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateNetworkPeering(
        $networkPeering,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateNetworkPeeringRequest();
        $requestParamHeaders = [];
        $request->setNetworkPeering($networkPeering);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'network_peering.name'
        ] = $networkPeering->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateNetworkPeering',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Modifies a `NetworkPolicy` resource. Only the following fields can be
     * updated: `internet_access`, `external_ip`, `edge_services_cidr`.
     * Only fields specified in `updateMask` are applied. When updating a network
     * policy, the external IP network service can only be disabled if there are
     * no external IP addresses present in the scope of the policy. Also, a
     * `NetworkService` cannot be updated when `NetworkService.state` is set
     * to `RECONCILING`.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $networkPolicy = new NetworkPolicy();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $vmwareEngineClient->updateNetworkPolicy($networkPolicy, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateNetworkPolicy($networkPolicy, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateNetworkPolicy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param NetworkPolicy $networkPolicy Required. Network policy description.
     * @param FieldMask     $updateMask    Required. Field mask is used to specify the fields to be overwritten in the
     *                                     `NetworkPolicy` resource by the update.
     *                                     The fields specified in the `update_mask` are relative to the resource, not
     *                                     the full request. A field will be overwritten if it is in the mask. If the
     *                                     user does not provide a mask then all fields will be overwritten.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateNetworkPolicy(
        $networkPolicy,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateNetworkPolicyRequest();
        $requestParamHeaders = [];
        $request->setNetworkPolicy($networkPolicy);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['network_policy.name'] = $networkPolicy->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateNetworkPolicy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Modifies a `PrivateCloud` resource. Only the following fields can be
     * updated: `description`.
     * Only fields specified in `updateMask` are applied.
     *
     * During operation processing, the resource is temporarily in the `ACTIVE`
     * state before the operation fully completes. For that period of time, you
     * can't update the resource. Use the operation status to determine when the
     * processing fully completes.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $privateCloud = new PrivateCloud();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $vmwareEngineClient->updatePrivateCloud($privateCloud, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updatePrivateCloud($privateCloud, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updatePrivateCloud');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param PrivateCloud $privateCloud Required. Private cloud description.
     * @param FieldMask    $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                   `PrivateCloud` resource by the update. The fields specified in `updateMask`
     *                                   are relative to the resource, not the full request. A field will be
     *                                   overwritten if it is in the mask. If the user does not provide a mask then
     *                                   all fields will be overwritten.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. The request ID must be a valid UUID with the exception that zero
     *           UUID is not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updatePrivateCloud(
        $privateCloud,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdatePrivateCloudRequest();
        $requestParamHeaders = [];
        $request->setPrivateCloud($privateCloud);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['private_cloud.name'] = $privateCloud->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdatePrivateCloud',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Modifies a `PrivateConnection` resource. Only `description` and
     * `routing_mode` fields can be updated. Only fields specified in `updateMask`
     * are applied.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $privateConnection = new PrivateConnection();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $vmwareEngineClient->updatePrivateConnection($privateConnection, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updatePrivateConnection($privateConnection, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updatePrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param PrivateConnection $privateConnection Required. Private connection description.
     * @param FieldMask         $updateMask        Required. Field mask is used to specify the fields to be overwritten in the
     *                                             `PrivateConnection` resource by the update.
     *                                             The fields specified in the `update_mask` are relative to the resource, not
     *                                             the full request. A field will be overwritten if it is in the mask. If the
     *                                             user does not provide a mask then all fields will be overwritten.
     * @param array             $optionalArgs      {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updatePrivateConnection(
        $privateConnection,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdatePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setPrivateConnection($privateConnection);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'private_connection.name'
        ] = $privateConnection->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdatePrivateConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single subnet. Only fields specified in
     * `update_mask` are applied.
     *
     * *Note*: This API is synchronous and always returns a successful
     * `google.longrunning.Operation` (LRO). The returned LRO will only have
     * `done` and `response` fields.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $subnet = new Subnet();
     *     $operationResponse = $vmwareEngineClient->updateSubnet($updateMask, $subnet);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateSubnet($updateMask, $subnet);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateSubnet');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Field mask is used to specify the fields to be overwritten in the
     *                                `Subnet` resource by the update.
     *                                The fields specified in the `update_mask` are relative to the resource, not
     *                                the full request. A field will be overwritten if it is in the mask. If the
     *                                user does not provide a mask then all fields will be overwritten.
     * @param Subnet    $subnet       Required. Subnet description.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSubnet($updateMask, $subnet, array $optionalArgs = [])
    {
        $request = new UpdateSubnetRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setSubnet($subnet);
        $requestParamHeaders['subnet.name'] = $subnet->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateSubnet',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Modifies a VMware Engine network resource. Only the following fields can be
     * updated: `description`. Only fields specified in `updateMask` are
     * applied.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $vmwareEngineNetwork = new VmwareEngineNetwork();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $vmwareEngineClient->updateVmwareEngineNetwork($vmwareEngineNetwork, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmwareEngineClient->updateVmwareEngineNetwork($vmwareEngineNetwork, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmwareEngineClient->resumeOperation($operationName, 'updateVmwareEngineNetwork');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param VmwareEngineNetwork $vmwareEngineNetwork Required. VMware Engine network description.
     * @param FieldMask           $updateMask          Required. Field mask is used to specify the fields to be overwritten in the
     *                                                 VMware Engine network resource by the update.
     *                                                 The fields specified in the `update_mask` are relative to the resource, not
     *                                                 the full request. A field will be overwritten if it is in the mask. If the
     *                                                 user does not provide a mask then all fields will be overwritten. Only the
     *                                                 following fields can be updated: `description`.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server guarantees that a
     *           request doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateVmwareEngineNetwork(
        $vmwareEngineNetwork,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateVmwareEngineNetworkRequest();
        $requestParamHeaders = [];
        $request->setVmwareEngineNetwork($vmwareEngineNetwork);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'vmware_engine_network.name'
        ] = $vmwareEngineNetwork->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateVmwareEngineNetwork',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $response = $vmwareEngineClient->getLocation();
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmwareEngineClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmwareEngineClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $resource = 'resource';
     *     $response = $vmwareEngineClient->getIamPolicy($resource);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $vmwareEngineClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $vmwareEngineClient = new VmwareEngineClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $vmwareEngineClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $vmwareEngineClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
