<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/vmwareengine/v1/vmwareengine_resources.proto

namespace Google\Cloud\VmwareEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * External access firewall rules for filtering incoming traffic destined to
 * `ExternalAddress` resources.
 *
 * Generated from protobuf message <code>google.cloud.vmwareengine.v1.ExternalAccessRule</code>
 */
class ExternalAccessRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of this external access rule.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * User-provided description for this external access rule.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     */
    private $description = '';
    /**
     * External access rule priority, which determines the external access rule to
     * use when multiple rules apply. If multiple rules have the same priority,
     * their ordering is non-deterministic. If specific ordering is required,
     * assign unique priorities to enforce such ordering. The external access rule
     * priority is an integer from 100 to 4096, both inclusive. Lower integers
     * indicate higher precedence. For example, a rule with priority `100` has
     * higher precedence than a rule with priority `101`.
     *
     * Generated from protobuf field <code>int32 priority = 6;</code>
     */
    private $priority = 0;
    /**
     * The action that the external access rule performs.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.ExternalAccessRule.Action action = 7;</code>
     */
    private $action = 0;
    /**
     * The IP protocol to which the external access rule applies. This value can
     * be one of the following three protocol strings (not case-sensitive):
     * `tcp`, `udp`, or `icmp`.
     *
     * Generated from protobuf field <code>string ip_protocol = 8;</code>
     */
    private $ip_protocol = '';
    /**
     * If source ranges are specified, the external access rule applies only to
     * traffic that has a source IP address in these ranges. These ranges can
     * either be expressed in the CIDR format or as an IP address. As only inbound
     * rules are supported, `ExternalAddress` resources cannot be the source IP
     * addresses of an external access rule. To match all source addresses,
     * specify `0.0.0.0/0`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange source_ip_ranges = 9;</code>
     */
    private $source_ip_ranges;
    /**
     * A list of source ports to which the external access rule applies. This
     * field is only applicable for the UDP or TCP protocol.
     * Each entry must be either an integer or a range. For example: `["22"]`,
     * `["80","443"]`, or `["12345-12349"]`. To match all source ports, specify
     * `["0-65535"]`.
     *
     * Generated from protobuf field <code>repeated string source_ports = 10;</code>
     */
    private $source_ports;
    /**
     * If destination ranges are specified, the external access rule applies only
     * to the traffic that has a destination IP address in these ranges. The
     * specified IP addresses must have reserved external IP addresses in the
     * scope of the parent network policy. To match all external IP addresses in
     * the scope of the parent network policy, specify `0.0.0.0/0`. To match a
     * specific external IP address, specify it using the
     * `IpRange.external_address` property.
     *
     * Generated from protobuf field <code>repeated .google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange destination_ip_ranges = 11;</code>
     */
    private $destination_ip_ranges;
    /**
     * A list of destination ports to which the external access rule applies. This
     * field is only applicable for the UDP or TCP protocol.
     * Each entry must be either an integer or a range. For example: `["22"]`,
     * `["80","443"]`, or `["12345-12349"]`. To match all destination ports,
     * specify `["0-65535"]`.
     *
     * Generated from protobuf field <code>repeated string destination_ports = 12;</code>
     */
    private $destination_ports;
    /**
     * Output only. The state of the resource.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.ExternalAccessRule.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $uid = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of this external access rule.
     *           Resource names are schemeless URIs that follow the conventions in
     *           https://cloud.google.com/apis/design/resource_names.
     *           For example:
     *           `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Creation time of this resource.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Last update time of this resource.
     *     @type string $description
     *           User-provided description for this external access rule.
     *     @type int $priority
     *           External access rule priority, which determines the external access rule to
     *           use when multiple rules apply. If multiple rules have the same priority,
     *           their ordering is non-deterministic. If specific ordering is required,
     *           assign unique priorities to enforce such ordering. The external access rule
     *           priority is an integer from 100 to 4096, both inclusive. Lower integers
     *           indicate higher precedence. For example, a rule with priority `100` has
     *           higher precedence than a rule with priority `101`.
     *     @type int $action
     *           The action that the external access rule performs.
     *     @type string $ip_protocol
     *           The IP protocol to which the external access rule applies. This value can
     *           be one of the following three protocol strings (not case-sensitive):
     *           `tcp`, `udp`, or `icmp`.
     *     @type array<\Google\Cloud\VmwareEngine\V1\ExternalAccessRule\IpRange>|\Google\Protobuf\Internal\RepeatedField $source_ip_ranges
     *           If source ranges are specified, the external access rule applies only to
     *           traffic that has a source IP address in these ranges. These ranges can
     *           either be expressed in the CIDR format or as an IP address. As only inbound
     *           rules are supported, `ExternalAddress` resources cannot be the source IP
     *           addresses of an external access rule. To match all source addresses,
     *           specify `0.0.0.0/0`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $source_ports
     *           A list of source ports to which the external access rule applies. This
     *           field is only applicable for the UDP or TCP protocol.
     *           Each entry must be either an integer or a range. For example: `["22"]`,
     *           `["80","443"]`, or `["12345-12349"]`. To match all source ports, specify
     *           `["0-65535"]`.
     *     @type array<\Google\Cloud\VmwareEngine\V1\ExternalAccessRule\IpRange>|\Google\Protobuf\Internal\RepeatedField $destination_ip_ranges
     *           If destination ranges are specified, the external access rule applies only
     *           to the traffic that has a destination IP address in these ranges. The
     *           specified IP addresses must have reserved external IP addresses in the
     *           scope of the parent network policy. To match all external IP addresses in
     *           the scope of the parent network policy, specify `0.0.0.0/0`. To match a
     *           specific external IP address, specify it using the
     *           `IpRange.external_address` property.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $destination_ports
     *           A list of destination ports to which the external access rule applies. This
     *           field is only applicable for the UDP or TCP protocol.
     *           Each entry must be either an integer or a range. For example: `["22"]`,
     *           `["80","443"]`, or `["12345-12349"]`. To match all destination ports,
     *           specify `["0-65535"]`.
     *     @type int $state
     *           Output only. The state of the resource.
     *     @type string $uid
     *           Output only. System-generated unique identifier for the resource.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Vmwareengine\V1\VmwareengineResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of this external access rule.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of this external access rule.
     * Resource names are schemeless URIs that follow the conventions in
     * https://cloud.google.com/apis/design/resource_names.
     * For example:
     * `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Creation time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Last update time of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-provided description for this external access rule.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User-provided description for this external access rule.
     *
     * Generated from protobuf field <code>string description = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * External access rule priority, which determines the external access rule to
     * use when multiple rules apply. If multiple rules have the same priority,
     * their ordering is non-deterministic. If specific ordering is required,
     * assign unique priorities to enforce such ordering. The external access rule
     * priority is an integer from 100 to 4096, both inclusive. Lower integers
     * indicate higher precedence. For example, a rule with priority `100` has
     * higher precedence than a rule with priority `101`.
     *
     * Generated from protobuf field <code>int32 priority = 6;</code>
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * External access rule priority, which determines the external access rule to
     * use when multiple rules apply. If multiple rules have the same priority,
     * their ordering is non-deterministic. If specific ordering is required,
     * assign unique priorities to enforce such ordering. The external access rule
     * priority is an integer from 100 to 4096, both inclusive. Lower integers
     * indicate higher precedence. For example, a rule with priority `100` has
     * higher precedence than a rule with priority `101`.
     *
     * Generated from protobuf field <code>int32 priority = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setPriority($var)
    {
        GPBUtil::checkInt32($var);
        $this->priority = $var;

        return $this;
    }

    /**
     * The action that the external access rule performs.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.ExternalAccessRule.Action action = 7;</code>
     * @return int
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * The action that the external access rule performs.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.ExternalAccessRule.Action action = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setAction($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VmwareEngine\V1\ExternalAccessRule\Action::class);
        $this->action = $var;

        return $this;
    }

    /**
     * The IP protocol to which the external access rule applies. This value can
     * be one of the following three protocol strings (not case-sensitive):
     * `tcp`, `udp`, or `icmp`.
     *
     * Generated from protobuf field <code>string ip_protocol = 8;</code>
     * @return string
     */
    public function getIpProtocol()
    {
        return $this->ip_protocol;
    }

    /**
     * The IP protocol to which the external access rule applies. This value can
     * be one of the following three protocol strings (not case-sensitive):
     * `tcp`, `udp`, or `icmp`.
     *
     * Generated from protobuf field <code>string ip_protocol = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setIpProtocol($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_protocol = $var;

        return $this;
    }

    /**
     * If source ranges are specified, the external access rule applies only to
     * traffic that has a source IP address in these ranges. These ranges can
     * either be expressed in the CIDR format or as an IP address. As only inbound
     * rules are supported, `ExternalAddress` resources cannot be the source IP
     * addresses of an external access rule. To match all source addresses,
     * specify `0.0.0.0/0`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange source_ip_ranges = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSourceIpRanges()
    {
        return $this->source_ip_ranges;
    }

    /**
     * If source ranges are specified, the external access rule applies only to
     * traffic that has a source IP address in these ranges. These ranges can
     * either be expressed in the CIDR format or as an IP address. As only inbound
     * rules are supported, `ExternalAddress` resources cannot be the source IP
     * addresses of an external access rule. To match all source addresses,
     * specify `0.0.0.0/0`.
     *
     * Generated from protobuf field <code>repeated .google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange source_ip_ranges = 9;</code>
     * @param array<\Google\Cloud\VmwareEngine\V1\ExternalAccessRule\IpRange>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSourceIpRanges($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VmwareEngine\V1\ExternalAccessRule\IpRange::class);
        $this->source_ip_ranges = $arr;

        return $this;
    }

    /**
     * A list of source ports to which the external access rule applies. This
     * field is only applicable for the UDP or TCP protocol.
     * Each entry must be either an integer or a range. For example: `["22"]`,
     * `["80","443"]`, or `["12345-12349"]`. To match all source ports, specify
     * `["0-65535"]`.
     *
     * Generated from protobuf field <code>repeated string source_ports = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSourcePorts()
    {
        return $this->source_ports;
    }

    /**
     * A list of source ports to which the external access rule applies. This
     * field is only applicable for the UDP or TCP protocol.
     * Each entry must be either an integer or a range. For example: `["22"]`,
     * `["80","443"]`, or `["12345-12349"]`. To match all source ports, specify
     * `["0-65535"]`.
     *
     * Generated from protobuf field <code>repeated string source_ports = 10;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSourcePorts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->source_ports = $arr;

        return $this;
    }

    /**
     * If destination ranges are specified, the external access rule applies only
     * to the traffic that has a destination IP address in these ranges. The
     * specified IP addresses must have reserved external IP addresses in the
     * scope of the parent network policy. To match all external IP addresses in
     * the scope of the parent network policy, specify `0.0.0.0/0`. To match a
     * specific external IP address, specify it using the
     * `IpRange.external_address` property.
     *
     * Generated from protobuf field <code>repeated .google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange destination_ip_ranges = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDestinationIpRanges()
    {
        return $this->destination_ip_ranges;
    }

    /**
     * If destination ranges are specified, the external access rule applies only
     * to the traffic that has a destination IP address in these ranges. The
     * specified IP addresses must have reserved external IP addresses in the
     * scope of the parent network policy. To match all external IP addresses in
     * the scope of the parent network policy, specify `0.0.0.0/0`. To match a
     * specific external IP address, specify it using the
     * `IpRange.external_address` property.
     *
     * Generated from protobuf field <code>repeated .google.cloud.vmwareengine.v1.ExternalAccessRule.IpRange destination_ip_ranges = 11;</code>
     * @param array<\Google\Cloud\VmwareEngine\V1\ExternalAccessRule\IpRange>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDestinationIpRanges($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\VmwareEngine\V1\ExternalAccessRule\IpRange::class);
        $this->destination_ip_ranges = $arr;

        return $this;
    }

    /**
     * A list of destination ports to which the external access rule applies. This
     * field is only applicable for the UDP or TCP protocol.
     * Each entry must be either an integer or a range. For example: `["22"]`,
     * `["80","443"]`, or `["12345-12349"]`. To match all destination ports,
     * specify `["0-65535"]`.
     *
     * Generated from protobuf field <code>repeated string destination_ports = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDestinationPorts()
    {
        return $this->destination_ports;
    }

    /**
     * A list of destination ports to which the external access rule applies. This
     * field is only applicable for the UDP or TCP protocol.
     * Each entry must be either an integer or a range. For example: `["22"]`,
     * `["80","443"]`, or `["12345-12349"]`. To match all destination ports,
     * specify `["0-65535"]`.
     *
     * Generated from protobuf field <code>repeated string destination_ports = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDestinationPorts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->destination_ports = $arr;

        return $this;
    }

    /**
     * Output only. The state of the resource.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.ExternalAccessRule.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the resource.
     *
     * Generated from protobuf field <code>.google.cloud.vmwareengine.v1.ExternalAccessRule.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\VmwareEngine\V1\ExternalAccessRule\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. System-generated unique identifier for the resource.
     *
     * Generated from protobuf field <code>string uid = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

}

