<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/video/livestream/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Video\LiveStream\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\Video\LiveStream\V1\Asset;
use Google\Cloud\Video\LiveStream\V1\Channel;
use Google\Cloud\Video\LiveStream\V1\CreateAssetRequest;
use Google\Cloud\Video\LiveStream\V1\CreateChannelRequest;
use Google\Cloud\Video\LiveStream\V1\CreateEventRequest;
use Google\Cloud\Video\LiveStream\V1\CreateInputRequest;
use Google\Cloud\Video\LiveStream\V1\DeleteAssetRequest;
use Google\Cloud\Video\LiveStream\V1\DeleteChannelRequest;
use Google\Cloud\Video\LiveStream\V1\DeleteEventRequest;
use Google\Cloud\Video\LiveStream\V1\DeleteInputRequest;
use Google\Cloud\Video\LiveStream\V1\Event;
use Google\Cloud\Video\LiveStream\V1\GetAssetRequest;
use Google\Cloud\Video\LiveStream\V1\GetChannelRequest;
use Google\Cloud\Video\LiveStream\V1\GetEventRequest;
use Google\Cloud\Video\LiveStream\V1\GetInputRequest;
use Google\Cloud\Video\LiveStream\V1\GetPoolRequest;
use Google\Cloud\Video\LiveStream\V1\Input;
use Google\Cloud\Video\LiveStream\V1\ListAssetsRequest;
use Google\Cloud\Video\LiveStream\V1\ListAssetsResponse;
use Google\Cloud\Video\LiveStream\V1\ListChannelsRequest;
use Google\Cloud\Video\LiveStream\V1\ListChannelsResponse;
use Google\Cloud\Video\LiveStream\V1\ListEventsRequest;
use Google\Cloud\Video\LiveStream\V1\ListEventsResponse;
use Google\Cloud\Video\LiveStream\V1\ListInputsRequest;
use Google\Cloud\Video\LiveStream\V1\ListInputsResponse;
use Google\Cloud\Video\LiveStream\V1\Pool;
use Google\Cloud\Video\LiveStream\V1\StartChannelRequest;
use Google\Cloud\Video\LiveStream\V1\StopChannelRequest;
use Google\Cloud\Video\LiveStream\V1\UpdateChannelRequest;
use Google\Cloud\Video\LiveStream\V1\UpdateInputRequest;
use Google\Cloud\Video\LiveStream\V1\UpdatePoolRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Using Live Stream API, you can generate live streams in the various
 * renditions and streaming formats. The streaming format include HTTP Live
 * Streaming (HLS) and Dynamic Adaptive Streaming over HTTP (DASH). You can send
 * a source stream in the various ways, including Real-Time Messaging
 * Protocol (RTMP) and Secure Reliable Transport (SRT).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $livestreamServiceClient = new LivestreamServiceClient();
 * try {
 *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $asset = new Asset();
 *     $assetId = 'asset_id';
 *     $operationResponse = $livestreamServiceClient->createAsset($formattedParent, $asset, $assetId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $livestreamServiceClient->createAsset($formattedParent, $asset, $assetId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'createAsset');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $livestreamServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\Video\LiveStream\V1\Client\LivestreamServiceClient}.
 */
class LivestreamServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.video.livestream.v1.LivestreamService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'livestream.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'livestream.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $assetNameTemplate;

    private static $channelNameTemplate;

    private static $eventNameTemplate;

    private static $inputNameTemplate;

    private static $locationNameTemplate;

    private static $networkNameTemplate;

    private static $poolNameTemplate;

    private static $secretVersionNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/livestream_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/livestream_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/livestream_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/livestream_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAssetNameTemplate()
    {
        if (self::$assetNameTemplate == null) {
            self::$assetNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/assets/{asset}'
            );
        }

        return self::$assetNameTemplate;
    }

    private static function getChannelNameTemplate()
    {
        if (self::$channelNameTemplate == null) {
            self::$channelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/channels/{channel}'
            );
        }

        return self::$channelNameTemplate;
    }

    private static function getEventNameTemplate()
    {
        if (self::$eventNameTemplate == null) {
            self::$eventNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/channels/{channel}/events/{event}'
            );
        }

        return self::$eventNameTemplate;
    }

    private static function getInputNameTemplate()
    {
        if (self::$inputNameTemplate == null) {
            self::$inputNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/inputs/{input}'
            );
        }

        return self::$inputNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getPoolNameTemplate()
    {
        if (self::$poolNameTemplate == null) {
            self::$poolNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/pools/{pool}'
            );
        }

        return self::$poolNameTemplate;
    }

    private static function getSecretVersionNameTemplate()
    {
        if (self::$secretVersionNameTemplate == null) {
            self::$secretVersionNameTemplate = new PathTemplate(
                'projects/{project}/secrets/{secret}/versions/{version}'
            );
        }

        return self::$secretVersionNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'asset' => self::getAssetNameTemplate(),
                'channel' => self::getChannelNameTemplate(),
                'event' => self::getEventNameTemplate(),
                'input' => self::getInputNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'pool' => self::getPoolNameTemplate(),
                'secretVersion' => self::getSecretVersionNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a asset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $asset
     *
     * @return string The formatted asset resource.
     */
    public static function assetName($project, $location, $asset)
    {
        return self::getAssetNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a channel
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channel
     *
     * @return string The formatted channel resource.
     */
    public static function channelName($project, $location, $channel)
    {
        return self::getChannelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'channel' => $channel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a event
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channel
     * @param string $event
     *
     * @return string The formatted event resource.
     */
    public static function eventName($project, $location, $channel, $event)
    {
        return self::getEventNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'channel' => $channel,
            'event' => $event,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a input
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $input
     *
     * @return string The formatted input resource.
     */
    public static function inputName($project, $location, $input)
    {
        return self::getInputNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'input' => $input,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $pool
     *
     * @return string The formatted pool resource.
     */
    public static function poolName($project, $location, $pool)
    {
        return self::getPoolNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'pool' => $pool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $version
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName($project, $secret, $version)
    {
        return self::getSecretVersionNameTemplate()->render([
            'project' => $project,
            'secret' => $secret,
            'version' => $version,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - asset: projects/{project}/locations/{location}/assets/{asset}
     * - channel: projects/{project}/locations/{location}/channels/{channel}
     * - event: projects/{project}/locations/{location}/channels/{channel}/events/{event}
     * - input: projects/{project}/locations/{location}/inputs/{input}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - pool: projects/{project}/locations/{location}/pools/{pool}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'livestream.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a Asset with the provided unique ID in the specified
     * region.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $asset = new Asset();
     *     $assetId = 'asset_id';
     *     $operationResponse = $livestreamServiceClient->createAsset($formattedParent, $asset, $assetId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->createAsset($formattedParent, $asset, $assetId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'createAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location for the resource, in the form of:
     *                             `projects/{project}/locations/{location}`.
     * @param Asset  $asset        Required. The asset resource to be created.
     * @param string $assetId      Required. The ID of the asset resource to be created.
     *                             This value must be 1-63 characters, begin and end with `[a-z0-9]`,
     *                             could contain dashes (-) in between.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAsset(
        $parent,
        $asset,
        $assetId,
        array $optionalArgs = []
    ) {
        $request = new CreateAssetRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAsset($asset);
        $request->setAssetId($assetId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAsset',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a channel with the provided unique ID in the specified
     * region.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $channel = new Channel();
     *     $channelId = 'channel_id';
     *     $operationResponse = $livestreamServiceClient->createChannel($formattedParent, $channel, $channelId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->createChannel($formattedParent, $channel, $channelId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'createChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent location for the resource, in the form of:
     *                              `projects/{project}/locations/{location}`.
     * @param Channel $channel      Required. The channel resource to be created.
     * @param string  $channelId    Required. The ID of the channel resource to be created.
     *                              This value must be 1-63 characters, begin and end with `[a-z0-9]`,
     *                              could contain dashes (-) in between.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createChannel(
        $parent,
        $channel,
        $channelId,
        array $optionalArgs = []
    ) {
        $request = new CreateChannelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannel($channel);
        $request->setChannelId($channelId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates an event with the provided unique ID in the specified channel.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $event = new Event();
     *     $eventId = 'event_id';
     *     $response = $livestreamServiceClient->createEvent($formattedParent, $event, $eventId);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent channel for the resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}`.
     * @param Event  $event        Required. The event resource to be created.
     * @param string $eventId      Required. The ID of the event resource to be created.
     *                             This value must be 1-63 characters, begin and end with `[a-z0-9]`,
     *                             could contain dashes (-) in between.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\LiveStream\V1\Event
     *
     * @throws ApiException if the remote call fails
     */
    public function createEvent(
        $parent,
        $event,
        $eventId,
        array $optionalArgs = []
    ) {
        $request = new CreateEventRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEvent($event);
        $request->setEventId($eventId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateEvent',
            Event::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an input with the provided unique ID in the specified region.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $input = new Input();
     *     $inputId = 'input_id';
     *     $operationResponse = $livestreamServiceClient->createInput($formattedParent, $input, $inputId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->createInput($formattedParent, $input, $inputId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'createInput');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location for the resource, in the form of:
     *                             `projects/{project}/locations/{location}`.
     * @param Input  $input        Required. The input resource to be created.
     * @param string $inputId      Required. The ID of the input resource to be created.
     *                             This value must be 1-63 characters, begin and end with `[a-z0-9]`,
     *                             could contain dashes (-) in between.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createInput(
        $parent,
        $input,
        $inputId,
        array $optionalArgs = []
    ) {
        $request = new CreateInputRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setInput($input);
        $request->setInputId($inputId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateInput',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified asset if it is not used.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->assetName('[PROJECT]', '[LOCATION]', '[ASSET]');
     *     $operationResponse = $livestreamServiceClient->deleteAsset($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->deleteAsset($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'deleteAsset');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the asset resource, in the form of:
     *                             `projects/{project}/locations/{location}/assets/{assetId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAsset($name, array $optionalArgs = [])
    {
        $request = new DeleteAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAsset',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified channel.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $operationResponse = $livestreamServiceClient->deleteChannel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->deleteChannel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'deleteChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type bool $force
     *           If the `force` field is set to the default value of `false`, you must
     *           delete all of a channel's events before you can delete the channel itself.
     *           If the field is set to `true`, requests to delete a channel also delete
     *           associated channel events.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteChannel($name, array $optionalArgs = [])
    {
        $request = new DeleteChannelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified event.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->eventName('[PROJECT]', '[LOCATION]', '[CHANNEL]', '[EVENT]');
     *     $livestreamServiceClient->deleteEvent($formattedName);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the event resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEvent($name, array $optionalArgs = [])
    {
        $request = new DeleteEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteEvent',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes the specified input.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->inputName('[PROJECT]', '[LOCATION]', '[INPUT]');
     *     $operationResponse = $livestreamServiceClient->deleteInput($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->deleteInput($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'deleteInput');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the input resource, in the form of:
     *                             `projects/{project}/locations/{location}/inputs/{inputId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteInput($name, array $optionalArgs = [])
    {
        $request = new DeleteInputRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteInput',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Returns the specified asset.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->assetName('[PROJECT]', '[LOCATION]', '[ASSET]');
     *     $response = $livestreamServiceClient->getAsset($formattedName);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource, in the following form:
     *                             `projects/{project}/locations/{location}/assets/{asset}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\LiveStream\V1\Asset
     *
     * @throws ApiException if the remote call fails
     */
    public function getAsset($name, array $optionalArgs = [])
    {
        $request = new GetAssetRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAsset',
            Asset::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified channel.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $response = $livestreamServiceClient->getChannel($formattedName);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\LiveStream\V1\Channel
     *
     * @throws ApiException if the remote call fails
     */
    public function getChannel($name, array $optionalArgs = [])
    {
        $request = new GetChannelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetChannel',
            Channel::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified event.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->eventName('[PROJECT]', '[LOCATION]', '[CHANNEL]', '[EVENT]');
     *     $response = $livestreamServiceClient->getEvent($formattedName);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the event resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\LiveStream\V1\Event
     *
     * @throws ApiException if the remote call fails
     */
    public function getEvent($name, array $optionalArgs = [])
    {
        $request = new GetEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEvent',
            Event::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified input.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->inputName('[PROJECT]', '[LOCATION]', '[INPUT]');
     *     $response = $livestreamServiceClient->getInput($formattedName);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the input resource, in the form of:
     *                             `projects/{project}/locations/{location}/inputs/{inputId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\LiveStream\V1\Input
     *
     * @throws ApiException if the remote call fails
     */
    public function getInput($name, array $optionalArgs = [])
    {
        $request = new GetInputRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetInput',
            Input::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the specified pool.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->poolName('[PROJECT]', '[LOCATION]', '[POOL]');
     *     $response = $livestreamServiceClient->getPool($formattedName);
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the pool resource, in the form of:
     *                             `projects/{project}/locations/{location}/pools/{poolId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Video\LiveStream\V1\Pool
     *
     * @throws ApiException if the remote call fails
     */
    public function getPool($name, array $optionalArgs = [])
    {
        $request = new GetPoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetPool',
            Pool::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a list of all assets in the specified region.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $livestreamServiceClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $livestreamServiceClient->listAssets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location for the resource, in the form of:
     *                             `projects/{project}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filtering results
     *     @type string $orderBy
     *           Hint for how to order the results
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAssets($parent, array $optionalArgs = [])
    {
        $request = new ListAssetsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAssets',
            $optionalArgs,
            ListAssetsResponse::class,
            $request
        );
    }

    /**
     * Returns a list of all channels in the specified region.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $livestreamServiceClient->listChannels($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $livestreamServiceClient->listChannels($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location for the resource, in the form of:
     *                             `projects/{project}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter to apply to list results.
     *     @type string $orderBy
     *           Specifies the ordering of results following syntax at
     *           https://cloud.google.com/apis/design/design_patterns#sorting_order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listChannels($parent, array $optionalArgs = [])
    {
        $request = new ListChannelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListChannels',
            $optionalArgs,
            ListChannelsResponse::class,
            $request
        );
    }

    /**
     * Returns a list of all events in the specified channel.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $livestreamServiceClient->listEvents($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $livestreamServiceClient->listEvents($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent channel for the resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter to apply to list results.
     *     @type string $orderBy
     *           Specifies the ordering of results following syntax at
     *           https://cloud.google.com/apis/design/design_patterns#sorting_order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEvents($parent, array $optionalArgs = [])
    {
        $request = new ListEventsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEvents',
            $optionalArgs,
            ListEventsResponse::class,
            $request
        );
    }

    /**
     * Returns a list of all inputs in the specified region.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedParent = $livestreamServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $livestreamServiceClient->listInputs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $livestreamServiceClient->listInputs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location for the resource, in the form of:
     *                             `projects/{project}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter to apply to list results.
     *     @type string $orderBy
     *           Specifies the ordering of results following syntax at [Sorting
     *           Order](https://cloud.google.com/apis/design/design_patterns#sorting_order).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInputs($parent, array $optionalArgs = [])
    {
        $request = new ListInputsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListInputs',
            $optionalArgs,
            ListInputsResponse::class,
            $request
        );
    }

    /**
     * Starts the specified channel. Part of the video pipeline will be created
     * only when the StartChannel request is received by the server.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $operationResponse = $livestreamServiceClient->startChannel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->startChannel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'startChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startChannel($name, array $optionalArgs = [])
    {
        $request = new StartChannelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'StartChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Stops the specified channel. Part of the video pipeline will be released
     * when the StopChannel request is received by the server.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $formattedName = $livestreamServiceClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $operationResponse = $livestreamServiceClient->stopChannel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->stopChannel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'stopChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel resource, in the form of:
     *                             `projects/{project}/locations/{location}/channels/{channelId}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function stopChannel($name, array $optionalArgs = [])
    {
        $request = new StopChannelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'StopChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the specified channel.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $channel = new Channel();
     *     $operationResponse = $livestreamServiceClient->updateChannel($channel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->updateChannel($channel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'updateChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param Channel $channel      Required. The channel resource to be updated.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the Channel
     *           resource by the update. You can only update the following fields:
     *
     *           * [`inputAttachments`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#inputattachment)
     *           * [`inputConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#inputconfig)
     *           * [`output`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#output)
     *           * [`elementaryStreams`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#elementarystream)
     *           * [`muxStreams`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#muxstream)
     *           * [`manifests`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#manifest)
     *           * [`spriteSheets`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#spritesheet)
     *           * [`logConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#logconfig)
     *           * [`timecodeConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#timecodeconfig)
     *           * [`encryptions`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.channels#encryption)
     *
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask.
     *
     *           If the mask is not present, then each field from the list above is updated
     *           if the field appears in the request payload. To unset a field, add the
     *           field to the update mask and remove it from the request payload.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateChannel($channel, array $optionalArgs = [])
    {
        $request = new UpdateChannelRequest();
        $requestParamHeaders = [];
        $request->setChannel($channel);
        $requestParamHeaders['channel.name'] = $channel->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the specified input.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $input = new Input();
     *     $operationResponse = $livestreamServiceClient->updateInput($input);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->updateInput($input);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'updateInput');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param Input $input        Required. The input resource to be updated.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the Input
     *           resource by the update. You can only update the following fields:
     *
     *           * [`preprocessingConfig`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#PreprocessingConfig)
     *           * [`securityRules`](https://cloud.google.com/livestream/docs/reference/rest/v1/projects.locations.inputs#SecurityRule)
     *
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask.
     *
     *           If the mask is not present, then each field from the list above is updated
     *           if the field appears in the request payload. To unset a field, add the
     *           field to the update mask and remove it from the request payload.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateInput($input, array $optionalArgs = [])
    {
        $request = new UpdateInputRequest();
        $requestParamHeaders = [];
        $request->setInput($input);
        $requestParamHeaders['input.name'] = $input->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateInput',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the specified pool.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $pool = new Pool();
     *     $operationResponse = $livestreamServiceClient->updatePool($pool);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $livestreamServiceClient->updatePool($pool);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $livestreamServiceClient->resumeOperation($operationName, 'updatePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param Pool  $pool         Required. The pool resource to be updated.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the Pool
     *           resource by the update. You can only update the following fields:
     *
     *           * `networkConfig`
     *
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and the
     *           request times out. If you make the request again with the same request ID,
     *           the server can check if original operation with the same request ID was
     *           received, and if so, will ignore the second request. This prevents clients
     *           from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported `(00000000-0000-0000-0000-000000000000)`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updatePool($pool, array $optionalArgs = [])
    {
        $request = new UpdatePoolRequest();
        $requestParamHeaders = [];
        $request->setPool($pool);
        $requestParamHeaders['pool.name'] = $pool->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdatePool',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     $response = $livestreamServiceClient->getLocation();
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $livestreamServiceClient = new LivestreamServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $livestreamServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $livestreamServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $livestreamServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
