<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v2/cloud_speech.proto

namespace Google\Cloud\Speech\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for the
 * [StreamingRecognize][google.cloud.speech.v2.Speech.StreamingRecognize]
 * method. Multiple
 * [StreamingRecognizeRequest][google.cloud.speech.v2.StreamingRecognizeRequest]
 * messages are sent in one call.
 * If the [Recognizer][google.cloud.speech.v2.Recognizer] referenced by
 * [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer]
 * contains a fully specified request configuration then the stream may only
 * contain messages with only
 * [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
 * Otherwise the first message must contain a
 * [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer] and
 * a
 * [streaming_config][google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config]
 * message that together fully specify the request configuration and must not
 * contain [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio]. All
 * subsequent messages must only have
 * [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
 *
 * Generated from protobuf message <code>google.cloud.speech.v2.StreamingRecognizeRequest</code>
 */
class StreamingRecognizeRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *
     * Generated from protobuf field <code>string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $recognizer = '';
    protected $streaming_request;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $recognizer
     *           Required. The name of the Recognizer to use during recognition. The
     *           expected format is
     *           `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     *           {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *     @type \Google\Cloud\Speech\V2\StreamingRecognitionConfig $streaming_config
     *           StreamingRecognitionConfig to be used in this recognition attempt.
     *           If provided, it will override the default RecognitionConfig stored in the
     *           Recognizer.
     *     @type string $audio
     *           Inline audio bytes to be Recognized.
     *           Maximum size for this field is 15 KB per request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V2\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *
     * Generated from protobuf field <code>string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getRecognizer()
    {
        return $this->recognizer;
    }

    /**
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *
     * Generated from protobuf field <code>string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRecognizer($var)
    {
        GPBUtil::checkString($var, True);
        $this->recognizer = $var;

        return $this;
    }

    /**
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     * @return \Google\Cloud\Speech\V2\StreamingRecognitionConfig|null
     */
    public function getStreamingConfig()
    {
        return $this->readOneof(6);
    }

    public function hasStreamingConfig()
    {
        return $this->hasOneof(6);
    }

    /**
     * StreamingRecognitionConfig to be used in this recognition attempt.
     * If provided, it will override the default RecognitionConfig stored in the
     * Recognizer.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.StreamingRecognitionConfig streaming_config = 6;</code>
     * @param \Google\Cloud\Speech\V2\StreamingRecognitionConfig $var
     * @return $this
     */
    public function setStreamingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\StreamingRecognitionConfig::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Inline audio bytes to be Recognized.
     * Maximum size for this field is 15 KB per request.
     *
     * Generated from protobuf field <code>bytes audio = 5;</code>
     * @return string
     */
    public function getAudio()
    {
        return $this->readOneof(5);
    }

    public function hasAudio()
    {
        return $this->hasOneof(5);
    }

    /**
     * Inline audio bytes to be Recognized.
     * Maximum size for this field is 15 KB per request.
     *
     * Generated from protobuf field <code>bytes audio = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAudio($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getStreamingRequest()
    {
        return $this->whichOneof("streaming_request");
    }

}

