<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v2/cloud_speech.proto

namespace Google\Cloud\Speech\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for the
 * [Recognize][google.cloud.speech.v2.Speech.Recognize] method. Either
 * `content` or `uri` must be supplied. Supplying both or neither returns
 * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See [content
 * limits](https://cloud.google.com/speech-to-text/quotas#content).
 *
 * Generated from protobuf message <code>google.cloud.speech.v2.RecognizeRequest</code>
 */
class RecognizeRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *
     * Generated from protobuf field <code>string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $recognizer = '';
    /**
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     */
    private $config = null;
    /**
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask config_mask = 8;</code>
     */
    private $config_mask = null;
    protected $audio_source;

    /**
     * @param string                                    $recognizer Required. The name of the Recognizer to use during recognition. The
     *                                                              expected format is
     *                                                              `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     *                                                              {recognizer} segment may be set to `_` to use an empty implicit Recognizer. Please see
     *                                                              {@see SpeechClient::recognizerName()} for help formatting this field.
     * @param \Google\Cloud\Speech\V2\RecognitionConfig $config     Features and audio metadata to use for the Automatic Speech Recognition.
     *                                                              This field in combination with the
     *                                                              [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     *                                                              can be used to override parts of the
     *                                                              [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     *                                                              of the Recognizer resource.
     * @param \Google\Protobuf\FieldMask                $configMask The list of fields in
     *                                                              [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     *                                                              values in the
     *                                                              [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     *                                                              of the recognizer during this recognition request. If no mask is provided,
     *                                                              all non-default valued fields in
     *                                                              [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     *                                                              values in the recognizer for this recognition request. If a mask is
     *                                                              provided, only the fields listed in the mask override the config in the
     *                                                              recognizer for this recognition request. If a wildcard (`*`) is provided,
     *                                                              [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     *                                                              overrides and replaces the config in the recognizer for this recognition
     *                                                              request.
     * @param string                                    $content    The audio data bytes encoded as specified in
     *                                                              [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     *                                                              with all bytes fields, proto buffers use a pure binary representation,
     *                                                              whereas JSON representations use base64.
     *
     * @return \Google\Cloud\Speech\V2\RecognizeRequest
     *
     * @experimental
     */
    public static function build(string $recognizer, \Google\Cloud\Speech\V2\RecognitionConfig $config, \Google\Protobuf\FieldMask $configMask, string $content): self
    {
        return (new self())
            ->setRecognizer($recognizer)
            ->setConfig($config)
            ->setConfigMask($configMask)
            ->setContent($content);
    }

    /**
     * @param string                                    $recognizer Required. The name of the Recognizer to use during recognition. The
     *                                                              expected format is
     *                                                              `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     *                                                              {recognizer} segment may be set to `_` to use an empty implicit Recognizer. Please see
     *                                                              {@see SpeechClient::recognizerName()} for help formatting this field.
     * @param \Google\Cloud\Speech\V2\RecognitionConfig $config     Features and audio metadata to use for the Automatic Speech Recognition.
     *                                                              This field in combination with the
     *                                                              [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     *                                                              can be used to override parts of the
     *                                                              [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     *                                                              of the Recognizer resource.
     * @param \Google\Protobuf\FieldMask                $configMask The list of fields in
     *                                                              [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     *                                                              values in the
     *                                                              [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     *                                                              of the recognizer during this recognition request. If no mask is provided,
     *                                                              all non-default valued fields in
     *                                                              [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     *                                                              values in the recognizer for this recognition request. If a mask is
     *                                                              provided, only the fields listed in the mask override the config in the
     *                                                              recognizer for this recognition request. If a wildcard (`*`) is provided,
     *                                                              [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     *                                                              overrides and replaces the config in the recognizer for this recognition
     *                                                              request.
     * @param string                                    $uri        URI that points to a file that contains audio data bytes as specified in
     *                                                              [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     *                                                              must not be compressed (for example, gzip). Currently, only Google Cloud
     *                                                              Storage URIs are supported, which must be specified in the following
     *                                                              format: `gs://bucket_name/object_name` (other URI formats return
     *                                                              [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     *                                                              information, see [Request
     *                                                              URIs](https://cloud.google.com/storage/docs/reference-uris).
     *
     * @return \Google\Cloud\Speech\V2\RecognizeRequest
     *
     * @experimental
     */
    public static function buildFromRecognizerConfigConfigMaskUri(string $recognizer, \Google\Cloud\Speech\V2\RecognitionConfig $config, \Google\Protobuf\FieldMask $configMask, string $uri): self
    {
        return (new self())
            ->setRecognizer($recognizer)
            ->setConfig($config)
            ->setConfigMask($configMask)
            ->setUri($uri);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $recognizer
     *           Required. The name of the Recognizer to use during recognition. The
     *           expected format is
     *           `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     *           {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *     @type \Google\Cloud\Speech\V2\RecognitionConfig $config
     *           Features and audio metadata to use for the Automatic Speech Recognition.
     *           This field in combination with the
     *           [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     *           can be used to override parts of the
     *           [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     *           of the Recognizer resource.
     *     @type \Google\Protobuf\FieldMask $config_mask
     *           The list of fields in
     *           [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     *           values in the
     *           [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     *           of the recognizer during this recognition request. If no mask is provided,
     *           all non-default valued fields in
     *           [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     *           values in the recognizer for this recognition request. If a mask is
     *           provided, only the fields listed in the mask override the config in the
     *           recognizer for this recognition request. If a wildcard (`*`) is provided,
     *           [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     *           overrides and replaces the config in the recognizer for this recognition
     *           request.
     *     @type string $content
     *           The audio data bytes encoded as specified in
     *           [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     *           with all bytes fields, proto buffers use a pure binary representation,
     *           whereas JSON representations use base64.
     *     @type string $uri
     *           URI that points to a file that contains audio data bytes as specified in
     *           [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     *           must not be compressed (for example, gzip). Currently, only Google Cloud
     *           Storage URIs are supported, which must be specified in the following
     *           format: `gs://bucket_name/object_name` (other URI formats return
     *           [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     *           information, see [Request
     *           URIs](https://cloud.google.com/storage/docs/reference-uris).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V2\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *
     * Generated from protobuf field <code>string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getRecognizer()
    {
        return $this->recognizer;
    }

    /**
     * Required. The name of the Recognizer to use during recognition. The
     * expected format is
     * `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
     * {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
     *
     * Generated from protobuf field <code>string recognizer = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setRecognizer($var)
    {
        GPBUtil::checkString($var, True);
        $this->recognizer = $var;

        return $this;
    }

    /**
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     * @return \Google\Cloud\Speech\V2\RecognitionConfig|null
     */
    public function getConfig()
    {
        return $this->config;
    }

    public function hasConfig()
    {
        return isset($this->config);
    }

    public function clearConfig()
    {
        unset($this->config);
    }

    /**
     * Features and audio metadata to use for the Automatic Speech Recognition.
     * This field in combination with the
     * [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
     * can be used to override parts of the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the Recognizer resource.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.RecognitionConfig config = 1;</code>
     * @param \Google\Cloud\Speech\V2\RecognitionConfig $var
     * @return $this
     */
    public function setConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\RecognitionConfig::class);
        $this->config = $var;

        return $this;
    }

    /**
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask config_mask = 8;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getConfigMask()
    {
        return $this->config_mask;
    }

    public function hasConfigMask()
    {
        return isset($this->config_mask);
    }

    public function clearConfigMask()
    {
        unset($this->config_mask);
    }

    /**
     * The list of fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
     * values in the
     * [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
     * of the recognizer during this recognition request. If no mask is provided,
     * all non-default valued fields in
     * [config][google.cloud.speech.v2.RecognizeRequest.config] override the
     * values in the recognizer for this recognition request. If a mask is
     * provided, only the fields listed in the mask override the config in the
     * recognizer for this recognition request. If a wildcard (`*`) is provided,
     * [config][google.cloud.speech.v2.RecognizeRequest.config] completely
     * overrides and replaces the config in the recognizer for this recognition
     * request.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask config_mask = 8;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setConfigMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->config_mask = $var;

        return $this;
    }

    /**
     * The audio data bytes encoded as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     * with all bytes fields, proto buffers use a pure binary representation,
     * whereas JSON representations use base64.
     *
     * Generated from protobuf field <code>bytes content = 5;</code>
     * @return string
     */
    public function getContent()
    {
        return $this->readOneof(5);
    }

    public function hasContent()
    {
        return $this->hasOneof(5);
    }

    /**
     * The audio data bytes encoded as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
     * with all bytes fields, proto buffers use a pure binary representation,
     * whereas JSON representations use base64.
     *
     * Generated from protobuf field <code>bytes content = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setContent($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     *
     * Generated from protobuf field <code>string uri = 6;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->readOneof(6);
    }

    public function hasUri()
    {
        return $this->hasOneof(6);
    }

    /**
     * URI that points to a file that contains audio data bytes as specified in
     * [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
     * must not be compressed (for example, gzip). Currently, only Google Cloud
     * Storage URIs are supported, which must be specified in the following
     * format: `gs://bucket_name/object_name` (other URI formats return
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
     * information, see [Request
     * URIs](https://cloud.google.com/storage/docs/reference-uris).
     *
     * Generated from protobuf field <code>string uri = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getAudioSource()
    {
        return $this->whichOneof("audio_source");
    }

}

