<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/shopping/merchant/inventories/v1beta/localinventory.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Shopping\Merchant\Inventories\V1beta\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Protobuf\GPBEmpty;
use Google\Shopping\Merchant\Inventories\V1beta\DeleteLocalInventoryRequest;
use Google\Shopping\Merchant\Inventories\V1beta\InsertLocalInventoryRequest;
use Google\Shopping\Merchant\Inventories\V1beta\ListLocalInventoriesRequest;
use Google\Shopping\Merchant\Inventories\V1beta\ListLocalInventoriesResponse;
use Google\Shopping\Merchant\Inventories\V1beta\LocalInventory;

/**
 * Service Description: Service to manage local inventory for products
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $localInventoryServiceClient = new LocalInventoryServiceClient();
 * try {
 *     $formattedName = $localInventoryServiceClient->localInventoryName('[ACCOUNT]', '[PRODUCT]', '[STORE_CODE]');
 *     $localInventoryServiceClient->deleteLocalInventory($formattedName);
 * } finally {
 *     $localInventoryServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 */
class LocalInventoryServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.shopping.merchant.inventories.v1beta.LocalInventoryService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'merchantapi.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/content'];

    private static $localInventoryNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/local_inventory_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/local_inventory_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/local_inventory_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/local_inventory_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLocalInventoryNameTemplate()
    {
        if (self::$localInventoryNameTemplate == null) {
            self::$localInventoryNameTemplate = new PathTemplate(
                'accounts/{account}/products/{product}/localInventories/{store_code}'
            );
        }

        return self::$localInventoryNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'localInventory' => self::getLocalInventoryNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * local_inventory resource.
     *
     * @param string $account
     * @param string $product
     * @param string $storeCode
     *
     * @return string The formatted local_inventory resource.
     *
     * @experimental
     */
    public static function localInventoryName($account, $product, $storeCode)
    {
        return self::getLocalInventoryNameTemplate()->render([
            'account' => $account,
            'product' => $product,
            'store_code' => $storeCode,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - localInventory: accounts/{account}/products/{product}/localInventories/{store_code}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'merchantapi.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Deletes the specified `LocalInventory` from the given product in your
     * merchant account. It might take a up to an hour for the
     * `LocalInventory` to be deleted from the specific product.
     * Once you have received a successful delete response, wait for that
     * period before attempting a delete again.
     *
     * Sample code:
     * ```
     * $localInventoryServiceClient = new LocalInventoryServiceClient();
     * try {
     *     $formattedName = $localInventoryServiceClient->localInventoryName('[ACCOUNT]', '[PRODUCT]', '[STORE_CODE]');
     *     $localInventoryServiceClient->deleteLocalInventory($formattedName);
     * } finally {
     *     $localInventoryServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the local inventory for the given product to delete.
     *                             Format:
     *                             `accounts/{account}/products/{product}/localInventories/{store_code}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteLocalInventory($name, array $optionalArgs = [])
    {
        $request = new DeleteLocalInventoryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteLocalInventory',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Inserts a `LocalInventory` resource to a product in your merchant
     * account.
     *
     * Replaces the full `LocalInventory` resource if an entry with the same
     * [`storeCode`][google.shopping.merchant.inventories.v1beta.LocalInventory.store_code]
     * already exists for the product.
     *
     * It might take up to 30 minutes for the new or updated `LocalInventory`
     * resource to appear in products.
     *
     * Sample code:
     * ```
     * $localInventoryServiceClient = new LocalInventoryServiceClient();
     * try {
     *     $parent = 'parent';
     *     $localInventory = new LocalInventory();
     *     $response = $localInventoryServiceClient->insertLocalInventory($parent, $localInventory);
     * } finally {
     *     $localInventoryServiceClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The account and product where this inventory will be inserted.
     *                                       Format: `accounts/{account}/products/{product}`
     * @param LocalInventory $localInventory Required. Local inventory information of the product. If the product
     *                                       already has a `LocalInventory` resource for the same `storeCode`, full
     *                                       replacement of the `LocalInventory` resource is performed.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Shopping\Merchant\Inventories\V1beta\LocalInventory
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function insertLocalInventory(
        $parent,
        $localInventory,
        array $optionalArgs = []
    ) {
        $request = new InsertLocalInventoryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLocalInventory($localInventory);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'InsertLocalInventory',
            LocalInventory::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists the `LocalInventory` resources for the given product in your merchant
     * account. The response might contain fewer items than specified by
     * `pageSize`. If `pageToken` was returned in previous request, it can be used
     * to obtain additional results.
     *
     * `LocalInventory` resources are listed per product for a given account.
     *
     * Sample code:
     * ```
     * $localInventoryServiceClient = new LocalInventoryServiceClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $localInventoryServiceClient->listLocalInventories($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $localInventoryServiceClient->listLocalInventories($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $localInventoryServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The `name` of the parent product to list local inventories for.
     *                             Format:
     *                             `accounts/{account}/products/{product}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listLocalInventories($parent, array $optionalArgs = [])
    {
        $request = new ListLocalInventoriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocalInventories',
            $optionalArgs,
            ListLocalInventoriesResponse::class,
            $request
        );
    }
}
