<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securitycentermanagement/v1/security_center_management.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecurityCenterManagement\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\SecurityCenterManagement\V1\CreateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\CreateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\DeleteEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\DeleteSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\EffectiveEventThreatDetectionCustomModule;
use Google\Cloud\SecurityCenterManagement\V1\EffectiveSecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenterManagement\V1\EventThreatDetectionCustomModule;
use Google\Cloud\SecurityCenterManagement\V1\GetEffectiveEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\GetEffectiveSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\GetEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\GetSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\ListDescendantEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenterManagement\V1\ListDescendantSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenterManagement\V1\ListEffectiveEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenterManagement\V1\ListEffectiveSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenterManagement\V1\ListEventThreatDetectionCustomModulesRequest;
use Google\Cloud\SecurityCenterManagement\V1\ListSecurityHealthAnalyticsCustomModulesRequest;
use Google\Cloud\SecurityCenterManagement\V1\SecurityHealthAnalyticsCustomModule;
use Google\Cloud\SecurityCenterManagement\V1\SimulateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\SimulateSecurityHealthAnalyticsCustomModuleResponse;
use Google\Cloud\SecurityCenterManagement\V1\UpdateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\UpdateSecurityHealthAnalyticsCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\ValidateEventThreatDetectionCustomModuleRequest;
use Google\Cloud\SecurityCenterManagement\V1\ValidateEventThreatDetectionCustomModuleResponse;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service describing handlers for resources
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createEventThreatDetectionCustomModuleAsync(CreateEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSecurityHealthAnalyticsCustomModuleAsync(CreateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEventThreatDetectionCustomModuleAsync(DeleteEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSecurityHealthAnalyticsCustomModuleAsync(DeleteSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEffectiveEventThreatDetectionCustomModuleAsync(GetEffectiveEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEffectiveSecurityHealthAnalyticsCustomModuleAsync(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEventThreatDetectionCustomModuleAsync(GetEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSecurityHealthAnalyticsCustomModuleAsync(GetSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDescendantEventThreatDetectionCustomModulesAsync(ListDescendantEventThreatDetectionCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDescendantSecurityHealthAnalyticsCustomModulesAsync(ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEffectiveEventThreatDetectionCustomModulesAsync(ListEffectiveEventThreatDetectionCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEffectiveSecurityHealthAnalyticsCustomModulesAsync(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEventThreatDetectionCustomModulesAsync(ListEventThreatDetectionCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSecurityHealthAnalyticsCustomModulesAsync(ListSecurityHealthAnalyticsCustomModulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface simulateSecurityHealthAnalyticsCustomModuleAsync(SimulateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateEventThreatDetectionCustomModuleAsync(UpdateEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSecurityHealthAnalyticsCustomModuleAsync(UpdateSecurityHealthAnalyticsCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface validateEventThreatDetectionCustomModuleAsync(ValidateEventThreatDetectionCustomModuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class SecurityCenterManagementClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.securitycentermanagement.v1.SecurityCenterManagement';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'securitycentermanagement.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'securitycentermanagement.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/security_center_management_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/security_center_management_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/security_center_management_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/security_center_management_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $effectiveEventThreatDetectionCustomModule
     *
     * @return string The formatted effective_event_threat_detection_custom_module resource.
     */
    public static function effectiveEventThreatDetectionCustomModuleName(
        string $organization,
        string $location,
        string $effectiveEventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('effectiveEventThreatDetectionCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'effective_event_threat_detection_custom_module' => $effectiveEventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * effective_security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $effectiveSecurityHealthAnalyticsCustomModule
     *
     * @return string The formatted effective_security_health_analytics_custom_module resource.
     */
    public static function effectiveSecurityHealthAnalyticsCustomModuleName(
        string $organization,
        string $location,
        string $effectiveSecurityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('effectiveSecurityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'effective_security_health_analytics_custom_module' => $effectiveSecurityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $eventThreatDetectionCustomModule
     *
     * @return string The formatted event_threat_detection_custom_module resource.
     */
    public static function eventThreatDetectionCustomModuleName(
        string $organization,
        string $location,
        string $eventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('eventThreatDetectionCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'event_threat_detection_custom_module' => $eventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_effective_event_threat_detection_custom_module resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $effectiveEventThreatDetectionCustomModule
     *
     * @return string The formatted folder_location_effective_event_threat_detection_custom_module resource.
     */
    public static function folderLocationEffectiveEventThreatDetectionCustomModuleName(
        string $folder,
        string $location,
        string $effectiveEventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('folderLocationEffectiveEventThreatDetectionCustomModule')->render([
            'folder' => $folder,
            'location' => $location,
            'effective_event_threat_detection_custom_module' => $effectiveEventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_effective_security_health_analytics_custom_module resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $effectiveSecurityHealthAnalyticsCustomModule
     *
     * @return string The formatted folder_location_effective_security_health_analytics_custom_module resource.
     */
    public static function folderLocationEffectiveSecurityHealthAnalyticsCustomModuleName(
        string $folder,
        string $location,
        string $effectiveSecurityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('folderLocationEffectiveSecurityHealthAnalyticsCustomModule')->render([
            'folder' => $folder,
            'location' => $location,
            'effective_security_health_analytics_custom_module' => $effectiveSecurityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_event_threat_detection_custom_module resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $eventThreatDetectionCustomModule
     *
     * @return string The formatted folder_location_event_threat_detection_custom_module resource.
     */
    public static function folderLocationEventThreatDetectionCustomModuleName(
        string $folder,
        string $location,
        string $eventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('folderLocationEventThreatDetectionCustomModule')->render([
            'folder' => $folder,
            'location' => $location,
            'event_threat_detection_custom_module' => $eventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_security_health_analytics_custom_module resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $securityHealthAnalyticsCustomModule
     *
     * @return string The formatted folder_location_security_health_analytics_custom_module resource.
     */
    public static function folderLocationSecurityHealthAnalyticsCustomModuleName(
        string $folder,
        string $location,
        string $securityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('folderLocationSecurityHealthAnalyticsCustomModule')->render([
            'folder' => $folder,
            'location' => $location,
            'security_health_analytics_custom_module' => $securityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_effective_event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $effectiveEventThreatDetectionCustomModule
     *
     * @return string The formatted organization_location_effective_event_threat_detection_custom_module resource.
     */
    public static function organizationLocationEffectiveEventThreatDetectionCustomModuleName(
        string $organization,
        string $location,
        string $effectiveEventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('organizationLocationEffectiveEventThreatDetectionCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'effective_event_threat_detection_custom_module' => $effectiveEventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_effective_security_health_analytics_custom_module
     * resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $effectiveSecurityHealthAnalyticsCustomModule
     *
     * @return string The formatted organization_location_effective_security_health_analytics_custom_module resource.
     */
    public static function organizationLocationEffectiveSecurityHealthAnalyticsCustomModuleName(
        string $organization,
        string $location,
        string $effectiveSecurityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('organizationLocationEffectiveSecurityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'effective_security_health_analytics_custom_module' => $effectiveSecurityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_event_threat_detection_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $eventThreatDetectionCustomModule
     *
     * @return string The formatted organization_location_event_threat_detection_custom_module resource.
     */
    public static function organizationLocationEventThreatDetectionCustomModuleName(
        string $organization,
        string $location,
        string $eventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('organizationLocationEventThreatDetectionCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'event_threat_detection_custom_module' => $eventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $securityHealthAnalyticsCustomModule
     *
     * @return string The formatted organization_location_security_health_analytics_custom_module resource.
     */
    public static function organizationLocationSecurityHealthAnalyticsCustomModuleName(
        string $organization,
        string $location,
        string $securityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('organizationLocationSecurityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'security_health_analytics_custom_module' => $securityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_effective_event_threat_detection_custom_module resource.
     *
     * @param string $project
     * @param string $location
     * @param string $effectiveEventThreatDetectionCustomModule
     *
     * @return string The formatted project_location_effective_event_threat_detection_custom_module resource.
     */
    public static function projectLocationEffectiveEventThreatDetectionCustomModuleName(
        string $project,
        string $location,
        string $effectiveEventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('projectLocationEffectiveEventThreatDetectionCustomModule')->render([
            'project' => $project,
            'location' => $location,
            'effective_event_threat_detection_custom_module' => $effectiveEventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_effective_security_health_analytics_custom_module resource.
     *
     * @param string $project
     * @param string $location
     * @param string $effectiveSecurityHealthAnalyticsCustomModule
     *
     * @return string The formatted project_location_effective_security_health_analytics_custom_module resource.
     */
    public static function projectLocationEffectiveSecurityHealthAnalyticsCustomModuleName(
        string $project,
        string $location,
        string $effectiveSecurityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('projectLocationEffectiveSecurityHealthAnalyticsCustomModule')->render([
            'project' => $project,
            'location' => $location,
            'effective_security_health_analytics_custom_module' => $effectiveSecurityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_event_threat_detection_custom_module resource.
     *
     * @param string $project
     * @param string $location
     * @param string $eventThreatDetectionCustomModule
     *
     * @return string The formatted project_location_event_threat_detection_custom_module resource.
     */
    public static function projectLocationEventThreatDetectionCustomModuleName(
        string $project,
        string $location,
        string $eventThreatDetectionCustomModule
    ): string {
        return self::getPathTemplate('projectLocationEventThreatDetectionCustomModule')->render([
            'project' => $project,
            'location' => $location,
            'event_threat_detection_custom_module' => $eventThreatDetectionCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_security_health_analytics_custom_module resource.
     *
     * @param string $project
     * @param string $location
     * @param string $securityHealthAnalyticsCustomModule
     *
     * @return string The formatted project_location_security_health_analytics_custom_module resource.
     */
    public static function projectLocationSecurityHealthAnalyticsCustomModuleName(
        string $project,
        string $location,
        string $securityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('projectLocationSecurityHealthAnalyticsCustomModule')->render([
            'project' => $project,
            'location' => $location,
            'security_health_analytics_custom_module' => $securityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * security_health_analytics_custom_module resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $securityHealthAnalyticsCustomModule
     *
     * @return string The formatted security_health_analytics_custom_module resource.
     */
    public static function securityHealthAnalyticsCustomModuleName(
        string $organization,
        string $location,
        string $securityHealthAnalyticsCustomModule
    ): string {
        return self::getPathTemplate('securityHealthAnalyticsCustomModule')->render([
            'organization' => $organization,
            'location' => $location,
            'security_health_analytics_custom_module' => $securityHealthAnalyticsCustomModule,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - effectiveEventThreatDetectionCustomModule: organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}
     * - effectiveSecurityHealthAnalyticsCustomModule: organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}
     * - eventThreatDetectionCustomModule: organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationEffectiveEventThreatDetectionCustomModule: folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}
     * - folderLocationEffectiveSecurityHealthAnalyticsCustomModule: folders/{folder}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}
     * - folderLocationEventThreatDetectionCustomModule: folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}
     * - folderLocationSecurityHealthAnalyticsCustomModule: folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}
     * - location: projects/{project}/locations/{location}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationEffectiveEventThreatDetectionCustomModule: organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}
     * - organizationLocationEffectiveSecurityHealthAnalyticsCustomModule: organizations/{organization}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}
     * - organizationLocationEventThreatDetectionCustomModule: organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}
     * - organizationLocationSecurityHealthAnalyticsCustomModule: organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}
     * - projectLocationEffectiveEventThreatDetectionCustomModule: projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}
     * - projectLocationEffectiveSecurityHealthAnalyticsCustomModule: projects/{project}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}
     * - projectLocationEventThreatDetectionCustomModule: projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}
     * - projectLocationSecurityHealthAnalyticsCustomModule: projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}
     * - securityHealthAnalyticsCustomModule: organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securitycentermanagement.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a resident Event Threat Detection custom module at the scope of the
     * given Resource Manager parent, and also creates inherited custom modules
     * for all descendants of the given parent. These modules are enabled by
     * default.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::createEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/create_event_threat_detection_custom_module.php
     *
     * @param CreateEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEventThreatDetectionCustomModule(
        CreateEventThreatDetectionCustomModuleRequest $request,
        array $callOptions = []
    ): EventThreatDetectionCustomModule {
        return $this->startApiCall('CreateEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
     * given CRM parent, and also creates inherited
     * SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
     * parent. These modules are enabled by default.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::createSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/create_security_health_analytics_custom_module.php
     *
     * @param CreateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSecurityHealthAnalyticsCustomModule(
        CreateSecurityHealthAnalyticsCustomModuleRequest $request,
        array $callOptions = []
    ): SecurityHealthAnalyticsCustomModule {
        return $this->startApiCall('CreateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified Event Threat Detection custom module and all of its
     * descendants in the Resource Manager hierarchy. This method is only
     * supported for resident custom modules.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::deleteEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/delete_event_threat_detection_custom_module.php
     *
     * @param DeleteEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEventThreatDetectionCustomModule(
        DeleteEventThreatDetectionCustomModuleRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
     * descendants in the CRM hierarchy. This method is only supported for
     * resident custom modules.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::deleteSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/delete_security_health_analytics_custom_module.php
     *
     * @param DeleteSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSecurityHealthAnalyticsCustomModule(
        DeleteSecurityHealthAnalyticsCustomModuleRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets an effective ETD custom module. Retrieves the effective module at the
     * given level. The difference between an EffectiveCustomModule and a
     * CustomModule is that the fields for an EffectiveCustomModule are computed
     * from ancestors if needed. For example, the enablement_state for a
     * CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
     * enablement_state for an EffectiveCustomModule is always computed to ENABLED
     * or DISABLED (the effective enablement_state).
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::getEffectiveEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/get_effective_event_threat_detection_custom_module.php
     *
     * @param GetEffectiveEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EffectiveEventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEffectiveEventThreatDetectionCustomModule(
        GetEffectiveEventThreatDetectionCustomModuleRequest $request,
        array $callOptions = []
    ): EffectiveEventThreatDetectionCustomModule {
        return $this->startApiCall('GetEffectiveEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::getEffectiveSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/get_effective_security_health_analytics_custom_module.php
     *
     * @param GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EffectiveSecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEffectiveSecurityHealthAnalyticsCustomModule(
        GetEffectiveSecurityHealthAnalyticsCustomModuleRequest $request,
        array $callOptions = []
    ): EffectiveSecurityHealthAnalyticsCustomModule {
        return $this->startApiCall('GetEffectiveSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets an Event Threat Detection custom module.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::getEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/get_event_threat_detection_custom_module.php
     *
     * @param GetEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEventThreatDetectionCustomModule(
        GetEventThreatDetectionCustomModuleRequest $request,
        array $callOptions = []
    ): EventThreatDetectionCustomModule {
        return $this->startApiCall('GetEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a SecurityHealthAnalyticsCustomModule.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::getSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/get_security_health_analytics_custom_module.php
     *
     * @param GetSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSecurityHealthAnalyticsCustomModule(
        GetSecurityHealthAnalyticsCustomModuleRequest $request,
        array $callOptions = []
    ): SecurityHealthAnalyticsCustomModule {
        return $this->startApiCall('GetSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Lists all resident Event Threat Detection custom modules under the
     * given Resource Manager parent and its descendants.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::listDescendantEventThreatDetectionCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_descendant_event_threat_detection_custom_modules.php
     *
     * @param ListDescendantEventThreatDetectionCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDescendantEventThreatDetectionCustomModules(
        ListDescendantEventThreatDetectionCustomModulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDescendantEventThreatDetectionCustomModules', $request, $callOptions);
    }

    /**
     * Returns a list of all resident SecurityHealthAnalyticsCustomModules under
     * the given CRM parent and all of the parent’s CRM descendants.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::listDescendantSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_descendant_security_health_analytics_custom_modules.php
     *
     * @param ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDescendantSecurityHealthAnalyticsCustomModules(
        ListDescendantSecurityHealthAnalyticsCustomModulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDescendantSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists all effective Event Threat Detection custom modules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent along with modules inherited from its ancestors.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::listEffectiveEventThreatDetectionCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_effective_event_threat_detection_custom_modules.php
     *
     * @param ListEffectiveEventThreatDetectionCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEffectiveEventThreatDetectionCustomModules(
        ListEffectiveEventThreatDetectionCustomModulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListEffectiveEventThreatDetectionCustomModules', $request, $callOptions);
    }

    /**
     * Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
     * given parent. This includes resident modules defined at the scope of the
     * parent, and inherited modules, inherited from CRM ancestors (no
     * descendants).
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::listEffectiveSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_effective_security_health_analytics_custom_modules.php
     *
     * @param ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEffectiveSecurityHealthAnalyticsCustomModules(
        ListEffectiveSecurityHealthAnalyticsCustomModulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListEffectiveSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Lists all Event Threat Detection custom modules for the given
     * Resource Manager parent. This includes resident modules defined at the
     * scope of the parent along with modules inherited from ancestors.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::listEventThreatDetectionCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_event_threat_detection_custom_modules.php
     *
     * @param ListEventThreatDetectionCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEventThreatDetectionCustomModules(
        ListEventThreatDetectionCustomModulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListEventThreatDetectionCustomModules', $request, $callOptions);
    }

    /**
     * Returns a list of all SecurityHealthAnalyticsCustomModules for the given
     * parent. This includes resident modules defined at the scope of the parent,
     * and inherited modules, inherited from CRM ancestors (no descendants).
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::listSecurityHealthAnalyticsCustomModulesAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_security_health_analytics_custom_modules.php
     *
     * @param ListSecurityHealthAnalyticsCustomModulesRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSecurityHealthAnalyticsCustomModules(
        ListSecurityHealthAnalyticsCustomModulesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListSecurityHealthAnalyticsCustomModules', $request, $callOptions);
    }

    /**
     * Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::simulateSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/simulate_security_health_analytics_custom_module.php
     *
     * @param SimulateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SimulateSecurityHealthAnalyticsCustomModuleResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function simulateSecurityHealthAnalyticsCustomModule(
        SimulateSecurityHealthAnalyticsCustomModuleRequest $request,
        array $callOptions = []
    ): SimulateSecurityHealthAnalyticsCustomModuleResponse {
        return $this->startApiCall('SimulateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Updates the Event Threat Detection custom module with the given name based
     * on the given update mask. Updating the enablement state is supported for
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name or
     * configuration of a module is supported for resident modules only. The type
     * of a module cannot be changed.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::updateEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/update_event_threat_detection_custom_module.php
     *
     * @param UpdateEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventThreatDetectionCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEventThreatDetectionCustomModule(
        UpdateEventThreatDetectionCustomModuleRequest $request,
        array $callOptions = []
    ): EventThreatDetectionCustomModule {
        return $this->startApiCall('UpdateEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Updates the SecurityHealthAnalyticsCustomModule under the given name based
     * on the given update mask. Updating the enablement state is supported on
     * both resident and inherited modules (though resident modules cannot have an
     * enablement state of "inherited"). Updating the display name and custom
     * config of a module is supported on resident modules only.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::updateSecurityHealthAnalyticsCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/update_security_health_analytics_custom_module.php
     *
     * @param UpdateSecurityHealthAnalyticsCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SecurityHealthAnalyticsCustomModule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSecurityHealthAnalyticsCustomModule(
        UpdateSecurityHealthAnalyticsCustomModuleRequest $request,
        array $callOptions = []
    ): SecurityHealthAnalyticsCustomModule {
        return $this->startApiCall('UpdateSecurityHealthAnalyticsCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Validates the given Event Threat Detection custom module.
     *
     * The async variant is
     * {@see SecurityCenterManagementClient::validateEventThreatDetectionCustomModuleAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/validate_event_threat_detection_custom_module.php
     *
     * @param ValidateEventThreatDetectionCustomModuleRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ValidateEventThreatDetectionCustomModuleResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function validateEventThreatDetectionCustomModule(
        ValidateEventThreatDetectionCustomModuleRequest $request,
        array $callOptions = []
    ): ValidateEventThreatDetectionCustomModuleResponse {
        return $this->startApiCall('ValidateEventThreatDetectionCustomModule', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see SecurityCenterManagementClient::getLocationAsync()} .
     *
     * @example samples/V1/SecurityCenterManagementClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see SecurityCenterManagementClient::listLocationsAsync()}
     * .
     *
     * @example samples/V1/SecurityCenterManagementClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
