<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/netapp/v1/active_directory.proto

namespace Google\Cloud\NetApp\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ActiveDirectory is the public representation of the active directory config.
 *
 * Generated from protobuf message <code>google.cloud.netapp.v1.ActiveDirectory</code>
 */
class ActiveDirectory extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the active directory.
     * Format:
     * `projects/{project_number}/locations/{location_id}/activeDirectories/{active_directory_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. Create time of the active directory.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The state of the AD.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.ActiveDirectory.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Required. Name of the Active Directory domain
     *
     * Generated from protobuf field <code>string domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $domain = '';
    /**
     * The Active Directory site the service will limit Domain Controller
     * discovery too.
     *
     * Generated from protobuf field <code>string site = 5;</code>
     */
    protected $site = '';
    /**
     * Required. Comma separated list of DNS server IP addresses for the Active
     * Directory domain.
     *
     * Generated from protobuf field <code>string dns = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $dns = '';
    /**
     * Required. NetBIOSPrefix is used as a prefix for SMB server name.
     *
     * Generated from protobuf field <code>string net_bios_prefix = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $net_bios_prefix = '';
    /**
     * The Organizational Unit (OU) within the Windows Active Directory the user
     * belongs to.
     *
     * Generated from protobuf field <code>string organizational_unit = 8;</code>
     */
    protected $organizational_unit = '';
    /**
     * If enabled, AES encryption will be enabled for SMB communication.
     *
     * Generated from protobuf field <code>bool aes_encryption = 9;</code>
     */
    protected $aes_encryption = false;
    /**
     * Required. Username of the Active Directory domain administrator.
     *
     * Generated from protobuf field <code>string username = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $username = '';
    /**
     * Required. Password of the Active Directory domain administrator.
     *
     * Generated from protobuf field <code>string password = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $password = '';
    /**
     * Users to be added to the Built-in Backup Operator active directory group.
     *
     * Generated from protobuf field <code>repeated string backup_operators = 12;</code>
     */
    private $backup_operators;
    /**
     * Domain users to be given the SeSecurityPrivilege.
     *
     * Generated from protobuf field <code>repeated string security_operators = 13;</code>
     */
    private $security_operators;
    /**
     * Name of the active directory machine. This optional parameter is used only
     * while creating kerberos volume
     *
     * Generated from protobuf field <code>string kdc_hostname = 14;</code>
     */
    protected $kdc_hostname = '';
    /**
     * KDC server IP address for the active directory machine.
     *
     * Generated from protobuf field <code>string kdc_ip = 15;</code>
     */
    protected $kdc_ip = '';
    /**
     * If enabled, will allow access to local users and LDAP users. If access is
     * needed for only LDAP users, it has to be disabled.
     *
     * Generated from protobuf field <code>bool nfs_users_with_ldap = 16;</code>
     */
    protected $nfs_users_with_ldap = false;
    /**
     * Description of the active directory.
     *
     * Generated from protobuf field <code>string description = 17;</code>
     */
    protected $description = '';
    /**
     * Specifies whether or not the LDAP traffic needs to be signed.
     *
     * Generated from protobuf field <code>bool ldap_signing = 18;</code>
     */
    protected $ldap_signing = false;
    /**
     * If enabled, traffic between the SMB server to Domain Controller (DC) will
     * be encrypted.
     *
     * Generated from protobuf field <code>bool encrypt_dc_connections = 19;</code>
     */
    protected $encrypt_dc_connections = false;
    /**
     * Labels for the active directory.
     *
     * Generated from protobuf field <code>map<string, string> labels = 20;</code>
     */
    private $labels;
    /**
     * Output only. The state details of the Active Directory.
     *
     * Generated from protobuf field <code>string state_details = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state_details = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the active directory.
     *           Format:
     *           `projects/{project_number}/locations/{location_id}/activeDirectories/{active_directory_id}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Create time of the active directory.
     *     @type int $state
     *           Output only. The state of the AD.
     *     @type string $domain
     *           Required. Name of the Active Directory domain
     *     @type string $site
     *           The Active Directory site the service will limit Domain Controller
     *           discovery too.
     *     @type string $dns
     *           Required. Comma separated list of DNS server IP addresses for the Active
     *           Directory domain.
     *     @type string $net_bios_prefix
     *           Required. NetBIOSPrefix is used as a prefix for SMB server name.
     *     @type string $organizational_unit
     *           The Organizational Unit (OU) within the Windows Active Directory the user
     *           belongs to.
     *     @type bool $aes_encryption
     *           If enabled, AES encryption will be enabled for SMB communication.
     *     @type string $username
     *           Required. Username of the Active Directory domain administrator.
     *     @type string $password
     *           Required. Password of the Active Directory domain administrator.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $backup_operators
     *           Users to be added to the Built-in Backup Operator active directory group.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $security_operators
     *           Domain users to be given the SeSecurityPrivilege.
     *     @type string $kdc_hostname
     *           Name of the active directory machine. This optional parameter is used only
     *           while creating kerberos volume
     *     @type string $kdc_ip
     *           KDC server IP address for the active directory machine.
     *     @type bool $nfs_users_with_ldap
     *           If enabled, will allow access to local users and LDAP users. If access is
     *           needed for only LDAP users, it has to be disabled.
     *     @type string $description
     *           Description of the active directory.
     *     @type bool $ldap_signing
     *           Specifies whether or not the LDAP traffic needs to be signed.
     *     @type bool $encrypt_dc_connections
     *           If enabled, traffic between the SMB server to Domain Controller (DC) will
     *           be encrypted.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels for the active directory.
     *     @type string $state_details
     *           Output only. The state details of the Active Directory.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Netapp\V1\ActiveDirectory::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the active directory.
     * Format:
     * `projects/{project_number}/locations/{location_id}/activeDirectories/{active_directory_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the active directory.
     * Format:
     * `projects/{project_number}/locations/{location_id}/activeDirectories/{active_directory_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Create time of the active directory.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Create time of the active directory.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The state of the AD.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.ActiveDirectory.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the AD.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.ActiveDirectory.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\ActiveDirectory\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Required. Name of the Active Directory domain
     *
     * Generated from protobuf field <code>string domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * Required. Name of the Active Directory domain
     *
     * Generated from protobuf field <code>string domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDomain($var)
    {
        GPBUtil::checkString($var, True);
        $this->domain = $var;

        return $this;
    }

    /**
     * The Active Directory site the service will limit Domain Controller
     * discovery too.
     *
     * Generated from protobuf field <code>string site = 5;</code>
     * @return string
     */
    public function getSite()
    {
        return $this->site;
    }

    /**
     * The Active Directory site the service will limit Domain Controller
     * discovery too.
     *
     * Generated from protobuf field <code>string site = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setSite($var)
    {
        GPBUtil::checkString($var, True);
        $this->site = $var;

        return $this;
    }

    /**
     * Required. Comma separated list of DNS server IP addresses for the Active
     * Directory domain.
     *
     * Generated from protobuf field <code>string dns = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDns()
    {
        return $this->dns;
    }

    /**
     * Required. Comma separated list of DNS server IP addresses for the Active
     * Directory domain.
     *
     * Generated from protobuf field <code>string dns = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDns($var)
    {
        GPBUtil::checkString($var, True);
        $this->dns = $var;

        return $this;
    }

    /**
     * Required. NetBIOSPrefix is used as a prefix for SMB server name.
     *
     * Generated from protobuf field <code>string net_bios_prefix = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getNetBiosPrefix()
    {
        return $this->net_bios_prefix;
    }

    /**
     * Required. NetBIOSPrefix is used as a prefix for SMB server name.
     *
     * Generated from protobuf field <code>string net_bios_prefix = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setNetBiosPrefix($var)
    {
        GPBUtil::checkString($var, True);
        $this->net_bios_prefix = $var;

        return $this;
    }

    /**
     * The Organizational Unit (OU) within the Windows Active Directory the user
     * belongs to.
     *
     * Generated from protobuf field <code>string organizational_unit = 8;</code>
     * @return string
     */
    public function getOrganizationalUnit()
    {
        return $this->organizational_unit;
    }

    /**
     * The Organizational Unit (OU) within the Windows Active Directory the user
     * belongs to.
     *
     * Generated from protobuf field <code>string organizational_unit = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setOrganizationalUnit($var)
    {
        GPBUtil::checkString($var, True);
        $this->organizational_unit = $var;

        return $this;
    }

    /**
     * If enabled, AES encryption will be enabled for SMB communication.
     *
     * Generated from protobuf field <code>bool aes_encryption = 9;</code>
     * @return bool
     */
    public function getAesEncryption()
    {
        return $this->aes_encryption;
    }

    /**
     * If enabled, AES encryption will be enabled for SMB communication.
     *
     * Generated from protobuf field <code>bool aes_encryption = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setAesEncryption($var)
    {
        GPBUtil::checkBool($var);
        $this->aes_encryption = $var;

        return $this;
    }

    /**
     * Required. Username of the Active Directory domain administrator.
     *
     * Generated from protobuf field <code>string username = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Required. Username of the Active Directory domain administrator.
     *
     * Generated from protobuf field <code>string username = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setUsername($var)
    {
        GPBUtil::checkString($var, True);
        $this->username = $var;

        return $this;
    }

    /**
     * Required. Password of the Active Directory domain administrator.
     *
     * Generated from protobuf field <code>string password = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Required. Password of the Active Directory domain administrator.
     *
     * Generated from protobuf field <code>string password = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->password = $var;

        return $this;
    }

    /**
     * Users to be added to the Built-in Backup Operator active directory group.
     *
     * Generated from protobuf field <code>repeated string backup_operators = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBackupOperators()
    {
        return $this->backup_operators;
    }

    /**
     * Users to be added to the Built-in Backup Operator active directory group.
     *
     * Generated from protobuf field <code>repeated string backup_operators = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBackupOperators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->backup_operators = $arr;

        return $this;
    }

    /**
     * Domain users to be given the SeSecurityPrivilege.
     *
     * Generated from protobuf field <code>repeated string security_operators = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSecurityOperators()
    {
        return $this->security_operators;
    }

    /**
     * Domain users to be given the SeSecurityPrivilege.
     *
     * Generated from protobuf field <code>repeated string security_operators = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSecurityOperators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->security_operators = $arr;

        return $this;
    }

    /**
     * Name of the active directory machine. This optional parameter is used only
     * while creating kerberos volume
     *
     * Generated from protobuf field <code>string kdc_hostname = 14;</code>
     * @return string
     */
    public function getKdcHostname()
    {
        return $this->kdc_hostname;
    }

    /**
     * Name of the active directory machine. This optional parameter is used only
     * while creating kerberos volume
     *
     * Generated from protobuf field <code>string kdc_hostname = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setKdcHostname($var)
    {
        GPBUtil::checkString($var, True);
        $this->kdc_hostname = $var;

        return $this;
    }

    /**
     * KDC server IP address for the active directory machine.
     *
     * Generated from protobuf field <code>string kdc_ip = 15;</code>
     * @return string
     */
    public function getKdcIp()
    {
        return $this->kdc_ip;
    }

    /**
     * KDC server IP address for the active directory machine.
     *
     * Generated from protobuf field <code>string kdc_ip = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setKdcIp($var)
    {
        GPBUtil::checkString($var, True);
        $this->kdc_ip = $var;

        return $this;
    }

    /**
     * If enabled, will allow access to local users and LDAP users. If access is
     * needed for only LDAP users, it has to be disabled.
     *
     * Generated from protobuf field <code>bool nfs_users_with_ldap = 16;</code>
     * @return bool
     */
    public function getNfsUsersWithLdap()
    {
        return $this->nfs_users_with_ldap;
    }

    /**
     * If enabled, will allow access to local users and LDAP users. If access is
     * needed for only LDAP users, it has to be disabled.
     *
     * Generated from protobuf field <code>bool nfs_users_with_ldap = 16;</code>
     * @param bool $var
     * @return $this
     */
    public function setNfsUsersWithLdap($var)
    {
        GPBUtil::checkBool($var);
        $this->nfs_users_with_ldap = $var;

        return $this;
    }

    /**
     * Description of the active directory.
     *
     * Generated from protobuf field <code>string description = 17;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Description of the active directory.
     *
     * Generated from protobuf field <code>string description = 17;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Specifies whether or not the LDAP traffic needs to be signed.
     *
     * Generated from protobuf field <code>bool ldap_signing = 18;</code>
     * @return bool
     */
    public function getLdapSigning()
    {
        return $this->ldap_signing;
    }

    /**
     * Specifies whether or not the LDAP traffic needs to be signed.
     *
     * Generated from protobuf field <code>bool ldap_signing = 18;</code>
     * @param bool $var
     * @return $this
     */
    public function setLdapSigning($var)
    {
        GPBUtil::checkBool($var);
        $this->ldap_signing = $var;

        return $this;
    }

    /**
     * If enabled, traffic between the SMB server to Domain Controller (DC) will
     * be encrypted.
     *
     * Generated from protobuf field <code>bool encrypt_dc_connections = 19;</code>
     * @return bool
     */
    public function getEncryptDcConnections()
    {
        return $this->encrypt_dc_connections;
    }

    /**
     * If enabled, traffic between the SMB server to Domain Controller (DC) will
     * be encrypted.
     *
     * Generated from protobuf field <code>bool encrypt_dc_connections = 19;</code>
     * @param bool $var
     * @return $this
     */
    public function setEncryptDcConnections($var)
    {
        GPBUtil::checkBool($var);
        $this->encrypt_dc_connections = $var;

        return $this;
    }

    /**
     * Labels for the active directory.
     *
     * Generated from protobuf field <code>map<string, string> labels = 20;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels for the active directory.
     *
     * Generated from protobuf field <code>map<string, string> labels = 20;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The state details of the Active Directory.
     *
     * Generated from protobuf field <code>string state_details = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStateDetails()
    {
        return $this->state_details;
    }

    /**
     * Output only. The state details of the Active Directory.
     *
     * Generated from protobuf field <code>string state_details = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStateDetails($var)
    {
        GPBUtil::checkString($var, True);
        $this->state_details = $var;

        return $this;
    }

}

