<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gaming/v1/game_server_clusters_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Gaming\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Gaming\V1\CreateGameServerClusterRequest;
use Google\Cloud\Gaming\V1\DeleteGameServerClusterRequest;
use Google\Cloud\Gaming\V1\GameServerCluster;
use Google\Cloud\Gaming\V1\GetGameServerClusterRequest;
use Google\Cloud\Gaming\V1\ListGameServerClustersRequest;
use Google\Cloud\Gaming\V1\PreviewCreateGameServerClusterRequest;
use Google\Cloud\Gaming\V1\PreviewCreateGameServerClusterResponse;
use Google\Cloud\Gaming\V1\PreviewDeleteGameServerClusterRequest;
use Google\Cloud\Gaming\V1\PreviewDeleteGameServerClusterResponse;
use Google\Cloud\Gaming\V1\PreviewUpdateGameServerClusterRequest;
use Google\Cloud\Gaming\V1\PreviewUpdateGameServerClusterResponse;
use Google\Cloud\Gaming\V1\UpdateGameServerClusterRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The game server cluster maps to Kubernetes clusters running Agones and is
 * used to manage fleets within clusters.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\Gaming\V1\GameServerClustersServiceClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface createGameServerClusterAsync(CreateGameServerClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGameServerClusterAsync(DeleteGameServerClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGameServerClusterAsync(GetGameServerClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGameServerClustersAsync(ListGameServerClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface previewCreateGameServerClusterAsync(PreviewCreateGameServerClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface previewDeleteGameServerClusterAsync(PreviewDeleteGameServerClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface previewUpdateGameServerClusterAsync(PreviewUpdateGameServerClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGameServerClusterAsync(UpdateGameServerClusterRequest $request, array $optionalArgs = [])
 */
abstract class GameServerClustersServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.gaming.v1.GameServerClustersService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'gameservices.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/game_server_clusters_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/game_server_clusters_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/game_server_clusters_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/game_server_clusters_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * game_server_cluster resource.
     *
     * @param string $project
     * @param string $location
     * @param string $realm
     * @param string $cluster
     *
     * @return string The formatted game_server_cluster resource.
     */
    public static function gameServerClusterName(string $project, string $location, string $realm, string $cluster): string
    {
        return self::getPathTemplate('gameServerCluster')->render([
            'project' => $project,
            'location' => $location,
            'realm' => $realm,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a realm
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $realm
     *
     * @return string The formatted realm resource.
     */
    public static function realmName(string $project, string $location, string $realm): string
    {
        return self::getPathTemplate('realm')->render([
            'project' => $project,
            'location' => $location,
            'realm' => $realm,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - gameServerCluster: projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}
     * - realm: projects/{project}/locations/{location}/realms/{realm}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gameservices.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new game server cluster in a given project and location.
     *
     * The async variant is {@see self::createGameServerClusterAsync()} .
     *
     * @param CreateGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGameServerCluster(CreateGameServerClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGameServerCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single game server cluster.
     *
     * The async variant is {@see self::deleteGameServerClusterAsync()} .
     *
     * @param DeleteGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGameServerCluster(DeleteGameServerClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGameServerCluster', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single game server cluster.
     *
     * The async variant is {@see self::getGameServerClusterAsync()} .
     *
     * @param GetGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GameServerCluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGameServerCluster(GetGameServerClusterRequest $request, array $callOptions = []): GameServerCluster
    {
        return $this->startApiCall('GetGameServerCluster', $request, $callOptions)->wait();
    }

    /**
     * Lists game server clusters in a given project and location.
     *
     * The async variant is {@see self::listGameServerClustersAsync()} .
     *
     * @param ListGameServerClustersRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGameServerClusters(ListGameServerClustersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGameServerClusters', $request, $callOptions);
    }

    /**
     * Previews creation of a new game server cluster in a given project and
     * location.
     *
     * The async variant is {@see self::previewCreateGameServerClusterAsync()} .
     *
     * @param PreviewCreateGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PreviewCreateGameServerClusterResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function previewCreateGameServerCluster(PreviewCreateGameServerClusterRequest $request, array $callOptions = []): PreviewCreateGameServerClusterResponse
    {
        return $this->startApiCall('PreviewCreateGameServerCluster', $request, $callOptions)->wait();
    }

    /**
     * Previews deletion of a single game server cluster.
     *
     * The async variant is {@see self::previewDeleteGameServerClusterAsync()} .
     *
     * @param PreviewDeleteGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PreviewDeleteGameServerClusterResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function previewDeleteGameServerCluster(PreviewDeleteGameServerClusterRequest $request, array $callOptions = []): PreviewDeleteGameServerClusterResponse
    {
        return $this->startApiCall('PreviewDeleteGameServerCluster', $request, $callOptions)->wait();
    }

    /**
     * Previews updating a GameServerCluster.
     *
     * The async variant is {@see self::previewUpdateGameServerClusterAsync()} .
     *
     * @param PreviewUpdateGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PreviewUpdateGameServerClusterResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function previewUpdateGameServerCluster(PreviewUpdateGameServerClusterRequest $request, array $callOptions = []): PreviewUpdateGameServerClusterResponse
    {
        return $this->startApiCall('PreviewUpdateGameServerCluster', $request, $callOptions)->wait();
    }

    /**
     * Patches a single game server cluster.
     *
     * The async variant is {@see self::updateGameServerClusterAsync()} .
     *
     * @param UpdateGameServerClusterRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGameServerCluster(UpdateGameServerClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGameServerCluster', $request, $callOptions)->wait();
    }
}
