<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/filestore/v1/cloud_filestore_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Filestore\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Filestore\V1\Backup;
use Google\Cloud\Filestore\V1\CreateBackupRequest;
use Google\Cloud\Filestore\V1\CreateInstanceRequest;
use Google\Cloud\Filestore\V1\CreateSnapshotRequest;
use Google\Cloud\Filestore\V1\DeleteBackupRequest;
use Google\Cloud\Filestore\V1\DeleteInstanceRequest;
use Google\Cloud\Filestore\V1\DeleteSnapshotRequest;
use Google\Cloud\Filestore\V1\GetBackupRequest;
use Google\Cloud\Filestore\V1\GetInstanceRequest;
use Google\Cloud\Filestore\V1\GetSnapshotRequest;
use Google\Cloud\Filestore\V1\Instance;
use Google\Cloud\Filestore\V1\ListBackupsRequest;
use Google\Cloud\Filestore\V1\ListBackupsResponse;
use Google\Cloud\Filestore\V1\ListInstancesRequest;
use Google\Cloud\Filestore\V1\ListInstancesResponse;
use Google\Cloud\Filestore\V1\ListSnapshotsRequest;
use Google\Cloud\Filestore\V1\ListSnapshotsResponse;
use Google\Cloud\Filestore\V1\RestoreInstanceRequest;
use Google\Cloud\Filestore\V1\RevertInstanceRequest;
use Google\Cloud\Filestore\V1\Snapshot;
use Google\Cloud\Filestore\V1\UpdateBackupRequest;
use Google\Cloud\Filestore\V1\UpdateInstanceRequest;
use Google\Cloud\Filestore\V1\UpdateSnapshotRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Configures and manages Filestore resources.
 *
 * Filestore Manager v1.
 *
 * The `file.googleapis.com` service implements the Filestore API and
 * defines the following resource model for managing instances:
 * * The service works with a collection of cloud projects, named: `/projects/*`
 * * Each project has a collection of available locations, named: `/locations/*`
 * * Each location has a collection of instances and backups, named:
 * `/instances/*` and `/backups/*` respectively.
 * * As such, Filestore instances are resources of the form:
 * `/projects/{project_number}/locations/{location_id}/instances/{instance_id}`
 * and backups are resources of the form:
 * `/projects/{project_number}/locations/{location_id}/backup/{backup_id}`
 *
 * Note that location_id must be a Google Cloud `zone` for instances, but
 * a Google Cloud `region` for backups; for example:
 * * `projects/12345/locations/us-central1-c/instances/my-filestore`
 * * `projects/12345/locations/us-central1/backups/my-backup`
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
 * try {
 *     $formattedParent = $cloudFilestoreManagerClient->locationName('[PROJECT]', '[LOCATION]');
 *     $backup = new Backup();
 *     $backupId = 'backup_id';
 *     $operationResponse = $cloudFilestoreManagerClient->createBackup($formattedParent, $backup, $backupId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $cloudFilestoreManagerClient->createBackup($formattedParent, $backup, $backupId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'createBackup');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $cloudFilestoreManagerClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\Filestore\V1\Client\CloudFilestoreManagerClient}.
 */
class CloudFilestoreManagerGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.filestore.v1.CloudFilestoreManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'file.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'file.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $backupNameTemplate;

    private static $instanceNameTemplate;

    private static $locationNameTemplate;

    private static $snapshotNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/cloud_filestore_manager_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/cloud_filestore_manager_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/cloud_filestore_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/cloud_filestore_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBackupNameTemplate()
    {
        if (self::$backupNameTemplate == null) {
            self::$backupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/backups/{backup}'
            );
        }

        return self::$backupNameTemplate;
    }

    private static function getInstanceNameTemplate()
    {
        if (self::$instanceNameTemplate == null) {
            self::$instanceNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/instances/{instance}'
            );
        }

        return self::$instanceNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getSnapshotNameTemplate()
    {
        if (self::$snapshotNameTemplate == null) {
            self::$snapshotNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/instances/{instance}/snapshots/{snapshot}'
            );
        }

        return self::$snapshotNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'backup' => self::getBackupNameTemplate(),
                'instance' => self::getInstanceNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'snapshot' => self::getSnapshotNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName($project, $location, $backup)
    {
        return self::getBackupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName($project, $location, $instance)
    {
        return self::getInstanceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a snapshot
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $snapshot
     *
     * @return string The formatted snapshot resource.
     */
    public static function snapshotName(
        $project,
        $location,
        $instance,
        $snapshot
    ) {
        return self::getSnapshotNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'snapshot' => $snapshot,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backups/{backup}
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - snapshot: projects/{project}/locations/{location}/instances/{instance}/snapshots/{snapshot}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'file.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a backup.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedParent = $cloudFilestoreManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     $backup = new Backup();
     *     $backupId = 'backup_id';
     *     $operationResponse = $cloudFilestoreManagerClient->createBackup($formattedParent, $backup, $backupId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->createBackup($formattedParent, $backup, $backupId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'createBackup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The backup's project and location, in the format
     *                             `projects/{project_number}/locations/{location}`. In Filestore,
     *                             backup locations map to Google Cloud regions, for example **us-west1**.
     * @param Backup $backup       Required. A [backup resource][google.cloud.filestore.v1.Backup]
     * @param string $backupId     Required. The ID to use for the backup.
     *                             The ID must be unique within the specified project and location.
     *
     *                             This value must start with a lowercase letter followed by up to 62
     *                             lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     *                             Values that do not match this pattern will trigger an INVALID_ARGUMENT
     *                             error.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createBackup(
        $parent,
        $backup,
        $backupId,
        array $optionalArgs = []
    ) {
        $request = new CreateBackupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setBackup($backup);
        $request->setBackupId($backupId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateBackup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates an instance.
     * When creating from a backup, the capacity of the new instance needs to be
     * equal to or larger than the capacity of the backup (and also equal to or
     * larger than the minimum capacity of the tier).
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedParent = $cloudFilestoreManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     $instanceId = 'instance_id';
     *     $instance = new Instance();
     *     $operationResponse = $cloudFilestoreManagerClient->createInstance($formattedParent, $instanceId, $instance);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->createInstance($formattedParent, $instanceId, $instance);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'createInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The instance's project and location, in the format
     *                               `projects/{project_id}/locations/{location}`. In Filestore,
     *                               locations map to Google Cloud zones, for example **us-west1-b**.
     * @param string   $instanceId   Required. The name of the instance to create.
     *                               The name must be unique for the specified project and location.
     * @param Instance $instance     Required. An [instance resource][google.cloud.filestore.v1.Instance]
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createInstance(
        $parent,
        $instanceId,
        $instance,
        array $optionalArgs = []
    ) {
        $request = new CreateInstanceRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setInstanceId($instanceId);
        $request->setInstance($instance);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a snapshot.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedParent = $cloudFilestoreManagerClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $snapshotId = 'snapshot_id';
     *     $snapshot = new Snapshot();
     *     $operationResponse = $cloudFilestoreManagerClient->createSnapshot($formattedParent, $snapshotId, $snapshot);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->createSnapshot($formattedParent, $snapshotId, $snapshot);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'createSnapshot');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The Filestore Instance to create the snapshots of, in the format
     *                               `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * @param string   $snapshotId   Required. The ID to use for the snapshot.
     *                               The ID must be unique within the specified instance.
     *
     *                               This value must start with a lowercase letter followed by up to 62
     *                               lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
     * @param Snapshot $snapshot     Required. A snapshot resource.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createSnapshot(
        $parent,
        $snapshotId,
        $snapshot,
        array $optionalArgs = []
    ) {
        $request = new CreateSnapshotRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSnapshotId($snapshotId);
        $request->setSnapshot($snapshot);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateSnapshot',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a backup.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP]');
     *     $operationResponse = $cloudFilestoreManagerClient->deleteBackup($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->deleteBackup($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'deleteBackup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The backup resource name, in the format
     *                             `projects/{project_number}/locations/{location}/backups/{backup_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBackup($name, array $optionalArgs = [])
    {
        $request = new DeleteBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteBackup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an instance.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $cloudFilestoreManagerClient->deleteInstance($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->deleteInstance($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'deleteInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The instance resource name, in the format
     *                             `projects/{project_id}/locations/{location}/instances/{instance_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, all snapshots of the instance will also be deleted.
     *           (Otherwise, the request will only work if the instance has no snapshots.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteInstance($name, array $optionalArgs = [])
    {
        $request = new DeleteInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a snapshot.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->snapshotName('[PROJECT]', '[LOCATION]', '[INSTANCE]', '[SNAPSHOT]');
     *     $operationResponse = $cloudFilestoreManagerClient->deleteSnapshot($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->deleteSnapshot($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'deleteSnapshot');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The snapshot resource name, in the format
     *                             `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSnapshot($name, array $optionalArgs = [])
    {
        $request = new DeleteSnapshotRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteSnapshot',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets the details of a specific backup.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP]');
     *     $response = $cloudFilestoreManagerClient->getBackup($formattedName);
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The backup resource name, in the format
     *                             `projects/{project_number}/locations/{location}/backups/{backup_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Filestore\V1\Backup
     *
     * @throws ApiException if the remote call fails
     */
    public function getBackup($name, array $optionalArgs = [])
    {
        $request = new GetBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetBackup',
            Backup::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the details of a specific instance.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $response = $cloudFilestoreManagerClient->getInstance($formattedName);
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The instance resource name, in the format
     *                             `projects/{project_id}/locations/{location}/instances/{instance_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Filestore\V1\Instance
     *
     * @throws ApiException if the remote call fails
     */
    public function getInstance($name, array $optionalArgs = [])
    {
        $request = new GetInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetInstance',
            Instance::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets the details of a specific snapshot.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->snapshotName('[PROJECT]', '[LOCATION]', '[INSTANCE]', '[SNAPSHOT]');
     *     $response = $cloudFilestoreManagerClient->getSnapshot($formattedName);
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The snapshot resource name, in the format
     *                             `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Filestore\V1\Snapshot
     *
     * @throws ApiException if the remote call fails
     */
    public function getSnapshot($name, array $optionalArgs = [])
    {
        $request = new GetSnapshotRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSnapshot',
            Snapshot::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all backups in a project for either a specified location or for all
     * locations.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedParent = $cloudFilestoreManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudFilestoreManagerClient->listBackups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudFilestoreManagerClient->listBackups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location for which to retrieve backup
     *                             information, in the format
     *                             `projects/{project_number}/locations/{location}`. In Filestore, backup
     *                             locations map to Google Cloud regions, for example **us-west1**. To
     *                             retrieve backup information for all locations, use "-" for the
     *                             `{location}` value.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Sort results. Supported values are "name", "name desc" or "" (unsorted).
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBackups($parent, array $optionalArgs = [])
    {
        $request = new ListBackupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListBackups',
            $optionalArgs,
            ListBackupsResponse::class,
            $request
        );
    }

    /**
     * Lists all instances in a project for either a specified location
     * or for all locations.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedParent = $cloudFilestoreManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudFilestoreManagerClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudFilestoreManagerClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location for which to retrieve instance
     *                             information, in the format `projects/{project_id}/locations/{location}`. In
     *                             Cloud Filestore, locations map to Google Cloud zones, for example
     *                             **us-west1-b**. To retrieve instance information for all locations, use "-"
     *                             for the
     *                             `{location}` value.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Sort results. Supported values are "name", "name desc" or "" (unsorted).
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInstances($parent, array $optionalArgs = [])
    {
        $request = new ListInstancesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListInstances',
            $optionalArgs,
            ListInstancesResponse::class,
            $request
        );
    }

    /**
     * Lists all snapshots in a project for either a specified location
     * or for all locations.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedParent = $cloudFilestoreManagerClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudFilestoreManagerClient->listSnapshots($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudFilestoreManagerClient->listSnapshots($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The instance for which to retrieve snapshot information,
     *                             in the format
     *                             `projects/{project_id}/locations/{location}/instances/{instance_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Sort results. Supported values are "name", "name desc" or "" (unsorted).
     *     @type string $filter
     *           List filter.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSnapshots($parent, array $optionalArgs = [])
    {
        $request = new ListSnapshotsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSnapshots',
            $optionalArgs,
            ListSnapshotsResponse::class,
            $request
        );
    }

    /**
     * Restores an existing instance's file share from a backup.
     *
     * The capacity of the instance needs to be equal to or larger than the
     * capacity of the backup (and also equal to or larger than the minimum
     * capacity of the tier).
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $fileShare = 'file_share';
     *     $operationResponse = $cloudFilestoreManagerClient->restoreInstance($formattedName, $fileShare);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->restoreInstance($formattedName, $fileShare);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'restoreInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the instance, in the format
     *                             `projects/{project_number}/locations/{location_id}/instances/{instance_id}`.
     * @param string $fileShare    Required. Name of the file share in the Filestore instance that the backup
     *                             is being restored to.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $sourceBackup
     *           The resource name of the backup, in the format
     *           `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function restoreInstance($name, $fileShare, array $optionalArgs = [])
    {
        $request = new RestoreInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setFileShare($fileShare);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['sourceBackup'])) {
            $request->setSourceBackup($optionalArgs['sourceBackup']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RestoreInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Revert an existing instance's file system to a specified snapshot.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $formattedName = $cloudFilestoreManagerClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $targetSnapshotId = 'target_snapshot_id';
     *     $operationResponse = $cloudFilestoreManagerClient->revertInstance($formattedName, $targetSnapshotId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->revertInstance($formattedName, $targetSnapshotId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'revertInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param string $name             Required.
     *                                 `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
     *                                 The resource name of the instance, in the format
     * @param string $targetSnapshotId Required. The snapshot resource ID, in the format 'my-snapshot', where the
     *                                 specified ID is the {snapshot_id} of the fully qualified name like
     *                                 `projects/{project_id}/locations/{location_id}/instances/{instance_id}/snapshots/{snapshot_id}`
     * @param array  $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function revertInstance(
        $name,
        $targetSnapshotId,
        array $optionalArgs = []
    ) {
        $request = new RevertInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setTargetSnapshotId($targetSnapshotId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RevertInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the settings of a specific backup.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $backup = new Backup();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $cloudFilestoreManagerClient->updateBackup($backup, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->updateBackup($backup, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'updateBackup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param Backup    $backup       Required. A [backup resource][google.cloud.filestore.v1.Backup]
     * @param FieldMask $updateMask   Required. Mask of fields to update.  At least one path must be supplied in
     *                                this field.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBackup($backup, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateBackupRequest();
        $requestParamHeaders = [];
        $request->setBackup($backup);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['backup.name'] = $backup->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateBackup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the settings of a specific instance.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $operationResponse = $cloudFilestoreManagerClient->updateInstance();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->updateInstance();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'updateInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Mask of fields to update.  At least one path must be supplied in this
     *           field.  The elements of the repeated paths field may only include these
     *           fields:
     *
     *           * "description"
     *           * "file_shares"
     *           * "labels"
     *     @type Instance $instance
     *           Only fields specified in update_mask are updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateInstance(array $optionalArgs = [])
    {
        $request = new UpdateInstanceRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['instance'])) {
            $request->setInstance($optionalArgs['instance']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateInstance',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the settings of a specific snapshot.
     *
     * Sample code:
     * ```
     * $cloudFilestoreManagerClient = new CloudFilestoreManagerClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $snapshot = new Snapshot();
     *     $operationResponse = $cloudFilestoreManagerClient->updateSnapshot($updateMask, $snapshot);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudFilestoreManagerClient->updateSnapshot($updateMask, $snapshot);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudFilestoreManagerClient->resumeOperation($operationName, 'updateSnapshot');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudFilestoreManagerClient->close();
     * }
     * ```
     *
     * @param FieldMask $updateMask   Required. Mask of fields to update. At least one path must be supplied in
     *                                this field.
     * @param Snapshot  $snapshot     Required. A snapshot resource.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSnapshot(
        $updateMask,
        $snapshot,
        array $optionalArgs = []
    ) {
        $request = new UpdateSnapshotRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setSnapshot($snapshot);
        $requestParamHeaders['snapshot.name'] = $snapshot->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateSnapshot',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
