<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/clouddms/v1/clouddms.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\CloudDms\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\CloudDms\V1\ApplyConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\CommitConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\ConnectionProfile;
use Google\Cloud\CloudDms\V1\ConversionWorkspace;
use Google\Cloud\CloudDms\V1\ConvertConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\CreateConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\CreateConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\CreateMappingRuleRequest;
use Google\Cloud\CloudDms\V1\CreateMigrationJobRequest;
use Google\Cloud\CloudDms\V1\CreatePrivateConnectionRequest;
use Google\Cloud\CloudDms\V1\DeleteConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\DeleteConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\DeleteMappingRuleRequest;
use Google\Cloud\CloudDms\V1\DeleteMigrationJobRequest;
use Google\Cloud\CloudDms\V1\DeletePrivateConnectionRequest;
use Google\Cloud\CloudDms\V1\DescribeConversionWorkspaceRevisionsRequest;
use Google\Cloud\CloudDms\V1\DescribeConversionWorkspaceRevisionsResponse;
use Google\Cloud\CloudDms\V1\DescribeDatabaseEntitiesRequest;
use Google\Cloud\CloudDms\V1\DescribeDatabaseEntitiesResponse;
use Google\Cloud\CloudDms\V1\FetchStaticIpsRequest;
use Google\Cloud\CloudDms\V1\FetchStaticIpsResponse;
use Google\Cloud\CloudDms\V1\GenerateSshScriptRequest;
use Google\Cloud\CloudDms\V1\GenerateTcpProxyScriptRequest;
use Google\Cloud\CloudDms\V1\GetConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\GetConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\GetMappingRuleRequest;
use Google\Cloud\CloudDms\V1\GetMigrationJobRequest;
use Google\Cloud\CloudDms\V1\GetPrivateConnectionRequest;
use Google\Cloud\CloudDms\V1\ImportMappingRulesRequest;
use Google\Cloud\CloudDms\V1\ImportMappingRulesRequest\RulesFile;
use Google\Cloud\CloudDms\V1\ListConnectionProfilesRequest;
use Google\Cloud\CloudDms\V1\ListConnectionProfilesResponse;
use Google\Cloud\CloudDms\V1\ListConversionWorkspacesRequest;
use Google\Cloud\CloudDms\V1\ListConversionWorkspacesResponse;
use Google\Cloud\CloudDms\V1\ListMappingRulesRequest;
use Google\Cloud\CloudDms\V1\ListMappingRulesResponse;
use Google\Cloud\CloudDms\V1\ListMigrationJobsRequest;
use Google\Cloud\CloudDms\V1\ListMigrationJobsResponse;
use Google\Cloud\CloudDms\V1\ListPrivateConnectionsRequest;
use Google\Cloud\CloudDms\V1\ListPrivateConnectionsResponse;
use Google\Cloud\CloudDms\V1\MappingRule;
use Google\Cloud\CloudDms\V1\MigrationJob;
use Google\Cloud\CloudDms\V1\PrivateConnection;
use Google\Cloud\CloudDms\V1\PromoteMigrationJobRequest;
use Google\Cloud\CloudDms\V1\RestartMigrationJobRequest;
use Google\Cloud\CloudDms\V1\ResumeMigrationJobRequest;
use Google\Cloud\CloudDms\V1\RollbackConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\SearchBackgroundJobsRequest;
use Google\Cloud\CloudDms\V1\SearchBackgroundJobsResponse;
use Google\Cloud\CloudDms\V1\SeedConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\SshScript;
use Google\Cloud\CloudDms\V1\StartMigrationJobRequest;
use Google\Cloud\CloudDms\V1\StopMigrationJobRequest;
use Google\Cloud\CloudDms\V1\TcpProxyScript;
use Google\Cloud\CloudDms\V1\UpdateConnectionProfileRequest;
use Google\Cloud\CloudDms\V1\UpdateConversionWorkspaceRequest;
use Google\Cloud\CloudDms\V1\UpdateMigrationJobRequest;
use Google\Cloud\CloudDms\V1\VerifyMigrationJobRequest;
use Google\Cloud\CloudDms\V1\VmCreationConfig;
use Google\Cloud\CloudDms\V1\VmSelectionConfig;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: Database Migration service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataMigrationServiceClient = new DataMigrationServiceClient();
 * try {
 *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
 *     $operationResponse = $dataMigrationServiceClient->applyConversionWorkspace($formattedName);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $dataMigrationServiceClient->applyConversionWorkspace($formattedName);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'applyConversionWorkspace');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $dataMigrationServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\CloudDms\V1\Client\DataMigrationServiceClient}.
 */
class DataMigrationServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.clouddms.v1.DataMigrationService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'datamigration.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'datamigration.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $connectionProfileNameTemplate;

    private static $conversionWorkspaceNameTemplate;

    private static $locationNameTemplate;

    private static $mappingRuleNameTemplate;

    private static $migrationJobNameTemplate;

    private static $networksNameTemplate;

    private static $privateConnectionNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_migration_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_migration_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_migration_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/data_migration_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getConnectionProfileNameTemplate()
    {
        if (self::$connectionProfileNameTemplate == null) {
            self::$connectionProfileNameTemplate = new PathTemplate('projects/{project}/locations/{location}/connectionProfiles/{connection_profile}');
        }

        return self::$connectionProfileNameTemplate;
    }

    private static function getConversionWorkspaceNameTemplate()
    {
        if (self::$conversionWorkspaceNameTemplate == null) {
            self::$conversionWorkspaceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}');
        }

        return self::$conversionWorkspaceNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getMappingRuleNameTemplate()
    {
        if (self::$mappingRuleNameTemplate == null) {
            self::$mappingRuleNameTemplate = new PathTemplate('projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}/mappingRules/{mapping_rule}');
        }

        return self::$mappingRuleNameTemplate;
    }

    private static function getMigrationJobNameTemplate()
    {
        if (self::$migrationJobNameTemplate == null) {
            self::$migrationJobNameTemplate = new PathTemplate('projects/{project}/locations/{location}/migrationJobs/{migration_job}');
        }

        return self::$migrationJobNameTemplate;
    }

    private static function getNetworksNameTemplate()
    {
        if (self::$networksNameTemplate == null) {
            self::$networksNameTemplate = new PathTemplate('projects/{project}/global/networks/{network}');
        }

        return self::$networksNameTemplate;
    }

    private static function getPrivateConnectionNameTemplate()
    {
        if (self::$privateConnectionNameTemplate == null) {
            self::$privateConnectionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/privateConnections/{private_connection}');
        }

        return self::$privateConnectionNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'connectionProfile' => self::getConnectionProfileNameTemplate(),
                'conversionWorkspace' => self::getConversionWorkspaceNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'mappingRule' => self::getMappingRuleNameTemplate(),
                'migrationJob' => self::getMigrationJobNameTemplate(),
                'networks' => self::getNetworksNameTemplate(),
                'privateConnection' => self::getPrivateConnectionNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * connection_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connectionProfile
     *
     * @return string The formatted connection_profile resource.
     */
    public static function connectionProfileName($project, $location, $connectionProfile)
    {
        return self::getConnectionProfileNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'connection_profile' => $connectionProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversion_workspace resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversionWorkspace
     *
     * @return string The formatted conversion_workspace resource.
     */
    public static function conversionWorkspaceName($project, $location, $conversionWorkspace)
    {
        return self::getConversionWorkspaceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversion_workspace' => $conversionWorkspace,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a mapping_rule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversionWorkspace
     * @param string $mappingRule
     *
     * @return string The formatted mapping_rule resource.
     */
    public static function mappingRuleName($project, $location, $conversionWorkspace, $mappingRule)
    {
        return self::getMappingRuleNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversion_workspace' => $conversionWorkspace,
            'mapping_rule' => $mappingRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * migration_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $migrationJob
     *
     * @return string The formatted migration_job resource.
     */
    public static function migrationJobName($project, $location, $migrationJob)
    {
        return self::getMigrationJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'migration_job' => $migrationJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a networks
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted networks resource.
     */
    public static function networksName($project, $network)
    {
        return self::getNetworksNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     *
     * @return string The formatted private_connection resource.
     */
    public static function privateConnectionName($project, $location, $privateConnection)
    {
        return self::getPrivateConnectionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - connectionProfile: projects/{project}/locations/{location}/connectionProfiles/{connection_profile}
     * - conversionWorkspace: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}
     * - location: projects/{project}/locations/{location}
     * - mappingRule: projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}/mappingRules/{mapping_rule}
     * - migrationJob: projects/{project}/locations/{location}/migrationJobs/{migration_job}
     * - networks: projects/{project}/global/networks/{network}
     * - privateConnection: projects/{project}/locations/{location}/privateConnections/{private_connection}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datamigration.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Applies draft tree onto a specific destination database.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $operationResponse = $dataMigrationServiceClient->applyConversionWorkspace($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->applyConversionWorkspace($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'applyConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the conversion workspace resource for which to apply
     *                             the draft tree. Must be in the form of:
     *                             projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Filter which entities to apply. Leaving this field empty will apply all of
     *           the entities. Supports Google AIP 160 based filtering.
     *     @type bool $dryRun
     *           Optional. Only validates the apply process, but doesn't change the
     *           destination database. Only works for PostgreSQL destination connection
     *           profile.
     *     @type bool $autoCommit
     *           Optional. Specifies whether the conversion workspace is to be committed
     *           automatically after the apply.
     *     @type string $connectionProfile
     *           Optional. Fully qualified (Uri) name of the destination connection
     *           profile.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function applyConversionWorkspace($name, array $optionalArgs = [])
    {
        $request = new ApplyConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['dryRun'])) {
            $request->setDryRun($optionalArgs['dryRun']);
        }

        if (isset($optionalArgs['autoCommit'])) {
            $request->setAutoCommit($optionalArgs['autoCommit']);
        }

        if (isset($optionalArgs['connectionProfile'])) {
            $request->setConnectionProfile($optionalArgs['connectionProfile']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ApplyConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Marks all the data in the conversion workspace as committed.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $operationResponse = $dataMigrationServiceClient->commitConversionWorkspace($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->commitConversionWorkspace($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'commitConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the conversion workspace resource to commit.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $commitName
     *           Optional. Optional name of the commit.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function commitConversionWorkspace($name, array $optionalArgs = [])
    {
        $request = new CommitConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['commitName'])) {
            $request->setCommitName($optionalArgs['commitName']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CommitConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a draft tree schema for the destination database.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->convertConversionWorkspace();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->convertConversionWorkspace();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'convertConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the conversion workspace resource to convert in the form of:
     *           projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     *     @type bool $autoCommit
     *           Optional. Specifies whether the conversion workspace is to be committed
     *           automatically after the conversion.
     *     @type string $filter
     *           Optional. Filter the entities to convert. Leaving this field empty will
     *           convert all of the entities. Supports Google AIP-160 style filtering.
     *     @type bool $convertFullPath
     *           Optional. Automatically convert the full entity path for each entity
     *           specified by the filter. For example, if the filter specifies a table, that
     *           table schema (and database if there is one) will also be converted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function convertConversionWorkspace(array $optionalArgs = [])
    {
        $request = new ConvertConversionWorkspaceRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['autoCommit'])) {
            $request->setAutoCommit($optionalArgs['autoCommit']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['convertFullPath'])) {
            $request->setConvertFullPath($optionalArgs['convertFullPath']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ConvertConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new connection profile in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $connectionProfileId = 'connection_profile_id';
     *     $connectionProfile = new ConnectionProfile();
     *     $operationResponse = $dataMigrationServiceClient->createConnectionProfile($formattedParent, $connectionProfileId, $connectionProfile);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->createConnectionProfile($formattedParent, $connectionProfileId, $connectionProfile);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'createConnectionProfile');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The parent which owns this collection of connection profiles.
     * @param string            $connectionProfileId Required. The connection profile identifier.
     * @param ConnectionProfile $connectionProfile   Required. The create request body including the connection profile data
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type bool $validateOnly
     *           Optional. Only validate the connection profile, but don't create any
     *           resources. The default is false. Only supported for Oracle connection
     *           profiles.
     *     @type bool $skipValidation
     *           Optional. Create the connection profile without validating it.
     *           The default is false.
     *           Only supported for Oracle connection profiles.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createConnectionProfile($parent, $connectionProfileId, $connectionProfile, array $optionalArgs = [])
    {
        $request = new CreateConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConnectionProfileId($connectionProfileId);
        $request->setConnectionProfile($connectionProfile);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['skipValidation'])) {
            $request->setSkipValidation($optionalArgs['skipValidation']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateConnectionProfile', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new conversion workspace in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $conversionWorkspaceId = 'conversion_workspace_id';
     *     $conversionWorkspace = new ConversionWorkspace();
     *     $operationResponse = $dataMigrationServiceClient->createConversionWorkspace($formattedParent, $conversionWorkspaceId, $conversionWorkspace);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->createConversionWorkspace($formattedParent, $conversionWorkspaceId, $conversionWorkspace);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'createConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string              $parent                Required. The parent which owns this collection of conversion workspaces.
     * @param string              $conversionWorkspaceId Required. The ID of the conversion workspace to create.
     * @param ConversionWorkspace $conversionWorkspace   Required. Represents a conversion workspace object.
     * @param array               $optionalArgs          {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createConversionWorkspace($parent, $conversionWorkspaceId, $conversionWorkspace, array $optionalArgs = [])
    {
        $request = new CreateConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConversionWorkspaceId($conversionWorkspaceId);
        $request->setConversionWorkspace($conversionWorkspace);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new mapping rule for a given conversion workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $mappingRuleId = 'mapping_rule_id';
     *     $mappingRule = new MappingRule();
     *     $response = $dataMigrationServiceClient->createMappingRule($formattedParent, $mappingRuleId, $mappingRule);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The parent which owns this collection of mapping rules.
     * @param string      $mappingRuleId Required. The ID of the rule to create.
     * @param MappingRule $mappingRule   Required. Represents a [mapping rule]
     *                                   (https://cloud.google.com/database-migration/reference/rest/v1/projects.locations.mappingRules)
     *                                   object.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\MappingRule
     *
     * @throws ApiException if the remote call fails
     */
    public function createMappingRule($parent, $mappingRuleId, $mappingRule, array $optionalArgs = [])
    {
        $request = new CreateMappingRuleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMappingRuleId($mappingRuleId);
        $request->setMappingRule($mappingRule);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateMappingRule', MappingRule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new migration job in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $migrationJobId = 'migration_job_id';
     *     $migrationJob = new MigrationJob();
     *     $operationResponse = $dataMigrationServiceClient->createMigrationJob($formattedParent, $migrationJobId, $migrationJob);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->createMigrationJob($formattedParent, $migrationJobId, $migrationJob);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'createMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The parent which owns this collection of migration jobs.
     * @param string       $migrationJobId Required. The ID of the instance to create.
     * @param MigrationJob $migrationJob   Required. Represents a [migration
     *                                     job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
     *                                     object.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createMigrationJob($parent, $migrationJobId, $migrationJob, array $optionalArgs = [])
    {
        $request = new CreateMigrationJobRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMigrationJobId($migrationJobId);
        $request->setMigrationJob($migrationJob);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new private connection in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $privateConnectionId = 'private_connection_id';
     *     $privateConnection = new PrivateConnection();
     *     $operationResponse = $dataMigrationServiceClient->createPrivateConnection($formattedParent, $privateConnectionId, $privateConnection);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->createPrivateConnection($formattedParent, $privateConnectionId, $privateConnection);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'createPrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The parent that owns the collection of PrivateConnections.
     * @param string            $privateConnectionId Required. The private connection identifier.
     * @param PrivateConnection $privateConnection   Required. The private connection resource to create.
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type bool $skipValidation
     *           Optional. If set to true, will skip validations.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createPrivateConnection($parent, $privateConnectionId, $privateConnection, array $optionalArgs = [])
    {
        $request = new CreatePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPrivateConnectionId($privateConnectionId);
        $request->setPrivateConnection($privateConnection);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['skipValidation'])) {
            $request->setSkipValidation($optionalArgs['skipValidation']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreatePrivateConnection', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Database Migration Service connection profile.
     * A connection profile can only be deleted if it is not in use by any
     * active migration jobs.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->connectionProfileName('[PROJECT]', '[LOCATION]', '[CONNECTION_PROFILE]');
     *     $operationResponse = $dataMigrationServiceClient->deleteConnectionProfile($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->deleteConnectionProfile($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'deleteConnectionProfile');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the connection profile resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type bool $force
     *           In case of force delete, the CloudSQL replica database is also deleted
     *           (only for CloudSQL connection profile).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteConnectionProfile($name, array $optionalArgs = [])
    {
        $request = new DeleteConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteConnectionProfile', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single conversion workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $operationResponse = $dataMigrationServiceClient->deleteConversionWorkspace($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->deleteConversionWorkspace($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'deleteConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the conversion workspace resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type bool $force
     *           Force delete the conversion workspace, even if there's a running migration
     *           that is using the workspace.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteConversionWorkspace($name, array $optionalArgs = [])
    {
        $request = new DeleteConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single mapping rule.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $dataMigrationServiceClient->deleteMappingRule($formattedName);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the mapping rule resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteMappingRule($name, array $optionalArgs = [])
    {
        $request = new DeleteMappingRuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteMappingRule', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a single migration job.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->migrationJobName('[PROJECT]', '[LOCATION]', '[MIGRATION_JOB]');
     *     $operationResponse = $dataMigrationServiceClient->deleteMigrationJob($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->deleteMigrationJob($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'deleteMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the migration job resource to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type bool $force
     *           The destination CloudSQL connection profile is always deleted with the
     *           migration job. In case of force delete, the destination CloudSQL replica
     *           database is also deleted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteMigrationJob($name, array $optionalArgs = [])
    {
        $request = new DeleteMigrationJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a single Database Migration Service private connection.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $operationResponse = $dataMigrationServiceClient->deletePrivateConnection($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->deletePrivateConnection($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'deletePrivateConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the private connection to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deletePrivateConnection($name, array $optionalArgs = [])
    {
        $request = new DeletePrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeletePrivateConnection', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Retrieves a list of committed revisions of a specific conversion
     * workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedConversionWorkspace = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $response = $dataMigrationServiceClient->describeConversionWorkspaceRevisions($formattedConversionWorkspace);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $conversionWorkspace Required. Name of the conversion workspace resource whose revisions are
     *                                    listed. Must be in the form of:
     *                                    projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * @param array  $optionalArgs        {
     *     Optional.
     *
     *     @type string $commitId
     *           Optional. Optional filter to request a specific commit ID.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\DescribeConversionWorkspaceRevisionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function describeConversionWorkspaceRevisions($conversionWorkspace, array $optionalArgs = [])
    {
        $request = new DescribeConversionWorkspaceRevisionsRequest();
        $requestParamHeaders = [];
        $request->setConversionWorkspace($conversionWorkspace);
        $requestParamHeaders['conversion_workspace'] = $conversionWorkspace;
        if (isset($optionalArgs['commitId'])) {
            $request->setCommitId($optionalArgs['commitId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DescribeConversionWorkspaceRevisions', DescribeConversionWorkspaceRevisionsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Describes the database entities tree for a specific conversion workspace
     * and a specific tree type.
     *
     * Database entities are not resources like conversion workspaces or mapping
     * rules, and they can't be created, updated or deleted. Instead, they are
     * simple data objects describing the structure of the client database.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedConversionWorkspace = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->describeDatabaseEntities($formattedConversionWorkspace);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->describeDatabaseEntities($formattedConversionWorkspace);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $conversionWorkspace Required. Name of the conversion workspace resource whose database entities
     *                                    are described. Must be in the form of:
     *                                    projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * @param array  $optionalArgs        {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $tree
     *           Required. The tree to fetch.
     *           For allowed values, use constants defined on {@see \Google\Cloud\CloudDms\V1\DescribeDatabaseEntitiesRequest\DBTreeType}
     *     @type bool $uncommitted
     *           Optional. Whether to retrieve the latest committed version of the entities
     *           or the latest version. This field is ignored if a specific commit_id is
     *           specified.
     *     @type string $commitId
     *           Optional. Request a specific commit ID. If not specified, the entities from
     *           the latest commit are returned.
     *     @type string $filter
     *           Optional. Filter the returned entities based on AIP-160 standard.
     *     @type int $view
     *           Optional. Results view based on AIP-157
     *           For allowed values, use constants defined on {@see \Google\Cloud\CloudDms\V1\DatabaseEntityView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function describeDatabaseEntities($conversionWorkspace, array $optionalArgs = [])
    {
        $request = new DescribeDatabaseEntitiesRequest();
        $requestParamHeaders = [];
        $request->setConversionWorkspace($conversionWorkspace);
        $requestParamHeaders['conversion_workspace'] = $conversionWorkspace;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['tree'])) {
            $request->setTree($optionalArgs['tree']);
        }

        if (isset($optionalArgs['uncommitted'])) {
            $request->setUncommitted($optionalArgs['uncommitted']);
        }

        if (isset($optionalArgs['commitId'])) {
            $request->setCommitId($optionalArgs['commitId']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('DescribeDatabaseEntities', $optionalArgs, DescribeDatabaseEntitiesResponse::class, $request);
    }

    /**
     * Fetches a set of static IP addresses that need to be allowlisted by the
     * customer when using the static-IP connectivity method.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->fetchStaticIps($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->fetchStaticIps($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name for the location for which static IPs should be
     *                             returned. Must be in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function fetchStaticIps($name, array $optionalArgs = [])
    {
        $request = new FetchStaticIpsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('FetchStaticIps', $optionalArgs, FetchStaticIpsResponse::class, $request);
    }

    /**
     * Generate a SSH configuration script to configure the reverse SSH
     * connectivity.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $vm = 'vm';
     *     $response = $dataMigrationServiceClient->generateSshScript($vm);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $vm           Required. Bastion VM Instance name to use or to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $migrationJob
     *           Name of the migration job resource to generate the SSH script.
     *     @type VmCreationConfig $vmCreationConfig
     *           The VM creation configuration
     *     @type VmSelectionConfig $vmSelectionConfig
     *           The VM selection configuration
     *     @type int $vmPort
     *           The port that will be open on the bastion host.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\SshScript
     *
     * @throws ApiException if the remote call fails
     */
    public function generateSshScript($vm, array $optionalArgs = [])
    {
        $request = new GenerateSshScriptRequest();
        $requestParamHeaders = [];
        $request->setVm($vm);
        if (isset($optionalArgs['migrationJob'])) {
            $request->setMigrationJob($optionalArgs['migrationJob']);
            $requestParamHeaders['migration_job'] = $optionalArgs['migrationJob'];
        }

        if (isset($optionalArgs['vmCreationConfig'])) {
            $request->setVmCreationConfig($optionalArgs['vmCreationConfig']);
        }

        if (isset($optionalArgs['vmSelectionConfig'])) {
            $request->setVmSelectionConfig($optionalArgs['vmSelectionConfig']);
        }

        if (isset($optionalArgs['vmPort'])) {
            $request->setVmPort($optionalArgs['vmPort']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateSshScript', SshScript::class, $optionalArgs, $request)->wait();
    }

    /**
     * Generate a TCP Proxy configuration script to configure a cloud-hosted VM
     * running a TCP Proxy.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $vmName = 'vm_name';
     *     $vmMachineType = 'vm_machine_type';
     *     $vmSubnet = 'vm_subnet';
     *     $response = $dataMigrationServiceClient->generateTcpProxyScript($vmName, $vmMachineType, $vmSubnet);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $vmName        Required. The name of the Compute instance that will host the proxy.
     * @param string $vmMachineType Required. The type of the Compute instance that will host the proxy.
     * @param string $vmSubnet      Required. The name of the subnet the Compute instance will use for private
     *                              connectivity. Must be supplied in the form of
     *                              projects/{project}/regions/{region}/subnetworks/{subnetwork}.
     *                              Note: the region for the subnet must match the Compute instance region.
     * @param array  $optionalArgs  {
     *     Optional.
     *
     *     @type string $migrationJob
     *           Name of the migration job resource to generate the TCP Proxy script.
     *     @type string $vmZone
     *           Optional. The Google Cloud Platform zone to create the VM in. The fully
     *           qualified name of the zone must be specified, including the region name,
     *           for example "us-central1-b". If not specified, uses the "-b" zone of the
     *           destination Connection Profile's region.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\TcpProxyScript
     *
     * @throws ApiException if the remote call fails
     */
    public function generateTcpProxyScript($vmName, $vmMachineType, $vmSubnet, array $optionalArgs = [])
    {
        $request = new GenerateTcpProxyScriptRequest();
        $requestParamHeaders = [];
        $request->setVmName($vmName);
        $request->setVmMachineType($vmMachineType);
        $request->setVmSubnet($vmSubnet);
        if (isset($optionalArgs['migrationJob'])) {
            $request->setMigrationJob($optionalArgs['migrationJob']);
            $requestParamHeaders['migration_job'] = $optionalArgs['migrationJob'];
        }

        if (isset($optionalArgs['vmZone'])) {
            $request->setVmZone($optionalArgs['vmZone']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateTcpProxyScript', TcpProxyScript::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single connection profile.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->connectionProfileName('[PROJECT]', '[LOCATION]', '[CONNECTION_PROFILE]');
     *     $response = $dataMigrationServiceClient->getConnectionProfile($formattedName);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the connection profile resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\ConnectionProfile
     *
     * @throws ApiException if the remote call fails
     */
    public function getConnectionProfile($name, array $optionalArgs = [])
    {
        $request = new GetConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetConnectionProfile', ConnectionProfile::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single conversion workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $response = $dataMigrationServiceClient->getConversionWorkspace($formattedName);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the conversion workspace resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\ConversionWorkspace
     *
     * @throws ApiException if the remote call fails
     */
    public function getConversionWorkspace($name, array $optionalArgs = [])
    {
        $request = new GetConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetConversionWorkspace', ConversionWorkspace::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the details of a mapping rule.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->mappingRuleName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]', '[MAPPING_RULE]');
     *     $response = $dataMigrationServiceClient->getMappingRule($formattedName);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the mapping rule resource to get.
     *                             Example: conversionWorkspaces/123/mappingRules/rule123
     *
     *                             In order to retrieve a previous revision of the mapping rule, also provide
     *                             the revision ID.
     *                             Example:
     *                             conversionWorkspace/123/mappingRules/rule123&#64;c7cfa2a8c7cfa2a8c7cfa2a8c7cfa2a8
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\MappingRule
     *
     * @throws ApiException if the remote call fails
     */
    public function getMappingRule($name, array $optionalArgs = [])
    {
        $request = new GetMappingRuleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetMappingRule', MappingRule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single migration job.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->migrationJobName('[PROJECT]', '[LOCATION]', '[MIGRATION_JOB]');
     *     $response = $dataMigrationServiceClient->getMigrationJob($formattedName);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the migration job resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\MigrationJob
     *
     * @throws ApiException if the remote call fails
     */
    public function getMigrationJob($name, array $optionalArgs = [])
    {
        $request = new GetMigrationJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetMigrationJob', MigrationJob::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets details of a single private connection.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->privateConnectionName('[PROJECT]', '[LOCATION]', '[PRIVATE_CONNECTION]');
     *     $response = $dataMigrationServiceClient->getPrivateConnection($formattedName);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the private connection to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\PrivateConnection
     *
     * @throws ApiException if the remote call fails
     */
    public function getPrivateConnection($name, array $optionalArgs = [])
    {
        $request = new GetPrivateConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetPrivateConnection', PrivateConnection::class, $optionalArgs, $request)->wait();
    }

    /**
     * Imports the mapping rules for a given conversion workspace.
     * Supports various formats of external rules files.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $operationResponse = $dataMigrationServiceClient->importMappingRules($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->importMappingRules($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'importMappingRules');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the conversion workspace resource to import the rules to
     *                             in the form of:
     *                             projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $rulesFormat
     *           Required. The format of the rules content file.
     *           For allowed values, use constants defined on {@see \Google\Cloud\CloudDms\V1\ImportRulesFileFormat}
     *     @type RulesFile[] $rulesFiles
     *           Required. One or more rules files.
     *     @type bool $autoCommit
     *           Required. Should the conversion workspace be committed automatically after
     *           the import operation.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function importMappingRules($parent, array $optionalArgs = [])
    {
        $request = new ImportMappingRulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['rulesFormat'])) {
            $request->setRulesFormat($optionalArgs['rulesFormat']);
        }

        if (isset($optionalArgs['rulesFiles'])) {
            $request->setRulesFiles($optionalArgs['rulesFiles']);
        }

        if (isset($optionalArgs['autoCommit'])) {
            $request->setAutoCommit($optionalArgs['autoCommit']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ImportMappingRules', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Retrieves a list of all connection profiles in a given project and
     * location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->listConnectionProfiles($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->listConnectionProfiles($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent which owns this collection of connection profiles.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that filters connection profiles listed in the
     *           response. The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value must
     *           be a string, a number, or a boolean. The comparison operator must be either
     *           =, !=, >, or <. For example, list connection profiles created this year by
     *           specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z**. You can
     *           also filter nested fields. For example, you could specify **mySql.username
     *           = %lt;my_username%gt;** to list all connection profiles configured to
     *           connect with a specific username.
     *     @type string $orderBy
     *           A comma-separated list of fields to order results according to.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConnectionProfiles($parent, array $optionalArgs = [])
    {
        $request = new ListConnectionProfilesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListConnectionProfiles', $optionalArgs, ListConnectionProfilesResponse::class, $request);
    }

    /**
     * Lists conversion workspaces in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->listConversionWorkspaces($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->listConversionWorkspaces($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent which owns this collection of conversion workspaces.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that filters conversion workspaces listed in the
     *           response. The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value must
     *           be a string, a number, or a boolean. The comparison operator must be either
     *           =, !=, >, or <. For example, list conversion workspaces created this year
     *           by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.** You can
     *           also filter nested fields. For example, you could specify
     *           **source.version = "12.c.1"** to select all conversion workspaces with
     *           source database version equal to 12.c.1.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConversionWorkspaces($parent, array $optionalArgs = [])
    {
        $request = new ListConversionWorkspacesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListConversionWorkspaces', $optionalArgs, ListConversionWorkspacesResponse::class, $request);
    }

    /**
     * Lists the mapping rules for a specific conversion workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->listMappingRules($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->listMappingRules($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Name of the conversion workspace resource whose mapping rules are
     *                             listed in the form of:
     *                             projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMappingRules($parent, array $optionalArgs = [])
    {
        $request = new ListMappingRulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListMappingRules', $optionalArgs, ListMappingRulesResponse::class, $request);
    }

    /**
     * Lists migration jobs in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->listMigrationJobs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->listMigrationJobs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent which owns this collection of migrationJobs.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that filters migration jobs listed in the response.
     *           The expression must specify the field name, a comparison operator, and the
     *           value that you want to use for filtering. The value must be a string,
     *           a number, or a boolean. The comparison operator must be
     *           either =, !=, >, or <. For example, list migration jobs created this year
     *           by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.**
     *           You can also filter nested fields. For example, you could specify
     *           **reverseSshConnectivity.vmIp = "1.2.3.4"** to select all migration
     *           jobs connecting through the specific SSH tunnel bastion.
     *     @type string $orderBy
     *           Sort the results based on the migration job name.
     *           Valid values are: "name", "name asc", and "name desc".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMigrationJobs($parent, array $optionalArgs = [])
    {
        $request = new ListMigrationJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListMigrationJobs', $optionalArgs, ListMigrationJobsResponse::class, $request);
    }

    /**
     * Retrieves a list of private connections in a given project and location.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedParent = $dataMigrationServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataMigrationServiceClient->listPrivateConnections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataMigrationServiceClient->listPrivateConnections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent that owns the collection of private connections.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter expression that filters private connections listed in the
     *           response. The expression must specify the field name, a comparison
     *           operator, and the value that you want to use for filtering. The value must
     *           be a string, a number, or a boolean. The comparison operator must be either
     *           =, !=, >, or <. For example, list private connections created this year by
     *           specifying **createTime %gt; 2021-01-01T00:00:00.000000000Z**.
     *     @type string $orderBy
     *           Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPrivateConnections($parent, array $optionalArgs = [])
    {
        $request = new ListPrivateConnectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListPrivateConnections', $optionalArgs, ListPrivateConnectionsResponse::class, $request);
    }

    /**
     * Promote a migration job, stopping replication to the destination and
     * promoting the destination to be a standalone database.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->promoteMigrationJob();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->promoteMigrationJob();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'promoteMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the migration job resource to promote.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function promoteMigrationJob(array $optionalArgs = [])
    {
        $request = new PromoteMigrationJobRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('PromoteMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Restart a stopped or failed migration job, resetting the destination
     * instance to its original state and starting the migration process from
     * scratch.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->restartMigrationJob();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->restartMigrationJob();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'restartMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the migration job resource to restart.
     *     @type bool $skipValidation
     *           Optional. Restart the migration job without running prior configuration
     *           verification. Defaults to `false`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function restartMigrationJob(array $optionalArgs = [])
    {
        $request = new RestartMigrationJobRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['skipValidation'])) {
            $request->setSkipValidation($optionalArgs['skipValidation']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RestartMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Resume a migration job that is currently stopped and is resumable (was
     * stopped during CDC phase).
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->resumeMigrationJob();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->resumeMigrationJob();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'resumeMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the migration job resource to resume.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resumeMigrationJob(array $optionalArgs = [])
    {
        $request = new ResumeMigrationJobRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ResumeMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Rolls back a conversion workspace to the last committed snapshot.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedName = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $operationResponse = $dataMigrationServiceClient->rollbackConversionWorkspace($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->rollbackConversionWorkspace($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'rollbackConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the conversion workspace resource to roll back to.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function rollbackConversionWorkspace($name, array $optionalArgs = [])
    {
        $request = new RollbackConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RollbackConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Searches/lists the background jobs for a specific
     * conversion workspace.
     *
     * The background jobs are not resources like conversion workspaces or
     * mapping rules, and they can't be created, updated or deleted.
     * Instead, they are a way to expose the data plane jobs log.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $formattedConversionWorkspace = $dataMigrationServiceClient->conversionWorkspaceName('[PROJECT]', '[LOCATION]', '[CONVERSION_WORKSPACE]');
     *     $response = $dataMigrationServiceClient->searchBackgroundJobs($formattedConversionWorkspace);
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param string $conversionWorkspace Required. Name of the conversion workspace resource whose jobs are listed,
     *                                    in the form of:
     *                                    projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     * @param array  $optionalArgs        {
     *     Optional.
     *
     *     @type bool $returnMostRecentPerJobType
     *           Optional. Whether or not to return just the most recent job per job type,
     *     @type int $maxSize
     *           Optional. The maximum number of jobs to return. The service may return
     *           fewer than this value. If unspecified, at most 100 jobs are
     *           returned. The maximum value is 100; values above 100 are coerced to
     *           100.
     *     @type Timestamp $completedUntilTime
     *           Optional. If provided, only returns jobs that completed until (not
     *           including) the given timestamp.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CloudDms\V1\SearchBackgroundJobsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchBackgroundJobs($conversionWorkspace, array $optionalArgs = [])
    {
        $request = new SearchBackgroundJobsRequest();
        $requestParamHeaders = [];
        $request->setConversionWorkspace($conversionWorkspace);
        $requestParamHeaders['conversion_workspace'] = $conversionWorkspace;
        if (isset($optionalArgs['returnMostRecentPerJobType'])) {
            $request->setReturnMostRecentPerJobType($optionalArgs['returnMostRecentPerJobType']);
        }

        if (isset($optionalArgs['maxSize'])) {
            $request->setMaxSize($optionalArgs['maxSize']);
        }

        if (isset($optionalArgs['completedUntilTime'])) {
            $request->setCompletedUntilTime($optionalArgs['completedUntilTime']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SearchBackgroundJobs', SearchBackgroundJobsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Imports a snapshot of the source database into the
     * conversion workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->seedConversionWorkspace();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->seedConversionWorkspace();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'seedConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the conversion workspace resource to seed with new database
     *           structure, in the form of:
     *           projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
     *     @type bool $autoCommit
     *           Should the conversion workspace be committed automatically after the
     *           seed operation.
     *     @type string $sourceConnectionProfile
     *           Optional. Fully qualified (Uri) name of the source connection profile.
     *     @type string $destinationConnectionProfile
     *           Optional. Fully qualified (Uri) name of the destination connection
     *           profile.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function seedConversionWorkspace(array $optionalArgs = [])
    {
        $request = new SeedConversionWorkspaceRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['autoCommit'])) {
            $request->setAutoCommit($optionalArgs['autoCommit']);
        }

        if (isset($optionalArgs['sourceConnectionProfile'])) {
            $request->setSourceConnectionProfile($optionalArgs['sourceConnectionProfile']);
        }

        if (isset($optionalArgs['destinationConnectionProfile'])) {
            $request->setDestinationConnectionProfile($optionalArgs['destinationConnectionProfile']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('SeedConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Start an already created migration job.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->startMigrationJob();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->startMigrationJob();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'startMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the migration job resource to start.
     *     @type bool $skipValidation
     *           Optional. Start the migration job without running prior configuration
     *           verification. Defaults to `false`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startMigrationJob(array $optionalArgs = [])
    {
        $request = new StartMigrationJobRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['skipValidation'])) {
            $request->setSkipValidation($optionalArgs['skipValidation']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('StartMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Stops a running migration job.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->stopMigrationJob();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->stopMigrationJob();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'stopMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the migration job resource to stop.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function stopMigrationJob(array $optionalArgs = [])
    {
        $request = new StopMigrationJobRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('StopMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Update the configuration of a single connection profile.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $connectionProfile = new ConnectionProfile();
     *     $operationResponse = $dataMigrationServiceClient->updateConnectionProfile($updateMask, $connectionProfile);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->updateConnectionProfile($updateMask, $connectionProfile);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'updateConnectionProfile');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask         $updateMask        Required. Field mask is used to specify the fields to be overwritten by the
     *                                             update in the conversion workspace resource.
     * @param ConnectionProfile $connectionProfile Required. The connection profile parameters to update.
     * @param array             $optionalArgs      {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type bool $validateOnly
     *           Optional. Only validate the connection profile, but don't update any
     *           resources. The default is false. Only supported for Oracle connection
     *           profiles.
     *     @type bool $skipValidation
     *           Optional. Update the connection profile without validating it.
     *           The default is false.
     *           Only supported for Oracle connection profiles.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateConnectionProfile($updateMask, $connectionProfile, array $optionalArgs = [])
    {
        $request = new UpdateConnectionProfileRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setConnectionProfile($connectionProfile);
        $requestParamHeaders['connection_profile.name'] = $connectionProfile->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['skipValidation'])) {
            $request->setSkipValidation($optionalArgs['skipValidation']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateConnectionProfile', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single conversion workspace.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $conversionWorkspace = new ConversionWorkspace();
     *     $operationResponse = $dataMigrationServiceClient->updateConversionWorkspace($updateMask, $conversionWorkspace);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->updateConversionWorkspace($updateMask, $conversionWorkspace);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'updateConversionWorkspace');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask           $updateMask          Required. Field mask is used to specify the fields to be overwritten by the
     *                                                 update in the conversion workspace resource.
     * @param ConversionWorkspace $conversionWorkspace Required. The conversion workspace parameters to update.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateConversionWorkspace($updateMask, $conversionWorkspace, array $optionalArgs = [])
    {
        $request = new UpdateConversionWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setConversionWorkspace($conversionWorkspace);
        $requestParamHeaders['conversion_workspace.name'] = $conversionWorkspace->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateConversionWorkspace', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the parameters of a single migration job.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $migrationJob = new MigrationJob();
     *     $operationResponse = $dataMigrationServiceClient->updateMigrationJob($updateMask, $migrationJob);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->updateMigrationJob($updateMask, $migrationJob);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'updateMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask    $updateMask   Required. Field mask is used to specify the fields to be overwritten by the
     *                                   update in the conversion workspace resource.
     * @param MigrationJob $migrationJob Required. The migration job parameters to update.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique ID used to identify the request. If the server receives two
     *           requests with the same ID, then the second request is ignored.
     *
     *           It is recommended to always set this value to a UUID.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateMigrationJob($updateMask, $migrationJob, array $optionalArgs = [])
    {
        $request = new UpdateMigrationJobRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setMigrationJob($migrationJob);
        $requestParamHeaders['migration_job.name'] = $migrationJob->getName();
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Verify a migration job, making sure the destination can reach the source
     * and that all configuration and prerequisites are met.
     *
     * Sample code:
     * ```
     * $dataMigrationServiceClient = new DataMigrationServiceClient();
     * try {
     *     $operationResponse = $dataMigrationServiceClient->verifyMigrationJob();
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataMigrationServiceClient->verifyMigrationJob();
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataMigrationServiceClient->resumeOperation($operationName, 'verifyMigrationJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataMigrationServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the migration job resource to verify.
     *     @type FieldMask $updateMask
     *           Optional. Field mask is used to specify the changed fields to be verified.
     *           It will not update the migration job.
     *     @type MigrationJob $migrationJob
     *           Optional. The changed migration job parameters to verify.
     *           It will not update the migration job.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function verifyMigrationJob(array $optionalArgs = [])
    {
        $request = new VerifyMigrationJobRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['migrationJob'])) {
            $request->setMigrationJob($optionalArgs['migrationJob']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('VerifyMigrationJob', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
