<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/session.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the result of a conversational query.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.QueryResult</code>
 */
class QueryResult extends \Google\Protobuf\Internal\Message
{
    /**
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     *
     * Generated from protobuf field <code>string language_code = 2;</code>
     */
    protected $language_code = '';
    /**
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 3;</code>
     */
    protected $parameters = null;
    /**
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     */
    private $response_messages;
    /**
     * The list of webhook call status in the order of call sequence.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     */
    private $webhook_statuses;
    /**
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     *
     * Generated from protobuf field <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     */
    private $webhook_payloads;
    /**
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     */
    protected $current_page = null;
    /**
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     * @deprecated
     */
    protected $intent = null;
    /**
     * The intent detection confidence. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * This field is deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     *
     * Generated from protobuf field <code>float intent_detection_confidence = 9 [deprecated = true];</code>
     * @deprecated
     */
    protected $intent_detection_confidence = 0.0;
    /**
     * Intent match result, could be an intent or an event.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     */
    protected $match = null;
    /**
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     */
    protected $diagnostic_info = null;
    /**
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;</code>
     */
    protected $sentiment_analysis_result = null;
    /**
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     */
    protected $advanced_settings = null;
    /**
     * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     * shown for the response in the Dialogflow Messenger widget.
     *
     * Generated from protobuf field <code>bool allow_answer_feedback = 32;</code>
     */
    protected $allow_answer_feedback = false;
    protected $query;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $text
     *           If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     *           provided as input, this field will contain a copy of the text.
     *     @type string $trigger_intent
     *           If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     *           input, this field will contain a copy of the intent identifier. Format:
     *           `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/intents/<Intent ID>`.
     *     @type string $transcript
     *           If [natural language speech
     *           audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     *           this field will contain the transcript for the audio.
     *     @type string $trigger_event
     *           If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     *           input, this field will contain the name of the event.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\DtmfInput $dtmf
     *           If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     *           input, this field will contain a copy of the
     *           [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     *     @type string $language_code
     *           The language that was triggered during intent detection.
     *           See [Language
     *           Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     *           for a list of the currently supported language codes.
     *     @type \Google\Protobuf\Struct $parameters
     *           The collected [session
     *           parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     *           Depending on your protocol or client library language, this is a
     *           map, associative array, symbol table, dictionary, or JSON object
     *           composed of a collection of (MapKey, MapValue) pairs:
     *           * MapKey type: string
     *           * MapKey value: parameter name
     *           * MapValue type: If parameter's entity type is a composite entity then use
     *           map, otherwise, depending on the parameter value type, it could be one of
     *           string, number, boolean, null, list or map.
     *           * MapValue value: If parameter's entity type is a composite entity then use
     *           map from composite entity property names to property values, otherwise,
     *           use parameter value.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\ResponseMessage>|\Google\Protobuf\Internal\RepeatedField $response_messages
     *           The list of rich messages returned to the client. Responses vary from
     *           simple text messages to more sophisticated, structured payloads used
     *           to drive complex logic.
     *     @type array<\Google\Rpc\Status>|\Google\Protobuf\Internal\RepeatedField $webhook_statuses
     *           The list of webhook call status in the order of call sequence.
     *     @type array<\Google\Protobuf\Struct>|\Google\Protobuf\Internal\RepeatedField $webhook_payloads
     *           The list of webhook payload in
     *           [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     *           in the order of call sequence. If some webhook call fails or doesn't return
     *           any payload, an empty `Struct` would be used instead.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Page $current_page
     *           The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     *           fields are filled in this message, including but not limited to `name` and
     *           `display_name`.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Intent $intent
     *           The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     *           conversational query. Some, not all fields are filled in this message,
     *           including but not limited to: `name` and `display_name`. This field is
     *           deprecated, please use
     *           [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     *           instead.
     *     @type float $intent_detection_confidence
     *           The intent detection confidence. Values range from 0.0 (completely
     *           uncertain) to 1.0 (completely certain).
     *           This value is for informational purpose only and is only used to
     *           help match the best intent within the classification threshold.
     *           This value may change for the same end-user expression at any time due to a
     *           model retraining or change in implementation.
     *           This field is deprecated, please use
     *           [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     *           instead.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\PBMatch $match
     *           Intent match result, could be an intent or an event.
     *     @type \Google\Protobuf\Struct $diagnostic_info
     *           The free-form diagnostic info. For example, this field could contain
     *           webhook call latency. The fields of this data can change without notice,
     *           so you should not write code that depends on its structure.
     *           One of the fields is called "Alternative Matched Intents", which may
     *           aid with debugging. The following describes these intent results:
     *           - The list is empty if no intent was matched to end-user input.
     *           - Only intents that are referenced in the currently active flow are
     *             included.
     *           - The matched intent is included.
     *           - Other intents that could have matched end-user input, but did not match
     *             because they are referenced by intent routes that are out of
     *             [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *             are included.
     *           - Other intents referenced by intent routes in scope that matched end-user
     *             input, but had a lower confidence score.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\SentimentAnalysisResult $sentiment_analysis_result
     *           The sentiment analyss result, which depends on
     *           [`analyze_query_text_sentiment`]
     *           [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     *           specified in the request.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings $advanced_settings
     *           Returns the current advanced settings including IVR settings. Even though
     *           the operations configured by these settings are performed by Dialogflow,
     *           the client may need to perform special logic at the moment. For example, if
     *           Dialogflow exports audio to Google Cloud Storage, then the client may need
     *           to wait for the resulting object to appear in the bucket before proceeding.
     *     @type bool $allow_answer_feedback
     *           Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     *           shown for the response in the Dialogflow Messenger widget.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Session::initOnce();
        parent::__construct($data);
    }

    /**
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @return string
     */
    public function getText()
    {
        return $this->readOneof(1);
    }

    public function hasText()
    {
        return $this->hasOneof(1);
    }

    /**
     * If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
     * provided as input, this field will contain a copy of the text.
     *
     * Generated from protobuf field <code>string text = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/intents/<Intent ID>`.
     *
     * Generated from protobuf field <code>string trigger_intent = 11 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTriggerIntent()
    {
        return $this->readOneof(11);
    }

    public function hasTriggerIntent()
    {
        return $this->hasOneof(11);
    }

    /**
     * If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
     * input, this field will contain a copy of the intent identifier. Format:
     * `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/intents/<Intent ID>`.
     *
     * Generated from protobuf field <code>string trigger_intent = 11 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTriggerIntent($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     *
     * Generated from protobuf field <code>string transcript = 12;</code>
     * @return string
     */
    public function getTranscript()
    {
        return $this->readOneof(12);
    }

    public function hasTranscript()
    {
        return $this->hasOneof(12);
    }

    /**
     * If [natural language speech
     * audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
     * this field will contain the transcript for the audio.
     *
     * Generated from protobuf field <code>string transcript = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setTranscript($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     *
     * Generated from protobuf field <code>string trigger_event = 14;</code>
     * @return string
     */
    public function getTriggerEvent()
    {
        return $this->readOneof(14);
    }

    public function hasTriggerEvent()
    {
        return $this->hasOneof(14);
    }

    /**
     * If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
     * input, this field will contain the name of the event.
     *
     * Generated from protobuf field <code>string trigger_event = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setTriggerEvent($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\DtmfInput|null
     */
    public function getDtmf()
    {
        return $this->readOneof(23);
    }

    public function hasDtmf()
    {
        return $this->hasOneof(23);
    }

    /**
     * If a [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as
     * input, this field will contain a copy of the
     * [DtmfInput][google.cloud.dialogflow.cx.v3.DtmfInput].
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.DtmfInput dtmf = 23;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\DtmfInput $var
     * @return $this
     */
    public function setDtmf($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\DtmfInput::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     *
     * Generated from protobuf field <code>string language_code = 2;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes.
     *
     * Generated from protobuf field <code>string language_code = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 3;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    public function hasParameters()
    {
        return isset($this->parameters);
    }

    public function clearParameters()
    {
        unset($this->parameters);
    }

    /**
     * The collected [session
     * parameters][google.cloud.dialogflow.cx.v3.SessionInfo.parameters].
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 3;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->parameters = $var;

        return $this;
    }

    /**
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResponseMessages()
    {
        return $this->response_messages;
    }

    /**
     * The list of rich messages returned to the client. Responses vary from
     * simple text messages to more sophisticated, structured payloads used
     * to drive complex logic.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage response_messages = 4;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\ResponseMessage>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResponseMessages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage::class);
        $this->response_messages = $arr;

        return $this;
    }

    /**
     * The list of webhook call status in the order of call sequence.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWebhookStatuses()
    {
        return $this->webhook_statuses;
    }

    /**
     * The list of webhook call status in the order of call sequence.
     *
     * Generated from protobuf field <code>repeated .google.rpc.Status webhook_statuses = 13;</code>
     * @param array<\Google\Rpc\Status>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWebhookStatuses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Rpc\Status::class);
        $this->webhook_statuses = $arr;

        return $this;
    }

    /**
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     *
     * Generated from protobuf field <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWebhookPayloads()
    {
        return $this->webhook_payloads;
    }

    /**
     * The list of webhook payload in
     * [WebhookResponse.payload][google.cloud.dialogflow.cx.v3.WebhookResponse.payload],
     * in the order of call sequence. If some webhook call fails or doesn't return
     * any payload, an empty `Struct` would be used instead.
     *
     * Generated from protobuf field <code>repeated .google.protobuf.Struct webhook_payloads = 6;</code>
     * @param array<\Google\Protobuf\Struct>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWebhookPayloads($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\Struct::class);
        $this->webhook_payloads = $arr;

        return $this;
    }

    /**
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Page|null
     */
    public function getCurrentPage()
    {
        return $this->current_page;
    }

    public function hasCurrentPage()
    {
        return isset($this->current_page);
    }

    public function clearCurrentPage()
    {
        unset($this->current_page);
    }

    /**
     * The current [Page][google.cloud.dialogflow.cx.v3.Page]. Some, not all
     * fields are filled in this message, including but not limited to `name` and
     * `display_name`.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Page current_page = 7;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Page $var
     * @return $this
     */
    public function setCurrentPage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Page::class);
        $this->current_page = $var;

        return $this;
    }

    /**
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Intent|null
     * @deprecated
     */
    public function getIntent()
    {
        @trigger_error('intent is deprecated.', E_USER_DEPRECATED);
        return $this->intent;
    }

    public function hasIntent()
    {
        @trigger_error('intent is deprecated.', E_USER_DEPRECATED);
        return isset($this->intent);
    }

    public function clearIntent()
    {
        @trigger_error('intent is deprecated.', E_USER_DEPRECATED);
        unset($this->intent);
    }

    /**
     * The [Intent][google.cloud.dialogflow.cx.v3.Intent] that matched the
     * conversational query. Some, not all fields are filled in this message,
     * including but not limited to: `name` and `display_name`. This field is
     * deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Intent intent = 8 [deprecated = true];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Intent $var
     * @return $this
     * @deprecated
     */
    public function setIntent($var)
    {
        @trigger_error('intent is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Intent::class);
        $this->intent = $var;

        return $this;
    }

    /**
     * The intent detection confidence. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * This field is deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     *
     * Generated from protobuf field <code>float intent_detection_confidence = 9 [deprecated = true];</code>
     * @return float
     * @deprecated
     */
    public function getIntentDetectionConfidence()
    {
        @trigger_error('intent_detection_confidence is deprecated.', E_USER_DEPRECATED);
        return $this->intent_detection_confidence;
    }

    /**
     * The intent detection confidence. Values range from 0.0 (completely
     * uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * This field is deprecated, please use
     * [QueryResult.match][google.cloud.dialogflow.cx.v3.QueryResult.match]
     * instead.
     *
     * Generated from protobuf field <code>float intent_detection_confidence = 9 [deprecated = true];</code>
     * @param float $var
     * @return $this
     * @deprecated
     */
    public function setIntentDetectionConfidence($var)
    {
        @trigger_error('intent_detection_confidence is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkFloat($var);
        $this->intent_detection_confidence = $var;

        return $this;
    }

    /**
     * Intent match result, could be an intent or an event.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\PBMatch|null
     */
    public function getMatch()
    {
        return $this->match;
    }

    public function hasMatch()
    {
        return isset($this->match);
    }

    public function clearMatch()
    {
        unset($this->match);
    }

    /**
     * Intent match result, could be an intent or an event.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Match match = 15;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\PBMatch $var
     * @return $this
     */
    public function setMatch($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\PBMatch::class);
        $this->match = $var;

        return $this;
    }

    /**
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getDiagnosticInfo()
    {
        return $this->diagnostic_info;
    }

    public function hasDiagnosticInfo()
    {
        return isset($this->diagnostic_info);
    }

    public function clearDiagnosticInfo()
    {
        unset($this->diagnostic_info);
    }

    /**
     * The free-form diagnostic info. For example, this field could contain
     * webhook call latency. The fields of this data can change without notice,
     * so you should not write code that depends on its structure.
     * One of the fields is called "Alternative Matched Intents", which may
     * aid with debugging. The following describes these intent results:
     * - The list is empty if no intent was matched to end-user input.
     * - Only intents that are referenced in the currently active flow are
     *   included.
     * - The matched intent is included.
     * - Other intents that could have matched end-user input, but did not match
     *   because they are referenced by intent routes that are out of
     *   [scope](https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope),
     *   are included.
     * - Other intents referenced by intent routes in scope that matched end-user
     *   input, but had a lower confidence score.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct diagnostic_info = 10;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setDiagnosticInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->diagnostic_info = $var;

        return $this;
    }

    /**
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\SentimentAnalysisResult|null
     */
    public function getSentimentAnalysisResult()
    {
        return $this->sentiment_analysis_result;
    }

    public function hasSentimentAnalysisResult()
    {
        return isset($this->sentiment_analysis_result);
    }

    public function clearSentimentAnalysisResult()
    {
        unset($this->sentiment_analysis_result);
    }

    /**
     * The sentiment analyss result, which depends on
     * [`analyze_query_text_sentiment`]
     * [google.cloud.dialogflow.cx.v3.QueryParameters.analyze_query_text_sentiment],
     * specified in the request.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SentimentAnalysisResult sentiment_analysis_result = 17;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\SentimentAnalysisResult $var
     * @return $this
     */
    public function setSentimentAnalysisResult($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\SentimentAnalysisResult::class);
        $this->sentiment_analysis_result = $var;

        return $this;
    }

    /**
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings|null
     */
    public function getAdvancedSettings()
    {
        return $this->advanced_settings;
    }

    public function hasAdvancedSettings()
    {
        return isset($this->advanced_settings);
    }

    public function clearAdvancedSettings()
    {
        unset($this->advanced_settings);
    }

    /**
     * Returns the current advanced settings including IVR settings. Even though
     * the operations configured by these settings are performed by Dialogflow,
     * the client may need to perform special logic at the moment. For example, if
     * Dialogflow exports audio to Google Cloud Storage, then the client may need
     * to wait for the resulting object to appear in the bucket before proceeding.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 21;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings $var
     * @return $this
     */
    public function setAdvancedSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings::class);
        $this->advanced_settings = $var;

        return $this;
    }

    /**
     * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     * shown for the response in the Dialogflow Messenger widget.
     *
     * Generated from protobuf field <code>bool allow_answer_feedback = 32;</code>
     * @return bool
     */
    public function getAllowAnswerFeedback()
    {
        return $this->allow_answer_feedback;
    }

    /**
     * Indicates whether the Thumbs up/Thumbs down rating controls are need to be
     * shown for the response in the Dialogflow Messenger widget.
     *
     * Generated from protobuf field <code>bool allow_answer_feedback = 32;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAnswerFeedback($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_answer_feedback = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getQuery()
    {
        return $this->whichOneof("query");
    }

}

