<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/intent.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An intent represents a user's intent to interact with a conversational agent.
 * You can provide information for the Dialogflow API to use to match user input
 * to an intent by adding training phrases (i.e., examples of user input) to
 * your intent.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Intent</code>
 */
class Intent extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/intents/<Intent ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The human-readable name of the intent, unique within the agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Intent.TrainingPhrase training_phrases = 3;</code>
     */
    private $training_phrases;
    /**
     * The collection of parameters associated with the intent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Intent.Parameter parameters = 4;</code>
     */
    private $parameters;
    /**
     * The priority of this intent. Higher numbers represent higher
     * priorities.
     * - If the supplied value is unspecified or 0, the service
     *   translates the value to 500,000, which corresponds to the
     *   `Normal` priority in the console.
     * - If the supplied value is negative, the intent is ignored
     *   in runtime detect intent requests.
     *
     * Generated from protobuf field <code>int32 priority = 5;</code>
     */
    protected $priority = 0;
    /**
     * Indicates whether this is a fallback intent. Currently only default
     * fallback intent is allowed in the agent, which is added upon agent
     * creation.
     * Adding training phrases to fallback intent is useful in the case of
     * requests that are mistakenly matched, since training phrases assigned to
     * fallback intents act as negative examples that triggers no-match event.
     *
     * Generated from protobuf field <code>bool is_fallback = 6;</code>
     */
    protected $is_fallback = false;
    /**
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys.contextual" means the intent is a contextual intent.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    /**
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     */
    protected $description = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The unique identifier of the intent.
     *           Required for the
     *           [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3.Intents.UpdateIntent]
     *           method.
     *           [Intents.CreateIntent][google.cloud.dialogflow.cx.v3.Intents.CreateIntent]
     *           populates the name automatically.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/intents/<Intent ID>`.
     *     @type string $display_name
     *           Required. The human-readable name of the intent, unique within the agent.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\Intent\TrainingPhrase>|\Google\Protobuf\Internal\RepeatedField $training_phrases
     *           The collection of training phrases the agent is trained on to identify the
     *           intent.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\Intent\Parameter>|\Google\Protobuf\Internal\RepeatedField $parameters
     *           The collection of parameters associated with the intent.
     *     @type int $priority
     *           The priority of this intent. Higher numbers represent higher
     *           priorities.
     *           - If the supplied value is unspecified or 0, the service
     *             translates the value to 500,000, which corresponds to the
     *             `Normal` priority in the console.
     *           - If the supplied value is negative, the intent is ignored
     *             in runtime detect intent requests.
     *     @type bool $is_fallback
     *           Indicates whether this is a fallback intent. Currently only default
     *           fallback intent is allowed in the agent, which is added upon agent
     *           creation.
     *           Adding training phrases to fallback intent is useful in the case of
     *           requests that are mistakenly matched, since training phrases assigned to
     *           fallback intents act as negative examples that triggers no-match event.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The key/value metadata to label an intent. Labels can contain
     *           lowercase letters, digits and the symbols '-' and '_'. International
     *           characters are allowed, including letters from unicase alphabets. Keys must
     *           start with a letter. Keys and values can be no longer than 63 characters
     *           and no more than 128 bytes.
     *           Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     *           Dialogflow defined labels include:
     *           * sys-head
     *           * sys-contextual
     *           The above labels do not require value. "sys-head" means the intent is a
     *           head intent. "sys.contextual" means the intent is a contextual intent.
     *     @type string $description
     *           Human readable description for better understanding an intent like its
     *           scope, content, result etc. Maximum character limit: 140 characters.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Intent::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/intents/<Intent ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The unique identifier of the intent.
     * Required for the
     * [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3.Intents.UpdateIntent]
     * method.
     * [Intents.CreateIntent][google.cloud.dialogflow.cx.v3.Intents.CreateIntent]
     * populates the name automatically.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/intents/<Intent ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human-readable name of the intent, unique within the agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human-readable name of the intent, unique within the agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Intent.TrainingPhrase training_phrases = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTrainingPhrases()
    {
        return $this->training_phrases;
    }

    /**
     * The collection of training phrases the agent is trained on to identify the
     * intent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Intent.TrainingPhrase training_phrases = 3;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\Intent\TrainingPhrase>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTrainingPhrases($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Intent\TrainingPhrase::class);
        $this->training_phrases = $arr;

        return $this;
    }

    /**
     * The collection of parameters associated with the intent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Intent.Parameter parameters = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    /**
     * The collection of parameters associated with the intent.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Intent.Parameter parameters = 4;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\Intent\Parameter>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setParameters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Intent\Parameter::class);
        $this->parameters = $arr;

        return $this;
    }

    /**
     * The priority of this intent. Higher numbers represent higher
     * priorities.
     * - If the supplied value is unspecified or 0, the service
     *   translates the value to 500,000, which corresponds to the
     *   `Normal` priority in the console.
     * - If the supplied value is negative, the intent is ignored
     *   in runtime detect intent requests.
     *
     * Generated from protobuf field <code>int32 priority = 5;</code>
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * The priority of this intent. Higher numbers represent higher
     * priorities.
     * - If the supplied value is unspecified or 0, the service
     *   translates the value to 500,000, which corresponds to the
     *   `Normal` priority in the console.
     * - If the supplied value is negative, the intent is ignored
     *   in runtime detect intent requests.
     *
     * Generated from protobuf field <code>int32 priority = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setPriority($var)
    {
        GPBUtil::checkInt32($var);
        $this->priority = $var;

        return $this;
    }

    /**
     * Indicates whether this is a fallback intent. Currently only default
     * fallback intent is allowed in the agent, which is added upon agent
     * creation.
     * Adding training phrases to fallback intent is useful in the case of
     * requests that are mistakenly matched, since training phrases assigned to
     * fallback intents act as negative examples that triggers no-match event.
     *
     * Generated from protobuf field <code>bool is_fallback = 6;</code>
     * @return bool
     */
    public function getIsFallback()
    {
        return $this->is_fallback;
    }

    /**
     * Indicates whether this is a fallback intent. Currently only default
     * fallback intent is allowed in the agent, which is added upon agent
     * creation.
     * Adding training phrases to fallback intent is useful in the case of
     * requests that are mistakenly matched, since training phrases assigned to
     * fallback intents act as negative examples that triggers no-match event.
     *
     * Generated from protobuf field <code>bool is_fallback = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsFallback($var)
    {
        GPBUtil::checkBool($var);
        $this->is_fallback = $var;

        return $this;
    }

    /**
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys.contextual" means the intent is a contextual intent.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The key/value metadata to label an intent. Labels can contain
     * lowercase letters, digits and the symbols '-' and '_'. International
     * characters are allowed, including letters from unicase alphabets. Keys must
     * start with a letter. Keys and values can be no longer than 63 characters
     * and no more than 128 bytes.
     * Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
     * Dialogflow defined labels include:
     * * sys-head
     * * sys-contextual
     * The above labels do not require value. "sys-head" means the intent is a
     * head intent. "sys.contextual" means the intent is a contextual intent.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Human readable description for better understanding an intent like its
     * scope, content, result etc. Maximum character limit: 140 characters.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

}

