<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataproc/v1/node_groups.proto

namespace Google\Cloud\Dataproc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to create a node group.
 *
 * Generated from protobuf message <code>google.cloud.dataproc.v1.CreateNodeGroupRequest</code>
 */
class CreateNodeGroupRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource where this node group will be created.
     * Format: `projects/{project}/regions/{region}/clusters/{cluster}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The node group to create.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.NodeGroup node_group = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $node_group = null;
    /**
     * Optional. An optional node group ID. Generated if not specified.
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of from 3 to 33 characters.
     *
     * Generated from protobuf field <code>string node_group_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $node_group_id = '';
    /**
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [CreateNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     *
     * Generated from protobuf field <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $request_id = '';

    /**
     * @param string                              $parent      Required. The parent resource where this node group will be created.
     *                                                         Format: `projects/{project}/regions/{region}/clusters/{cluster}`
     *                                                         Please see {@see NodeGroupControllerClient::clusterRegionName()} for help formatting this field.
     * @param \Google\Cloud\Dataproc\V1\NodeGroup $nodeGroup   Required. The node group to create.
     * @param string                              $nodeGroupId Optional. An optional node group ID. Generated if not specified.
     *
     *                                                         The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *                                                         underscores (_), and hyphens (-). Cannot begin or end with underscore
     *                                                         or hyphen. Must consist of from 3 to 33 characters.
     *
     * @return \Google\Cloud\Dataproc\V1\CreateNodeGroupRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Dataproc\V1\NodeGroup $nodeGroup, string $nodeGroupId): self
    {
        return (new self())
            ->setParent($parent)
            ->setNodeGroup($nodeGroup)
            ->setNodeGroupId($nodeGroupId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource where this node group will be created.
     *           Format: `projects/{project}/regions/{region}/clusters/{cluster}`
     *     @type \Google\Cloud\Dataproc\V1\NodeGroup $node_group
     *           Required. The node group to create.
     *     @type string $node_group_id
     *           Optional. An optional node group ID. Generated if not specified.
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). Cannot begin or end with underscore
     *           or hyphen. Must consist of from 3 to 33 characters.
     *     @type string $request_id
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two
     *           [CreateNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateNodeGroupRequests)
     *           with the same ID, the second request is ignored and the
     *           first [google.longrunning.Operation][google.longrunning.Operation] created
     *           and stored in the backend is returned.
     *           Recommendation: Set this value to a
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). The maximum length is 40 characters.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataproc\V1\NodeGroups::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource where this node group will be created.
     * Format: `projects/{project}/regions/{region}/clusters/{cluster}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource where this node group will be created.
     * Format: `projects/{project}/regions/{region}/clusters/{cluster}`
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The node group to create.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.NodeGroup node_group = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Dataproc\V1\NodeGroup|null
     */
    public function getNodeGroup()
    {
        return $this->node_group;
    }

    public function hasNodeGroup()
    {
        return isset($this->node_group);
    }

    public function clearNodeGroup()
    {
        unset($this->node_group);
    }

    /**
     * Required. The node group to create.
     *
     * Generated from protobuf field <code>.google.cloud.dataproc.v1.NodeGroup node_group = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Dataproc\V1\NodeGroup $var
     * @return $this
     */
    public function setNodeGroup($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataproc\V1\NodeGroup::class);
        $this->node_group = $var;

        return $this;
    }

    /**
     * Optional. An optional node group ID. Generated if not specified.
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of from 3 to 33 characters.
     *
     * Generated from protobuf field <code>string node_group_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNodeGroupId()
    {
        return $this->node_group_id;
    }

    /**
     * Optional. An optional node group ID. Generated if not specified.
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). Cannot begin or end with underscore
     * or hyphen. Must consist of from 3 to 33 characters.
     *
     * Generated from protobuf field <code>string node_group_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNodeGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->node_group_id = $var;

        return $this;
    }

    /**
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [CreateNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     *
     * Generated from protobuf field <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [CreateNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     *
     * Generated from protobuf field <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

