<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/logs.proto

namespace Google\Cloud\Dataplex\V1\DataScanEvent;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Data quality result for data scan job.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.DataScanEvent.DataQualityResult</code>
 */
class DataQualityResult extends \Google\Protobuf\Internal\Message
{
    /**
     * The count of rows processed in the data scan job.
     *
     * Generated from protobuf field <code>int64 row_count = 1;</code>
     */
    private $row_count = 0;
    /**
     * Whether the data quality result was `pass` or not.
     *
     * Generated from protobuf field <code>bool passed = 2;</code>
     */
    private $passed = false;
    /**
     * The result of each dimension for data quality result.
     * The key of the map is the name of the dimension.
     * The value is the bool value depicting whether the dimension result was
     * `pass` or not.
     *
     * Generated from protobuf field <code>map<string, bool> dimension_passed = 3;</code>
     */
    private $dimension_passed;
    /**
     * The table-level data quality score for the data scan job.
     * The data quality score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>float score = 4;</code>
     */
    private $score = 0.0;
    /**
     * The score of each dimension for data quality result.
     * The key of the map is the name of the dimension.
     * The value is the data quality score for the dimension.
     * The score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>map<string, float> dimension_score = 5;</code>
     */
    private $dimension_score;
    /**
     * The score of each column scanned in the data scan job.
     * The key of the map is the name of the column.
     * The value is the data quality score for the column.
     * The score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>map<string, float> column_score = 6;</code>
     */
    private $column_score;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $row_count
     *           The count of rows processed in the data scan job.
     *     @type bool $passed
     *           Whether the data quality result was `pass` or not.
     *     @type array|\Google\Protobuf\Internal\MapField $dimension_passed
     *           The result of each dimension for data quality result.
     *           The key of the map is the name of the dimension.
     *           The value is the bool value depicting whether the dimension result was
     *           `pass` or not.
     *     @type float $score
     *           The table-level data quality score for the data scan job.
     *           The data quality score ranges between [0, 100] (up to two decimal
     *           points).
     *     @type array|\Google\Protobuf\Internal\MapField $dimension_score
     *           The score of each dimension for data quality result.
     *           The key of the map is the name of the dimension.
     *           The value is the data quality score for the dimension.
     *           The score ranges between [0, 100] (up to two decimal
     *           points).
     *     @type array|\Google\Protobuf\Internal\MapField $column_score
     *           The score of each column scanned in the data scan job.
     *           The key of the map is the name of the column.
     *           The value is the data quality score for the column.
     *           The score ranges between [0, 100] (up to two decimal
     *           points).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Logs::initOnce();
        parent::__construct($data);
    }

    /**
     * The count of rows processed in the data scan job.
     *
     * Generated from protobuf field <code>int64 row_count = 1;</code>
     * @return int|string
     */
    public function getRowCount()
    {
        return $this->row_count;
    }

    /**
     * The count of rows processed in the data scan job.
     *
     * Generated from protobuf field <code>int64 row_count = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setRowCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->row_count = $var;

        return $this;
    }

    /**
     * Whether the data quality result was `pass` or not.
     *
     * Generated from protobuf field <code>bool passed = 2;</code>
     * @return bool
     */
    public function getPassed()
    {
        return $this->passed;
    }

    /**
     * Whether the data quality result was `pass` or not.
     *
     * Generated from protobuf field <code>bool passed = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setPassed($var)
    {
        GPBUtil::checkBool($var);
        $this->passed = $var;

        return $this;
    }

    /**
     * The result of each dimension for data quality result.
     * The key of the map is the name of the dimension.
     * The value is the bool value depicting whether the dimension result was
     * `pass` or not.
     *
     * Generated from protobuf field <code>map<string, bool> dimension_passed = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getDimensionPassed()
    {
        return $this->dimension_passed;
    }

    /**
     * The result of each dimension for data quality result.
     * The key of the map is the name of the dimension.
     * The value is the bool value depicting whether the dimension result was
     * `pass` or not.
     *
     * Generated from protobuf field <code>map<string, bool> dimension_passed = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setDimensionPassed($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::BOOL);
        $this->dimension_passed = $arr;

        return $this;
    }

    /**
     * The table-level data quality score for the data scan job.
     * The data quality score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>float score = 4;</code>
     * @return float
     */
    public function getScore()
    {
        return $this->score;
    }

    /**
     * The table-level data quality score for the data scan job.
     * The data quality score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>float score = 4;</code>
     * @param float $var
     * @return $this
     */
    public function setScore($var)
    {
        GPBUtil::checkFloat($var);
        $this->score = $var;

        return $this;
    }

    /**
     * The score of each dimension for data quality result.
     * The key of the map is the name of the dimension.
     * The value is the data quality score for the dimension.
     * The score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>map<string, float> dimension_score = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getDimensionScore()
    {
        return $this->dimension_score;
    }

    /**
     * The score of each dimension for data quality result.
     * The key of the map is the name of the dimension.
     * The value is the data quality score for the dimension.
     * The score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>map<string, float> dimension_score = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setDimensionScore($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::FLOAT);
        $this->dimension_score = $arr;

        return $this;
    }

    /**
     * The score of each column scanned in the data scan job.
     * The key of the map is the name of the column.
     * The value is the data quality score for the column.
     * The score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>map<string, float> column_score = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getColumnScore()
    {
        return $this->column_score;
    }

    /**
     * The score of each column scanned in the data scan job.
     * The key of the map is the name of the column.
     * The value is the data quality score for the column.
     * The score ranges between [0, 100] (up to two decimal
     * points).
     *
     * Generated from protobuf field <code>map<string, float> column_score = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setColumnScore($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::FLOAT);
        $this->column_score = $arr;

        return $this;
    }

}


