<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/service.proto

namespace Google\Cloud\Dataplex\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Create zone request.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.CreateZoneRequest</code>
 */
class CreateZoneRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the parent lake:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. Zone identifier.
     * This ID will be used to generate names such as database and dataset names
     * when publishing metadata to Hive Metastore and BigQuery.
     * * Must contain only lowercase letters, numbers and hyphens.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * * Must be between 1-63 characters.
     * * Must be unique across all lakes from all locations in a project.
     * * Must not be one of the reserved IDs (i.e. "default", "global-temp")
     *
     * Generated from protobuf field <code>string zone_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $zone_id = '';
    /**
     * Required. Zone resource.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Zone zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $zone = null;
    /**
     * Optional. Only validate the request, but do not perform mutations.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $validate_only = false;

    /**
     * @param string                         $parent Required. The resource name of the parent lake:
     *                                               `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`. Please see
     *                                               {@see DataplexServiceClient::lakeName()} for help formatting this field.
     * @param \Google\Cloud\Dataplex\V1\Zone $zone   Required. Zone resource.
     * @param string                         $zoneId Required. Zone identifier.
     *                                               This ID will be used to generate names such as database and dataset names
     *                                               when publishing metadata to Hive Metastore and BigQuery.
     *                                               * Must contain only lowercase letters, numbers and hyphens.
     *                                               * Must start with a letter.
     *                                               * Must end with a number or a letter.
     *                                               * Must be between 1-63 characters.
     *                                               * Must be unique across all lakes from all locations in a project.
     *                                               * Must not be one of the reserved IDs (i.e. "default", "global-temp")
     *
     * @return \Google\Cloud\Dataplex\V1\CreateZoneRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Dataplex\V1\Zone $zone, string $zoneId): self
    {
        return (new self())
            ->setParent($parent)
            ->setZone($zone)
            ->setZoneId($zoneId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the parent lake:
     *           `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *     @type string $zone_id
     *           Required. Zone identifier.
     *           This ID will be used to generate names such as database and dataset names
     *           when publishing metadata to Hive Metastore and BigQuery.
     *           * Must contain only lowercase letters, numbers and hyphens.
     *           * Must start with a letter.
     *           * Must end with a number or a letter.
     *           * Must be between 1-63 characters.
     *           * Must be unique across all lakes from all locations in a project.
     *           * Must not be one of the reserved IDs (i.e. "default", "global-temp")
     *     @type \Google\Cloud\Dataplex\V1\Zone $zone
     *           Required. Zone resource.
     *     @type bool $validate_only
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the parent lake:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the parent lake:
     * `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. Zone identifier.
     * This ID will be used to generate names such as database and dataset names
     * when publishing metadata to Hive Metastore and BigQuery.
     * * Must contain only lowercase letters, numbers and hyphens.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * * Must be between 1-63 characters.
     * * Must be unique across all lakes from all locations in a project.
     * * Must not be one of the reserved IDs (i.e. "default", "global-temp")
     *
     * Generated from protobuf field <code>string zone_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getZoneId()
    {
        return $this->zone_id;
    }

    /**
     * Required. Zone identifier.
     * This ID will be used to generate names such as database and dataset names
     * when publishing metadata to Hive Metastore and BigQuery.
     * * Must contain only lowercase letters, numbers and hyphens.
     * * Must start with a letter.
     * * Must end with a number or a letter.
     * * Must be between 1-63 characters.
     * * Must be unique across all lakes from all locations in a project.
     * * Must not be one of the reserved IDs (i.e. "default", "global-temp")
     *
     * Generated from protobuf field <code>string zone_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setZoneId($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone_id = $var;

        return $this;
    }

    /**
     * Required. Zone resource.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Zone zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Dataplex\V1\Zone|null
     */
    public function getZone()
    {
        return $this->zone;
    }

    public function hasZone()
    {
        return isset($this->zone);
    }

    public function clearZone()
    {
        unset($this->zone);
    }

    /**
     * Required. Zone resource.
     *
     * Generated from protobuf field <code>.google.cloud.dataplex.v1.Zone zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Dataplex\V1\Zone $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataplex\V1\Zone::class);
        $this->zone = $var;

        return $this;
    }

    /**
     * Optional. Only validate the request, but do not perform mutations.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. Only validate the request, but do not perform mutations.
     * The default is false.
     *
     * Generated from protobuf field <code>bool validate_only = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

}

