<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datafusion/v1/datafusion.proto

namespace Google\Cloud\DataFusion\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Network configuration for a Data Fusion instance. These configurations
 * are used for peering with the customer network. Configurations are optional
 * when a public Data Fusion instance is to be created. However, providing
 * these configurations allows several benefits, such as reduced network latency
 * while accessing the customer resources from managed Data Fusion instance
 * nodes, as well as access to the customer on-prem resources.
 *
 * Generated from protobuf message <code>google.cloud.datafusion.v1.NetworkConfig</code>
 */
class NetworkConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the network in the customer project with which the Tenant Project
     * will be peered for executing pipelines. In case of shared VPC where the
     * network resides in another host project the network should specified in
     * the form of projects/{host-project-id}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 1;</code>
     */
    private $network = '';
    /**
     * The IP range in CIDR notation to use for the managed Data Fusion instance
     * nodes. This range must not overlap with any other ranges used in the
     * customer network.
     *
     * Generated from protobuf field <code>string ip_allocation = 2;</code>
     */
    private $ip_allocation = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $network
     *           Name of the network in the customer project with which the Tenant Project
     *           will be peered for executing pipelines. In case of shared VPC where the
     *           network resides in another host project the network should specified in
     *           the form of projects/{host-project-id}/global/networks/{network}
     *     @type string $ip_allocation
     *           The IP range in CIDR notation to use for the managed Data Fusion instance
     *           nodes. This range must not overlap with any other ranges used in the
     *           customer network.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datafusion\V1\Datafusion::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the network in the customer project with which the Tenant Project
     * will be peered for executing pipelines. In case of shared VPC where the
     * network resides in another host project the network should specified in
     * the form of projects/{host-project-id}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 1;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Name of the network in the customer project with which the Tenant Project
     * will be peered for executing pipelines. In case of shared VPC where the
     * network resides in another host project the network should specified in
     * the form of projects/{host-project-id}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * The IP range in CIDR notation to use for the managed Data Fusion instance
     * nodes. This range must not overlap with any other ranges used in the
     * customer network.
     *
     * Generated from protobuf field <code>string ip_allocation = 2;</code>
     * @return string
     */
    public function getIpAllocation()
    {
        return $this->ip_allocation;
    }

    /**
     * The IP range in CIDR notation to use for the managed Data Fusion instance
     * nodes. This range must not overlap with any other ranges used in the
     * customer network.
     *
     * Generated from protobuf field <code>string ip_allocation = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setIpAllocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_allocation = $var;

        return $this;
    }

}

