<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/compute/v1/compute.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Compute\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Compute\V1\AddAccessConfigInstanceRequest;
use Google\Cloud\Compute\V1\AddResourcePoliciesInstanceRequest;
use Google\Cloud\Compute\V1\AggregatedListInstancesRequest;
use Google\Cloud\Compute\V1\AttachDiskInstanceRequest;
use Google\Cloud\Compute\V1\BulkInsertInstanceRequest;
use Google\Cloud\Compute\V1\DeleteAccessConfigInstanceRequest;
use Google\Cloud\Compute\V1\DeleteInstanceRequest;
use Google\Cloud\Compute\V1\DetachDiskInstanceRequest;
use Google\Cloud\Compute\V1\GetEffectiveFirewallsInstanceRequest;
use Google\Cloud\Compute\V1\GetGuestAttributesInstanceRequest;
use Google\Cloud\Compute\V1\GetIamPolicyInstanceRequest;
use Google\Cloud\Compute\V1\GetInstanceRequest;
use Google\Cloud\Compute\V1\GetScreenshotInstanceRequest;
use Google\Cloud\Compute\V1\GetSerialPortOutputInstanceRequest;
use Google\Cloud\Compute\V1\GetShieldedInstanceIdentityInstanceRequest;
use Google\Cloud\Compute\V1\GuestAttributes;
use Google\Cloud\Compute\V1\InsertInstanceRequest;
use Google\Cloud\Compute\V1\Instance;
use Google\Cloud\Compute\V1\InstancesGetEffectiveFirewallsResponse;
use Google\Cloud\Compute\V1\ListInstancesRequest;
use Google\Cloud\Compute\V1\ListReferrersInstancesRequest;
use Google\Cloud\Compute\V1\Policy;
use Google\Cloud\Compute\V1\RemoveResourcePoliciesInstanceRequest;
use Google\Cloud\Compute\V1\ResetInstanceRequest;
use Google\Cloud\Compute\V1\ResumeInstanceRequest;
use Google\Cloud\Compute\V1\Screenshot;
use Google\Cloud\Compute\V1\SendDiagnosticInterruptInstanceRequest;
use Google\Cloud\Compute\V1\SendDiagnosticInterruptInstanceResponse;
use Google\Cloud\Compute\V1\SerialPortOutput;
use Google\Cloud\Compute\V1\SetDeletionProtectionInstanceRequest;
use Google\Cloud\Compute\V1\SetDiskAutoDeleteInstanceRequest;
use Google\Cloud\Compute\V1\SetIamPolicyInstanceRequest;
use Google\Cloud\Compute\V1\SetLabelsInstanceRequest;
use Google\Cloud\Compute\V1\SetMachineResourcesInstanceRequest;
use Google\Cloud\Compute\V1\SetMachineTypeInstanceRequest;
use Google\Cloud\Compute\V1\SetMetadataInstanceRequest;
use Google\Cloud\Compute\V1\SetMinCpuPlatformInstanceRequest;
use Google\Cloud\Compute\V1\SetNameInstanceRequest;
use Google\Cloud\Compute\V1\SetSchedulingInstanceRequest;
use Google\Cloud\Compute\V1\SetSecurityPolicyInstanceRequest;
use Google\Cloud\Compute\V1\SetServiceAccountInstanceRequest;
use Google\Cloud\Compute\V1\SetShieldedInstanceIntegrityPolicyInstanceRequest;
use Google\Cloud\Compute\V1\SetTagsInstanceRequest;
use Google\Cloud\Compute\V1\ShieldedInstanceIdentity;
use Google\Cloud\Compute\V1\SimulateMaintenanceEventInstanceRequest;
use Google\Cloud\Compute\V1\StartInstanceRequest;
use Google\Cloud\Compute\V1\StartWithEncryptionKeyInstanceRequest;
use Google\Cloud\Compute\V1\StopInstanceRequest;
use Google\Cloud\Compute\V1\SuspendInstanceRequest;
use Google\Cloud\Compute\V1\TestIamPermissionsInstanceRequest;
use Google\Cloud\Compute\V1\TestPermissionsResponse;
use Google\Cloud\Compute\V1\UpdateAccessConfigInstanceRequest;
use Google\Cloud\Compute\V1\UpdateDisplayDeviceInstanceRequest;
use Google\Cloud\Compute\V1\UpdateInstanceRequest;
use Google\Cloud\Compute\V1\UpdateNetworkInterfaceInstanceRequest;
use Google\Cloud\Compute\V1\UpdateShieldedInstanceConfigInstanceRequest;
use Google\Cloud\Compute\V1\ZoneOperationsClient;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The Instances API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * @method PromiseInterface addAccessConfigAsync(AddAccessConfigInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface addResourcePoliciesAsync(AddResourcePoliciesInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface aggregatedListAsync(AggregatedListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface attachDiskAsync(AttachDiskInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface bulkInsertAsync(BulkInsertInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAccessConfigAsync(DeleteAccessConfigInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface detachDiskAsync(DetachDiskInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEffectiveFirewallsAsync(GetEffectiveFirewallsInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGuestAttributesAsync(GetGuestAttributesInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getScreenshotAsync(GetScreenshotInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSerialPortOutputAsync(GetSerialPortOutputInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getShieldedInstanceIdentityAsync(GetShieldedInstanceIdentityInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface insertAsync(InsertInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listReferrersAsync(ListReferrersInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface removeResourcePoliciesAsync(RemoveResourcePoliciesInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resetAsync(ResetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resumeAsync(ResumeInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface sendDiagnosticInterruptAsync(SendDiagnosticInterruptInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setDeletionProtectionAsync(SetDeletionProtectionInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setDiskAutoDeleteAsync(SetDiskAutoDeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setLabelsAsync(SetLabelsInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMachineResourcesAsync(SetMachineResourcesInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMachineTypeAsync(SetMachineTypeInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMetadataAsync(SetMetadataInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setMinCpuPlatformAsync(SetMinCpuPlatformInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setNameAsync(SetNameInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setSchedulingAsync(SetSchedulingInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setSecurityPolicyAsync(SetSecurityPolicyInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setServiceAccountAsync(SetServiceAccountInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setShieldedInstanceIntegrityPolicyAsync(SetShieldedInstanceIntegrityPolicyInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setTagsAsync(SetTagsInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface simulateMaintenanceEventAsync(SimulateMaintenanceEventInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startAsync(StartInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startWithEncryptionKeyAsync(StartWithEncryptionKeyInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface stopAsync(StopInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface suspendAsync(SuspendInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAsync(UpdateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAccessConfigAsync(UpdateAccessConfigInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDisplayDeviceAsync(UpdateDisplayDeviceInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateNetworkInterfaceAsync(UpdateNetworkInterfaceInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateShieldedInstanceConfigAsync(UpdateShieldedInstanceConfigInstanceRequest $request, array $optionalArgs = [])
 */
final class InstancesClient
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.compute.v1.Instances';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'compute.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'compute.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/compute',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/instances_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/instances_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/instances_rest_client_config.php',
                ],
            ],
            'operationsClientClass' => ZoneOperationsClient::class,
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements GapicClientTrait::getSupportedTransports. */
    private static function getSupportedTransports()
    {
        return [
            'rest',
        ];
    }

    /**
     * Return an ZoneOperationsClient object with the same endpoint as $this.
     *
     * @return ZoneOperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /** Return the default longrunning operation descriptor config. */
    private function getDefaultOperationDescriptor()
    {
        return [
            'additionalArgumentMethods' => [
                'getProject',
                'getZone',
            ],
            'getOperationMethod' => 'get',
            'cancelOperationMethod' => null,
            'deleteOperationMethod' => 'delete',
            'operationErrorCodeMethod' => 'getHttpErrorStatusCode',
            'operationErrorMessageMethod' => 'getHttpErrorMessage',
            'operationNameMethod' => 'getName',
            'operationStatusMethod' => 'getStatus',
            'operationStatusDoneValue' => \Google\Cloud\Compute\V1\Operation\Status::DONE,
        ];
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : $this->getDefaultOperationDescriptor();
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'compute.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds an access config to an instance's network interface.
     *
     * The async variant is {@see InstancesClient::addAccessConfigAsync()} .
     *
     * @param AddAccessConfigInstanceRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addAccessConfig(AddAccessConfigInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AddAccessConfig', $request, $callOptions)->wait();
    }

    /**
     * Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.
     *
     * The async variant is {@see InstancesClient::addResourcePoliciesAsync()} .
     *
     * @param AddResourcePoliciesInstanceRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addResourcePolicies(AddResourcePoliciesInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AddResourcePolicies', $request, $callOptions)->wait();
    }

    /**
     * Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances.
     *
     * The async variant is {@see InstancesClient::aggregatedListAsync()} .
     *
     * @param AggregatedListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function aggregatedList(AggregatedListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('AggregatedList', $request, $callOptions);
    }

    /**
     * Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.
     *
     * The async variant is {@see InstancesClient::attachDiskAsync()} .
     *
     * @param AttachDiskInstanceRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function attachDisk(AttachDiskInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AttachDisk', $request, $callOptions)->wait();
    }

    /**
     * Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.
     *
     * The async variant is {@see InstancesClient::bulkInsertAsync()} .
     *
     * @param BulkInsertInstanceRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function bulkInsert(BulkInsertInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BulkInsert', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified Instance resource. For more information, see Deleting an instance.
     *
     * The async variant is {@see InstancesClient::deleteAsync()} .
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function delete(DeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Delete', $request, $callOptions)->wait();
    }

    /**
     * Deletes an access config from an instance's network interface.
     *
     * The async variant is {@see InstancesClient::deleteAccessConfigAsync()} .
     *
     * @param DeleteAccessConfigInstanceRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAccessConfig(DeleteAccessConfigInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAccessConfig', $request, $callOptions)->wait();
    }

    /**
     * Detaches a disk from an instance.
     *
     * The async variant is {@see InstancesClient::detachDiskAsync()} .
     *
     * @param DetachDiskInstanceRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function detachDisk(DetachDiskInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DetachDisk', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified Instance resource.
     *
     * The async variant is {@see InstancesClient::getAsync()} .
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function get(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('Get', $request, $callOptions)->wait();
    }

    /**
     * Returns effective firewalls applied to an interface of the instance.
     *
     * The async variant is {@see InstancesClient::getEffectiveFirewallsAsync()} .
     *
     * @param GetEffectiveFirewallsInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstancesGetEffectiveFirewallsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEffectiveFirewalls(GetEffectiveFirewallsInstanceRequest $request, array $callOptions = []): InstancesGetEffectiveFirewallsResponse
    {
        return $this->startApiCall('GetEffectiveFirewalls', $request, $callOptions)->wait();
    }

    /**
     * Returns the specified guest attributes entry.
     *
     * The async variant is {@see InstancesClient::getGuestAttributesAsync()} .
     *
     * @param GetGuestAttributesInstanceRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GuestAttributes
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGuestAttributes(GetGuestAttributesInstanceRequest $request, array $callOptions = []): GuestAttributes
    {
        return $this->startApiCall('GetGuestAttributes', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource. May be empty if no such policy or resource exists.
     *
     * The async variant is {@see InstancesClient::getIamPolicyAsync()} .
     *
     * @param GetIamPolicyInstanceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyInstanceRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns the screenshot from the specified instance.
     *
     * The async variant is {@see InstancesClient::getScreenshotAsync()} .
     *
     * @param GetScreenshotInstanceRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Screenshot
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getScreenshot(GetScreenshotInstanceRequest $request, array $callOptions = []): Screenshot
    {
        return $this->startApiCall('GetScreenshot', $request, $callOptions)->wait();
    }

    /**
     * Returns the last 1 MB of serial port output from the specified instance.
     *
     * The async variant is {@see InstancesClient::getSerialPortOutputAsync()} .
     *
     * @param GetSerialPortOutputInstanceRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SerialPortOutput
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSerialPortOutput(GetSerialPortOutputInstanceRequest $request, array $callOptions = []): SerialPortOutput
    {
        return $this->startApiCall('GetSerialPortOutput', $request, $callOptions)->wait();
    }

    /**
     * Returns the Shielded Instance Identity of an instance
     *
     * The async variant is {@see InstancesClient::getShieldedInstanceIdentityAsync()}
     * .
     *
     * @param GetShieldedInstanceIdentityInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ShieldedInstanceIdentity
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getShieldedInstanceIdentity(GetShieldedInstanceIdentityInstanceRequest $request, array $callOptions = []): ShieldedInstanceIdentity
    {
        return $this->startApiCall('GetShieldedInstanceIdentity', $request, $callOptions)->wait();
    }

    /**
     * Creates an instance resource in the specified project using the data included in the request.
     *
     * The async variant is {@see InstancesClient::insertAsync()} .
     *
     * @param InsertInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function insert(InsertInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Insert', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the list of instances contained within the specified zone.
     *
     * The async variant is {@see InstancesClient::listAsync()} .
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function list(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('List', $request, $callOptions);
    }

    /**
     * Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.
     *
     * The async variant is {@see InstancesClient::listReferrersAsync()} .
     *
     * @param ListReferrersInstancesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReferrers(ListReferrersInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReferrers', $request, $callOptions);
    }

    /**
     * Removes resource policies from an instance.
     *
     * The async variant is {@see InstancesClient::removeResourcePoliciesAsync()} .
     *
     * @param RemoveResourcePoliciesInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeResourcePolicies(RemoveResourcePoliciesInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RemoveResourcePolicies', $request, $callOptions)->wait();
    }

    /**
     * Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.
     *
     * The async variant is {@see InstancesClient::resetAsync()} .
     *
     * @param ResetInstanceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reset(ResetInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Reset', $request, $callOptions)->wait();
    }

    /**
     * Resumes an instance that was suspended using the instances().suspend method.
     *
     * The async variant is {@see InstancesClient::resumeAsync()} .
     *
     * @param ResumeInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resume(ResumeInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Resume', $request, $callOptions)->wait();
    }

    /**
     * Sends diagnostic interrupt to the instance.
     *
     * The async variant is {@see InstancesClient::sendDiagnosticInterruptAsync()} .
     *
     * @param SendDiagnosticInterruptInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SendDiagnosticInterruptInstanceResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function sendDiagnosticInterrupt(SendDiagnosticInterruptInstanceRequest $request, array $callOptions = []): SendDiagnosticInterruptInstanceResponse
    {
        return $this->startApiCall('SendDiagnosticInterrupt', $request, $callOptions)->wait();
    }

    /**
     * Sets deletion protection on the instance.
     *
     * The async variant is {@see InstancesClient::setDeletionProtectionAsync()} .
     *
     * @param SetDeletionProtectionInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setDeletionProtection(SetDeletionProtectionInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetDeletionProtection', $request, $callOptions)->wait();
    }

    /**
     * Sets the auto-delete flag for a disk attached to an instance.
     *
     * The async variant is {@see InstancesClient::setDiskAutoDeleteAsync()} .
     *
     * @param SetDiskAutoDeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setDiskAutoDelete(SetDiskAutoDeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetDiskAutoDelete', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy.
     *
     * The async variant is {@see InstancesClient::setIamPolicyAsync()} .
     *
     * @param SetIamPolicyInstanceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyInstanceRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.
     *
     * The async variant is {@see InstancesClient::setLabelsAsync()} .
     *
     * @param SetLabelsInstanceRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setLabels(SetLabelsInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetLabels', $request, $callOptions)->wait();
    }

    /**
     * Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.
     *
     * The async variant is {@see InstancesClient::setMachineResourcesAsync()} .
     *
     * @param SetMachineResourcesInstanceRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMachineResources(SetMachineResourcesInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetMachineResources', $request, $callOptions)->wait();
    }

    /**
     * Changes the machine type for a stopped instance to the machine type specified in the request.
     *
     * The async variant is {@see InstancesClient::setMachineTypeAsync()} .
     *
     * @param SetMachineTypeInstanceRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMachineType(SetMachineTypeInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetMachineType', $request, $callOptions)->wait();
    }

    /**
     * Sets metadata for the specified instance to the data included in the request.
     *
     * The async variant is {@see InstancesClient::setMetadataAsync()} .
     *
     * @param SetMetadataInstanceRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMetadata(SetMetadataInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetMetadata', $request, $callOptions)->wait();
    }

    /**
     * Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.
     *
     * The async variant is {@see InstancesClient::setMinCpuPlatformAsync()} .
     *
     * @param SetMinCpuPlatformInstanceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setMinCpuPlatform(SetMinCpuPlatformInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetMinCpuPlatform', $request, $callOptions)->wait();
    }

    /**
     * Sets name of an instance.
     *
     * The async variant is {@see InstancesClient::setNameAsync()} .
     *
     * @param SetNameInstanceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setName(SetNameInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetName', $request, $callOptions)->wait();
    }

    /**
     * Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.
     *
     * The async variant is {@see InstancesClient::setSchedulingAsync()} .
     *
     * @param SetSchedulingInstanceRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setScheduling(SetSchedulingInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetScheduling', $request, $callOptions)->wait();
    }

    /**
     * Sets the Google Cloud Armor security policy for the specified instance. For more information, see Google Cloud Armor Overview
     *
     * The async variant is {@see InstancesClient::setSecurityPolicyAsync()} .
     *
     * @param SetSecurityPolicyInstanceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setSecurityPolicy(SetSecurityPolicyInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetSecurityPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.
     *
     * The async variant is {@see InstancesClient::setServiceAccountAsync()} .
     *
     * @param SetServiceAccountInstanceRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setServiceAccount(SetServiceAccountInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetServiceAccount', $request, $callOptions)->wait();
    }

    /**
     * Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * The async variant is
     * {@see InstancesClient::setShieldedInstanceIntegrityPolicyAsync()} .
     *
     * @param SetShieldedInstanceIntegrityPolicyInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setShieldedInstanceIntegrityPolicy(SetShieldedInstanceIntegrityPolicyInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetShieldedInstanceIntegrityPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets network tags for the specified instance to the data included in the request.
     *
     * The async variant is {@see InstancesClient::setTagsAsync()} .
     *
     * @param SetTagsInstanceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setTags(SetTagsInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetTags', $request, $callOptions)->wait();
    }

    /**
     * Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.
     *
     * The async variant is {@see InstancesClient::simulateMaintenanceEventAsync()} .
     *
     * @param SimulateMaintenanceEventInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function simulateMaintenanceEvent(SimulateMaintenanceEventInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SimulateMaintenanceEvent', $request, $callOptions)->wait();
    }

    /**
     * Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
     *
     * The async variant is {@see InstancesClient::startAsync()} .
     *
     * @param StartInstanceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function start(StartInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Start', $request, $callOptions)->wait();
    }

    /**
     * Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
     *
     * The async variant is {@see InstancesClient::startWithEncryptionKeyAsync()} .
     *
     * @param StartWithEncryptionKeyInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startWithEncryptionKey(StartWithEncryptionKeyInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StartWithEncryptionKey', $request, $callOptions)->wait();
    }

    /**
     * Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.
     *
     * The async variant is {@see InstancesClient::stopAsync()} .
     *
     * @param StopInstanceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stop(StopInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Stop', $request, $callOptions)->wait();
    }

    /**
     * This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.
     *
     * The async variant is {@see InstancesClient::suspendAsync()} .
     *
     * @param SuspendInstanceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function suspend(SuspendInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Suspend', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * The async variant is {@see InstancesClient::testIamPermissionsAsync()} .
     *
     * @param TestIamPermissionsInstanceRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsInstanceRequest $request, array $callOptions = []): TestPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.
     *
     * The async variant is {@see InstancesClient::updateAsync()} .
     *
     * @param UpdateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function update(UpdateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('Update', $request, $callOptions)->wait();
    }

    /**
     * Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * The async variant is {@see InstancesClient::updateAccessConfigAsync()} .
     *
     * @param UpdateAccessConfigInstanceRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAccessConfig(UpdateAccessConfigInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAccessConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * The async variant is {@see InstancesClient::updateDisplayDeviceAsync()} .
     *
     * @param UpdateDisplayDeviceInstanceRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDisplayDevice(UpdateDisplayDeviceInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDisplayDevice', $request, $callOptions)->wait();
    }

    /**
     * Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.
     *
     * The async variant is {@see InstancesClient::updateNetworkInterfaceAsync()} .
     *
     * @param UpdateNetworkInterfaceInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateNetworkInterface(UpdateNetworkInterfaceInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateNetworkInterface', $request, $callOptions)->wait();
    }

    /**
     * Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * The async variant is {@see InstancesClient::updateShieldedInstanceConfigAsync()}
     * .
     *
     * @param UpdateShieldedInstanceConfigInstanceRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateShieldedInstanceConfig(UpdateShieldedInstanceConfigInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateShieldedInstanceConfig', $request, $callOptions)->wait();
    }
}
