<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/storage/v1/storage.proto

namespace Google\Cloud\BigQuery\Storage\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Response from calling `ReadRows` may include row data, progress and
 * throttling information.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.storage.v1.ReadRowsResponse</code>
 */
class ReadRowsResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * Number of serialized rows in the rows block.
     *
     * Generated from protobuf field <code>int64 row_count = 6;</code>
     */
    private $row_count = 0;
    /**
     * Statistics for the stream.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     */
    private $stats = null;
    /**
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     */
    private $throttle_state = null;
    /**
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     *
     * Generated from protobuf field <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $uncompressed_byte_size = null;
    protected $rows;
    protected $schema;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\BigQuery\Storage\V1\AvroRows $avro_rows
     *           Serialized row data in AVRO format.
     *     @type \Google\Cloud\BigQuery\Storage\V1\ArrowRecordBatch $arrow_record_batch
     *           Serialized row data in Arrow RecordBatch format.
     *     @type int|string $row_count
     *           Number of serialized rows in the rows block.
     *     @type \Google\Cloud\BigQuery\Storage\V1\StreamStats $stats
     *           Statistics for the stream.
     *     @type \Google\Cloud\BigQuery\Storage\V1\ThrottleState $throttle_state
     *           Throttling state. If unset, the latest response still describes
     *           the current throttling status.
     *     @type \Google\Cloud\BigQuery\Storage\V1\AvroSchema $avro_schema
     *           Output only. Avro schema.
     *     @type \Google\Cloud\BigQuery\Storage\V1\ArrowSchema $arrow_schema
     *           Output only. Arrow schema.
     *     @type int|string $uncompressed_byte_size
     *           Optional. If the row data in this ReadRowsResponse is compressed, then
     *           uncompressed byte size is the original size of the uncompressed row data.
     *           If it is set to a value greater than 0, then decompress into a buffer of
     *           size uncompressed_byte_size using the compression codec that was requested
     *           during session creation time and which is specified in
     *           TableReadOptions.response_compression_codec in ReadSession.
     *           This value is not set if no response_compression_codec was not requested
     *           and it is -1 if the requested compression would not have reduced the size
     *           of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     *           behavior described here https://github.com/apache/arrow/issues/15102 where
     *           the uncompressed length may be set to -1 to indicate that the data that
     *           follows is not compressed, which can be useful for cases where compression
     *           does not yield appreciable savings. When uncompressed_byte_size is not
     *           greater than 0, the client should skip decompression.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Storage\V1\Storage::initOnce();
        parent::__construct($data);
    }

    /**
     * Serialized row data in AVRO format.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\AvroRows|null
     */
    public function getAvroRows()
    {
        return $this->readOneof(3);
    }

    public function hasAvroRows()
    {
        return $this->hasOneof(3);
    }

    /**
     * Serialized row data in AVRO format.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.AvroRows avro_rows = 3;</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\AvroRows $var
     * @return $this
     */
    public function setAvroRows($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\AvroRows::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Serialized row data in Arrow RecordBatch format.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\ArrowRecordBatch|null
     */
    public function getArrowRecordBatch()
    {
        return $this->readOneof(4);
    }

    public function hasArrowRecordBatch()
    {
        return $this->hasOneof(4);
    }

    /**
     * Serialized row data in Arrow RecordBatch format.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrow_record_batch = 4;</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\ArrowRecordBatch $var
     * @return $this
     */
    public function setArrowRecordBatch($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\ArrowRecordBatch::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Number of serialized rows in the rows block.
     *
     * Generated from protobuf field <code>int64 row_count = 6;</code>
     * @return int|string
     */
    public function getRowCount()
    {
        return $this->row_count;
    }

    /**
     * Number of serialized rows in the rows block.
     *
     * Generated from protobuf field <code>int64 row_count = 6;</code>
     * @param int|string $var
     * @return $this
     */
    public function setRowCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->row_count = $var;

        return $this;
    }

    /**
     * Statistics for the stream.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\StreamStats|null
     */
    public function getStats()
    {
        return $this->stats;
    }

    public function hasStats()
    {
        return isset($this->stats);
    }

    public function clearStats()
    {
        unset($this->stats);
    }

    /**
     * Statistics for the stream.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.StreamStats stats = 2;</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\StreamStats $var
     * @return $this
     */
    public function setStats($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\StreamStats::class);
        $this->stats = $var;

        return $this;
    }

    /**
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\ThrottleState|null
     */
    public function getThrottleState()
    {
        return $this->throttle_state;
    }

    public function hasThrottleState()
    {
        return isset($this->throttle_state);
    }

    public function clearThrottleState()
    {
        unset($this->throttle_state);
    }

    /**
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ThrottleState throttle_state = 5;</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\ThrottleState $var
     * @return $this
     */
    public function setThrottleState($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\ThrottleState::class);
        $this->throttle_state = $var;

        return $this;
    }

    /**
     * Output only. Avro schema.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\AvroSchema|null
     */
    public function getAvroSchema()
    {
        return $this->readOneof(7);
    }

    public function hasAvroSchema()
    {
        return $this->hasOneof(7);
    }

    /**
     * Output only. Avro schema.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\AvroSchema $var
     * @return $this
     */
    public function setAvroSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\AvroSchema::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Output only. Arrow schema.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\BigQuery\Storage\V1\ArrowSchema|null
     */
    public function getArrowSchema()
    {
        return $this->readOneof(8);
    }

    public function hasArrowSchema()
    {
        return $this->hasOneof(8);
    }

    /**
     * Output only. Arrow schema.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\BigQuery\Storage\V1\ArrowSchema $var
     * @return $this
     */
    public function setArrowSchema($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Storage\V1\ArrowSchema::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     *
     * Generated from protobuf field <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getUncompressedByteSize()
    {
        return isset($this->uncompressed_byte_size) ? $this->uncompressed_byte_size : 0;
    }

    public function hasUncompressedByteSize()
    {
        return isset($this->uncompressed_byte_size);
    }

    public function clearUncompressedByteSize()
    {
        unset($this->uncompressed_byte_size);
    }

    /**
     * Optional. If the row data in this ReadRowsResponse is compressed, then
     * uncompressed byte size is the original size of the uncompressed row data.
     * If it is set to a value greater than 0, then decompress into a buffer of
     * size uncompressed_byte_size using the compression codec that was requested
     * during session creation time and which is specified in
     * TableReadOptions.response_compression_codec in ReadSession.
     * This value is not set if no response_compression_codec was not requested
     * and it is -1 if the requested compression would not have reduced the size
     * of this ReadRowsResponse's row data. This attempts to match Apache Arrow's
     * behavior described here https://github.com/apache/arrow/issues/15102 where
     * the uncompressed length may be set to -1 to indicate that the data that
     * follows is not compressed, which can be useful for cases where compression
     * does not yield appreciable savings. When uncompressed_byte_size is not
     * greater than 0, the client should skip decompression.
     *
     * Generated from protobuf field <code>optional int64 uncompressed_byte_size = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setUncompressedByteSize($var)
    {
        GPBUtil::checkInt64($var);
        $this->uncompressed_byte_size = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getRows()
    {
        return $this->whichOneof("rows");
    }

    /**
     * @return string
     */
    public function getSchema()
    {
        return $this->whichOneof("schema");
    }

}

