<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/asset_service.proto

namespace Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedAssetsResponse;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The IAM policies governed by the organization policies of the
 * [AnalyzeOrgPolicyGovernedAssetsRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest.constraint].
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy</code>
 */
class GovernedIamPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * The full resource name of the resource on which this IAM policy is set.
     * Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Cloud Asset Inventory Resource Name
     * Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * for more information.
     *
     * Generated from protobuf field <code>string attached_resource = 1;</code>
     */
    private $attached_resource = '';
    /**
     * The IAM policy directly set on the given resource.
     *
     * Generated from protobuf field <code>.google.iam.v1.Policy policy = 2;</code>
     */
    private $policy = null;
    /**
     * The project that this IAM policy belongs to, in the format of
     * projects/{PROJECT_NUMBER}. This field is available when the IAM policy
     * belongs to a project.
     *
     * Generated from protobuf field <code>string project = 5;</code>
     */
    private $project = '';
    /**
     * The folder(s) that this IAM policy belongs to, in the format of
     * folders/{FOLDER_NUMBER}. This field is available when the IAM policy
     * belongs (directly or cascadingly) to one or more folders.
     *
     * Generated from protobuf field <code>repeated string folders = 6;</code>
     */
    private $folders;
    /**
     * The organization that this IAM policy belongs to, in the format of
     * organizations/{ORGANIZATION_NUMBER}. This field is available when the
     * IAM policy belongs (directly or cascadingly) to an organization.
     *
     * Generated from protobuf field <code>string organization = 7;</code>
     */
    private $organization = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $attached_resource
     *           The full resource name of the resource on which this IAM policy is set.
     *           Example:
     *           `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *           See [Cloud Asset Inventory Resource Name
     *           Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     *           for more information.
     *     @type \Google\Cloud\Iam\V1\Policy $policy
     *           The IAM policy directly set on the given resource.
     *     @type string $project
     *           The project that this IAM policy belongs to, in the format of
     *           projects/{PROJECT_NUMBER}. This field is available when the IAM policy
     *           belongs to a project.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $folders
     *           The folder(s) that this IAM policy belongs to, in the format of
     *           folders/{FOLDER_NUMBER}. This field is available when the IAM policy
     *           belongs (directly or cascadingly) to one or more folders.
     *     @type string $organization
     *           The organization that this IAM policy belongs to, in the format of
     *           organizations/{ORGANIZATION_NUMBER}. This field is available when the
     *           IAM policy belongs (directly or cascadingly) to an organization.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\AssetService::initOnce();
        parent::__construct($data);
    }

    /**
     * The full resource name of the resource on which this IAM policy is set.
     * Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Cloud Asset Inventory Resource Name
     * Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * for more information.
     *
     * Generated from protobuf field <code>string attached_resource = 1;</code>
     * @return string
     */
    public function getAttachedResource()
    {
        return $this->attached_resource;
    }

    /**
     * The full resource name of the resource on which this IAM policy is set.
     * Example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Cloud Asset Inventory Resource Name
     * Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
     * for more information.
     *
     * Generated from protobuf field <code>string attached_resource = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setAttachedResource($var)
    {
        GPBUtil::checkString($var, True);
        $this->attached_resource = $var;

        return $this;
    }

    /**
     * The IAM policy directly set on the given resource.
     *
     * Generated from protobuf field <code>.google.iam.v1.Policy policy = 2;</code>
     * @return \Google\Cloud\Iam\V1\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }

    public function hasPolicy()
    {
        return isset($this->policy);
    }

    public function clearPolicy()
    {
        unset($this->policy);
    }

    /**
     * The IAM policy directly set on the given resource.
     *
     * Generated from protobuf field <code>.google.iam.v1.Policy policy = 2;</code>
     * @param \Google\Cloud\Iam\V1\Policy $var
     * @return $this
     */
    public function setPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iam\V1\Policy::class);
        $this->policy = $var;

        return $this;
    }

    /**
     * The project that this IAM policy belongs to, in the format of
     * projects/{PROJECT_NUMBER}. This field is available when the IAM policy
     * belongs to a project.
     *
     * Generated from protobuf field <code>string project = 5;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * The project that this IAM policy belongs to, in the format of
     * projects/{PROJECT_NUMBER}. This field is available when the IAM policy
     * belongs to a project.
     *
     * Generated from protobuf field <code>string project = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The folder(s) that this IAM policy belongs to, in the format of
     * folders/{FOLDER_NUMBER}. This field is available when the IAM policy
     * belongs (directly or cascadingly) to one or more folders.
     *
     * Generated from protobuf field <code>repeated string folders = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFolders()
    {
        return $this->folders;
    }

    /**
     * The folder(s) that this IAM policy belongs to, in the format of
     * folders/{FOLDER_NUMBER}. This field is available when the IAM policy
     * belongs (directly or cascadingly) to one or more folders.
     *
     * Generated from protobuf field <code>repeated string folders = 6;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFolders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->folders = $arr;

        return $this;
    }

    /**
     * The organization that this IAM policy belongs to, in the format of
     * organizations/{ORGANIZATION_NUMBER}. This field is available when the
     * IAM policy belongs (directly or cascadingly) to an organization.
     *
     * Generated from protobuf field <code>string organization = 7;</code>
     * @return string
     */
    public function getOrganization()
    {
        return $this->organization;
    }

    /**
     * The organization that this IAM policy belongs to, in the format of
     * organizations/{ORGANIZATION_NUMBER}. This field is available when the
     * IAM policy belongs (directly or cascadingly) to an organization.
     *
     * Generated from protobuf field <code>string organization = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setOrganization($var)
    {
        GPBUtil::checkString($var, True);
        $this->organization = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GovernedIamPolicy::class, \Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy::class);

