<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/analytics/admin/v1alpha/analytics_admin.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Analytics\Admin\V1alpha\Client;

use Google\Analytics\Admin\V1alpha\AccessBinding;
use Google\Analytics\Admin\V1alpha\Account;
use Google\Analytics\Admin\V1alpha\AcknowledgeUserDataCollectionRequest;
use Google\Analytics\Admin\V1alpha\AcknowledgeUserDataCollectionResponse;
use Google\Analytics\Admin\V1alpha\AdSenseLink;
use Google\Analytics\Admin\V1alpha\ApproveDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\ApproveDisplayVideo360AdvertiserLinkProposalResponse;
use Google\Analytics\Admin\V1alpha\ArchiveAudienceRequest;
use Google\Analytics\Admin\V1alpha\ArchiveCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\ArchiveCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\AttributionSettings;
use Google\Analytics\Admin\V1alpha\Audience;
use Google\Analytics\Admin\V1alpha\BatchCreateAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchCreateAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\BatchDeleteAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchGetAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchGetAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\BatchUpdateAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\BatchUpdateAccessBindingsResponse;
use Google\Analytics\Admin\V1alpha\BigQueryLink;
use Google\Analytics\Admin\V1alpha\CalculatedMetric;
use Google\Analytics\Admin\V1alpha\CancelDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\ChannelGroup;
use Google\Analytics\Admin\V1alpha\ConversionEvent;
use Google\Analytics\Admin\V1alpha\CreateAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\CreateAdSenseLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateAudienceRequest;
use Google\Analytics\Admin\V1alpha\CreateCalculatedMetricRequest;
use Google\Analytics\Admin\V1alpha\CreateChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\CreateConnectedSiteTagRequest;
use Google\Analytics\Admin\V1alpha\CreateConnectedSiteTagResponse;
use Google\Analytics\Admin\V1alpha\CreateConversionEventRequest;
use Google\Analytics\Admin\V1alpha\CreateCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\CreateCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\CreateDataStreamRequest;
use Google\Analytics\Admin\V1alpha\CreateDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\CreateDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\CreateExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\CreateFirebaseLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\CreatePropertyRequest;
use Google\Analytics\Admin\V1alpha\CreateRollupPropertyRequest;
use Google\Analytics\Admin\V1alpha\CreateRollupPropertyResponse;
use Google\Analytics\Admin\V1alpha\CreateRollupPropertySourceLinkRequest;
use Google\Analytics\Admin\V1alpha\CreateSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\CreateSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\CreateSubpropertyEventFilterRequest;
use Google\Analytics\Admin\V1alpha\CreateSubpropertyRequest;
use Google\Analytics\Admin\V1alpha\CreateSubpropertyResponse;
use Google\Analytics\Admin\V1alpha\CustomDimension;
use Google\Analytics\Admin\V1alpha\CustomMetric;
use Google\Analytics\Admin\V1alpha\DataRedactionSettings;
use Google\Analytics\Admin\V1alpha\DataRetentionSettings;
use Google\Analytics\Admin\V1alpha\DataSharingSettings;
use Google\Analytics\Admin\V1alpha\DataStream;
use Google\Analytics\Admin\V1alpha\DeleteAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\DeleteAccountRequest;
use Google\Analytics\Admin\V1alpha\DeleteAdSenseLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteCalculatedMetricRequest;
use Google\Analytics\Admin\V1alpha\DeleteChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\DeleteConnectedSiteTagRequest;
use Google\Analytics\Admin\V1alpha\DeleteConversionEventRequest;
use Google\Analytics\Admin\V1alpha\DeleteDataStreamRequest;
use Google\Analytics\Admin\V1alpha\DeleteDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\DeleteDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\DeleteExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\DeleteFirebaseLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\DeletePropertyRequest;
use Google\Analytics\Admin\V1alpha\DeleteRollupPropertySourceLinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\DeleteSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\DeleteSubpropertyEventFilterRequest;
use Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLink;
use Google\Analytics\Admin\V1alpha\DisplayVideo360AdvertiserLinkProposal;
use Google\Analytics\Admin\V1alpha\EnhancedMeasurementSettings;
use Google\Analytics\Admin\V1alpha\EventCreateRule;
use Google\Analytics\Admin\V1alpha\ExpandedDataSet;
use Google\Analytics\Admin\V1alpha\FetchAutomatedGa4ConfigurationOptOutRequest;
use Google\Analytics\Admin\V1alpha\FetchAutomatedGa4ConfigurationOptOutResponse;
use Google\Analytics\Admin\V1alpha\FetchConnectedGa4PropertyRequest;
use Google\Analytics\Admin\V1alpha\FetchConnectedGa4PropertyResponse;
use Google\Analytics\Admin\V1alpha\FirebaseLink;
use Google\Analytics\Admin\V1alpha\GetAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\GetAccountRequest;
use Google\Analytics\Admin\V1alpha\GetAdSenseLinkRequest;
use Google\Analytics\Admin\V1alpha\GetAttributionSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetAudienceRequest;
use Google\Analytics\Admin\V1alpha\GetBigQueryLinkRequest;
use Google\Analytics\Admin\V1alpha\GetCalculatedMetricRequest;
use Google\Analytics\Admin\V1alpha\GetChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\GetConversionEventRequest;
use Google\Analytics\Admin\V1alpha\GetCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\GetCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\GetDataRedactionSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetDataRetentionSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetDataSharingSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetDataStreamRequest;
use Google\Analytics\Admin\V1alpha\GetDisplayVideo360AdvertiserLinkProposalRequest;
use Google\Analytics\Admin\V1alpha\GetDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\GetEnhancedMeasurementSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\GetExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\GetGlobalSiteTagRequest;
use Google\Analytics\Admin\V1alpha\GetGoogleSignalsSettingsRequest;
use Google\Analytics\Admin\V1alpha\GetMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\GetPropertyRequest;
use Google\Analytics\Admin\V1alpha\GetRollupPropertySourceLinkRequest;
use Google\Analytics\Admin\V1alpha\GetSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\GetSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\GetSubpropertyEventFilterRequest;
use Google\Analytics\Admin\V1alpha\GlobalSiteTag;
use Google\Analytics\Admin\V1alpha\GoogleAdsLink;
use Google\Analytics\Admin\V1alpha\GoogleSignalsSettings;
use Google\Analytics\Admin\V1alpha\ListAccessBindingsRequest;
use Google\Analytics\Admin\V1alpha\ListAccountSummariesRequest;
use Google\Analytics\Admin\V1alpha\ListAccountsRequest;
use Google\Analytics\Admin\V1alpha\ListAdSenseLinksRequest;
use Google\Analytics\Admin\V1alpha\ListAudiencesRequest;
use Google\Analytics\Admin\V1alpha\ListBigQueryLinksRequest;
use Google\Analytics\Admin\V1alpha\ListCalculatedMetricsRequest;
use Google\Analytics\Admin\V1alpha\ListChannelGroupsRequest;
use Google\Analytics\Admin\V1alpha\ListConnectedSiteTagsRequest;
use Google\Analytics\Admin\V1alpha\ListConnectedSiteTagsResponse;
use Google\Analytics\Admin\V1alpha\ListConversionEventsRequest;
use Google\Analytics\Admin\V1alpha\ListCustomDimensionsRequest;
use Google\Analytics\Admin\V1alpha\ListCustomMetricsRequest;
use Google\Analytics\Admin\V1alpha\ListDataStreamsRequest;
use Google\Analytics\Admin\V1alpha\ListDisplayVideo360AdvertiserLinkProposalsRequest;
use Google\Analytics\Admin\V1alpha\ListDisplayVideo360AdvertiserLinksRequest;
use Google\Analytics\Admin\V1alpha\ListEventCreateRulesRequest;
use Google\Analytics\Admin\V1alpha\ListExpandedDataSetsRequest;
use Google\Analytics\Admin\V1alpha\ListFirebaseLinksRequest;
use Google\Analytics\Admin\V1alpha\ListGoogleAdsLinksRequest;
use Google\Analytics\Admin\V1alpha\ListMeasurementProtocolSecretsRequest;
use Google\Analytics\Admin\V1alpha\ListPropertiesRequest;
use Google\Analytics\Admin\V1alpha\ListRollupPropertySourceLinksRequest;
use Google\Analytics\Admin\V1alpha\ListSKAdNetworkConversionValueSchemasRequest;
use Google\Analytics\Admin\V1alpha\ListSearchAds360LinksRequest;
use Google\Analytics\Admin\V1alpha\ListSubpropertyEventFiltersRequest;
use Google\Analytics\Admin\V1alpha\MeasurementProtocolSecret;
use Google\Analytics\Admin\V1alpha\Property;
use Google\Analytics\Admin\V1alpha\ProvisionAccountTicketRequest;
use Google\Analytics\Admin\V1alpha\ProvisionAccountTicketResponse;
use Google\Analytics\Admin\V1alpha\RollupPropertySourceLink;
use Google\Analytics\Admin\V1alpha\RunAccessReportRequest;
use Google\Analytics\Admin\V1alpha\RunAccessReportResponse;
use Google\Analytics\Admin\V1alpha\SKAdNetworkConversionValueSchema;
use Google\Analytics\Admin\V1alpha\SearchAds360Link;
use Google\Analytics\Admin\V1alpha\SearchChangeHistoryEventsRequest;
use Google\Analytics\Admin\V1alpha\SetAutomatedGa4ConfigurationOptOutRequest;
use Google\Analytics\Admin\V1alpha\SetAutomatedGa4ConfigurationOptOutResponse;
use Google\Analytics\Admin\V1alpha\SubpropertyEventFilter;
use Google\Analytics\Admin\V1alpha\UpdateAccessBindingRequest;
use Google\Analytics\Admin\V1alpha\UpdateAccountRequest;
use Google\Analytics\Admin\V1alpha\UpdateAttributionSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateAudienceRequest;
use Google\Analytics\Admin\V1alpha\UpdateCalculatedMetricRequest;
use Google\Analytics\Admin\V1alpha\UpdateChannelGroupRequest;
use Google\Analytics\Admin\V1alpha\UpdateConversionEventRequest;
use Google\Analytics\Admin\V1alpha\UpdateCustomDimensionRequest;
use Google\Analytics\Admin\V1alpha\UpdateCustomMetricRequest;
use Google\Analytics\Admin\V1alpha\UpdateDataRedactionSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateDataRetentionSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateDataStreamRequest;
use Google\Analytics\Admin\V1alpha\UpdateDisplayVideo360AdvertiserLinkRequest;
use Google\Analytics\Admin\V1alpha\UpdateEnhancedMeasurementSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateEventCreateRuleRequest;
use Google\Analytics\Admin\V1alpha\UpdateExpandedDataSetRequest;
use Google\Analytics\Admin\V1alpha\UpdateGoogleAdsLinkRequest;
use Google\Analytics\Admin\V1alpha\UpdateGoogleSignalsSettingsRequest;
use Google\Analytics\Admin\V1alpha\UpdateMeasurementProtocolSecretRequest;
use Google\Analytics\Admin\V1alpha\UpdatePropertyRequest;
use Google\Analytics\Admin\V1alpha\UpdateSKAdNetworkConversionValueSchemaRequest;
use Google\Analytics\Admin\V1alpha\UpdateSearchAds360LinkRequest;
use Google\Analytics\Admin\V1alpha\UpdateSubpropertyEventFilterRequest;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service Interface for the Analytics Admin API (GA4).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 *
 * @method PromiseInterface acknowledgeUserDataCollectionAsync(AcknowledgeUserDataCollectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface approveDisplayVideo360AdvertiserLinkProposalAsync(ApproveDisplayVideo360AdvertiserLinkProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface archiveAudienceAsync(ArchiveAudienceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface archiveCustomDimensionAsync(ArchiveCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface archiveCustomMetricAsync(ArchiveCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchCreateAccessBindingsAsync(BatchCreateAccessBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchDeleteAccessBindingsAsync(BatchDeleteAccessBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchGetAccessBindingsAsync(BatchGetAccessBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchUpdateAccessBindingsAsync(BatchUpdateAccessBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface cancelDisplayVideo360AdvertiserLinkProposalAsync(CancelDisplayVideo360AdvertiserLinkProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createAccessBindingAsync(CreateAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createAdSenseLinkAsync(CreateAdSenseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createAudienceAsync(CreateAudienceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCalculatedMetricAsync(CreateCalculatedMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createChannelGroupAsync(CreateChannelGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createConnectedSiteTagAsync(CreateConnectedSiteTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createConversionEventAsync(CreateConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCustomDimensionAsync(CreateCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCustomMetricAsync(CreateCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDataStreamAsync(CreateDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDisplayVideo360AdvertiserLinkAsync(CreateDisplayVideo360AdvertiserLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDisplayVideo360AdvertiserLinkProposalAsync(CreateDisplayVideo360AdvertiserLinkProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createEventCreateRuleAsync(CreateEventCreateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createExpandedDataSetAsync(CreateExpandedDataSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createFirebaseLinkAsync(CreateFirebaseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createGoogleAdsLinkAsync(CreateGoogleAdsLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMeasurementProtocolSecretAsync(CreateMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPropertyAsync(CreatePropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRollupPropertyAsync(CreateRollupPropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRollupPropertySourceLinkAsync(CreateRollupPropertySourceLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSKAdNetworkConversionValueSchemaAsync(CreateSKAdNetworkConversionValueSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSearchAds360LinkAsync(CreateSearchAds360LinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSubpropertyAsync(CreateSubpropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSubpropertyEventFilterAsync(CreateSubpropertyEventFilterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAccessBindingAsync(DeleteAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAccountAsync(DeleteAccountRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAdSenseLinkAsync(DeleteAdSenseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCalculatedMetricAsync(DeleteCalculatedMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteChannelGroupAsync(DeleteChannelGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConnectedSiteTagAsync(DeleteConnectedSiteTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConversionEventAsync(DeleteConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDataStreamAsync(DeleteDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDisplayVideo360AdvertiserLinkAsync(DeleteDisplayVideo360AdvertiserLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDisplayVideo360AdvertiserLinkProposalAsync(DeleteDisplayVideo360AdvertiserLinkProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEventCreateRuleAsync(DeleteEventCreateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteExpandedDataSetAsync(DeleteExpandedDataSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteFirebaseLinkAsync(DeleteFirebaseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGoogleAdsLinkAsync(DeleteGoogleAdsLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMeasurementProtocolSecretAsync(DeleteMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePropertyAsync(DeletePropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRollupPropertySourceLinkAsync(DeleteRollupPropertySourceLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSKAdNetworkConversionValueSchemaAsync(DeleteSKAdNetworkConversionValueSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSearchAds360LinkAsync(DeleteSearchAds360LinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSubpropertyEventFilterAsync(DeleteSubpropertyEventFilterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchAutomatedGa4ConfigurationOptOutAsync(FetchAutomatedGa4ConfigurationOptOutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchConnectedGa4PropertyAsync(FetchConnectedGa4PropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAccessBindingAsync(GetAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAccountAsync(GetAccountRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAdSenseLinkAsync(GetAdSenseLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAttributionSettingsAsync(GetAttributionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAudienceAsync(GetAudienceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBigQueryLinkAsync(GetBigQueryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCalculatedMetricAsync(GetCalculatedMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getChannelGroupAsync(GetChannelGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConversionEventAsync(GetConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCustomDimensionAsync(GetCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCustomMetricAsync(GetCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDataRedactionSettingsAsync(GetDataRedactionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDataRetentionSettingsAsync(GetDataRetentionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDataSharingSettingsAsync(GetDataSharingSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDataStreamAsync(GetDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDisplayVideo360AdvertiserLinkAsync(GetDisplayVideo360AdvertiserLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDisplayVideo360AdvertiserLinkProposalAsync(GetDisplayVideo360AdvertiserLinkProposalRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEnhancedMeasurementSettingsAsync(GetEnhancedMeasurementSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEventCreateRuleAsync(GetEventCreateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExpandedDataSetAsync(GetExpandedDataSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGlobalSiteTagAsync(GetGlobalSiteTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGoogleSignalsSettingsAsync(GetGoogleSignalsSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMeasurementProtocolSecretAsync(GetMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPropertyAsync(GetPropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRollupPropertySourceLinkAsync(GetRollupPropertySourceLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSKAdNetworkConversionValueSchemaAsync(GetSKAdNetworkConversionValueSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSearchAds360LinkAsync(GetSearchAds360LinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSubpropertyEventFilterAsync(GetSubpropertyEventFilterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAccessBindingsAsync(ListAccessBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAccountSummariesAsync(ListAccountSummariesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAccountsAsync(ListAccountsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAdSenseLinksAsync(ListAdSenseLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAudiencesAsync(ListAudiencesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBigQueryLinksAsync(ListBigQueryLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCalculatedMetricsAsync(ListCalculatedMetricsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listChannelGroupsAsync(ListChannelGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConnectedSiteTagsAsync(ListConnectedSiteTagsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConversionEventsAsync(ListConversionEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCustomDimensionsAsync(ListCustomDimensionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCustomMetricsAsync(ListCustomMetricsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDataStreamsAsync(ListDataStreamsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDisplayVideo360AdvertiserLinkProposalsAsync(ListDisplayVideo360AdvertiserLinkProposalsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDisplayVideo360AdvertiserLinksAsync(ListDisplayVideo360AdvertiserLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEventCreateRulesAsync(ListEventCreateRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExpandedDataSetsAsync(ListExpandedDataSetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listFirebaseLinksAsync(ListFirebaseLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGoogleAdsLinksAsync(ListGoogleAdsLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMeasurementProtocolSecretsAsync(ListMeasurementProtocolSecretsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPropertiesAsync(ListPropertiesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRollupPropertySourceLinksAsync(ListRollupPropertySourceLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSKAdNetworkConversionValueSchemasAsync(ListSKAdNetworkConversionValueSchemasRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSearchAds360LinksAsync(ListSearchAds360LinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSubpropertyEventFiltersAsync(ListSubpropertyEventFiltersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface provisionAccountTicketAsync(ProvisionAccountTicketRequest $request, array $optionalArgs = [])
 * @method PromiseInterface runAccessReportAsync(RunAccessReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchChangeHistoryEventsAsync(SearchChangeHistoryEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setAutomatedGa4ConfigurationOptOutAsync(SetAutomatedGa4ConfigurationOptOutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAccessBindingAsync(UpdateAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAccountAsync(UpdateAccountRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAttributionSettingsAsync(UpdateAttributionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAudienceAsync(UpdateAudienceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCalculatedMetricAsync(UpdateCalculatedMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateChannelGroupAsync(UpdateChannelGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConversionEventAsync(UpdateConversionEventRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCustomDimensionAsync(UpdateCustomDimensionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCustomMetricAsync(UpdateCustomMetricRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDataRedactionSettingsAsync(UpdateDataRedactionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDataRetentionSettingsAsync(UpdateDataRetentionSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDataStreamAsync(UpdateDataStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDisplayVideo360AdvertiserLinkAsync(UpdateDisplayVideo360AdvertiserLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateEnhancedMeasurementSettingsAsync(UpdateEnhancedMeasurementSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateEventCreateRuleAsync(UpdateEventCreateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExpandedDataSetAsync(UpdateExpandedDataSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGoogleAdsLinkAsync(UpdateGoogleAdsLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGoogleSignalsSettingsAsync(UpdateGoogleSignalsSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateMeasurementProtocolSecretAsync(UpdateMeasurementProtocolSecretRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePropertyAsync(UpdatePropertyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSKAdNetworkConversionValueSchemaAsync(UpdateSKAdNetworkConversionValueSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSearchAds360LinkAsync(UpdateSearchAds360LinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSubpropertyEventFilterAsync(UpdateSubpropertyEventFilterRequest $request, array $optionalArgs = [])
 */
final class AnalyticsAdminServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.analytics.admin.v1alpha.AnalyticsAdminService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'analyticsadmin.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'analyticsadmin.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/analytics.edit',
        'https://www.googleapis.com/auth/analytics.manage.users',
        'https://www.googleapis.com/auth/analytics.manage.users.readonly',
        'https://www.googleapis.com/auth/analytics.readonly',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/analytics_admin_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/analytics_admin_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/analytics_admin_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/analytics_admin_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * access_binding resource.
     *
     * @param string $account
     * @param string $accessBinding
     *
     * @return string The formatted access_binding resource.
     *
     * @experimental
     */
    public static function accessBindingName(string $account, string $accessBinding): string
    {
        return self::getPathTemplate('accessBinding')->render([
            'account' => $account,
            'access_binding' => $accessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a account
     * resource.
     *
     * @param string $account
     *
     * @return string The formatted account resource.
     *
     * @experimental
     */
    public static function accountName(string $account): string
    {
        return self::getPathTemplate('account')->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * account_access_binding resource.
     *
     * @param string $account
     * @param string $accessBinding
     *
     * @return string The formatted account_access_binding resource.
     *
     * @experimental
     */
    public static function accountAccessBindingName(string $account, string $accessBinding): string
    {
        return self::getPathTemplate('accountAccessBinding')->render([
            'account' => $account,
            'access_binding' => $accessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * ad_sense_link resource.
     *
     * @param string $property
     * @param string $adsenseLink
     *
     * @return string The formatted ad_sense_link resource.
     *
     * @experimental
     */
    public static function adSenseLinkName(string $property, string $adsenseLink): string
    {
        return self::getPathTemplate('adSenseLink')->render([
            'property' => $property,
            'adsense_link' => $adsenseLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * attribution_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted attribution_settings resource.
     *
     * @experimental
     */
    public static function attributionSettingsName(string $property): string
    {
        return self::getPathTemplate('attributionSettings')->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a audience
     * resource.
     *
     * @param string $property
     * @param string $audience
     *
     * @return string The formatted audience resource.
     *
     * @experimental
     */
    public static function audienceName(string $property, string $audience): string
    {
        return self::getPathTemplate('audience')->render([
            'property' => $property,
            'audience' => $audience,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * big_query_link resource.
     *
     * @param string $property
     * @param string $bigqueryLink
     *
     * @return string The formatted big_query_link resource.
     *
     * @experimental
     */
    public static function bigQueryLinkName(string $property, string $bigqueryLink): string
    {
        return self::getPathTemplate('bigQueryLink')->render([
            'property' => $property,
            'bigquery_link' => $bigqueryLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * calculated_metric resource.
     *
     * @param string $property
     * @param string $calculatedMetric
     *
     * @return string The formatted calculated_metric resource.
     *
     * @experimental
     */
    public static function calculatedMetricName(string $property, string $calculatedMetric): string
    {
        return self::getPathTemplate('calculatedMetric')->render([
            'property' => $property,
            'calculated_metric' => $calculatedMetric,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_group resource.
     *
     * @param string $property
     * @param string $channelGroup
     *
     * @return string The formatted channel_group resource.
     *
     * @experimental
     */
    public static function channelGroupName(string $property, string $channelGroup): string
    {
        return self::getPathTemplate('channelGroup')->render([
            'property' => $property,
            'channel_group' => $channelGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversion_event resource.
     *
     * @param string $property
     * @param string $conversionEvent
     *
     * @return string The formatted conversion_event resource.
     *
     * @experimental
     */
    public static function conversionEventName(string $property, string $conversionEvent): string
    {
        return self::getPathTemplate('conversionEvent')->render([
            'property' => $property,
            'conversion_event' => $conversionEvent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_dimension resource.
     *
     * @param string $property
     * @param string $customDimension
     *
     * @return string The formatted custom_dimension resource.
     *
     * @experimental
     */
    public static function customDimensionName(string $property, string $customDimension): string
    {
        return self::getPathTemplate('customDimension')->render([
            'property' => $property,
            'custom_dimension' => $customDimension,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * custom_metric resource.
     *
     * @param string $property
     * @param string $customMetric
     *
     * @return string The formatted custom_metric resource.
     *
     * @experimental
     */
    public static function customMetricName(string $property, string $customMetric): string
    {
        return self::getPathTemplate('customMetric')->render([
            'property' => $property,
            'custom_metric' => $customMetric,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_redaction_settings resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted data_redaction_settings resource.
     *
     * @experimental
     */
    public static function dataRedactionSettingsName(string $property, string $dataStream): string
    {
        return self::getPathTemplate('dataRedactionSettings')->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_retention_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted data_retention_settings resource.
     *
     * @experimental
     */
    public static function dataRetentionSettingsName(string $property): string
    {
        return self::getPathTemplate('dataRetentionSettings')->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_sharing_settings resource.
     *
     * @param string $account
     *
     * @return string The formatted data_sharing_settings resource.
     *
     * @experimental
     */
    public static function dataSharingSettingsName(string $account): string
    {
        return self::getPathTemplate('dataSharingSettings')->render([
            'account' => $account,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_stream
     * resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted data_stream resource.
     *
     * @experimental
     */
    public static function dataStreamName(string $property, string $dataStream): string
    {
        return self::getPathTemplate('dataStream')->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * display_video360_advertiser_link resource.
     *
     * @param string $property
     * @param string $displayVideo360AdvertiserLink
     *
     * @return string The formatted display_video360_advertiser_link resource.
     *
     * @experimental
     */
    public static function displayVideo360AdvertiserLinkName(string $property, string $displayVideo360AdvertiserLink): string
    {
        return self::getPathTemplate('displayVideo360AdvertiserLink')->render([
            'property' => $property,
            'display_video_360_advertiser_link' => $displayVideo360AdvertiserLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * display_video360_advertiser_link_proposal resource.
     *
     * @param string $property
     * @param string $displayVideo360AdvertiserLinkProposal
     *
     * @return string The formatted display_video360_advertiser_link_proposal resource.
     *
     * @experimental
     */
    public static function displayVideo360AdvertiserLinkProposalName(string $property, string $displayVideo360AdvertiserLinkProposal): string
    {
        return self::getPathTemplate('displayVideo360AdvertiserLinkProposal')->render([
            'property' => $property,
            'display_video_360_advertiser_link_proposal' => $displayVideo360AdvertiserLinkProposal,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * enhanced_measurement_settings resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted enhanced_measurement_settings resource.
     *
     * @experimental
     */
    public static function enhancedMeasurementSettingsName(string $property, string $dataStream): string
    {
        return self::getPathTemplate('enhancedMeasurementSettings')->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * event_create_rule resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $eventCreateRule
     *
     * @return string The formatted event_create_rule resource.
     *
     * @experimental
     */
    public static function eventCreateRuleName(string $property, string $dataStream, string $eventCreateRule): string
    {
        return self::getPathTemplate('eventCreateRule')->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'event_create_rule' => $eventCreateRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * expanded_data_set resource.
     *
     * @param string $property
     * @param string $expandedDataSet
     *
     * @return string The formatted expanded_data_set resource.
     *
     * @experimental
     */
    public static function expandedDataSetName(string $property, string $expandedDataSet): string
    {
        return self::getPathTemplate('expandedDataSet')->render([
            'property' => $property,
            'expanded_data_set' => $expandedDataSet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * firebase_link resource.
     *
     * @param string $property
     * @param string $firebaseLink
     *
     * @return string The formatted firebase_link resource.
     *
     * @experimental
     */
    public static function firebaseLinkName(string $property, string $firebaseLink): string
    {
        return self::getPathTemplate('firebaseLink')->render([
            'property' => $property,
            'firebase_link' => $firebaseLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * global_site_tag resource.
     *
     * @param string $property
     * @param string $dataStream
     *
     * @return string The formatted global_site_tag resource.
     *
     * @experimental
     */
    public static function globalSiteTagName(string $property, string $dataStream): string
    {
        return self::getPathTemplate('globalSiteTag')->render([
            'property' => $property,
            'data_stream' => $dataStream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_ads_link resource.
     *
     * @param string $property
     * @param string $googleAdsLink
     *
     * @return string The formatted google_ads_link resource.
     *
     * @experimental
     */
    public static function googleAdsLinkName(string $property, string $googleAdsLink): string
    {
        return self::getPathTemplate('googleAdsLink')->render([
            'property' => $property,
            'google_ads_link' => $googleAdsLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_signals_settings resource.
     *
     * @param string $property
     *
     * @return string The formatted google_signals_settings resource.
     *
     * @experimental
     */
    public static function googleSignalsSettingsName(string $property): string
    {
        return self::getPathTemplate('googleSignalsSettings')->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * measurement_protocol_secret resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $measurementProtocolSecret
     *
     * @return string The formatted measurement_protocol_secret resource.
     *
     * @experimental
     */
    public static function measurementProtocolSecretName(string $property, string $dataStream, string $measurementProtocolSecret): string
    {
        return self::getPathTemplate('measurementProtocolSecret')->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'measurement_protocol_secret' => $measurementProtocolSecret,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a property
     * resource.
     *
     * @param string $property
     *
     * @return string The formatted property resource.
     *
     * @experimental
     */
    public static function propertyName(string $property): string
    {
        return self::getPathTemplate('property')->render([
            'property' => $property,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * property_access_binding resource.
     *
     * @param string $property
     * @param string $accessBinding
     *
     * @return string The formatted property_access_binding resource.
     *
     * @experimental
     */
    public static function propertyAccessBindingName(string $property, string $accessBinding): string
    {
        return self::getPathTemplate('propertyAccessBinding')->render([
            'property' => $property,
            'access_binding' => $accessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * rollup_property_source_link resource.
     *
     * @param string $property
     * @param string $rollupPropertySourceLink
     *
     * @return string The formatted rollup_property_source_link resource.
     *
     * @experimental
     */
    public static function rollupPropertySourceLinkName(string $property, string $rollupPropertySourceLink): string
    {
        return self::getPathTemplate('rollupPropertySourceLink')->render([
            'property' => $property,
            'rollup_property_source_link' => $rollupPropertySourceLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * sk_ad_network_conversion_value_schema resource.
     *
     * @param string $property
     * @param string $dataStream
     * @param string $skadnetworkConversionValueSchema
     *
     * @return string The formatted sk_ad_network_conversion_value_schema resource.
     *
     * @experimental
     */
    public static function sKAdNetworkConversionValueSchemaName(string $property, string $dataStream, string $skadnetworkConversionValueSchema): string
    {
        return self::getPathTemplate('sKAdNetworkConversionValueSchema')->render([
            'property' => $property,
            'data_stream' => $dataStream,
            'skadnetwork_conversion_value_schema' => $skadnetworkConversionValueSchema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * search_ads360_link resource.
     *
     * @param string $property
     * @param string $searchAds360Link
     *
     * @return string The formatted search_ads360_link resource.
     *
     * @experimental
     */
    public static function searchAds360LinkName(string $property, string $searchAds360Link): string
    {
        return self::getPathTemplate('searchAds360Link')->render([
            'property' => $property,
            'search_ads_360_link' => $searchAds360Link,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * subproperty_event_filter resource.
     *
     * @param string $property
     * @param string $subPropertyEventFilter
     *
     * @return string The formatted subproperty_event_filter resource.
     *
     * @experimental
     */
    public static function subpropertyEventFilterName(string $property, string $subPropertyEventFilter): string
    {
        return self::getPathTemplate('subpropertyEventFilter')->render([
            'property' => $property,
            'sub_property_event_filter' => $subPropertyEventFilter,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - accessBinding: accounts/{account}/accessBindings/{access_binding}
     * - account: accounts/{account}
     * - accountAccessBinding: accounts/{account}/accessBindings/{access_binding}
     * - adSenseLink: properties/{property}/adSenseLinks/{adsense_link}
     * - attributionSettings: properties/{property}/attributionSettings
     * - audience: properties/{property}/audiences/{audience}
     * - bigQueryLink: properties/{property}/bigQueryLinks/{bigquery_link}
     * - calculatedMetric: properties/{property}/calculatedMetrics/{calculated_metric}
     * - channelGroup: properties/{property}/channelGroups/{channel_group}
     * - conversionEvent: properties/{property}/conversionEvents/{conversion_event}
     * - customDimension: properties/{property}/customDimensions/{custom_dimension}
     * - customMetric: properties/{property}/customMetrics/{custom_metric}
     * - dataRedactionSettings: properties/{property}/dataStreams/{data_stream}/dataRedactionSettings
     * - dataRetentionSettings: properties/{property}/dataRetentionSettings
     * - dataSharingSettings: accounts/{account}/dataSharingSettings
     * - dataStream: properties/{property}/dataStreams/{data_stream}
     * - displayVideo360AdvertiserLink: properties/{property}/displayVideo360AdvertiserLinks/{display_video_360_advertiser_link}
     * - displayVideo360AdvertiserLinkProposal: properties/{property}/displayVideo360AdvertiserLinkProposals/{display_video_360_advertiser_link_proposal}
     * - enhancedMeasurementSettings: properties/{property}/dataStreams/{data_stream}/enhancedMeasurementSettings
     * - eventCreateRule: properties/{property}/dataStreams/{data_stream}/eventCreateRules/{event_create_rule}
     * - expandedDataSet: properties/{property}/expandedDataSets/{expanded_data_set}
     * - firebaseLink: properties/{property}/firebaseLinks/{firebase_link}
     * - globalSiteTag: properties/{property}/dataStreams/{data_stream}/globalSiteTag
     * - googleAdsLink: properties/{property}/googleAdsLinks/{google_ads_link}
     * - googleSignalsSettings: properties/{property}/googleSignalsSettings
     * - measurementProtocolSecret: properties/{property}/dataStreams/{data_stream}/measurementProtocolSecrets/{measurement_protocol_secret}
     * - property: properties/{property}
     * - propertyAccessBinding: properties/{property}/accessBindings/{access_binding}
     * - rollupPropertySourceLink: properties/{property}/rollupPropertySourceLinks/{rollup_property_source_link}
     * - sKAdNetworkConversionValueSchema: properties/{property}/dataStreams/{data_stream}/sKAdNetworkConversionValueSchema/{skadnetwork_conversion_value_schema}
     * - searchAds360Link: properties/{property}/searchAds360Links/{search_ads_360_link}
     * - subpropertyEventFilter: properties/{property}/subpropertyEventFilters/{sub_property_event_filter}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'analyticsadmin.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Acknowledges the terms of user data collection for the specified property.
     *
     * This acknowledgement must be completed (either in the Google Analytics UI
     * or through this API) before MeasurementProtocolSecret resources may be
     * created.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::acknowledgeUserDataCollectionAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/acknowledge_user_data_collection.php
     *
     * @param AcknowledgeUserDataCollectionRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AcknowledgeUserDataCollectionResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function acknowledgeUserDataCollection(AcknowledgeUserDataCollectionRequest $request, array $callOptions = []): AcknowledgeUserDataCollectionResponse
    {
        return $this->startApiCall('AcknowledgeUserDataCollection', $request, $callOptions)->wait();
    }

    /**
     * Approves a DisplayVideo360AdvertiserLinkProposal.
     * The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
     * DisplayVideo360AdvertiserLink will be created.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::approveDisplayVideo360AdvertiserLinkProposalAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/approve_display_video360_advertiser_link_proposal.php
     *
     * @param ApproveDisplayVideo360AdvertiserLinkProposalRequest $request     A request to house fields associated with the call.
     * @param array                                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApproveDisplayVideo360AdvertiserLinkProposalResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function approveDisplayVideo360AdvertiserLinkProposal(ApproveDisplayVideo360AdvertiserLinkProposalRequest $request, array $callOptions = []): ApproveDisplayVideo360AdvertiserLinkProposalResponse
    {
        return $this->startApiCall('ApproveDisplayVideo360AdvertiserLinkProposal', $request, $callOptions)->wait();
    }

    /**
     * Archives an Audience on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::archiveAudienceAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/archive_audience.php
     *
     * @param ArchiveAudienceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function archiveAudience(ArchiveAudienceRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ArchiveAudience', $request, $callOptions)->wait();
    }

    /**
     * Archives a CustomDimension on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::archiveCustomDimensionAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/archive_custom_dimension.php
     *
     * @param ArchiveCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function archiveCustomDimension(ArchiveCustomDimensionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ArchiveCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Archives a CustomMetric on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::archiveCustomMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/archive_custom_metric.php
     *
     * @param ArchiveCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function archiveCustomMetric(ArchiveCustomMetricRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ArchiveCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Creates information about multiple access bindings to an account or
     * property.
     *
     * This method is transactional. If any AccessBinding cannot be created, none
     * of the AccessBindings will be created.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::batchCreateAccessBindingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/batch_create_access_bindings.php
     *
     * @param BatchCreateAccessBindingsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchCreateAccessBindingsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function batchCreateAccessBindings(BatchCreateAccessBindingsRequest $request, array $callOptions = []): BatchCreateAccessBindingsResponse
    {
        return $this->startApiCall('BatchCreateAccessBindings', $request, $callOptions)->wait();
    }

    /**
     * Deletes information about multiple users' links to an account or property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::batchDeleteAccessBindingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/batch_delete_access_bindings.php
     *
     * @param BatchDeleteAccessBindingsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function batchDeleteAccessBindings(BatchDeleteAccessBindingsRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('BatchDeleteAccessBindings', $request, $callOptions)->wait();
    }

    /**
     * Gets information about multiple access bindings to an account or property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::batchGetAccessBindingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/batch_get_access_bindings.php
     *
     * @param BatchGetAccessBindingsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchGetAccessBindingsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function batchGetAccessBindings(BatchGetAccessBindingsRequest $request, array $callOptions = []): BatchGetAccessBindingsResponse
    {
        return $this->startApiCall('BatchGetAccessBindings', $request, $callOptions)->wait();
    }

    /**
     * Updates information about multiple access bindings to an account or
     * property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::batchUpdateAccessBindingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/batch_update_access_bindings.php
     *
     * @param BatchUpdateAccessBindingsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchUpdateAccessBindingsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function batchUpdateAccessBindings(BatchUpdateAccessBindingsRequest $request, array $callOptions = []): BatchUpdateAccessBindingsResponse
    {
        return $this->startApiCall('BatchUpdateAccessBindings', $request, $callOptions)->wait();
    }

    /**
     * Cancels a DisplayVideo360AdvertiserLinkProposal.
     * Cancelling can mean either:
     * - Declining a proposal initiated from Display & Video 360
     * - Withdrawing a proposal initiated from Google Analytics
     * After being cancelled, a proposal will eventually be deleted automatically.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::cancelDisplayVideo360AdvertiserLinkProposalAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/cancel_display_video360_advertiser_link_proposal.php
     *
     * @param CancelDisplayVideo360AdvertiserLinkProposalRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DisplayVideo360AdvertiserLinkProposal
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function cancelDisplayVideo360AdvertiserLinkProposal(CancelDisplayVideo360AdvertiserLinkProposalRequest $request, array $callOptions = []): DisplayVideo360AdvertiserLinkProposal
    {
        return $this->startApiCall('CancelDisplayVideo360AdvertiserLinkProposal', $request, $callOptions)->wait();
    }

    /**
     * Creates an access binding on an account or property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createAccessBindingAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_access_binding.php
     *
     * @param CreateAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AccessBinding
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAccessBinding(CreateAccessBindingRequest $request, array $callOptions = []): AccessBinding
    {
        return $this->startApiCall('CreateAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Creates an AdSenseLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createAdSenseLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_ad_sense_link.php
     *
     * @param CreateAdSenseLinkRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AdSenseLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAdSenseLink(CreateAdSenseLinkRequest $request, array $callOptions = []): AdSenseLink
    {
        return $this->startApiCall('CreateAdSenseLink', $request, $callOptions)->wait();
    }

    /**
     * Creates an Audience.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::createAudienceAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_audience.php
     *
     * @param CreateAudienceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Audience
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createAudience(CreateAudienceRequest $request, array $callOptions = []): Audience
    {
        return $this->startApiCall('CreateAudience', $request, $callOptions)->wait();
    }

    /**
     * Creates a CalculatedMetric.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createCalculatedMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_calculated_metric.php
     *
     * @param CreateCalculatedMetricRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CalculatedMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createCalculatedMetric(CreateCalculatedMetricRequest $request, array $callOptions = []): CalculatedMetric
    {
        return $this->startApiCall('CreateCalculatedMetric', $request, $callOptions)->wait();
    }

    /**
     * Creates a ChannelGroup.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createChannelGroupAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_channel_group.php
     *
     * @param CreateChannelGroupRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelGroup
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createChannelGroup(CreateChannelGroupRequest $request, array $callOptions = []): ChannelGroup
    {
        return $this->startApiCall('CreateChannelGroup', $request, $callOptions)->wait();
    }

    /**
     * Creates a connected site tag for a Universal Analytics property. You can
     * create a maximum of 20 connected site tags per property.
     * Note: This API cannot be used on GA4 properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createConnectedSiteTagAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_connected_site_tag.php
     *
     * @param CreateConnectedSiteTagRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CreateConnectedSiteTagResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createConnectedSiteTag(CreateConnectedSiteTagRequest $request, array $callOptions = []): CreateConnectedSiteTagResponse
    {
        return $this->startApiCall('CreateConnectedSiteTag', $request, $callOptions)->wait();
    }

    /**
     * Creates a conversion event with the specified attributes.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createConversionEventAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_conversion_event.php
     *
     * @param CreateConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createConversionEvent(CreateConversionEventRequest $request, array $callOptions = []): ConversionEvent
    {
        return $this->startApiCall('CreateConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Creates a CustomDimension.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createCustomDimensionAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_custom_dimension.php
     *
     * @param CreateCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomDimension
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createCustomDimension(CreateCustomDimensionRequest $request, array $callOptions = []): CustomDimension
    {
        return $this->startApiCall('CreateCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Creates a CustomMetric.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createCustomMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_custom_metric.php
     *
     * @param CreateCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createCustomMetric(CreateCustomMetricRequest $request, array $callOptions = []): CustomMetric
    {
        return $this->startApiCall('CreateCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Creates a DataStream.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::createDataStreamAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_data_stream.php
     *
     * @param CreateDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataStream
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createDataStream(CreateDataStreamRequest $request, array $callOptions = []): DataStream
    {
        return $this->startApiCall('CreateDataStream', $request, $callOptions)->wait();
    }

    /**
     * Creates a DisplayVideo360AdvertiserLink.
     * This can only be utilized by users who have proper authorization both on
     * the Google Analytics property and on the Display & Video 360 advertiser.
     * Users who do not have access to the Display & Video 360 advertiser should
     * instead seek to create a DisplayVideo360LinkProposal.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createDisplayVideo360AdvertiserLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_display_video360_advertiser_link.php
     *
     * @param CreateDisplayVideo360AdvertiserLinkRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DisplayVideo360AdvertiserLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createDisplayVideo360AdvertiserLink(CreateDisplayVideo360AdvertiserLinkRequest $request, array $callOptions = []): DisplayVideo360AdvertiserLink
    {
        return $this->startApiCall('CreateDisplayVideo360AdvertiserLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a DisplayVideo360AdvertiserLinkProposal.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createDisplayVideo360AdvertiserLinkProposalAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_display_video360_advertiser_link_proposal.php
     *
     * @param CreateDisplayVideo360AdvertiserLinkProposalRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DisplayVideo360AdvertiserLinkProposal
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createDisplayVideo360AdvertiserLinkProposal(CreateDisplayVideo360AdvertiserLinkProposalRequest $request, array $callOptions = []): DisplayVideo360AdvertiserLinkProposal
    {
        return $this->startApiCall('CreateDisplayVideo360AdvertiserLinkProposal', $request, $callOptions)->wait();
    }

    /**
     * Creates an EventCreateRule.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createEventCreateRuleAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_event_create_rule.php
     *
     * @param CreateEventCreateRuleRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventCreateRule
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createEventCreateRule(CreateEventCreateRuleRequest $request, array $callOptions = []): EventCreateRule
    {
        return $this->startApiCall('CreateEventCreateRule', $request, $callOptions)->wait();
    }

    /**
     * Creates a ExpandedDataSet.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createExpandedDataSetAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_expanded_data_set.php
     *
     * @param CreateExpandedDataSetRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExpandedDataSet
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createExpandedDataSet(CreateExpandedDataSetRequest $request, array $callOptions = []): ExpandedDataSet
    {
        return $this->startApiCall('CreateExpandedDataSet', $request, $callOptions)->wait();
    }

    /**
     * Creates a FirebaseLink.
     *
     * Properties can have at most one FirebaseLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createFirebaseLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_firebase_link.php
     *
     * @param CreateFirebaseLinkRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FirebaseLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createFirebaseLink(CreateFirebaseLinkRequest $request, array $callOptions = []): FirebaseLink
    {
        return $this->startApiCall('CreateFirebaseLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a GoogleAdsLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createGoogleAdsLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_google_ads_link.php
     *
     * @param CreateGoogleAdsLinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleAdsLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createGoogleAdsLink(CreateGoogleAdsLinkRequest $request, array $callOptions = []): GoogleAdsLink
    {
        return $this->startApiCall('CreateGoogleAdsLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a measurement protocol secret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_measurement_protocol_secret.php
     *
     * @param CreateMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MeasurementProtocolSecret
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createMeasurementProtocolSecret(CreateMeasurementProtocolSecretRequest $request, array $callOptions = []): MeasurementProtocolSecret
    {
        return $this->startApiCall('CreateMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Creates an "GA4" property with the specified location and attributes.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::createPropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_property.php
     *
     * @param CreatePropertyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createProperty(CreatePropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('CreateProperty', $request, $callOptions)->wait();
    }

    /**
     * Create a roll-up property and all roll-up property source links.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createRollupPropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_rollup_property.php
     *
     * @param CreateRollupPropertyRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CreateRollupPropertyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createRollupProperty(CreateRollupPropertyRequest $request, array $callOptions = []): CreateRollupPropertyResponse
    {
        return $this->startApiCall('CreateRollupProperty', $request, $callOptions)->wait();
    }

    /**
     * Creates a roll-up property source link.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createRollupPropertySourceLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_rollup_property_source_link.php
     *
     * @param CreateRollupPropertySourceLinkRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RollupPropertySourceLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createRollupPropertySourceLink(CreateRollupPropertySourceLinkRequest $request, array $callOptions = []): RollupPropertySourceLink
    {
        return $this->startApiCall('CreateRollupPropertySourceLink', $request, $callOptions)->wait();
    }

    /**
     * Creates a SKAdNetworkConversionValueSchema.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createSKAdNetworkConversionValueSchemaAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_sk_ad_network_conversion_value_schema.php
     *
     * @param CreateSKAdNetworkConversionValueSchemaRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SKAdNetworkConversionValueSchema
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createSKAdNetworkConversionValueSchema(CreateSKAdNetworkConversionValueSchemaRequest $request, array $callOptions = []): SKAdNetworkConversionValueSchema
    {
        return $this->startApiCall('CreateSKAdNetworkConversionValueSchema', $request, $callOptions)->wait();
    }

    /**
     * Creates a SearchAds360Link.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createSearchAds360LinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_search_ads360_link.php
     *
     * @param CreateSearchAds360LinkRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SearchAds360Link
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createSearchAds360Link(CreateSearchAds360LinkRequest $request, array $callOptions = []): SearchAds360Link
    {
        return $this->startApiCall('CreateSearchAds360Link', $request, $callOptions)->wait();
    }

    /**
     * Create a subproperty and a subproperty event filter that applies to the
     * created subproperty.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createSubpropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_subproperty.php
     *
     * @param CreateSubpropertyRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CreateSubpropertyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createSubproperty(CreateSubpropertyRequest $request, array $callOptions = []): CreateSubpropertyResponse
    {
        return $this->startApiCall('CreateSubproperty', $request, $callOptions)->wait();
    }

    /**
     * Creates a subproperty Event Filter.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::createSubpropertyEventFilterAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/create_subproperty_event_filter.php
     *
     * @param CreateSubpropertyEventFilterRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SubpropertyEventFilter
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function createSubpropertyEventFilter(CreateSubpropertyEventFilterRequest $request, array $callOptions = []): SubpropertyEventFilter
    {
        return $this->startApiCall('CreateSubpropertyEventFilter', $request, $callOptions)->wait();
    }

    /**
     * Deletes an access binding on an account or property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteAccessBindingAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_access_binding.php
     *
     * @param DeleteAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAccessBinding(DeleteAccessBindingRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Marks target Account as soft-deleted (ie: "trashed") and returns it.
     *
     * This API does not have a method to restore soft-deleted accounts.
     * However, they can be restored using the Trash Can UI.
     *
     * If the accounts are not restored before the expiration time, the account
     * and all child resources (eg: Properties, GoogleAdsLinks, Streams,
     * AccessBindings) will be permanently purged.
     * https://support.google.com/analytics/answer/6154772
     *
     * Returns an error if the target is not found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deleteAccountAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_account.php
     *
     * @param DeleteAccountRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAccount(DeleteAccountRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAccount', $request, $callOptions)->wait();
    }

    /**
     * Deletes an AdSenseLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteAdSenseLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_ad_sense_link.php
     *
     * @param DeleteAdSenseLinkRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteAdSenseLink(DeleteAdSenseLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAdSenseLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a CalculatedMetric on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteCalculatedMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_calculated_metric.php
     *
     * @param DeleteCalculatedMetricRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteCalculatedMetric(DeleteCalculatedMetricRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteCalculatedMetric', $request, $callOptions)->wait();
    }

    /**
     * Deletes a ChannelGroup on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteChannelGroupAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_channel_group.php
     *
     * @param DeleteChannelGroupRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteChannelGroup(DeleteChannelGroupRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteChannelGroup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a connected site tag for a Universal Analytics property.
     * Note: this has no effect on GA4 properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteConnectedSiteTagAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_connected_site_tag.php
     *
     * @param DeleteConnectedSiteTagRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteConnectedSiteTag(DeleteConnectedSiteTagRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConnectedSiteTag', $request, $callOptions)->wait();
    }

    /**
     * Deletes a conversion event in a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteConversionEventAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_conversion_event.php
     *
     * @param DeleteConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteConversionEvent(DeleteConversionEventRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Deletes a DataStream on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deleteDataStreamAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_data_stream.php
     *
     * @param DeleteDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteDataStream(DeleteDataStreamRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDataStream', $request, $callOptions)->wait();
    }

    /**
     * Deletes a DisplayVideo360AdvertiserLink on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteDisplayVideo360AdvertiserLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_display_video360_advertiser_link.php
     *
     * @param DeleteDisplayVideo360AdvertiserLinkRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteDisplayVideo360AdvertiserLink(DeleteDisplayVideo360AdvertiserLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDisplayVideo360AdvertiserLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
     * This can only be used on cancelled proposals.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteDisplayVideo360AdvertiserLinkProposalAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_display_video360_advertiser_link_proposal.php
     *
     * @param DeleteDisplayVideo360AdvertiserLinkProposalRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteDisplayVideo360AdvertiserLinkProposal(DeleteDisplayVideo360AdvertiserLinkProposalRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDisplayVideo360AdvertiserLinkProposal', $request, $callOptions)->wait();
    }

    /**
     * Deletes an EventCreateRule.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteEventCreateRuleAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_event_create_rule.php
     *
     * @param DeleteEventCreateRuleRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteEventCreateRule(DeleteEventCreateRuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEventCreateRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a ExpandedDataSet on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteExpandedDataSetAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_expanded_data_set.php
     *
     * @param DeleteExpandedDataSetRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteExpandedDataSet(DeleteExpandedDataSetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteExpandedDataSet', $request, $callOptions)->wait();
    }

    /**
     * Deletes a FirebaseLink on a property
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteFirebaseLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_firebase_link.php
     *
     * @param DeleteFirebaseLinkRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteFirebaseLink(DeleteFirebaseLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteFirebaseLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a GoogleAdsLink on a property
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteGoogleAdsLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_google_ads_link.php
     *
     * @param DeleteGoogleAdsLinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteGoogleAdsLink(DeleteGoogleAdsLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteGoogleAdsLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes target MeasurementProtocolSecret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_measurement_protocol_secret.php
     *
     * @param DeleteMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteMeasurementProtocolSecret(DeleteMeasurementProtocolSecretRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Marks target Property as soft-deleted (ie: "trashed") and returns it.
     *
     * This API does not have a method to restore soft-deleted properties.
     * However, they can be restored using the Trash Can UI.
     *
     * If the properties are not restored before the expiration time, the Property
     * and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
     * will be permanently purged.
     * https://support.google.com/analytics/answer/6154772
     *
     * Returns an error if the target is not found, or is not a GA4 Property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::deletePropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_property.php
     *
     * @param DeletePropertyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteProperty(DeletePropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('DeleteProperty', $request, $callOptions)->wait();
    }

    /**
     * Deletes a roll-up property source link.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteRollupPropertySourceLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_rollup_property_source_link.php
     *
     * @param DeleteRollupPropertySourceLinkRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteRollupPropertySourceLink(DeleteRollupPropertySourceLinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteRollupPropertySourceLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes target SKAdNetworkConversionValueSchema.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteSKAdNetworkConversionValueSchemaAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_sk_ad_network_conversion_value_schema.php
     *
     * @param DeleteSKAdNetworkConversionValueSchemaRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteSKAdNetworkConversionValueSchema(DeleteSKAdNetworkConversionValueSchemaRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSKAdNetworkConversionValueSchema', $request, $callOptions)->wait();
    }

    /**
     * Deletes a SearchAds360Link on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteSearchAds360LinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_search_ads360_link.php
     *
     * @param DeleteSearchAds360LinkRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteSearchAds360Link(DeleteSearchAds360LinkRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSearchAds360Link', $request, $callOptions)->wait();
    }

    /**
     * Deletes a subproperty event filter.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::deleteSubpropertyEventFilterAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/delete_subproperty_event_filter.php
     *
     * @param DeleteSubpropertyEventFilterRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function deleteSubpropertyEventFilter(DeleteSubpropertyEventFilterRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSubpropertyEventFilter', $request, $callOptions)->wait();
    }

    /**
     * Fetches the opt out status for the automated GA4 setup process for a UA
     * property.
     * Note: this has no effect on GA4 property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::fetchAutomatedGa4ConfigurationOptOutAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/fetch_automated_ga4_configuration_opt_out.php
     *
     * @param FetchAutomatedGa4ConfigurationOptOutRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchAutomatedGa4ConfigurationOptOutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchAutomatedGa4ConfigurationOptOut(FetchAutomatedGa4ConfigurationOptOutRequest $request, array $callOptions = []): FetchAutomatedGa4ConfigurationOptOutResponse
    {
        return $this->startApiCall('FetchAutomatedGa4ConfigurationOptOut', $request, $callOptions)->wait();
    }

    /**
     * Given a specified UA property, looks up the GA4 property connected to it.
     * Note: this cannot be used with GA4 properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::fetchConnectedGa4PropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/fetch_connected_ga4_property.php
     *
     * @param FetchConnectedGa4PropertyRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchConnectedGa4PropertyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function fetchConnectedGa4Property(FetchConnectedGa4PropertyRequest $request, array $callOptions = []): FetchConnectedGa4PropertyResponse
    {
        return $this->startApiCall('FetchConnectedGa4Property', $request, $callOptions)->wait();
    }

    /**
     * Gets information about an access binding.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getAccessBindingAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_access_binding.php
     *
     * @param GetAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AccessBinding
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAccessBinding(GetAccessBindingRequest $request, array $callOptions = []): AccessBinding
    {
        return $this->startApiCall('GetAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single Account.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getAccountAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_account.php
     *
     * @param GetAccountRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Account
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAccount(GetAccountRequest $request, array $callOptions = []): Account
    {
        return $this->startApiCall('GetAccount', $request, $callOptions)->wait();
    }

    /**
     * Looks up a single AdSenseLink.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getAdSenseLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_ad_sense_link.php
     *
     * @param GetAdSenseLinkRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AdSenseLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAdSenseLink(GetAdSenseLinkRequest $request, array $callOptions = []): AdSenseLink
    {
        return $this->startApiCall('GetAdSenseLink', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a AttributionSettings singleton.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getAttributionSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_attribution_settings.php
     *
     * @param GetAttributionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAttributionSettings(GetAttributionSettingsRequest $request, array $callOptions = []): AttributionSettings
    {
        return $this->startApiCall('GetAttributionSettings', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single Audience.
     * Audiences created before 2020 may not be supported.
     * Default audiences will not show filter definitions.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getAudienceAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_audience.php
     *
     * @param GetAudienceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Audience
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getAudience(GetAudienceRequest $request, array $callOptions = []): Audience
    {
        return $this->startApiCall('GetAudience', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single BigQuery Link.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getBigQueryLinkAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_big_query_link.php
     *
     * @param GetBigQueryLinkRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BigQueryLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getBigQueryLink(GetBigQueryLinkRequest $request, array $callOptions = []): BigQueryLink
    {
        return $this->startApiCall('GetBigQueryLink', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single CalculatedMetric.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getCalculatedMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_calculated_metric.php
     *
     * @param GetCalculatedMetricRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CalculatedMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getCalculatedMetric(GetCalculatedMetricRequest $request, array $callOptions = []): CalculatedMetric
    {
        return $this->startApiCall('GetCalculatedMetric', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single ChannelGroup.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getChannelGroupAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_channel_group.php
     *
     * @param GetChannelGroupRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelGroup
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getChannelGroup(GetChannelGroupRequest $request, array $callOptions = []): ChannelGroup
    {
        return $this->startApiCall('GetChannelGroup', $request, $callOptions)->wait();
    }

    /**
     * Retrieve a single conversion event.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getConversionEventAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_conversion_event.php
     *
     * @param GetConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getConversionEvent(GetConversionEventRequest $request, array $callOptions = []): ConversionEvent
    {
        return $this->startApiCall('GetConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single CustomDimension.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getCustomDimensionAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_custom_dimension.php
     *
     * @param GetCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomDimension
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getCustomDimension(GetCustomDimensionRequest $request, array $callOptions = []): CustomDimension
    {
        return $this->startApiCall('GetCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single CustomMetric.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getCustomMetricAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_custom_metric.php
     *
     * @param GetCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getCustomMetric(GetCustomMetricRequest $request, array $callOptions = []): CustomMetric
    {
        return $this->startApiCall('GetCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single DataRedactionSettings.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDataRedactionSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_data_redaction_settings.php
     *
     * @param GetDataRedactionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataRedactionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataRedactionSettings(GetDataRedactionSettingsRequest $request, array $callOptions = []): DataRedactionSettings
    {
        return $this->startApiCall('GetDataRedactionSettings', $request, $callOptions)->wait();
    }

    /**
     * Returns the singleton data retention settings for this property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDataRetentionSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_data_retention_settings.php
     *
     * @param GetDataRetentionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataRetentionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataRetentionSettings(GetDataRetentionSettingsRequest $request, array $callOptions = []): DataRetentionSettings
    {
        return $this->startApiCall('GetDataRetentionSettings', $request, $callOptions)->wait();
    }

    /**
     * Get data sharing settings on an account.
     * Data sharing settings are singletons.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDataSharingSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_data_sharing_settings.php
     *
     * @param GetDataSharingSettingsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataSharingSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataSharingSettings(GetDataSharingSettingsRequest $request, array $callOptions = []): DataSharingSettings
    {
        return $this->startApiCall('GetDataSharingSettings', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single DataStream.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getDataStreamAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_data_stream.php
     *
     * @param GetDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataStream
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDataStream(GetDataStreamRequest $request, array $callOptions = []): DataStream
    {
        return $this->startApiCall('GetDataStream', $request, $callOptions)->wait();
    }

    /**
     * Look up a single DisplayVideo360AdvertiserLink
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDisplayVideo360AdvertiserLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_display_video360_advertiser_link.php
     *
     * @param GetDisplayVideo360AdvertiserLinkRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DisplayVideo360AdvertiserLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDisplayVideo360AdvertiserLink(GetDisplayVideo360AdvertiserLinkRequest $request, array $callOptions = []): DisplayVideo360AdvertiserLink
    {
        return $this->startApiCall('GetDisplayVideo360AdvertiserLink', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single DisplayVideo360AdvertiserLinkProposal.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getDisplayVideo360AdvertiserLinkProposalAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_display_video360_advertiser_link_proposal.php
     *
     * @param GetDisplayVideo360AdvertiserLinkProposalRequest $request     A request to house fields associated with the call.
     * @param array                                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DisplayVideo360AdvertiserLinkProposal
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getDisplayVideo360AdvertiserLinkProposal(GetDisplayVideo360AdvertiserLinkProposalRequest $request, array $callOptions = []): DisplayVideo360AdvertiserLinkProposal
    {
        return $this->startApiCall('GetDisplayVideo360AdvertiserLinkProposal', $request, $callOptions)->wait();
    }

    /**
     * Returns the enhanced measurement settings for this data stream.
     * Note that the stream must enable enhanced measurement for these settings to
     * take effect.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getEnhancedMeasurementSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_enhanced_measurement_settings.php
     *
     * @param GetEnhancedMeasurementSettingsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EnhancedMeasurementSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEnhancedMeasurementSettings(GetEnhancedMeasurementSettingsRequest $request, array $callOptions = []): EnhancedMeasurementSettings
    {
        return $this->startApiCall('GetEnhancedMeasurementSettings', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single EventCreateRule.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getEventCreateRuleAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_event_create_rule.php
     *
     * @param GetEventCreateRuleRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventCreateRule
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getEventCreateRule(GetEventCreateRuleRequest $request, array $callOptions = []): EventCreateRule
    {
        return $this->startApiCall('GetEventCreateRule', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single ExpandedDataSet.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getExpandedDataSetAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_expanded_data_set.php
     *
     * @param GetExpandedDataSetRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExpandedDataSet
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getExpandedDataSet(GetExpandedDataSetRequest $request, array $callOptions = []): ExpandedDataSet
    {
        return $this->startApiCall('GetExpandedDataSet', $request, $callOptions)->wait();
    }

    /**
     * Returns the Site Tag for the specified web stream.
     * Site Tags are immutable singletons.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getGlobalSiteTagAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_global_site_tag.php
     *
     * @param GetGlobalSiteTagRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GlobalSiteTag
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getGlobalSiteTag(GetGlobalSiteTagRequest $request, array $callOptions = []): GlobalSiteTag
    {
        return $this->startApiCall('GetGlobalSiteTag', $request, $callOptions)->wait();
    }

    /**
     * Lookup for Google Signals settings for a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getGoogleSignalsSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_google_signals_settings.php
     *
     * @param GetGoogleSignalsSettingsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleSignalsSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getGoogleSignalsSettings(GetGoogleSignalsSettingsRequest $request, array $callOptions = []): GoogleSignalsSettings
    {
        return $this->startApiCall('GetGoogleSignalsSettings', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single "GA4" MeasurementProtocolSecret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_measurement_protocol_secret.php
     *
     * @param GetMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MeasurementProtocolSecret
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getMeasurementProtocolSecret(GetMeasurementProtocolSecretRequest $request, array $callOptions = []): MeasurementProtocolSecret
    {
        return $this->startApiCall('GetMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single "GA4" Property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::getPropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_property.php
     *
     * @param GetPropertyRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getProperty(GetPropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('GetProperty', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single roll-up property source Link.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getRollupPropertySourceLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_rollup_property_source_link.php
     *
     * @param GetRollupPropertySourceLinkRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RollupPropertySourceLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getRollupPropertySourceLink(GetRollupPropertySourceLinkRequest $request, array $callOptions = []): RollupPropertySourceLink
    {
        return $this->startApiCall('GetRollupPropertySourceLink', $request, $callOptions)->wait();
    }

    /**
     * Looks up a single SKAdNetworkConversionValueSchema.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getSKAdNetworkConversionValueSchemaAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_sk_ad_network_conversion_value_schema.php
     *
     * @param GetSKAdNetworkConversionValueSchemaRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SKAdNetworkConversionValueSchema
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getSKAdNetworkConversionValueSchema(GetSKAdNetworkConversionValueSchemaRequest $request, array $callOptions = []): SKAdNetworkConversionValueSchema
    {
        return $this->startApiCall('GetSKAdNetworkConversionValueSchema', $request, $callOptions)->wait();
    }

    /**
     * Look up a single SearchAds360Link
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getSearchAds360LinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_search_ads360_link.php
     *
     * @param GetSearchAds360LinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SearchAds360Link
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getSearchAds360Link(GetSearchAds360LinkRequest $request, array $callOptions = []): SearchAds360Link
    {
        return $this->startApiCall('GetSearchAds360Link', $request, $callOptions)->wait();
    }

    /**
     * Lookup for a single subproperty Event Filter.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::getSubpropertyEventFilterAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/get_subproperty_event_filter.php
     *
     * @param GetSubpropertyEventFilterRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SubpropertyEventFilter
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function getSubpropertyEventFilter(GetSubpropertyEventFilterRequest $request, array $callOptions = []): SubpropertyEventFilter
    {
        return $this->startApiCall('GetSubpropertyEventFilter', $request, $callOptions)->wait();
    }

    /**
     * Lists all access bindings on an account or property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listAccessBindingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_access_bindings.php
     *
     * @param ListAccessBindingsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAccessBindings(ListAccessBindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccessBindings', $request, $callOptions);
    }

    /**
     * Returns summaries of all accounts accessible by the caller.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listAccountSummariesAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_account_summaries.php
     *
     * @param ListAccountSummariesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAccountSummaries(ListAccountSummariesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccountSummaries', $request, $callOptions);
    }

    /**
     * Returns all accounts accessible by the caller.
     *
     * Note that these accounts might not currently have GA4 properties.
     * Soft-deleted (ie: "trashed") accounts are excluded by default.
     * Returns an empty list if no relevant accounts are found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listAccountsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_accounts.php
     *
     * @param ListAccountsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAccounts(ListAccountsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccounts', $request, $callOptions);
    }

    /**
     * Lists AdSenseLinks on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listAdSenseLinksAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_ad_sense_links.php
     *
     * @param ListAdSenseLinksRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAdSenseLinks(ListAdSenseLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAdSenseLinks', $request, $callOptions);
    }

    /**
     * Lists Audiences on a property.
     * Audiences created before 2020 may not be supported.
     * Default audiences will not show filter definitions.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listAudiencesAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_audiences.php
     *
     * @param ListAudiencesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listAudiences(ListAudiencesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAudiences', $request, $callOptions);
    }

    /**
     * Lists BigQuery Links on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listBigQueryLinksAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_big_query_links.php
     *
     * @param ListBigQueryLinksRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listBigQueryLinks(ListBigQueryLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBigQueryLinks', $request, $callOptions);
    }

    /**
     * Lists CalculatedMetrics on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listCalculatedMetricsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_calculated_metrics.php
     *
     * @param ListCalculatedMetricsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listCalculatedMetrics(ListCalculatedMetricsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCalculatedMetrics', $request, $callOptions);
    }

    /**
     * Lists ChannelGroups on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listChannelGroupsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_channel_groups.php
     *
     * @param ListChannelGroupsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listChannelGroups(ListChannelGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListChannelGroups', $request, $callOptions);
    }

    /**
     * Lists the connected site tags for a Universal Analytics property. A maximum
     * of 20 connected site tags will be returned. Note: this has no effect on GA4
     * property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listConnectedSiteTagsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_connected_site_tags.php
     *
     * @param ListConnectedSiteTagsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListConnectedSiteTagsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listConnectedSiteTags(ListConnectedSiteTagsRequest $request, array $callOptions = []): ListConnectedSiteTagsResponse
    {
        return $this->startApiCall('ListConnectedSiteTags', $request, $callOptions)->wait();
    }

    /**
     * Returns a list of conversion events in the specified parent property.
     *
     * Returns an empty list if no conversion events are found.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listConversionEventsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_conversion_events.php
     *
     * @param ListConversionEventsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listConversionEvents(ListConversionEventsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConversionEvents', $request, $callOptions);
    }

    /**
     * Lists CustomDimensions on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listCustomDimensionsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_custom_dimensions.php
     *
     * @param ListCustomDimensionsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listCustomDimensions(ListCustomDimensionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomDimensions', $request, $callOptions);
    }

    /**
     * Lists CustomMetrics on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listCustomMetricsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_custom_metrics.php
     *
     * @param ListCustomMetricsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listCustomMetrics(ListCustomMetricsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomMetrics', $request, $callOptions);
    }

    /**
     * Lists DataStreams on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listDataStreamsAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_data_streams.php
     *
     * @param ListDataStreamsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDataStreams(ListDataStreamsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataStreams', $request, $callOptions);
    }

    /**
     * Lists DisplayVideo360AdvertiserLinkProposals on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listDisplayVideo360AdvertiserLinkProposalsAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_display_video360_advertiser_link_proposals.php
     *
     * @param ListDisplayVideo360AdvertiserLinkProposalsRequest $request     A request to house fields associated with the call.
     * @param array                                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDisplayVideo360AdvertiserLinkProposals(ListDisplayVideo360AdvertiserLinkProposalsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDisplayVideo360AdvertiserLinkProposals', $request, $callOptions);
    }

    /**
     * Lists all DisplayVideo360AdvertiserLinks on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listDisplayVideo360AdvertiserLinksAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_display_video360_advertiser_links.php
     *
     * @param ListDisplayVideo360AdvertiserLinksRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listDisplayVideo360AdvertiserLinks(ListDisplayVideo360AdvertiserLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDisplayVideo360AdvertiserLinks', $request, $callOptions);
    }

    /**
     * Lists EventCreateRules on a web data stream.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listEventCreateRulesAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_event_create_rules.php
     *
     * @param ListEventCreateRulesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listEventCreateRules(ListEventCreateRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEventCreateRules', $request, $callOptions);
    }

    /**
     * Lists ExpandedDataSets on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listExpandedDataSetsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_expanded_data_sets.php
     *
     * @param ListExpandedDataSetsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listExpandedDataSets(ListExpandedDataSetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExpandedDataSets', $request, $callOptions);
    }

    /**
     * Lists FirebaseLinks on a property.
     * Properties can have at most one FirebaseLink.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listFirebaseLinksAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_firebase_links.php
     *
     * @param ListFirebaseLinksRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listFirebaseLinks(ListFirebaseLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFirebaseLinks', $request, $callOptions);
    }

    /**
     * Lists GoogleAdsLinks on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listGoogleAdsLinksAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_google_ads_links.php
     *
     * @param ListGoogleAdsLinksRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listGoogleAdsLinks(ListGoogleAdsLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGoogleAdsLinks', $request, $callOptions);
    }

    /**
     * Returns child MeasurementProtocolSecrets under the specified parent
     * Property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listMeasurementProtocolSecretsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_measurement_protocol_secrets.php
     *
     * @param ListMeasurementProtocolSecretsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listMeasurementProtocolSecrets(ListMeasurementProtocolSecretsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMeasurementProtocolSecrets', $request, $callOptions);
    }

    /**
     * Returns child Properties under the specified parent Account.
     *
     * Only "GA4" properties will be returned.
     * Properties will be excluded if the caller does not have access.
     * Soft-deleted (ie: "trashed") properties are excluded by default.
     * Returns an empty list if no relevant properties are found.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::listPropertiesAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_properties.php
     *
     * @param ListPropertiesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listProperties(ListPropertiesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProperties', $request, $callOptions);
    }

    /**
     * Lists roll-up property source Links on a property.
     * Only roll-up properties can have source links, so this method will throw an
     * error if used on other types of properties.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listRollupPropertySourceLinksAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_rollup_property_source_links.php
     *
     * @param ListRollupPropertySourceLinksRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listRollupPropertySourceLinks(ListRollupPropertySourceLinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRollupPropertySourceLinks', $request, $callOptions);
    }

    /**
     * Lists SKAdNetworkConversionValueSchema on a stream.
     * Properties can have at most one SKAdNetworkConversionValueSchema.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listSKAdNetworkConversionValueSchemasAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_sk_ad_network_conversion_value_schemas.php
     *
     * @param ListSKAdNetworkConversionValueSchemasRequest $request     A request to house fields associated with the call.
     * @param array                                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listSKAdNetworkConversionValueSchemas(ListSKAdNetworkConversionValueSchemasRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSKAdNetworkConversionValueSchemas', $request, $callOptions);
    }

    /**
     * Lists all SearchAds360Links on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listSearchAds360LinksAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_search_ads360_links.php
     *
     * @param ListSearchAds360LinksRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listSearchAds360Links(ListSearchAds360LinksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSearchAds360Links', $request, $callOptions);
    }

    /**
     * List all subproperty Event Filters on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::listSubpropertyEventFiltersAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/list_subproperty_event_filters.php
     *
     * @param ListSubpropertyEventFiltersRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function listSubpropertyEventFilters(ListSubpropertyEventFiltersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSubpropertyEventFilters', $request, $callOptions);
    }

    /**
     * Requests a ticket for creating an account.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::provisionAccountTicketAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/provision_account_ticket.php
     *
     * @param ProvisionAccountTicketRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ProvisionAccountTicketResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function provisionAccountTicket(ProvisionAccountTicketRequest $request, array $callOptions = []): ProvisionAccountTicketResponse
    {
        return $this->startApiCall('ProvisionAccountTicket', $request, $callOptions)->wait();
    }

    /**
     * Returns a customized report of data access records. The report provides
     * records of each time a user reads Google Analytics reporting data. Access
     * records are retained for up to 2 years.
     *
     * Data Access Reports can be requested for a property. Reports may be
     * requested for any property, but dimensions that aren't related to quota can
     * only be requested on Google Analytics 360 properties. This method is only
     * available to Administrators.
     *
     * These data access records include GA4 UI Reporting, GA4 UI Explorations,
     * GA4 Data API, and other products like Firebase & Admob that can retrieve
     * data from Google Analytics through a linkage. These records don't include
     * property configuration changes like adding a stream or changing a
     * property's time zone. For configuration change history, see
     * [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
     *
     * The async variant is {@see AnalyticsAdminServiceClient::runAccessReportAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/run_access_report.php
     *
     * @param RunAccessReportRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RunAccessReportResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function runAccessReport(RunAccessReportRequest $request, array $callOptions = []): RunAccessReportResponse
    {
        return $this->startApiCall('RunAccessReport', $request, $callOptions)->wait();
    }

    /**
     * Searches through all changes to an account or its children given the
     * specified set of filters.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::searchChangeHistoryEventsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/search_change_history_events.php
     *
     * @param SearchChangeHistoryEventsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function searchChangeHistoryEvents(SearchChangeHistoryEventsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchChangeHistoryEvents', $request, $callOptions);
    }

    /**
     * Sets the opt out status for the automated GA4 setup process for a UA
     * property.
     * Note: this has no effect on GA4 property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::setAutomatedGa4ConfigurationOptOutAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/set_automated_ga4_configuration_opt_out.php
     *
     * @param SetAutomatedGa4ConfigurationOptOutRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SetAutomatedGa4ConfigurationOptOutResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function setAutomatedGa4ConfigurationOptOut(SetAutomatedGa4ConfigurationOptOutRequest $request, array $callOptions = []): SetAutomatedGa4ConfigurationOptOutResponse
    {
        return $this->startApiCall('SetAutomatedGa4ConfigurationOptOut', $request, $callOptions)->wait();
    }

    /**
     * Updates an access binding on an account or property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateAccessBindingAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_access_binding.php
     *
     * @param UpdateAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AccessBinding
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateAccessBinding(UpdateAccessBindingRequest $request, array $callOptions = []): AccessBinding
    {
        return $this->startApiCall('UpdateAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Updates an account.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updateAccountAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_account.php
     *
     * @param UpdateAccountRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Account
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateAccount(UpdateAccountRequest $request, array $callOptions = []): Account
    {
        return $this->startApiCall('UpdateAccount', $request, $callOptions)->wait();
    }

    /**
     * Updates attribution settings on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateAttributionSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_attribution_settings.php
     *
     * @param UpdateAttributionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateAttributionSettings(UpdateAttributionSettingsRequest $request, array $callOptions = []): AttributionSettings
    {
        return $this->startApiCall('UpdateAttributionSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates an Audience on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updateAudienceAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_audience.php
     *
     * @param UpdateAudienceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Audience
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateAudience(UpdateAudienceRequest $request, array $callOptions = []): Audience
    {
        return $this->startApiCall('UpdateAudience', $request, $callOptions)->wait();
    }

    /**
     * Updates a CalculatedMetric on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateCalculatedMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_calculated_metric.php
     *
     * @param UpdateCalculatedMetricRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CalculatedMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateCalculatedMetric(UpdateCalculatedMetricRequest $request, array $callOptions = []): CalculatedMetric
    {
        return $this->startApiCall('UpdateCalculatedMetric', $request, $callOptions)->wait();
    }

    /**
     * Updates a ChannelGroup.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateChannelGroupAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_channel_group.php
     *
     * @param UpdateChannelGroupRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelGroup
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateChannelGroup(UpdateChannelGroupRequest $request, array $callOptions = []): ChannelGroup
    {
        return $this->startApiCall('UpdateChannelGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates a conversion event with the specified attributes.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateConversionEventAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_conversion_event.php
     *
     * @param UpdateConversionEventRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConversionEvent
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateConversionEvent(UpdateConversionEventRequest $request, array $callOptions = []): ConversionEvent
    {
        return $this->startApiCall('UpdateConversionEvent', $request, $callOptions)->wait();
    }

    /**
     * Updates a CustomDimension on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateCustomDimensionAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_custom_dimension.php
     *
     * @param UpdateCustomDimensionRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomDimension
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateCustomDimension(UpdateCustomDimensionRequest $request, array $callOptions = []): CustomDimension
    {
        return $this->startApiCall('UpdateCustomDimension', $request, $callOptions)->wait();
    }

    /**
     * Updates a CustomMetric on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateCustomMetricAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_custom_metric.php
     *
     * @param UpdateCustomMetricRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomMetric
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateCustomMetric(UpdateCustomMetricRequest $request, array $callOptions = []): CustomMetric
    {
        return $this->startApiCall('UpdateCustomMetric', $request, $callOptions)->wait();
    }

    /**
     * Updates a DataRedactionSettings on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateDataRedactionSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_data_redaction_settings.php
     *
     * @param UpdateDataRedactionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataRedactionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDataRedactionSettings(UpdateDataRedactionSettingsRequest $request, array $callOptions = []): DataRedactionSettings
    {
        return $this->startApiCall('UpdateDataRedactionSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates the singleton data retention settings for this property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateDataRetentionSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_data_retention_settings.php
     *
     * @param UpdateDataRetentionSettingsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataRetentionSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDataRetentionSettings(UpdateDataRetentionSettingsRequest $request, array $callOptions = []): DataRetentionSettings
    {
        return $this->startApiCall('UpdateDataRetentionSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates a DataStream on a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updateDataStreamAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_data_stream.php
     *
     * @param UpdateDataStreamRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataStream
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDataStream(UpdateDataStreamRequest $request, array $callOptions = []): DataStream
    {
        return $this->startApiCall('UpdateDataStream', $request, $callOptions)->wait();
    }

    /**
     * Updates a DisplayVideo360AdvertiserLink on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateDisplayVideo360AdvertiserLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_display_video360_advertiser_link.php
     *
     * @param UpdateDisplayVideo360AdvertiserLinkRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DisplayVideo360AdvertiserLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateDisplayVideo360AdvertiserLink(UpdateDisplayVideo360AdvertiserLinkRequest $request, array $callOptions = []): DisplayVideo360AdvertiserLink
    {
        return $this->startApiCall('UpdateDisplayVideo360AdvertiserLink', $request, $callOptions)->wait();
    }

    /**
     * Updates the enhanced measurement settings for this data stream.
     * Note that the stream must enable enhanced measurement for these settings to
     * take effect.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateEnhancedMeasurementSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_enhanced_measurement_settings.php
     *
     * @param UpdateEnhancedMeasurementSettingsRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EnhancedMeasurementSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateEnhancedMeasurementSettings(UpdateEnhancedMeasurementSettingsRequest $request, array $callOptions = []): EnhancedMeasurementSettings
    {
        return $this->startApiCall('UpdateEnhancedMeasurementSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates an EventCreateRule.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateEventCreateRuleAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_event_create_rule.php
     *
     * @param UpdateEventCreateRuleRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EventCreateRule
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateEventCreateRule(UpdateEventCreateRuleRequest $request, array $callOptions = []): EventCreateRule
    {
        return $this->startApiCall('UpdateEventCreateRule', $request, $callOptions)->wait();
    }

    /**
     * Updates a ExpandedDataSet on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateExpandedDataSetAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_expanded_data_set.php
     *
     * @param UpdateExpandedDataSetRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExpandedDataSet
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateExpandedDataSet(UpdateExpandedDataSetRequest $request, array $callOptions = []): ExpandedDataSet
    {
        return $this->startApiCall('UpdateExpandedDataSet', $request, $callOptions)->wait();
    }

    /**
     * Updates a GoogleAdsLink on a property
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateGoogleAdsLinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_google_ads_link.php
     *
     * @param UpdateGoogleAdsLinkRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleAdsLink
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateGoogleAdsLink(UpdateGoogleAdsLinkRequest $request, array $callOptions = []): GoogleAdsLink
    {
        return $this->startApiCall('UpdateGoogleAdsLink', $request, $callOptions)->wait();
    }

    /**
     * Updates Google Signals settings for a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateGoogleSignalsSettingsAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_google_signals_settings.php
     *
     * @param UpdateGoogleSignalsSettingsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleSignalsSettings
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateGoogleSignalsSettings(UpdateGoogleSignalsSettingsRequest $request, array $callOptions = []): GoogleSignalsSettings
    {
        return $this->startApiCall('UpdateGoogleSignalsSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates a measurement protocol secret.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateMeasurementProtocolSecretAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_measurement_protocol_secret.php
     *
     * @param UpdateMeasurementProtocolSecretRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MeasurementProtocolSecret
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateMeasurementProtocolSecret(UpdateMeasurementProtocolSecretRequest $request, array $callOptions = []): MeasurementProtocolSecret
    {
        return $this->startApiCall('UpdateMeasurementProtocolSecret', $request, $callOptions)->wait();
    }

    /**
     * Updates a property.
     *
     * The async variant is {@see AnalyticsAdminServiceClient::updatePropertyAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_property.php
     *
     * @param UpdatePropertyRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Property
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateProperty(UpdatePropertyRequest $request, array $callOptions = []): Property
    {
        return $this->startApiCall('UpdateProperty', $request, $callOptions)->wait();
    }

    /**
     * Updates a SKAdNetworkConversionValueSchema.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateSKAdNetworkConversionValueSchemaAsync()}
     * .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_sk_ad_network_conversion_value_schema.php
     *
     * @param UpdateSKAdNetworkConversionValueSchemaRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SKAdNetworkConversionValueSchema
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateSKAdNetworkConversionValueSchema(UpdateSKAdNetworkConversionValueSchemaRequest $request, array $callOptions = []): SKAdNetworkConversionValueSchema
    {
        return $this->startApiCall('UpdateSKAdNetworkConversionValueSchema', $request, $callOptions)->wait();
    }

    /**
     * Updates a SearchAds360Link on a property.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateSearchAds360LinkAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_search_ads360_link.php
     *
     * @param UpdateSearchAds360LinkRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SearchAds360Link
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateSearchAds360Link(UpdateSearchAds360LinkRequest $request, array $callOptions = []): SearchAds360Link
    {
        return $this->startApiCall('UpdateSearchAds360Link', $request, $callOptions)->wait();
    }

    /**
     * Updates a subproperty Event Filter.
     *
     * The async variant is
     * {@see AnalyticsAdminServiceClient::updateSubpropertyEventFilterAsync()} .
     *
     * @example samples/V1alpha/AnalyticsAdminServiceClient/update_subproperty_event_filter.php
     *
     * @param UpdateSubpropertyEventFilterRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SubpropertyEventFilter
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @experimental
     */
    public function updateSubpropertyEventFilter(UpdateSubpropertyEventFilterRequest $request, array $callOptions = []): SubpropertyEventFilter
    {
        return $this->startApiCall('UpdateSubpropertyEventFilter', $request, $callOptions)->wait();
    }
}
