<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1alpha/resources.proto

namespace Google\Cloud\AlloyDb\V1alpha;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A cluster is a collection of regional AlloyDB resources. It can include a
 * primary instance and one or more read pool instances.
 * All cluster resources share a storage layer, which scales as needed.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1alpha.Cluster</code>
 */
class Cluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the cluster resource with the format:
     *  * projects/{project}/locations/{region}/clusters/{cluster_id}
     * where the cluster ID segment should satisfy the regex expression
     * `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     * The prefix of the cluster resource name is the name of the parent resource:
     *  * projects/{project}/locations/{region}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * User-settable and human-readable display name for the Cluster.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * Output only. The system-generated UID of the resource. The UID is assigned
     * when the resource is created, and it is retained until it is deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. Delete time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    /**
     * Output only. The current serving state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The type of the cluster. This is an output-only field and it's
     * populated at the Cluster creation time or the Cluster promotion
     * time. The cluster type is determined by which RPC was used to create
     * the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.ClusterType cluster_type = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $cluster_type = 0;
    /**
     * Optional. The database engine major version. This is an optional field and
     * it is populated at the Cluster creation time. If a database version is not
     * supplied at cluster creation time, then a default database version will
     * be used.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.DatabaseVersion database_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $database_version = 0;
    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.NetworkConfig network_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $network_config = null;
    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project}/global/networks/{network_id}". This is required
     * to create a cluster. Deprecated, use network_config.network instead.
     *
     * Generated from protobuf field <code>string network = 10 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @deprecated
     */
    protected $network = '';
    /**
     * For Resource freshness validation (https://google.aip.dev/154)
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     */
    protected $etag = '';
    /**
     * Annotations to allow client tools to store small amount of arbitrary data.
     * This is distinct from labels.
     * https://google.aip.dev/128
     *
     * Generated from protobuf field <code>map<string, string> annotations = 12;</code>
     */
    private $annotations;
    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of Cluster does not match the user's
     * intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Input only. Initial user to setup during cluster creation. Required.
     * If used in `RestoreCluster` this is ignored.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.UserPassword initial_user = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $initial_user = null;
    /**
     * The automated backup policy for this cluster.
     * If no policy is provided then the default policy will be used. If backups
     * are supported for the cluster, the default policy takes one backup a day,
     * has a backup window of 1 hour, and retains backups for 14 days.
     * For more information on the defaults, consult the
     * documentation for the message type.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.AutomatedBackupPolicy automated_backup_policy = 17;</code>
     */
    protected $automated_backup_policy = null;
    /**
     * SSL configuration for this AlloyDB cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.SslConfig ssl_config = 18 [deprecated = true];</code>
     * @deprecated
     */
    protected $ssl_config = null;
    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.EncryptionConfig encryption_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $encryption_config = null;
    /**
     * Output only. The encryption information for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.EncryptionInfo encryption_info = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $encryption_info = null;
    /**
     * Optional. Continuous backup configuration for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.ContinuousBackupConfig continuous_backup_config = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $continuous_backup_config = null;
    /**
     * Output only. Continuous backup properties for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.ContinuousBackupInfo continuous_backup_info = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $continuous_backup_info = null;
    /**
     * Cross Region replication config specific to SECONDARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.SecondaryConfig secondary_config = 22;</code>
     */
    protected $secondary_config = null;
    /**
     * Output only. Cross Region replication config specific to PRIMARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.PrimaryConfig primary_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $primary_config = null;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = false;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Optional. The configuration for Private Service Connect (PSC) for the
     * cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.PscConfig psc_config = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $psc_config = null;
    protected $source;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AlloyDb\V1alpha\BackupSource $backup_source
     *           Output only. Cluster created from backup.
     *     @type \Google\Cloud\AlloyDb\V1alpha\MigrationSource $migration_source
     *           Output only. Cluster created via DMS migration.
     *     @type string $name
     *           Output only. The name of the cluster resource with the format:
     *            * projects/{project}/locations/{region}/clusters/{cluster_id}
     *           where the cluster ID segment should satisfy the regex expression
     *           `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     *           The prefix of the cluster resource name is the name of the parent resource:
     *            * projects/{project}/locations/{region}
     *     @type string $display_name
     *           User-settable and human-readable display name for the Cluster.
     *     @type string $uid
     *           Output only. The system-generated UID of the resource. The UID is assigned
     *           when the resource is created, and it is retained until it is deleted.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Create time stamp
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Update time stamp
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. Delete time stamp
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels as key value pairs
     *     @type int $state
     *           Output only. The current serving state of the cluster.
     *     @type int $cluster_type
     *           Output only. The type of the cluster. This is an output-only field and it's
     *           populated at the Cluster creation time or the Cluster promotion
     *           time. The cluster type is determined by which RPC was used to create
     *           the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *     @type int $database_version
     *           Optional. The database engine major version. This is an optional field and
     *           it is populated at the Cluster creation time. If a database version is not
     *           supplied at cluster creation time, then a default database version will
     *           be used.
     *     @type \Google\Cloud\AlloyDb\V1alpha\Cluster\NetworkConfig $network_config
     *     @type string $network
     *           Required. The resource link for the VPC network in which cluster resources
     *           are created and from which they are accessible via Private IP. The network
     *           must belong to the same project as the cluster. It is specified in the
     *           form: "projects/{project}/global/networks/{network_id}". This is required
     *           to create a cluster. Deprecated, use network_config.network instead.
     *     @type string $etag
     *           For Resource freshness validation (https://google.aip.dev/154)
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Annotations to allow client tools to store small amount of arbitrary data.
     *           This is distinct from labels.
     *           https://google.aip.dev/128
     *     @type bool $reconciling
     *           Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     *           Set to true if the current state of Cluster does not match the user's
     *           intended state, and the service is actively updating the resource to
     *           reconcile them. This can happen due to user-triggered updates or
     *           system actions like failover or maintenance.
     *     @type \Google\Cloud\AlloyDb\V1alpha\UserPassword $initial_user
     *           Input only. Initial user to setup during cluster creation. Required.
     *           If used in `RestoreCluster` this is ignored.
     *     @type \Google\Cloud\AlloyDb\V1alpha\AutomatedBackupPolicy $automated_backup_policy
     *           The automated backup policy for this cluster.
     *           If no policy is provided then the default policy will be used. If backups
     *           are supported for the cluster, the default policy takes one backup a day,
     *           has a backup window of 1 hour, and retains backups for 14 days.
     *           For more information on the defaults, consult the
     *           documentation for the message type.
     *     @type \Google\Cloud\AlloyDb\V1alpha\SslConfig $ssl_config
     *           SSL configuration for this AlloyDB cluster.
     *     @type \Google\Cloud\AlloyDb\V1alpha\EncryptionConfig $encryption_config
     *           Optional. The encryption config can be specified to encrypt the data disks
     *           and other persistent data resources of a cluster with a
     *           customer-managed encryption key (CMEK). When this field is not
     *           specified, the cluster will then use default encryption scheme to
     *           protect the user data.
     *     @type \Google\Cloud\AlloyDb\V1alpha\EncryptionInfo $encryption_info
     *           Output only. The encryption information for the cluster.
     *     @type \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupConfig $continuous_backup_config
     *           Optional. Continuous backup configuration for this cluster.
     *     @type \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupInfo $continuous_backup_info
     *           Output only. Continuous backup properties for this cluster.
     *     @type \Google\Cloud\AlloyDb\V1alpha\Cluster\SecondaryConfig $secondary_config
     *           Cross Region replication config specific to SECONDARY cluster.
     *     @type \Google\Cloud\AlloyDb\V1alpha\Cluster\PrimaryConfig $primary_config
     *           Output only. Cross Region replication config specific to PRIMARY cluster.
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use.
     *     @type \Google\Cloud\AlloyDb\V1alpha\Cluster\PscConfig $psc_config
     *           Optional. The configuration for Private Service Connect (PSC) for the
     *           cluster.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1Alpha\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Cluster created from backup.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.BackupSource backup_source = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\BackupSource|null
     */
    public function getBackupSource()
    {
        return $this->readOneof(15);
    }

    public function hasBackupSource()
    {
        return $this->hasOneof(15);
    }

    /**
     * Output only. Cluster created from backup.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.BackupSource backup_source = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\BackupSource $var
     * @return $this
     */
    public function setBackupSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\BackupSource::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Output only. Cluster created via DMS migration.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.MigrationSource migration_source = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\MigrationSource|null
     */
    public function getMigrationSource()
    {
        return $this->readOneof(16);
    }

    public function hasMigrationSource()
    {
        return $this->hasOneof(16);
    }

    /**
     * Output only. Cluster created via DMS migration.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.MigrationSource migration_source = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\MigrationSource $var
     * @return $this
     */
    public function setMigrationSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\MigrationSource::class);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * Output only. The name of the cluster resource with the format:
     *  * projects/{project}/locations/{region}/clusters/{cluster_id}
     * where the cluster ID segment should satisfy the regex expression
     * `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     * The prefix of the cluster resource name is the name of the parent resource:
     *  * projects/{project}/locations/{region}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the cluster resource with the format:
     *  * projects/{project}/locations/{region}/clusters/{cluster_id}
     * where the cluster ID segment should satisfy the regex expression
     * `[a-z0-9-]+`. For more details see https://google.aip.dev/122.
     * The prefix of the cluster resource name is the name of the parent resource:
     *  * projects/{project}/locations/{region}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User-settable and human-readable display name for the Cluster.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * User-settable and human-readable display name for the Cluster.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The system-generated UID of the resource. The UID is assigned
     * when the resource is created, and it is retained until it is deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. The system-generated UID of the resource. The UID is assigned
     * when the resource is created, and it is retained until it is deleted.
     *
     * Generated from protobuf field <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Create time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Update time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Delete time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. Delete time stamp
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The current serving state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current serving state of the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1alpha\Cluster\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The type of the cluster. This is an output-only field and it's
     * populated at the Cluster creation time or the Cluster promotion
     * time. The cluster type is determined by which RPC was used to create
     * the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.ClusterType cluster_type = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getClusterType()
    {
        return $this->cluster_type;
    }

    /**
     * Output only. The type of the cluster. This is an output-only field and it's
     * populated at the Cluster creation time or the Cluster promotion
     * time. The cluster type is determined by which RPC was used to create
     * the cluster (i.e. `CreateCluster` vs. `CreateSecondaryCluster`
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.ClusterType cluster_type = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setClusterType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1alpha\Cluster\ClusterType::class);
        $this->cluster_type = $var;

        return $this;
    }

    /**
     * Optional. The database engine major version. This is an optional field and
     * it is populated at the Cluster creation time. If a database version is not
     * supplied at cluster creation time, then a default database version will
     * be used.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.DatabaseVersion database_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDatabaseVersion()
    {
        return $this->database_version;
    }

    /**
     * Optional. The database engine major version. This is an optional field and
     * it is populated at the Cluster creation time. If a database version is not
     * supplied at cluster creation time, then a default database version will
     * be used.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.DatabaseVersion database_version = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1alpha\DatabaseVersion::class);
        $this->database_version = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.NetworkConfig network_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\Cluster\NetworkConfig|null
     */
    public function getNetworkConfig()
    {
        return $this->network_config;
    }

    public function hasNetworkConfig()
    {
        return isset($this->network_config);
    }

    public function clearNetworkConfig()
    {
        unset($this->network_config);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.NetworkConfig network_config = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\Cluster\NetworkConfig $var
     * @return $this
     */
    public function setNetworkConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\Cluster\NetworkConfig::class);
        $this->network_config = $var;

        return $this;
    }

    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project}/global/networks/{network_id}". This is required
     * to create a cluster. Deprecated, use network_config.network instead.
     *
     * Generated from protobuf field <code>string network = 10 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     * @deprecated
     */
    public function getNetwork()
    {
        @trigger_error('network is deprecated.', E_USER_DEPRECATED);
        return $this->network;
    }

    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project}/global/networks/{network_id}". This is required
     * to create a cluster. Deprecated, use network_config.network instead.
     *
     * Generated from protobuf field <code>string network = 10 [deprecated = true, (.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setNetwork($var)
    {
        @trigger_error('network is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * For Resource freshness validation (https://google.aip.dev/154)
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * For Resource freshness validation (https://google.aip.dev/154)
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Annotations to allow client tools to store small amount of arbitrary data.
     * This is distinct from labels.
     * https://google.aip.dev/128
     *
     * Generated from protobuf field <code>map<string, string> annotations = 12;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Annotations to allow client tools to store small amount of arbitrary data.
     * This is distinct from labels.
     * https://google.aip.dev/128
     *
     * Generated from protobuf field <code>map<string, string> annotations = 12;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of Cluster does not match the user's
     * intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Reconciling (https://google.aip.dev/128#reconciliation).
     * Set to true if the current state of Cluster does not match the user's
     * intended state, and the service is actively updating the resource to
     * reconcile them. This can happen due to user-triggered updates or
     * system actions like failover or maintenance.
     *
     * Generated from protobuf field <code>bool reconciling = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Input only. Initial user to setup during cluster creation. Required.
     * If used in `RestoreCluster` this is ignored.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.UserPassword initial_user = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\UserPassword|null
     */
    public function getInitialUser()
    {
        return $this->initial_user;
    }

    public function hasInitialUser()
    {
        return isset($this->initial_user);
    }

    public function clearInitialUser()
    {
        unset($this->initial_user);
    }

    /**
     * Input only. Initial user to setup during cluster creation. Required.
     * If used in `RestoreCluster` this is ignored.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.UserPassword initial_user = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\UserPassword $var
     * @return $this
     */
    public function setInitialUser($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\UserPassword::class);
        $this->initial_user = $var;

        return $this;
    }

    /**
     * The automated backup policy for this cluster.
     * If no policy is provided then the default policy will be used. If backups
     * are supported for the cluster, the default policy takes one backup a day,
     * has a backup window of 1 hour, and retains backups for 14 days.
     * For more information on the defaults, consult the
     * documentation for the message type.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.AutomatedBackupPolicy automated_backup_policy = 17;</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\AutomatedBackupPolicy|null
     */
    public function getAutomatedBackupPolicy()
    {
        return $this->automated_backup_policy;
    }

    public function hasAutomatedBackupPolicy()
    {
        return isset($this->automated_backup_policy);
    }

    public function clearAutomatedBackupPolicy()
    {
        unset($this->automated_backup_policy);
    }

    /**
     * The automated backup policy for this cluster.
     * If no policy is provided then the default policy will be used. If backups
     * are supported for the cluster, the default policy takes one backup a day,
     * has a backup window of 1 hour, and retains backups for 14 days.
     * For more information on the defaults, consult the
     * documentation for the message type.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.AutomatedBackupPolicy automated_backup_policy = 17;</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\AutomatedBackupPolicy $var
     * @return $this
     */
    public function setAutomatedBackupPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\AutomatedBackupPolicy::class);
        $this->automated_backup_policy = $var;

        return $this;
    }

    /**
     * SSL configuration for this AlloyDB cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.SslConfig ssl_config = 18 [deprecated = true];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\SslConfig|null
     * @deprecated
     */
    public function getSslConfig()
    {
        @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        return $this->ssl_config;
    }

    public function hasSslConfig()
    {
        @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        return isset($this->ssl_config);
    }

    public function clearSslConfig()
    {
        @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        unset($this->ssl_config);
    }

    /**
     * SSL configuration for this AlloyDB cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.SslConfig ssl_config = 18 [deprecated = true];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\SslConfig $var
     * @return $this
     * @deprecated
     */
    public function setSslConfig($var)
    {
        @trigger_error('ssl_config is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\SslConfig::class);
        $this->ssl_config = $var;

        return $this;
    }

    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.EncryptionConfig encryption_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\EncryptionConfig|null
     */
    public function getEncryptionConfig()
    {
        return $this->encryption_config;
    }

    public function hasEncryptionConfig()
    {
        return isset($this->encryption_config);
    }

    public function clearEncryptionConfig()
    {
        unset($this->encryption_config);
    }

    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.EncryptionConfig encryption_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\EncryptionConfig $var
     * @return $this
     */
    public function setEncryptionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\EncryptionConfig::class);
        $this->encryption_config = $var;

        return $this;
    }

    /**
     * Output only. The encryption information for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.EncryptionInfo encryption_info = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\EncryptionInfo|null
     */
    public function getEncryptionInfo()
    {
        return $this->encryption_info;
    }

    public function hasEncryptionInfo()
    {
        return isset($this->encryption_info);
    }

    public function clearEncryptionInfo()
    {
        unset($this->encryption_info);
    }

    /**
     * Output only. The encryption information for the cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.EncryptionInfo encryption_info = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\EncryptionInfo $var
     * @return $this
     */
    public function setEncryptionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\EncryptionInfo::class);
        $this->encryption_info = $var;

        return $this;
    }

    /**
     * Optional. Continuous backup configuration for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.ContinuousBackupConfig continuous_backup_config = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupConfig|null
     */
    public function getContinuousBackupConfig()
    {
        return $this->continuous_backup_config;
    }

    public function hasContinuousBackupConfig()
    {
        return isset($this->continuous_backup_config);
    }

    public function clearContinuousBackupConfig()
    {
        unset($this->continuous_backup_config);
    }

    /**
     * Optional. Continuous backup configuration for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.ContinuousBackupConfig continuous_backup_config = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupConfig $var
     * @return $this
     */
    public function setContinuousBackupConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupConfig::class);
        $this->continuous_backup_config = $var;

        return $this;
    }

    /**
     * Output only. Continuous backup properties for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.ContinuousBackupInfo continuous_backup_info = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupInfo|null
     */
    public function getContinuousBackupInfo()
    {
        return $this->continuous_backup_info;
    }

    public function hasContinuousBackupInfo()
    {
        return isset($this->continuous_backup_info);
    }

    public function clearContinuousBackupInfo()
    {
        unset($this->continuous_backup_info);
    }

    /**
     * Output only. Continuous backup properties for this cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.ContinuousBackupInfo continuous_backup_info = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupInfo $var
     * @return $this
     */
    public function setContinuousBackupInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\ContinuousBackupInfo::class);
        $this->continuous_backup_info = $var;

        return $this;
    }

    /**
     * Cross Region replication config specific to SECONDARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.SecondaryConfig secondary_config = 22;</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\Cluster\SecondaryConfig|null
     */
    public function getSecondaryConfig()
    {
        return $this->secondary_config;
    }

    public function hasSecondaryConfig()
    {
        return isset($this->secondary_config);
    }

    public function clearSecondaryConfig()
    {
        unset($this->secondary_config);
    }

    /**
     * Cross Region replication config specific to SECONDARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.SecondaryConfig secondary_config = 22;</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\Cluster\SecondaryConfig $var
     * @return $this
     */
    public function setSecondaryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\Cluster\SecondaryConfig::class);
        $this->secondary_config = $var;

        return $this;
    }

    /**
     * Output only. Cross Region replication config specific to PRIMARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.PrimaryConfig primary_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\Cluster\PrimaryConfig|null
     */
    public function getPrimaryConfig()
    {
        return $this->primary_config;
    }

    public function hasPrimaryConfig()
    {
        return isset($this->primary_config);
    }

    public function clearPrimaryConfig()
    {
        unset($this->primary_config);
    }

    /**
     * Output only. Cross Region replication config specific to PRIMARY cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.PrimaryConfig primary_config = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\Cluster\PrimaryConfig $var
     * @return $this
     */
    public function setPrimaryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\Cluster\PrimaryConfig::class);
        $this->primary_config = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return $this->satisfies_pzi;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Optional. The configuration for Private Service Connect (PSC) for the
     * cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.PscConfig psc_config = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1alpha\Cluster\PscConfig|null
     */
    public function getPscConfig()
    {
        return $this->psc_config;
    }

    public function hasPscConfig()
    {
        return isset($this->psc_config);
    }

    public function clearPscConfig()
    {
        unset($this->psc_config);
    }

    /**
     * Optional. The configuration for Private Service Connect (PSC) for the
     * cluster.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1alpha.Cluster.PscConfig psc_config = 31 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1alpha\Cluster\PscConfig $var
     * @return $this
     */
    public function setPscConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1alpha\Cluster\PscConfig::class);
        $this->psc_config = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSource()
    {
        return $this->whichOneof("source");
    }

}

