<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/featurestore_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AvroSource;
use Google\Cloud\AIPlatform\V1\BatchCreateFeaturesRequest;
use Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest;
use Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\EntityTypeSpec;
use Google\Cloud\AIPlatform\V1\BatchReadFeatureValuesRequest\PassThroughField;
use Google\Cloud\AIPlatform\V1\BigQuerySource;
use Google\Cloud\AIPlatform\V1\CreateEntityTypeRequest;
use Google\Cloud\AIPlatform\V1\CreateFeatureRequest;
use Google\Cloud\AIPlatform\V1\CreateFeaturestoreRequest;
use Google\Cloud\AIPlatform\V1\CsvSource;
use Google\Cloud\AIPlatform\V1\DeleteEntityTypeRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureValuesRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureValuesRequest\SelectEntity;
use Google\Cloud\AIPlatform\V1\DeleteFeatureValuesRequest\SelectTimeRangeAndFeature;
use Google\Cloud\AIPlatform\V1\DeleteFeaturestoreRequest;
use Google\Cloud\AIPlatform\V1\DestinationFeatureSetting;
use Google\Cloud\AIPlatform\V1\EntityType;
use Google\Cloud\AIPlatform\V1\ExportFeatureValuesRequest;
use Google\Cloud\AIPlatform\V1\ExportFeatureValuesRequest\FullExport;
use Google\Cloud\AIPlatform\V1\ExportFeatureValuesRequest\SnapshotExport;
use Google\Cloud\AIPlatform\V1\Feature;
use Google\Cloud\AIPlatform\V1\FeatureSelector;
use Google\Cloud\AIPlatform\V1\FeatureValueDestination;
use Google\Cloud\AIPlatform\V1\Featurestore;
use Google\Cloud\AIPlatform\V1\GetEntityTypeRequest;
use Google\Cloud\AIPlatform\V1\GetFeatureRequest;
use Google\Cloud\AIPlatform\V1\GetFeaturestoreRequest;
use Google\Cloud\AIPlatform\V1\ImportFeatureValuesRequest;
use Google\Cloud\AIPlatform\V1\ImportFeatureValuesRequest\FeatureSpec;
use Google\Cloud\AIPlatform\V1\ListEntityTypesRequest;
use Google\Cloud\AIPlatform\V1\ListEntityTypesResponse;
use Google\Cloud\AIPlatform\V1\ListFeaturesRequest;
use Google\Cloud\AIPlatform\V1\ListFeaturesResponse;
use Google\Cloud\AIPlatform\V1\ListFeaturestoresRequest;
use Google\Cloud\AIPlatform\V1\ListFeaturestoresResponse;
use Google\Cloud\AIPlatform\V1\SearchFeaturesRequest;
use Google\Cloud\AIPlatform\V1\SearchFeaturesResponse;
use Google\Cloud\AIPlatform\V1\UpdateEntityTypeRequest;
use Google\Cloud\AIPlatform\V1\UpdateFeatureRequest;
use Google\Cloud\AIPlatform\V1\UpdateFeaturestoreRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\Timestamp;

/**
 * Service Description: The service that handles CRUD and List for resources for Featurestore.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $featurestoreServiceClient = new FeaturestoreServiceClient();
 * try {
 *     $formattedParent = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
 *     $requests = [];
 *     $operationResponse = $featurestoreServiceClient->batchCreateFeatures($formattedParent, $requests);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $featurestoreServiceClient->batchCreateFeatures($formattedParent, $requests);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'batchCreateFeatures');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $featurestoreServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\AIPlatform\V1\Client\FeaturestoreServiceClient}.
 */
class FeaturestoreServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.FeaturestoreService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $entityTypeNameTemplate;

    private static $featureNameTemplate;

    private static $featureGroupNameTemplate;

    private static $featurestoreNameTemplate;

    private static $locationNameTemplate;

    private static $projectLocationFeatureGroupFeatureNameTemplate;

    private static $projectLocationFeaturestoreEntityTypeFeatureNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/featurestore_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/featurestore_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/featurestore_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/featurestore_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getEntityTypeNameTemplate()
    {
        if (self::$entityTypeNameTemplate == null) {
            self::$entityTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}'
            );
        }

        return self::$entityTypeNameTemplate;
    }

    private static function getFeatureNameTemplate()
    {
        if (self::$featureNameTemplate == null) {
            self::$featureNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}'
            );
        }

        return self::$featureNameTemplate;
    }

    private static function getFeatureGroupNameTemplate()
    {
        if (self::$featureGroupNameTemplate == null) {
            self::$featureGroupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureGroups/{feature_group}'
            );
        }

        return self::$featureGroupNameTemplate;
    }

    private static function getFeaturestoreNameTemplate()
    {
        if (self::$featurestoreNameTemplate == null) {
            self::$featurestoreNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}'
            );
        }

        return self::$featurestoreNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getProjectLocationFeatureGroupFeatureNameTemplate()
    {
        if (self::$projectLocationFeatureGroupFeatureNameTemplate == null) {
            self::$projectLocationFeatureGroupFeatureNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}'
            );
        }

        return self::$projectLocationFeatureGroupFeatureNameTemplate;
    }

    private static function getProjectLocationFeaturestoreEntityTypeFeatureNameTemplate()
    {
        if (
            self::$projectLocationFeaturestoreEntityTypeFeatureNameTemplate ==
            null
        ) {
            self::$projectLocationFeaturestoreEntityTypeFeatureNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}'
            );
        }

        return self::$projectLocationFeaturestoreEntityTypeFeatureNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'entityType' => self::getEntityTypeNameTemplate(),
                'feature' => self::getFeatureNameTemplate(),
                'featureGroup' => self::getFeatureGroupNameTemplate(),
                'featurestore' => self::getFeaturestoreNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'projectLocationFeatureGroupFeature' => self::getProjectLocationFeatureGroupFeatureNameTemplate(),
                'projectLocationFeaturestoreEntityTypeFeature' => self::getProjectLocationFeaturestoreEntityTypeFeatureNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entity_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     *
     * @return string The formatted entity_type resource.
     */
    public static function entityTypeName(
        $project,
        $location,
        $featurestore,
        $entityType
    ) {
        return self::getEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a feature
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     * @param string $feature
     *
     * @return string The formatted feature resource.
     */
    public static function featureName(
        $project,
        $location,
        $featurestore,
        $entityType,
        $feature
    ) {
        return self::getFeatureNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
            'feature' => $feature,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * feature_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureGroup
     *
     * @return string The formatted feature_group resource.
     */
    public static function featureGroupName($project, $location, $featureGroup)
    {
        return self::getFeatureGroupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'feature_group' => $featureGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a featurestore
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     *
     * @return string The formatted featurestore resource.
     */
    public static function featurestoreName($project, $location, $featurestore)
    {
        return self::getFeaturestoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_feature_group_feature resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureGroup
     * @param string $feature
     *
     * @return string The formatted project_location_feature_group_feature resource.
     */
    public static function projectLocationFeatureGroupFeatureName(
        $project,
        $location,
        $featureGroup,
        $feature
    ) {
        return self::getProjectLocationFeatureGroupFeatureNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'feature_group' => $featureGroup,
                'feature' => $feature,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_featurestore_entity_type_feature resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     * @param string $feature
     *
     * @return string The formatted project_location_featurestore_entity_type_feature resource.
     */
    public static function projectLocationFeaturestoreEntityTypeFeatureName(
        $project,
        $location,
        $featurestore,
        $entityType,
        $feature
    ) {
        return self::getProjectLocationFeaturestoreEntityTypeFeatureNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'featurestore' => $featurestore,
                'entity_type' => $entityType,
                'feature' => $feature,
            ]
        );
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entityType: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}
     * - feature: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}
     * - featureGroup: projects/{project}/locations/{location}/featureGroups/{feature_group}
     * - featurestore: projects/{project}/locations/{location}/featurestores/{featurestore}
     * - location: projects/{project}/locations/{location}
     * - projectLocationFeatureGroupFeature: projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}
     * - projectLocationFeaturestoreEntityTypeFeature: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a batch of Features in a given EntityType.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $requests = [];
     *     $operationResponse = $featurestoreServiceClient->batchCreateFeatures($formattedParent, $requests);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->batchCreateFeatures($formattedParent, $requests);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'batchCreateFeatures');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string                 $parent       Required. The resource name of the EntityType to create the batch of
     *                                             Features under. Format:
     *                                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * @param CreateFeatureRequest[] $requests     Required. The request message specifying the Features to create. All
     *                                             Features must be created under the same parent EntityType. The `parent`
     *                                             field in each child request message can be omitted. If `parent` is set in a
     *                                             child request, then the value must match the `parent` value in this request
     *                                             message.
     * @param array                  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchCreateFeatures(
        $parent,
        $requests,
        array $optionalArgs = []
    ) {
        $request = new BatchCreateFeaturesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRequests($requests);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'BatchCreateFeatures',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Batch reads Feature values from a Featurestore.
     *
     * This API enables batch reading Feature values, where each read
     * instance in the batch may read Feature values of entities from one or
     * more EntityTypes. Point-in-time correctness is guaranteed for Feature
     * values of each read instance as of each instance's read timestamp.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedFeaturestore = $featurestoreServiceClient->featurestoreName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]');
     *     $destination = new FeatureValueDestination();
     *     $entityTypeSpecs = [];
     *     $operationResponse = $featurestoreServiceClient->batchReadFeatureValues($formattedFeaturestore, $destination, $entityTypeSpecs);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->batchReadFeatureValues($formattedFeaturestore, $destination, $entityTypeSpecs);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'batchReadFeatureValues');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string                  $featurestore    Required. The resource name of the Featurestore from which to query Feature
     *                                                 values. Format:
     *                                                 `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * @param FeatureValueDestination $destination     Required. Specifies output location and format.
     * @param EntityTypeSpec[]        $entityTypeSpecs Required. Specifies EntityType grouping Features to read values of and
     *                                                 settings.
     * @param array                   $optionalArgs    {
     *     Optional.
     *
     *     @type CsvSource $csvReadInstances
     *           Each read instance consists of exactly one read timestamp and one or more
     *           entity IDs identifying entities of the corresponding EntityTypes whose
     *           Features are requested.
     *
     *           Each output instance contains Feature values of requested entities
     *           concatenated together as of the read time.
     *
     *           An example read instance may be `foo_entity_id, bar_entity_id,
     *           2020-01-01T10:00:00.123Z`.
     *
     *           An example output instance may be `foo_entity_id, bar_entity_id,
     *           2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
     *           bar_entity_feature2_value`.
     *
     *           Timestamp in each read instance must be millisecond-aligned.
     *
     *           `csv_read_instances` are read instances stored in a plain-text CSV file.
     *           The header should be:
     *           [ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
     *
     *           The columns can be in any order.
     *
     *           Values in the timestamp column must use the RFC 3339 format, e.g.
     *           `2012-07-30T10:43:17.123Z`.
     *     @type BigQuerySource $bigqueryReadInstances
     *           Similar to csv_read_instances, but from BigQuery source.
     *     @type PassThroughField[] $passThroughFields
     *           When not empty, the specified fields in the *_read_instances source will be
     *           joined as-is in the output, in addition to those fields from the
     *           Featurestore Entity.
     *
     *           For BigQuery source, the type of the pass-through values will be
     *           automatically inferred. For CSV source, the pass-through values will be
     *           passed as opaque bytes.
     *     @type Timestamp $startTime
     *           Optional. Excludes Feature values with feature generation timestamp before
     *           this timestamp. If not set, retrieve oldest values kept in Feature Store.
     *           Timestamp, if present, must not have higher than millisecond precision.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchReadFeatureValues(
        $featurestore,
        $destination,
        $entityTypeSpecs,
        array $optionalArgs = []
    ) {
        $request = new BatchReadFeatureValuesRequest();
        $requestParamHeaders = [];
        $request->setFeaturestore($featurestore);
        $request->setDestination($destination);
        $request->setEntityTypeSpecs($entityTypeSpecs);
        $requestParamHeaders['featurestore'] = $featurestore;
        if (isset($optionalArgs['csvReadInstances'])) {
            $request->setCsvReadInstances($optionalArgs['csvReadInstances']);
        }

        if (isset($optionalArgs['bigqueryReadInstances'])) {
            $request->setBigqueryReadInstances(
                $optionalArgs['bigqueryReadInstances']
            );
        }

        if (isset($optionalArgs['passThroughFields'])) {
            $request->setPassThroughFields($optionalArgs['passThroughFields']);
        }

        if (isset($optionalArgs['startTime'])) {
            $request->setStartTime($optionalArgs['startTime']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'BatchReadFeatureValues',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new EntityType in a given Featurestore.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->featurestoreName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]');
     *     $entityTypeId = 'entity_type_id';
     *     $operationResponse = $featurestoreServiceClient->createEntityType($formattedParent, $entityTypeId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->createEntityType($formattedParent, $entityTypeId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'createEntityType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Featurestore to create EntityTypes.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * @param string $entityTypeId Required. The ID to use for the EntityType, which will become the final
     *                             component of the EntityType's resource name.
     *
     *                             This value may be up to 60 characters, and valid characters are
     *                             `[a-z0-9_]`. The first character cannot be a number.
     *
     *                             The value must be unique within a featurestore.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type EntityType $entityType
     *           The EntityType to create.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntityType(
        $parent,
        $entityTypeId,
        array $optionalArgs = []
    ) {
        $request = new CreateEntityTypeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntityTypeId($entityTypeId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['entityType'])) {
            $request->setEntityType($optionalArgs['entityType']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateEntityType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Feature in a given EntityType.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $feature = new Feature();
     *     $featureId = 'feature_id';
     *     $operationResponse = $featurestoreServiceClient->createFeature($formattedParent, $feature, $featureId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->createFeature($formattedParent, $feature, $featureId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'createFeature');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The resource name of the EntityType or FeatureGroup to create a
     *                              Feature. Format for entity_type as parent:
     *                              `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     *                              Format for feature_group as parent:
     *                              `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param Feature $feature      Required. The Feature to create.
     * @param string  $featureId    Required. The ID to use for the Feature, which will become the final
     *                              component of the Feature's resource name.
     *
     *                              This value may be up to 128 characters, and valid characters are
     *                              `[a-z0-9_]`. The first character cannot be a number.
     *
     *                              The value must be unique within an EntityType/FeatureGroup.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeature(
        $parent,
        $feature,
        $featureId,
        array $optionalArgs = []
    ) {
        $request = new CreateFeatureRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeature($feature);
        $request->setFeatureId($featureId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFeature',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Featurestore in a given project and location.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $featurestore = new Featurestore();
     *     $featurestoreId = 'featurestore_id';
     *     $operationResponse = $featurestoreServiceClient->createFeaturestore($formattedParent, $featurestore, $featurestoreId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->createFeaturestore($formattedParent, $featurestore, $featurestoreId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'createFeaturestore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The resource name of the Location to create Featurestores.
     *                                     Format:
     *                                     `projects/{project}/locations/{location}`
     * @param Featurestore $featurestore   Required. The Featurestore to create.
     * @param string       $featurestoreId Required. The ID to use for this Featurestore, which will become the final
     *                                     component of the Featurestore's resource name.
     *
     *                                     This value may be up to 60 characters, and valid characters are
     *                                     `[a-z0-9_]`. The first character cannot be a number.
     *
     *                                     The value must be unique within the project and location.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFeaturestore(
        $parent,
        $featurestore,
        $featurestoreId,
        array $optionalArgs = []
    ) {
        $request = new CreateFeaturestoreRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFeaturestore($featurestore);
        $request->setFeaturestoreId($featurestoreId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFeaturestore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single EntityType. The EntityType must not have any Features
     * or `force` must be set to true for the request to succeed.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedName = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $operationResponse = $featurestoreServiceClient->deleteEntityType($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->deleteEntityType($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'deleteEntityType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the EntityType to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any Features for this EntityType will also be deleted.
     *           (Otherwise, the request will only work if the EntityType has no Features.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEntityType($name, array $optionalArgs = [])
    {
        $request = new DeleteEntityTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteEntityType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Feature.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedName = $featurestoreServiceClient->featureName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]', '[FEATURE]');
     *     $operationResponse = $featurestoreServiceClient->deleteFeature($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->deleteFeature($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'deleteFeature');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Features to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeature($name, array $optionalArgs = [])
    {
        $request = new DeleteFeatureRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeature',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete Feature values from Featurestore.
     *
     * The progress of the deletion is tracked by the returned operation. The
     * deleted feature values are guaranteed to be invisible to subsequent read
     * operations after the operation is marked as successfully done.
     *
     * If a delete feature values operation fails, the feature values
     * returned from reads and exports may be inconsistent. If consistency is
     * required, the caller must retry the same delete request again and wait till
     * the new operation returned is marked as successfully done.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedEntityType = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $operationResponse = $featurestoreServiceClient->deleteFeatureValues($formattedEntityType);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->deleteFeatureValues($formattedEntityType);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'deleteFeatureValues');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $entityType   Required. The resource name of the EntityType grouping the Features for
     *                             which values are being deleted from. Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type SelectEntity $selectEntity
     *           Select feature values to be deleted by specifying entities.
     *     @type SelectTimeRangeAndFeature $selectTimeRangeAndFeature
     *           Select feature values to be deleted by specifying time range and
     *           features.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeatureValues($entityType, array $optionalArgs = [])
    {
        $request = new DeleteFeatureValuesRequest();
        $requestParamHeaders = [];
        $request->setEntityType($entityType);
        $requestParamHeaders['entity_type'] = $entityType;
        if (isset($optionalArgs['selectEntity'])) {
            $request->setSelectEntity($optionalArgs['selectEntity']);
        }

        if (isset($optionalArgs['selectTimeRangeAndFeature'])) {
            $request->setSelectTimeRangeAndFeature(
                $optionalArgs['selectTimeRangeAndFeature']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeatureValues',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Featurestore. The Featurestore must not contain any
     * EntityTypes or `force` must be set to true for the request to succeed.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedName = $featurestoreServiceClient->featurestoreName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]');
     *     $operationResponse = $featurestoreServiceClient->deleteFeaturestore($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->deleteFeaturestore($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'deleteFeaturestore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Featurestore to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any EntityTypes and Features for this Featurestore will
     *           also be deleted. (Otherwise, the request will only work if the Featurestore
     *           has no EntityTypes.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFeaturestore($name, array $optionalArgs = [])
    {
        $request = new DeleteFeaturestoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFeaturestore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Exports Feature values from all the entities of a target EntityType.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedEntityType = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $destination = new FeatureValueDestination();
     *     $featureSelector = new FeatureSelector();
     *     $operationResponse = $featurestoreServiceClient->exportFeatureValues($formattedEntityType, $destination, $featureSelector);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->exportFeatureValues($formattedEntityType, $destination, $featureSelector);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'exportFeatureValues');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string                  $entityType      Required. The resource name of the EntityType from which to export Feature
     *                                                 values. Format:
     *                                                 `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * @param FeatureValueDestination $destination     Required. Specifies destination location and format.
     * @param FeatureSelector         $featureSelector Required. Selects Features to export values of.
     * @param array                   $optionalArgs    {
     *     Optional.
     *
     *     @type SnapshotExport $snapshotExport
     *           Exports the latest Feature values of all entities of the EntityType
     *           within a time range.
     *     @type FullExport $fullExport
     *           Exports all historical values of all entities of the EntityType within a
     *           time range
     *     @type DestinationFeatureSetting[] $settings
     *           Per-Feature export settings.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function exportFeatureValues(
        $entityType,
        $destination,
        $featureSelector,
        array $optionalArgs = []
    ) {
        $request = new ExportFeatureValuesRequest();
        $requestParamHeaders = [];
        $request->setEntityType($entityType);
        $request->setDestination($destination);
        $request->setFeatureSelector($featureSelector);
        $requestParamHeaders['entity_type'] = $entityType;
        if (isset($optionalArgs['snapshotExport'])) {
            $request->setSnapshotExport($optionalArgs['snapshotExport']);
        }

        if (isset($optionalArgs['fullExport'])) {
            $request->setFullExport($optionalArgs['fullExport']);
        }

        if (isset($optionalArgs['settings'])) {
            $request->setSettings($optionalArgs['settings']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ExportFeatureValues',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of a single EntityType.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedName = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $response = $featurestoreServiceClient->getEntityType($formattedName);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the EntityType resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\EntityType
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntityType($name, array $optionalArgs = [])
    {
        $request = new GetEntityTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEntityType',
            EntityType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Feature.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedName = $featurestoreServiceClient->featureName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]', '[FEATURE]');
     *     $response = $featurestoreServiceClient->getFeature($formattedName);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Feature resource.
     *                             Format for entity_type as parent:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     *                             Format for feature_group as parent:
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Feature
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeature($name, array $optionalArgs = [])
    {
        $request = new GetFeatureRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeature',
            Feature::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Featurestore.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedName = $featurestoreServiceClient->featurestoreName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]');
     *     $response = $featurestoreServiceClient->getFeaturestore($formattedName);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the Featurestore resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Featurestore
     *
     * @throws ApiException if the remote call fails
     */
    public function getFeaturestore($name, array $optionalArgs = [])
    {
        $request = new GetFeaturestoreRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFeaturestore',
            Featurestore::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Imports Feature values into the Featurestore from a source storage.
     *
     * The progress of the import is tracked by the returned operation. The
     * imported features are guaranteed to be visible to subsequent read
     * operations after the operation is marked as successfully done.
     *
     * If an import operation fails, the Feature values returned from
     * reads and exports may be inconsistent. If consistency is
     * required, the caller must retry the same import request again and wait till
     * the new operation returned is marked as successfully done.
     *
     * There are also scenarios where the caller can cause inconsistency.
     *
     * - Source data for import contains multiple distinct Feature values for
     * the same entity ID and timestamp.
     * - Source is modified during an import. This includes adding, updating, or
     * removing source data and/or metadata. Examples of updating metadata
     * include but are not limited to changing storage location, storage class,
     * or retention policy.
     * - Online serving cluster is under-provisioned.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedEntityType = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $featureSpecs = [];
     *     $operationResponse = $featurestoreServiceClient->importFeatureValues($formattedEntityType, $featureSpecs);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->importFeatureValues($formattedEntityType, $featureSpecs);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'importFeatureValues');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string        $entityType   Required. The resource name of the EntityType grouping the Features for
     *                                    which values are being imported. Format:
     *                                    `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
     * @param FeatureSpec[] $featureSpecs Required. Specifications defining which Feature values to import from the
     *                                    entity. The request fails if no feature_specs are provided, and having
     *                                    multiple feature_specs for one Feature is not allowed.
     * @param array         $optionalArgs {
     *     Optional.
     *
     *     @type AvroSource $avroSource
     *     @type BigQuerySource $bigquerySource
     *     @type CsvSource $csvSource
     *     @type string $featureTimeField
     *           Source column that holds the Feature timestamp for all Feature
     *           values in each entity.
     *     @type Timestamp $featureTime
     *           Single Feature timestamp for all entities being imported. The
     *           timestamp must not have higher than millisecond precision.
     *     @type string $entityIdField
     *           Source column that holds entity IDs. If not provided, entity IDs are
     *           extracted from the column named entity_id.
     *     @type bool $disableOnlineServing
     *           If set, data will not be imported for online serving. This
     *           is typically used for backfilling, where Feature generation timestamps are
     *           not in the timestamp range needed for online serving.
     *     @type int $workerCount
     *           Specifies the number of workers that are used to write data to the
     *           Featurestore. Consider the online serving capacity that you require to
     *           achieve the desired import throughput without interfering with online
     *           serving. The value must be positive, and less than or equal to 100.
     *           If not set, defaults to using 1 worker. The low count ensures minimal
     *           impact on online serving performance.
     *     @type bool $disableIngestionAnalysis
     *           If true, API doesn't start ingestion analysis pipeline.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function importFeatureValues(
        $entityType,
        $featureSpecs,
        array $optionalArgs = []
    ) {
        $request = new ImportFeatureValuesRequest();
        $requestParamHeaders = [];
        $request->setEntityType($entityType);
        $request->setFeatureSpecs($featureSpecs);
        $requestParamHeaders['entity_type'] = $entityType;
        if (isset($optionalArgs['avroSource'])) {
            $request->setAvroSource($optionalArgs['avroSource']);
        }

        if (isset($optionalArgs['bigquerySource'])) {
            $request->setBigquerySource($optionalArgs['bigquerySource']);
        }

        if (isset($optionalArgs['csvSource'])) {
            $request->setCsvSource($optionalArgs['csvSource']);
        }

        if (isset($optionalArgs['featureTimeField'])) {
            $request->setFeatureTimeField($optionalArgs['featureTimeField']);
        }

        if (isset($optionalArgs['featureTime'])) {
            $request->setFeatureTime($optionalArgs['featureTime']);
        }

        if (isset($optionalArgs['entityIdField'])) {
            $request->setEntityIdField($optionalArgs['entityIdField']);
        }

        if (isset($optionalArgs['disableOnlineServing'])) {
            $request->setDisableOnlineServing(
                $optionalArgs['disableOnlineServing']
            );
        }

        if (isset($optionalArgs['workerCount'])) {
            $request->setWorkerCount($optionalArgs['workerCount']);
        }

        if (isset($optionalArgs['disableIngestionAnalysis'])) {
            $request->setDisableIngestionAnalysis(
                $optionalArgs['disableIngestionAnalysis']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ImportFeatureValues',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Lists EntityTypes in a given Featurestore.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->featurestoreName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featurestoreServiceClient->listEntityTypes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featurestoreServiceClient->listEntityTypes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Featurestore to list EntityTypes.
     *                             Format:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the EntityTypes that match the filter expression. The following
     *           filters are supported:
     *
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
     *           Values must be in RFC 3339 format.
     *           * `labels`: Supports key-value equality as well as key presence.
     *
     *           Examples:
     *
     *           * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
     *           update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
     *           or updated after 2020-01-31T15:30:00.000000Z.
     *           * `labels.active = yes AND labels.env = prod` --> EntityTypes having both
     *           (active: yes) and (env: prod) labels.
     *           * `labels.env: *` --> Any EntityType which has a label with 'env' as the
     *           key.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *
     *           Supported fields:
     *
     *           * `entity_type_id`
     *           * `create_time`
     *           * `update_time`
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntityTypes($parent, array $optionalArgs = [])
    {
        $request = new ListEntityTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEntityTypes',
            $optionalArgs,
            ListEntityTypesResponse::class,
            $request
        );
    }

    /**
     * Lists Features in a given EntityType.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featurestoreServiceClient->listFeatures($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featurestoreServiceClient->listFeatures($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list Features.
     *                             Format for entity_type as parent:
     *                             `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     *                             Format for feature_group as parent:
     *                             `projects/{project}/locations/{location}/featureGroups/{feature_group}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the Features that match the filter expression. The following
     *           filters are supported:
     *
     *           * `value_type`: Supports = and != comparisons.
     *           * `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
     *           be in RFC 3339 format.
     *           * `update_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
     *           be in RFC 3339 format.
     *           * `labels`: Supports key-value equality as well as key presence.
     *
     *           Examples:
     *
     *           * `value_type = DOUBLE` --> Features whose type is DOUBLE.
     *           * `create_time > \"2020-01-31T15:30:00.000000Z\" OR
     *           update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
     *           or updated after 2020-01-31T15:30:00.000000Z.
     *           * `labels.active = yes AND labels.env = prod` --> Features having both
     *           (active: yes) and (env: prod) labels.
     *           * `labels.env: *` --> Any Feature which has a label with 'env' as the
     *           key.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported fields:
     *
     *           * `feature_id`
     *           * `value_type` (Not supported for FeatureRegistry Feature)
     *           * `create_time`
     *           * `update_time`
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type int $latestStatsCount
     *           Only applicable for Vertex AI Feature Store (Legacy).
     *           If set, return the most recent
     *           [ListFeaturesRequest.latest_stats_count][google.cloud.aiplatform.v1.ListFeaturesRequest.latest_stats_count]
     *           of stats for each Feature in response. Valid value is [0, 10]. If number of
     *           stats exists <
     *           [ListFeaturesRequest.latest_stats_count][google.cloud.aiplatform.v1.ListFeaturesRequest.latest_stats_count],
     *           return all existing stats.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeatures($parent, array $optionalArgs = [])
    {
        $request = new ListFeaturesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['latestStatsCount'])) {
            $request->setLatestStatsCount($optionalArgs['latestStatsCount']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeatures',
            $optionalArgs,
            ListFeaturesResponse::class,
            $request
        );
    }

    /**
     * Lists Featurestores in a given project and location.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedParent = $featurestoreServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featurestoreServiceClient->listFeaturestores($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featurestoreServiceClient->listFeaturestores($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location to list Featurestores.
     *                             Format:
     *                             `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Lists the featurestores that match the filter expression. The following
     *           fields are supported:
     *
     *           * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be
     *           in RFC 3339 format.
     *           * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
     *           Values must be
     *           in RFC 3339 format.
     *           * `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
     *           `<=`, and `>=` comparisons.
     *           * `labels`: Supports key-value equality and key presence.
     *
     *           Examples:
     *
     *           * `create_time > "2020-01-01" OR update_time > "2020-01-01"`
     *           Featurestores created or updated after 2020-01-01.
     *           * `labels.env = "prod"`
     *           Featurestores with label "env" set to "prod".
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           A comma-separated list of fields to order by, sorted in ascending order.
     *           Use "desc" after a field name for descending.
     *           Supported Fields:
     *
     *           * `create_time`
     *           * `update_time`
     *           * `online_serving_config.fixed_node_count`
     *     @type FieldMask $readMask
     *           Mask specifying which fields to read.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFeaturestores($parent, array $optionalArgs = [])
    {
        $request = new ListFeaturestoresRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFeaturestores',
            $optionalArgs,
            ListFeaturestoresResponse::class,
            $request
        );
    }

    /**
     * Searches Features matching a query in a given project.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $formattedLocation = $featurestoreServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $featurestoreServiceClient->searchFeatures($formattedLocation);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featurestoreServiceClient->searchFeatures($formattedLocation);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $location     Required. The resource name of the Location to search Features.
     *                             Format:
     *                             `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $query
     *           Query string that is a conjunction of field-restricted queries and/or
     *           field-restricted filters.  Field-restricted queries and filters can be
     *           combined using `AND` to form a conjunction.
     *
     *           A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
     *           exists as a substring within Feature's FIELD. The QUERY
     *           and the FIELD are converted to a sequence of words (i.e. tokens) for
     *           comparison. This is done by:
     *
     *           * Removing leading/trailing whitespace and tokenizing the search value.
     *           Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
     *           `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
     *           as a wildcard that matches characters within a token.
     *           * Ignoring case.
     *           * Prepending an asterisk to the first and appending an asterisk to the
     *           last token in QUERY.
     *
     *           A QUERY must be either a singular token or a phrase. A phrase is one or
     *           multiple words enclosed in double quotation marks ("). With phrases, the
     *           order of the words is important. Words in the phrase must be matching in
     *           order and consecutively.
     *
     *           Supported FIELDs for field-restricted queries:
     *
     *           * `feature_id`
     *           * `description`
     *           * `entity_type_id`
     *
     *           Examples:
     *
     *           * `feature_id: foo` --> Matches a Feature with ID containing the substring
     *           `foo` (eg. `foo`, `foofeature`, `barfoo`).
     *           * `feature_id: foo*feature` --> Matches a Feature with ID containing the
     *           substring `foo*feature` (eg. `foobarfeature`).
     *           * `feature_id: foo AND description: bar` --> Matches a Feature with ID
     *           containing the substring `foo` and description containing the substring
     *           `bar`.
     *
     *
     *           Besides field queries, the following exact-match filters are
     *           supported. The exact-match filters do not support wildcards. Unlike
     *           field-restricted queries, exact-match filters are case-sensitive.
     *
     *           * `feature_id`: Supports = comparisons.
     *           * `description`: Supports = comparisons. Multi-token filters should be
     *           enclosed in quotes.
     *           * `entity_type_id`: Supports = comparisons.
     *           * `value_type`: Supports = and != comparisons.
     *           * `labels`: Supports key-value equality as well as key presence.
     *           * `featurestore_id`: Supports = comparisons.
     *
     *           Examples:
     *
     *           * `description = "foo bar"` --> Any Feature with description exactly equal
     *           to `foo bar`
     *           * `value_type = DOUBLE` --> Features whose type is DOUBLE.
     *           * `labels.active = yes AND labels.env = prod` --> Features having both
     *           (active: yes) and (env: prod) labels.
     *           * `labels.env: *` --> Any Feature which has a label with `env` as the
     *           key.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchFeatures($location, array $optionalArgs = [])
    {
        $request = new SearchFeaturesRequest();
        $requestParamHeaders = [];
        $request->setLocation($location);
        $requestParamHeaders['location'] = $location;
        if (isset($optionalArgs['query'])) {
            $request->setQuery($optionalArgs['query']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'SearchFeatures',
            $optionalArgs,
            SearchFeaturesResponse::class,
            $request
        );
    }

    /**
     * Updates the parameters of a single EntityType.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $entityType = new EntityType();
     *     $response = $featurestoreServiceClient->updateEntityType($entityType);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param EntityType $entityType   Required. The EntityType's `name` field is used to identify the EntityType
     *                                 to be updated. Format:
     *                                 `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           EntityType resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `description`
     *           * `labels`
     *           * `monitoring_config.snapshot_analysis.disabled`
     *           * `monitoring_config.snapshot_analysis.monitoring_interval_days`
     *           * `monitoring_config.snapshot_analysis.staleness_days`
     *           * `monitoring_config.import_features_analysis.state`
     *           * `monitoring_config.import_features_analysis.anomaly_detection_baseline`
     *           * `monitoring_config.numerical_threshold_config.value`
     *           * `monitoring_config.categorical_threshold_config.value`
     *           * `offline_storage_ttl_days`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\EntityType
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEntityType($entityType, array $optionalArgs = [])
    {
        $request = new UpdateEntityTypeRequest();
        $requestParamHeaders = [];
        $request->setEntityType($entityType);
        $requestParamHeaders['entity_type.name'] = $entityType->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateEntityType',
            EntityType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the parameters of a single Feature.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $feature = new Feature();
     *     $response = $featurestoreServiceClient->updateFeature($feature);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param Feature $feature      Required. The Feature's `name` field is used to identify the Feature to be
     *                              updated.
     *                              Format:
     *                              `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
     *                              `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           Features resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `description`
     *           * `labels`
     *           * `disable_monitoring` (Not supported for FeatureRegistry Feature)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\Feature
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeature($feature, array $optionalArgs = [])
    {
        $request = new UpdateFeatureRequest();
        $requestParamHeaders = [];
        $request->setFeature($feature);
        $requestParamHeaders['feature.name'] = $feature->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateFeature',
            Feature::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the parameters of a single Featurestore.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $featurestore = new Featurestore();
     *     $operationResponse = $featurestoreServiceClient->updateFeaturestore($featurestore);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $featurestoreServiceClient->updateFeaturestore($featurestore);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $featurestoreServiceClient->resumeOperation($operationName, 'updateFeaturestore');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param Featurestore $featurestore Required. The Featurestore's `name` field is used to identify the
     *                                   Featurestore to be updated. Format:
     *                                   `projects/{project}/locations/{location}/featurestores/{featurestore}`
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           Featurestore resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then only the non-empty fields present in the
     *           request will be overwritten. Set the update_mask to `*` to override all
     *           fields.
     *
     *           Updatable fields:
     *
     *           * `labels`
     *           * `online_serving_config.fixed_node_count`
     *           * `online_serving_config.scaling`
     *           * `online_storage_ttl_days`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFeaturestore($featurestore, array $optionalArgs = [])
    {
        $request = new UpdateFeaturestoreRequest();
        $requestParamHeaders = [];
        $request->setFeaturestore($featurestore);
        $requestParamHeaders['featurestore.name'] = $featurestore->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateFeaturestore',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $response = $featurestoreServiceClient->getLocation();
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $featurestoreServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $featurestoreServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $featurestoreServiceClient->getIamPolicy($resource);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $featurestoreServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $featurestoreServiceClient = new FeaturestoreServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $featurestoreServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $featurestoreServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
