<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataform/v1beta1/dataform.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\Dataform\V1beta1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataform\V1beta1\CancelWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\CommitAuthor;
use Google\Cloud\Dataform\V1beta1\CommitWorkspaceChangesRequest;
use Google\Cloud\Dataform\V1beta1\CompilationResult;
use Google\Cloud\Dataform\V1beta1\CreateCompilationResultRequest;
use Google\Cloud\Dataform\V1beta1\CreateRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\CreateWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\CreateWorkspaceRequest;
use Google\Cloud\Dataform\V1beta1\DeleteRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\DeleteWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\DeleteWorkspaceRequest;
use Google\Cloud\Dataform\V1beta1\FetchFileDiffRequest;
use Google\Cloud\Dataform\V1beta1\FetchFileDiffResponse;
use Google\Cloud\Dataform\V1beta1\FetchFileGitStatusesRequest;
use Google\Cloud\Dataform\V1beta1\FetchFileGitStatusesResponse;
use Google\Cloud\Dataform\V1beta1\FetchGitAheadBehindRequest;
use Google\Cloud\Dataform\V1beta1\FetchGitAheadBehindResponse;
use Google\Cloud\Dataform\V1beta1\FetchRemoteBranchesRequest;
use Google\Cloud\Dataform\V1beta1\FetchRemoteBranchesResponse;
use Google\Cloud\Dataform\V1beta1\GetCompilationResultRequest;
use Google\Cloud\Dataform\V1beta1\GetRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\GetWorkflowInvocationRequest;
use Google\Cloud\Dataform\V1beta1\GetWorkspaceRequest;
use Google\Cloud\Dataform\V1beta1\InstallNpmPackagesRequest;
use Google\Cloud\Dataform\V1beta1\InstallNpmPackagesResponse;
use Google\Cloud\Dataform\V1beta1\ListCompilationResultsRequest;
use Google\Cloud\Dataform\V1beta1\ListCompilationResultsResponse;
use Google\Cloud\Dataform\V1beta1\ListRepositoriesRequest;
use Google\Cloud\Dataform\V1beta1\ListRepositoriesResponse;
use Google\Cloud\Dataform\V1beta1\ListWorkflowInvocationsRequest;
use Google\Cloud\Dataform\V1beta1\ListWorkflowInvocationsResponse;
use Google\Cloud\Dataform\V1beta1\ListWorkspacesRequest;
use Google\Cloud\Dataform\V1beta1\ListWorkspacesResponse;
use Google\Cloud\Dataform\V1beta1\MakeDirectoryRequest;
use Google\Cloud\Dataform\V1beta1\MakeDirectoryResponse;
use Google\Cloud\Dataform\V1beta1\MoveDirectoryRequest;
use Google\Cloud\Dataform\V1beta1\MoveDirectoryResponse;
use Google\Cloud\Dataform\V1beta1\MoveFileRequest;
use Google\Cloud\Dataform\V1beta1\MoveFileResponse;
use Google\Cloud\Dataform\V1beta1\PullGitCommitsRequest;
use Google\Cloud\Dataform\V1beta1\PushGitCommitsRequest;
use Google\Cloud\Dataform\V1beta1\QueryCompilationResultActionsRequest;
use Google\Cloud\Dataform\V1beta1\QueryCompilationResultActionsResponse;
use Google\Cloud\Dataform\V1beta1\QueryDirectoryContentsRequest;
use Google\Cloud\Dataform\V1beta1\QueryDirectoryContentsResponse;
use Google\Cloud\Dataform\V1beta1\QueryWorkflowInvocationActionsRequest;
use Google\Cloud\Dataform\V1beta1\QueryWorkflowInvocationActionsResponse;
use Google\Cloud\Dataform\V1beta1\ReadFileRequest;
use Google\Cloud\Dataform\V1beta1\ReadFileResponse;
use Google\Cloud\Dataform\V1beta1\RemoveDirectoryRequest;
use Google\Cloud\Dataform\V1beta1\RemoveFileRequest;
use Google\Cloud\Dataform\V1beta1\Repository;
use Google\Cloud\Dataform\V1beta1\ResetWorkspaceChangesRequest;
use Google\Cloud\Dataform\V1beta1\UpdateRepositoryRequest;
use Google\Cloud\Dataform\V1beta1\WorkflowInvocation;
use Google\Cloud\Dataform\V1beta1\Workspace;
use Google\Cloud\Dataform\V1beta1\WriteFileRequest;
use Google\Cloud\Dataform\V1beta1\WriteFileResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Dataform is a service to develop, create, document, test, and update curated
 * tables in BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataformClient = new DataformClient();
 * try {
 *     $formattedName = $dataformClient->workflowInvocationName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKFLOW_INVOCATION]');
 *     $dataformClient->cancelWorkflowInvocation($formattedName);
 * } finally {
 *     $dataformClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @experimental
 */
class DataformGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.dataform.v1beta1.Dataform';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'dataform.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $compilationResultNameTemplate;

    private static $locationNameTemplate;

    private static $repositoryNameTemplate;

    private static $workflowInvocationNameTemplate;

    private static $workspaceNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/dataform_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/dataform_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/dataform_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/dataform_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getCompilationResultNameTemplate()
    {
        if (self::$compilationResultNameTemplate == null) {
            self::$compilationResultNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/repositories/{repository}/compilationResults/{compilation_result}'
            );
        }

        return self::$compilationResultNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getRepositoryNameTemplate()
    {
        if (self::$repositoryNameTemplate == null) {
            self::$repositoryNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/repositories/{repository}'
            );
        }

        return self::$repositoryNameTemplate;
    }

    private static function getWorkflowInvocationNameTemplate()
    {
        if (self::$workflowInvocationNameTemplate == null) {
            self::$workflowInvocationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/repositories/{repository}/workflowInvocations/{workflow_invocation}'
            );
        }

        return self::$workflowInvocationNameTemplate;
    }

    private static function getWorkspaceNameTemplate()
    {
        if (self::$workspaceNameTemplate == null) {
            self::$workspaceNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/repositories/{repository}/workspaces/{workspace}'
            );
        }

        return self::$workspaceNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'compilationResult' => self::getCompilationResultNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'repository' => self::getRepositoryNameTemplate(),
                'workflowInvocation' => self::getWorkflowInvocationNameTemplate(),
                'workspace' => self::getWorkspaceNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * compilation_result resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $compilationResult
     *
     * @return string The formatted compilation_result resource.
     *
     * @experimental
     */
    public static function compilationResultName(
        $project,
        $location,
        $repository,
        $compilationResult
    ) {
        return self::getCompilationResultNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'compilation_result' => $compilationResult,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     *
     * @experimental
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     *
     * @return string The formatted repository resource.
     *
     * @experimental
     */
    public static function repositoryName($project, $location, $repository)
    {
        return self::getRepositoryNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * workflow_invocation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $workflowInvocation
     *
     * @return string The formatted workflow_invocation resource.
     *
     * @experimental
     */
    public static function workflowInvocationName(
        $project,
        $location,
        $repository,
        $workflowInvocation
    ) {
        return self::getWorkflowInvocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'workflow_invocation' => $workflowInvocation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a workspace
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $workspace
     *
     * @return string The formatted workspace resource.
     *
     * @experimental
     */
    public static function workspaceName(
        $project,
        $location,
        $repository,
        $workspace
    ) {
        return self::getWorkspaceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'workspace' => $workspace,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - compilationResult: projects/{project}/locations/{location}/repositories/{repository}/compilationResults/{compilation_result}
     * - location: projects/{project}/locations/{location}
     * - repository: projects/{project}/locations/{location}/repositories/{repository}
     * - workflowInvocation: projects/{project}/locations/{location}/repositories/{repository}/workflowInvocations/{workflow_invocation}
     * - workspace: projects/{project}/locations/{location}/repositories/{repository}/workspaces/{workspace}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     *
     * @experimental
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Requests cancellation of a running WorkflowInvocation.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workflowInvocationName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKFLOW_INVOCATION]');
     *     $dataformClient->cancelWorkflowInvocation($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workflow invocation resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function cancelWorkflowInvocation($name, array $optionalArgs = [])
    {
        $request = new CancelWorkflowInvocationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CancelWorkflowInvocation',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Applies a Git commit for uncommitted files in a Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $author = new CommitAuthor();
     *     $dataformClient->commitWorkspaceChanges($formattedName, $author);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string       $name         Required. The workspace's name.
     * @param CommitAuthor $author       Required. The commit's author.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $commitMessage
     *           Optional. The commit's message.
     *     @type string[] $paths
     *           Optional. Full file paths to commit including filename, rooted at workspace root. If
     *           left empty, all files will be committed.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function commitWorkspaceChanges(
        $name,
        $author,
        array $optionalArgs = []
    ) {
        $request = new CommitWorkspaceChangesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setAuthor($author);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['commitMessage'])) {
            $request->setCommitMessage($optionalArgs['commitMessage']);
        }

        if (isset($optionalArgs['paths'])) {
            $request->setPaths($optionalArgs['paths']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CommitWorkspaceChanges',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new CompilationResult in a given project and location.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     $compilationResult = new CompilationResult();
     *     $response = $dataformClient->createCompilationResult($formattedParent, $compilationResult);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string            $parent            Required. The repository in which to create the compilation result. Must be in the
     *                                             format `projects/&#42;/locations/&#42;/repositories/*`.
     * @param CompilationResult $compilationResult Required. The compilation result to create.
     * @param array             $optionalArgs      {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\CompilationResult
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createCompilationResult(
        $parent,
        $compilationResult,
        array $optionalArgs = []
    ) {
        $request = new CreateCompilationResultRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCompilationResult($compilationResult);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateCompilationResult',
            CompilationResult::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new Repository in a given project and location.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->locationName('[PROJECT]', '[LOCATION]');
     *     $repository = new Repository();
     *     $repositoryId = 'repository_id';
     *     $response = $dataformClient->createRepository($formattedParent, $repository, $repositoryId);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The location in which to create the repository. Must be in the format
     *                                 `projects/&#42;/locations/*`.
     * @param Repository $repository   Required. The repository to create.
     * @param string     $repositoryId Required. The ID to use for the repository, which will become the final component of
     *                                 the repository's resource name.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\Repository
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createRepository(
        $parent,
        $repository,
        $repositoryId,
        array $optionalArgs = []
    ) {
        $request = new CreateRepositoryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRepository($repository);
        $request->setRepositoryId($repositoryId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateRepository',
            Repository::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new WorkflowInvocation in a given Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     $workflowInvocation = new WorkflowInvocation();
     *     $response = $dataformClient->createWorkflowInvocation($formattedParent, $workflowInvocation);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string             $parent             Required. The repository in which to create the workflow invocation. Must be in the
     *                                               format `projects/&#42;/locations/&#42;/repositories/*`.
     * @param WorkflowInvocation $workflowInvocation Required. The workflow invocation resource to create.
     * @param array              $optionalArgs       {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\WorkflowInvocation
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createWorkflowInvocation(
        $parent,
        $workflowInvocation,
        array $optionalArgs = []
    ) {
        $request = new CreateWorkflowInvocationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setWorkflowInvocation($workflowInvocation);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateWorkflowInvocation',
            WorkflowInvocation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a new Workspace in a given Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     $workspace = new Workspace();
     *     $workspaceId = 'workspace_id';
     *     $response = $dataformClient->createWorkspace($formattedParent, $workspace, $workspaceId);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The repository in which to create the workspace. Must be in the format
     *                                `projects/&#42;/locations/&#42;/repositories/*`.
     * @param Workspace $workspace    Required. The workspace to create.
     * @param string    $workspaceId  Required. The ID to use for the workspace, which will become the final component of
     *                                the workspace's resource name.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\Workspace
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function createWorkspace(
        $parent,
        $workspace,
        $workspaceId,
        array $optionalArgs = []
    ) {
        $request = new CreateWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setWorkspace($workspace);
        $request->setWorkspaceId($workspaceId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateWorkspace',
            Workspace::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a single Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     $dataformClient->deleteRepository($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The repository's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any child resources of this repository will also be
     *           deleted. (Otherwise, the request will only succeed if the repository has no
     *           child resources.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteRepository($name, array $optionalArgs = [])
    {
        $request = new DeleteRepositoryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteRepository',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a single WorkflowInvocation.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workflowInvocationName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKFLOW_INVOCATION]');
     *     $dataformClient->deleteWorkflowInvocation($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workflow invocation resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteWorkflowInvocation($name, array $optionalArgs = [])
    {
        $request = new DeleteWorkflowInvocationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteWorkflowInvocation',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a single Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $dataformClient->deleteWorkspace($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workspace resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteWorkspace($name, array $optionalArgs = [])
    {
        $request = new DeleteWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteWorkspace',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches Git diff for an uncommitted file in a Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $response = $dataformClient->fetchFileDiff($formattedWorkspace, $path);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The file's full path including filename, relative to the workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\FetchFileDiffResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function fetchFileDiff($workspace, $path, array $optionalArgs = [])
    {
        $request = new FetchFileDiffRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FetchFileDiff',
            FetchFileDiffResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches Git statuses for the files in a Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $response = $dataformClient->fetchFileGitStatuses($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\FetchFileGitStatusesResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function fetchFileGitStatuses($name, array $optionalArgs = [])
    {
        $request = new FetchFileGitStatusesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FetchFileGitStatuses',
            FetchFileGitStatusesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches Git ahead/behind against a remote branch.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $response = $dataformClient->fetchGitAheadBehind($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $remoteBranch
     *           Optional. The name of the branch in the Git remote against which this workspace
     *           should be compared. If left unset, the repository's default branch name
     *           will be used.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\FetchGitAheadBehindResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function fetchGitAheadBehind($name, array $optionalArgs = [])
    {
        $request = new FetchGitAheadBehindRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['remoteBranch'])) {
            $request->setRemoteBranch($optionalArgs['remoteBranch']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FetchGitAheadBehind',
            FetchGitAheadBehindResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches a Repository's remote branches.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     $response = $dataformClient->fetchRemoteBranches($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The repository's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\FetchRemoteBranchesResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function fetchRemoteBranches($name, array $optionalArgs = [])
    {
        $request = new FetchRemoteBranchesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FetchRemoteBranches',
            FetchRemoteBranchesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches a single CompilationResult.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->compilationResultName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[COMPILATION_RESULT]');
     *     $response = $dataformClient->getCompilationResult($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The compilation result's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\CompilationResult
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getCompilationResult($name, array $optionalArgs = [])
    {
        $request = new GetCompilationResultRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCompilationResult',
            CompilationResult::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches a single Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     $response = $dataformClient->getRepository($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The repository's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\Repository
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getRepository($name, array $optionalArgs = [])
    {
        $request = new GetRepositoryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRepository',
            Repository::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches a single WorkflowInvocation.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workflowInvocationName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKFLOW_INVOCATION]');
     *     $response = $dataformClient->getWorkflowInvocation($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workflow invocation resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\WorkflowInvocation
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getWorkflowInvocation($name, array $optionalArgs = [])
    {
        $request = new GetWorkflowInvocationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetWorkflowInvocation',
            WorkflowInvocation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Fetches a single Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $response = $dataformClient->getWorkspace($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\Workspace
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getWorkspace($name, array $optionalArgs = [])
    {
        $request = new GetWorkspaceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetWorkspace',
            Workspace::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Installs dependency NPM packages (inside a Workspace).
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $response = $dataformClient->installNpmPackages($formattedWorkspace);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\InstallNpmPackagesResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function installNpmPackages($workspace, array $optionalArgs = [])
    {
        $request = new InstallNpmPackagesRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'InstallNpmPackages',
            InstallNpmPackagesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists CompilationResults in a given Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->listCompilationResults($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->listCompilationResults($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The repository in which to list compilation results. Must be in the
     *                             format `projects/&#42;/locations/&#42;/repositories/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listCompilationResults($parent, array $optionalArgs = [])
    {
        $request = new ListCompilationResultsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCompilationResults',
            $optionalArgs,
            ListCompilationResultsResponse::class,
            $request
        );
    }

    /**
     * Lists Repositories in a given project and location.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->listRepositories($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->listRepositories($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The location in which to list repositories. Must be in the format
     *                             `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Optional. This field only supports ordering by `name`. If unspecified, the server
     *           will choose the ordering. If specified, the default order is ascending for
     *           the `name` field.
     *     @type string $filter
     *           Optional. Filter for the returned list.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listRepositories($parent, array $optionalArgs = [])
    {
        $request = new ListRepositoriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRepositories',
            $optionalArgs,
            ListRepositoriesResponse::class,
            $request
        );
    }

    /**
     * Lists WorkflowInvocations in a given Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->listWorkflowInvocations($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->listWorkflowInvocations($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the WorkflowInvocation type. Must be in the
     *                             format `projects/&#42;/locations/&#42;/repositories/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listWorkflowInvocations($parent, array $optionalArgs = [])
    {
        $request = new ListWorkflowInvocationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListWorkflowInvocations',
            $optionalArgs,
            ListWorkflowInvocationsResponse::class,
            $request
        );
    }

    /**
     * Lists Workspaces in a given Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedParent = $dataformClient->repositoryName('[PROJECT]', '[LOCATION]', '[REPOSITORY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->listWorkspaces($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->listWorkspaces($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The repository in which to list workspaces. Must be in the
     *                             format `projects/&#42;/locations/&#42;/repositories/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Optional. This field only supports ordering by `name`. If unspecified, the server
     *           will choose the ordering. If specified, the default order is ascending for
     *           the `name` field.
     *     @type string $filter
     *           Optional. Filter for the returned list.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listWorkspaces($parent, array $optionalArgs = [])
    {
        $request = new ListWorkspacesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListWorkspaces',
            $optionalArgs,
            ListWorkspacesResponse::class,
            $request
        );
    }

    /**
     * Creates a directory inside a Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $response = $dataformClient->makeDirectory($formattedWorkspace, $path);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The directory's full path including directory name, relative to the
     *                             workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\MakeDirectoryResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function makeDirectory($workspace, $path, array $optionalArgs = [])
    {
        $request = new MakeDirectoryRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'MakeDirectory',
            MakeDirectoryResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Moves a directory (inside a Workspace), and all of its contents, to a new
     * location.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $newPath = 'new_path';
     *     $response = $dataformClient->moveDirectory($formattedWorkspace, $path, $newPath);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The directory's full path including directory name, relative to the
     *                             workspace root.
     * @param string $newPath      Required. The new path for the directory including directory name, rooted at
     *                             workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\MoveDirectoryResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function moveDirectory(
        $workspace,
        $path,
        $newPath,
        array $optionalArgs = []
    ) {
        $request = new MoveDirectoryRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $request->setNewPath($newPath);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'MoveDirectory',
            MoveDirectoryResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Moves a file (inside a Workspace) to a new location.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $newPath = 'new_path';
     *     $response = $dataformClient->moveFile($formattedWorkspace, $path, $newPath);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The file's full path including filename, relative to the workspace root.
     * @param string $newPath      Required. The file's new path including filename, relative to the workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\MoveFileResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function moveFile(
        $workspace,
        $path,
        $newPath,
        array $optionalArgs = []
    ) {
        $request = new MoveFileRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $request->setNewPath($newPath);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'MoveFile',
            MoveFileResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Pulls Git commits from the Repository's remote into a Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $author = new CommitAuthor();
     *     $dataformClient->pullGitCommits($formattedName, $author);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string       $name         Required. The workspace's name.
     * @param CommitAuthor $author       Required. The author of any merge commit which may be created as a result of merging
     *                                   fetched Git commits into this workspace.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $remoteBranch
     *           Optional. The name of the branch in the Git remote from which to pull commits.
     *           If left unset, the repository's default branch name will be used.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function pullGitCommits($name, $author, array $optionalArgs = [])
    {
        $request = new PullGitCommitsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setAuthor($author);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['remoteBranch'])) {
            $request->setRemoteBranch($optionalArgs['remoteBranch']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'PullGitCommits',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Pushes Git commits from a Workspace to the Repository's remote.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $dataformClient->pushGitCommits($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $remoteBranch
     *           Optional. The name of the branch in the Git remote to which commits should be pushed.
     *           If left unset, the repository's default branch name will be used.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function pushGitCommits($name, array $optionalArgs = [])
    {
        $request = new PushGitCommitsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['remoteBranch'])) {
            $request->setRemoteBranch($optionalArgs['remoteBranch']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'PushGitCommits',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns CompilationResultActions in a given CompilationResult.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->compilationResultName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[COMPILATION_RESULT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->queryCompilationResultActions($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->queryCompilationResultActions($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The compilation result's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Optional filter for the returned list. Filtering is only currently
     *           supported on the `file_path` field.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function queryCompilationResultActions(
        $name,
        array $optionalArgs = []
    ) {
        $request = new QueryCompilationResultActionsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'QueryCompilationResultActions',
            $optionalArgs,
            QueryCompilationResultActionsResponse::class,
            $request
        );
    }

    /**
     * Returns the contents of a given Workspace directory.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->queryDirectoryContents($formattedWorkspace);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->queryDirectoryContents($formattedWorkspace);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $path
     *           Optional. The directory's full path including directory name, relative to the
     *           workspace root. If left unset, the workspace root is used.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function queryDirectoryContents($workspace, array $optionalArgs = [])
    {
        $request = new QueryDirectoryContentsRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $requestParamHeaders['workspace'] = $workspace;
        if (isset($optionalArgs['path'])) {
            $request->setPath($optionalArgs['path']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'QueryDirectoryContents',
            $optionalArgs,
            QueryDirectoryContentsResponse::class,
            $request
        );
    }

    /**
     * Returns WorkflowInvocationActions in a given WorkflowInvocation.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workflowInvocationName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKFLOW_INVOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->queryWorkflowInvocationActions($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->queryWorkflowInvocationActions($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workflow invocation's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function queryWorkflowInvocationActions(
        $name,
        array $optionalArgs = []
    ) {
        $request = new QueryWorkflowInvocationActionsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'QueryWorkflowInvocationActions',
            $optionalArgs,
            QueryWorkflowInvocationActionsResponse::class,
            $request
        );
    }

    /**
     * Returns the contents of a file (inside a Workspace).
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $response = $dataformClient->readFile($formattedWorkspace, $path);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The file's full path including filename, relative to the workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\ReadFileResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function readFile($workspace, $path, array $optionalArgs = [])
    {
        $request = new ReadFileRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReadFile',
            ReadFileResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a directory (inside a Workspace) and all of its contents.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $dataformClient->removeDirectory($formattedWorkspace, $path);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The directory's full path including directory name, relative to the
     *                             workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function removeDirectory($workspace, $path, array $optionalArgs = [])
    {
        $request = new RemoveDirectoryRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RemoveDirectory',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a file (inside a Workspace).
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $dataformClient->removeFile($formattedWorkspace, $path);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The file's full path including filename, relative to the workspace root.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function removeFile($workspace, $path, array $optionalArgs = [])
    {
        $request = new RemoveFileRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RemoveFile',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Performs a Git reset for uncommitted files in a Workspace.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedName = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $dataformClient->resetWorkspaceChanges($formattedName);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The workspace's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $paths
     *           Optional. Full file paths to reset back to their committed state including filename,
     *           rooted at workspace root. If left empty, all files will be reset.
     *     @type bool $clean
     *           Optional. If set to true, untracked files will be deleted.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function resetWorkspaceChanges($name, array $optionalArgs = [])
    {
        $request = new ResetWorkspaceChangesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['paths'])) {
            $request->setPaths($optionalArgs['paths']);
        }

        if (isset($optionalArgs['clean'])) {
            $request->setClean($optionalArgs['clean']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ResetWorkspaceChanges',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a single Repository.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $repository = new Repository();
     *     $response = $dataformClient->updateRepository($repository);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param Repository $repository   Required. The repository to update.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Specifies the fields to be updated in the repository. If left unset,
     *           all fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\Repository
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function updateRepository($repository, array $optionalArgs = [])
    {
        $request = new UpdateRepositoryRequest();
        $requestParamHeaders = [];
        $request->setRepository($repository);
        $requestParamHeaders['repository.name'] = $repository->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateRepository',
            Repository::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Writes to a file (inside a Workspace).
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $formattedWorkspace = $dataformClient->workspaceName('[PROJECT]', '[LOCATION]', '[REPOSITORY]', '[WORKSPACE]');
     *     $path = 'path';
     *     $contents = '';
     *     $response = $dataformClient->writeFile($formattedWorkspace, $path, $contents);
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param string $workspace    Required. The workspace's name.
     * @param string $path         Required. The file.
     * @param string $contents     Required. The file's contents.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataform\V1beta1\WriteFileResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function writeFile(
        $workspace,
        $path,
        $contents,
        array $optionalArgs = []
    ) {
        $request = new WriteFileRequest();
        $requestParamHeaders = [];
        $request->setWorkspace($workspace);
        $request->setPath($path);
        $request->setContents($contents);
        $requestParamHeaders['workspace'] = $workspace;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'WriteFile',
            WriteFileResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     $response = $dataformClient->getLocation();
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $dataformClient = new DataformClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataformClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataformClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataformClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
