<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/apigeeregistry/v1/registry_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ApigeeRegistry\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\Api\HttpBody;

use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ApigeeRegistry\V1\Api;
use Google\Cloud\ApigeeRegistry\V1\ApiDeployment;
use Google\Cloud\ApigeeRegistry\V1\ApiSpec;
use Google\Cloud\ApigeeRegistry\V1\ApiVersion;
use Google\Cloud\ApigeeRegistry\V1\Artifact;
use Google\Cloud\ApigeeRegistry\V1\CreateApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateApiRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateApiVersionRequest;
use Google\Cloud\ApigeeRegistry\V1\CreateArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiDeploymentRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiSpecRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteApiVersionRequest;
use Google\Cloud\ApigeeRegistry\V1\DeleteArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiSpecContentsRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\GetApiVersionRequest;
use Google\Cloud\ApigeeRegistry\V1\GetArtifactContentsRequest;
use Google\Cloud\ApigeeRegistry\V1\GetArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiDeploymentRevisionsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiDeploymentRevisionsResponse;
use Google\Cloud\ApigeeRegistry\V1\ListApiDeploymentsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiDeploymentsResponse;
use Google\Cloud\ApigeeRegistry\V1\ListApiSpecRevisionsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiSpecRevisionsResponse;
use Google\Cloud\ApigeeRegistry\V1\ListApiSpecsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiSpecsResponse;
use Google\Cloud\ApigeeRegistry\V1\ListApisRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApisResponse;
use Google\Cloud\ApigeeRegistry\V1\ListApiVersionsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListApiVersionsResponse;
use Google\Cloud\ApigeeRegistry\V1\ListArtifactsRequest;
use Google\Cloud\ApigeeRegistry\V1\ListArtifactsResponse;
use Google\Cloud\ApigeeRegistry\V1\ReplaceArtifactRequest;
use Google\Cloud\ApigeeRegistry\V1\RollbackApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\RollbackApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\TagApiDeploymentRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\TagApiSpecRevisionRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiDeploymentRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiSpecRequest;
use Google\Cloud\ApigeeRegistry\V1\UpdateApiVersionRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: The Registry service allows teams to manage descriptions of APIs.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $registryClient = new RegistryClient();
 * try {
 *     $formattedParent = $registryClient->locationName('[PROJECT]', '[LOCATION]');
 *     $api = new Api();
 *     $apiId = 'api_id';
 *     $response = $registryClient->createApi($formattedParent, $api, $apiId);
 * } finally {
 *     $registryClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class RegistryGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.apigeeregistry.v1.Registry';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'apigeeregistry.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $apiNameTemplate;

    private static $apiDeploymentNameTemplate;

    private static $apiSpecNameTemplate;

    private static $apiVersionNameTemplate;

    private static $artifactNameTemplate;

    private static $locationNameTemplate;

    private static $projectLocationApiArtifactNameTemplate;

    private static $projectLocationApiDeploymentArtifactNameTemplate;

    private static $projectLocationApiVersionArtifactNameTemplate;

    private static $projectLocationApiVersionSpecArtifactNameTemplate;

    private static $projectLocationArtifactNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/registry_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/registry_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/registry_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/registry_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getApiNameTemplate()
    {
        if (self::$apiNameTemplate == null) {
            self::$apiNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}'
            );
        }

        return self::$apiNameTemplate;
    }

    private static function getApiDeploymentNameTemplate()
    {
        if (self::$apiDeploymentNameTemplate == null) {
            self::$apiDeploymentNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}'
            );
        }

        return self::$apiDeploymentNameTemplate;
    }

    private static function getApiSpecNameTemplate()
    {
        if (self::$apiSpecNameTemplate == null) {
            self::$apiSpecNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}'
            );
        }

        return self::$apiSpecNameTemplate;
    }

    private static function getApiVersionNameTemplate()
    {
        if (self::$apiVersionNameTemplate == null) {
            self::$apiVersionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/versions/{version}'
            );
        }

        return self::$apiVersionNameTemplate;
    }

    private static function getArtifactNameTemplate()
    {
        if (self::$artifactNameTemplate == null) {
            self::$artifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/artifacts/{artifact}'
            );
        }

        return self::$artifactNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getProjectLocationApiArtifactNameTemplate()
    {
        if (self::$projectLocationApiArtifactNameTemplate == null) {
            self::$projectLocationApiArtifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/artifacts/{artifact}'
            );
        }

        return self::$projectLocationApiArtifactNameTemplate;
    }

    private static function getProjectLocationApiDeploymentArtifactNameTemplate()
    {
        if (self::$projectLocationApiDeploymentArtifactNameTemplate == null) {
            self::$projectLocationApiDeploymentArtifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}/artifacts/{artifact}'
            );
        }

        return self::$projectLocationApiDeploymentArtifactNameTemplate;
    }

    private static function getProjectLocationApiVersionArtifactNameTemplate()
    {
        if (self::$projectLocationApiVersionArtifactNameTemplate == null) {
            self::$projectLocationApiVersionArtifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/versions/{version}/artifacts/{artifact}'
            );
        }

        return self::$projectLocationApiVersionArtifactNameTemplate;
    }

    private static function getProjectLocationApiVersionSpecArtifactNameTemplate()
    {
        if (self::$projectLocationApiVersionSpecArtifactNameTemplate == null) {
            self::$projectLocationApiVersionSpecArtifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}/artifacts/{artifact}'
            );
        }

        return self::$projectLocationApiVersionSpecArtifactNameTemplate;
    }

    private static function getProjectLocationArtifactNameTemplate()
    {
        if (self::$projectLocationArtifactNameTemplate == null) {
            self::$projectLocationArtifactNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/artifacts/{artifact}'
            );
        }

        return self::$projectLocationArtifactNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'api' => self::getApiNameTemplate(),
                'apiDeployment' => self::getApiDeploymentNameTemplate(),
                'apiSpec' => self::getApiSpecNameTemplate(),
                'apiVersion' => self::getApiVersionNameTemplate(),
                'artifact' => self::getArtifactNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'projectLocationApiArtifact' => self::getProjectLocationApiArtifactNameTemplate(),
                'projectLocationApiDeploymentArtifact' => self::getProjectLocationApiDeploymentArtifactNameTemplate(),
                'projectLocationApiVersionArtifact' => self::getProjectLocationApiVersionArtifactNameTemplate(),
                'projectLocationApiVersionSpecArtifact' => self::getProjectLocationApiVersionSpecArtifactNameTemplate(),
                'projectLocationArtifact' => self::getProjectLocationArtifactNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     *
     * @return string The formatted api resource.
     */
    public static function apiName($project, $location, $api)
    {
        return self::getApiNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * api_deployment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $deployment
     *
     * @return string The formatted api_deployment resource.
     */
    public static function apiDeploymentName(
        $project,
        $location,
        $api,
        $deployment
    ) {
        return self::getApiDeploymentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api_spec
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $spec
     *
     * @return string The formatted api_spec resource.
     */
    public static function apiSpecName(
        $project,
        $location,
        $api,
        $version,
        $spec
    ) {
        return self::getApiSpecNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'spec' => $spec,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api_version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     *
     * @return string The formatted api_version resource.
     */
    public static function apiVersionName($project, $location, $api, $version)
    {
        return self::getApiVersionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a artifact
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $artifact
     *
     * @return string The formatted artifact resource.
     */
    public static function artifactName($project, $location, $artifact)
    {
        return self::getArtifactNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $artifact
     *
     * @return string The formatted project_location_api_artifact resource.
     */
    public static function projectLocationApiArtifactName(
        $project,
        $location,
        $api,
        $artifact
    ) {
        return self::getProjectLocationApiArtifactNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_deployment_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $deployment
     * @param string $artifact
     *
     * @return string The formatted project_location_api_deployment_artifact resource.
     */
    public static function projectLocationApiDeploymentArtifactName(
        $project,
        $location,
        $api,
        $deployment,
        $artifact
    ) {
        return self::getProjectLocationApiDeploymentArtifactNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'api' => $api,
                'deployment' => $deployment,
                'artifact' => $artifact,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_version_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $artifact
     *
     * @return string The formatted project_location_api_version_artifact resource.
     */
    public static function projectLocationApiVersionArtifactName(
        $project,
        $location,
        $api,
        $version,
        $artifact
    ) {
        return self::getProjectLocationApiVersionArtifactNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'api' => $api,
                'version' => $version,
                'artifact' => $artifact,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_api_version_spec_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $spec
     * @param string $artifact
     *
     * @return string The formatted project_location_api_version_spec_artifact resource.
     */
    public static function projectLocationApiVersionSpecArtifactName(
        $project,
        $location,
        $api,
        $version,
        $spec,
        $artifact
    ) {
        return self::getProjectLocationApiVersionSpecArtifactNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'api' => $api,
                'version' => $version,
                'spec' => $spec,
                'artifact' => $artifact,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_artifact resource.
     *
     * @param string $project
     * @param string $location
     * @param string $artifact
     *
     * @return string The formatted project_location_artifact resource.
     */
    public static function projectLocationArtifactName(
        $project,
        $location,
        $artifact
    ) {
        return self::getProjectLocationArtifactNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - api: projects/{project}/locations/{location}/apis/{api}
     * - apiDeployment: projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}
     * - apiSpec: projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}
     * - apiVersion: projects/{project}/locations/{location}/apis/{api}/versions/{version}
     * - artifact: projects/{project}/locations/{location}/artifacts/{artifact}
     * - location: projects/{project}/locations/{location}
     * - projectLocationApiArtifact: projects/{project}/locations/{location}/apis/{api}/artifacts/{artifact}
     * - projectLocationApiDeploymentArtifact: projects/{project}/locations/{location}/apis/{api}/deployments/{deployment}/artifacts/{artifact}
     * - projectLocationApiVersionArtifact: projects/{project}/locations/{location}/apis/{api}/versions/{version}/artifacts/{artifact}
     * - projectLocationApiVersionSpecArtifact: projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}/artifacts/{artifact}
     * - projectLocationArtifact: projects/{project}/locations/{location}/artifacts/{artifact}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'apigeeregistry.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Creates a specified API.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->locationName('[PROJECT]', '[LOCATION]');
     *     $api = new Api();
     *     $apiId = 'api_id';
     *     $response = $registryClient->createApi($formattedParent, $api, $apiId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of APIs.
     *                             Format: `projects/&#42;/locations/*`
     * @param Api    $api          Required. The API to create.
     * @param string $apiId        Required. The ID to use for the API, which will become the final component of
     *                             the API's resource name.
     *
     *                             This value should be 4-63 characters, and valid characters
     *                             are /[a-z][0-9]-/.
     *
     *                             Following AIP-162, IDs must not have the form of a UUID.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\Api
     *
     * @throws ApiException if the remote call fails
     */
    public function createApi($parent, $api, $apiId, array $optionalArgs = [])
    {
        $request = new CreateApiRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setApi($api);
        $request->setApiId($apiId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateApi',
            Api::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a specified deployment.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->apiName('[PROJECT]', '[LOCATION]', '[API]');
     *     $apiDeployment = new ApiDeployment();
     *     $apiDeploymentId = 'api_deployment_id';
     *     $response = $registryClient->createApiDeployment($formattedParent, $apiDeployment, $apiDeploymentId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string        $parent          Required. The parent, which owns this collection of deployments.
     *                                       Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param ApiDeployment $apiDeployment   Required. The deployment to create.
     * @param string        $apiDeploymentId Required. The ID to use for the deployment, which will become the final component of
     *                                       the deployment's resource name.
     *
     *                                       This value should be 4-63 characters, and valid characters
     *                                       are /[a-z][0-9]-/.
     *
     *                                       Following AIP-162, IDs must not have the form of a UUID.
     * @param array         $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiDeployment
     *
     * @throws ApiException if the remote call fails
     */
    public function createApiDeployment(
        $parent,
        $apiDeployment,
        $apiDeploymentId,
        array $optionalArgs = []
    ) {
        $request = new CreateApiDeploymentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setApiDeployment($apiDeployment);
        $request->setApiDeploymentId($apiDeploymentId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateApiDeployment',
            ApiDeployment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a specified spec.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->apiVersionName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]');
     *     $apiSpec = new ApiSpec();
     *     $apiSpecId = 'api_spec_id';
     *     $response = $registryClient->createApiSpec($formattedParent, $apiSpec, $apiSpecId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent, which owns this collection of specs.
     *                              Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/*`
     * @param ApiSpec $apiSpec      Required. The spec to create.
     * @param string  $apiSpecId    Required. The ID to use for the spec, which will become the final component of
     *                              the spec's resource name.
     *
     *                              This value should be 4-63 characters, and valid characters
     *                              are /[a-z][0-9]-/.
     *
     *                              Following AIP-162, IDs must not have the form of a UUID.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiSpec
     *
     * @throws ApiException if the remote call fails
     */
    public function createApiSpec(
        $parent,
        $apiSpec,
        $apiSpecId,
        array $optionalArgs = []
    ) {
        $request = new CreateApiSpecRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setApiSpec($apiSpec);
        $request->setApiSpecId($apiSpecId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateApiSpec',
            ApiSpec::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a specified version.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->apiName('[PROJECT]', '[LOCATION]', '[API]');
     *     $apiVersion = new ApiVersion();
     *     $apiVersionId = 'api_version_id';
     *     $response = $registryClient->createApiVersion($formattedParent, $apiVersion, $apiVersionId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent, which owns this collection of versions.
     *                                 Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param ApiVersion $apiVersion   Required. The version to create.
     * @param string     $apiVersionId Required. The ID to use for the version, which will become the final component of
     *                                 the version's resource name.
     *
     *                                 This value should be 1-63 characters, and valid characters
     *                                 are /[a-z][0-9]-/.
     *
     *                                 Following AIP-162, IDs must not have the form of a UUID.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiVersion
     *
     * @throws ApiException if the remote call fails
     */
    public function createApiVersion(
        $parent,
        $apiVersion,
        $apiVersionId,
        array $optionalArgs = []
    ) {
        $request = new CreateApiVersionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setApiVersion($apiVersion);
        $request->setApiVersionId($apiVersionId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateApiVersion',
            ApiVersion::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a specified artifact.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->locationName('[PROJECT]', '[LOCATION]');
     *     $artifact = new Artifact();
     *     $artifactId = 'artifact_id';
     *     $response = $registryClient->createArtifact($formattedParent, $artifact, $artifactId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The parent, which owns this collection of artifacts.
     *                               Format: `{parent}`
     * @param Artifact $artifact     Required. The artifact to create.
     * @param string   $artifactId   Required. The ID to use for the artifact, which will become the final component of
     *                               the artifact's resource name.
     *
     *                               This value should be 4-63 characters, and valid characters
     *                               are /[a-z][0-9]-/.
     *
     *                               Following AIP-162, IDs must not have the form of a UUID.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\Artifact
     *
     * @throws ApiException if the remote call fails
     */
    public function createArtifact(
        $parent,
        $artifact,
        $artifactId,
        array $optionalArgs = []
    ) {
        $request = new CreateArtifactRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setArtifact($artifact);
        $request->setArtifactId($artifactId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateArtifact',
            Artifact::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Removes a specified API and all of the resources that it
     * owns.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiName('[PROJECT]', '[LOCATION]', '[API]');
     *     $registryClient->deleteApi($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the API to delete.
     *                             Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any child resources will also be deleted.
     *           (Otherwise, the request will only work if there are no child resources.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApi($name, array $optionalArgs = [])
    {
        $request = new DeleteApiRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteApi',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Removes a specified deployment, all revisions, and all
     * child resources (e.g., artifacts).
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiDeploymentName('[PROJECT]', '[LOCATION]', '[API]', '[DEPLOYMENT]');
     *     $registryClient->deleteApiDeployment($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the deployment to delete.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/deployments/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any child resources will also be deleted.
     *           (Otherwise, the request will only work if there are no child resources.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApiDeployment($name, array $optionalArgs = [])
    {
        $request = new DeleteApiDeploymentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteApiDeployment',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a revision of a deployment.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiDeploymentName('[PROJECT]', '[LOCATION]', '[API]', '[DEPLOYMENT]');
     *     $response = $registryClient->deleteApiDeploymentRevision($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the deployment revision to be deleted,
     *                             with a revision ID explicitly included.
     *
     *                             Example:
     *                             `projects/sample/locations/global/apis/petstore/deployments/prod&#64;c7cfa2a8`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiDeployment
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApiDeploymentRevision($name, array $optionalArgs = [])
    {
        $request = new DeleteApiDeploymentRevisionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteApiDeploymentRevision',
            ApiDeployment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Removes a specified spec, all revisions, and all child
     * resources (e.g., artifacts).
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     $registryClient->deleteApiSpec($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spec to delete.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/&#42;/specs/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any child resources will also be deleted.
     *           (Otherwise, the request will only work if there are no child resources.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApiSpec($name, array $optionalArgs = [])
    {
        $request = new DeleteApiSpecRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteApiSpec',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a revision of a spec.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     $response = $registryClient->deleteApiSpecRevision($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spec revision to be deleted,
     *                             with a revision ID explicitly included.
     *
     *                             Example:
     *                             `projects/sample/locations/global/apis/petstore/versions/1.0.0/specs/openapi.yaml&#64;c7cfa2a8`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiSpec
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApiSpecRevision($name, array $optionalArgs = [])
    {
        $request = new DeleteApiSpecRevisionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteApiSpecRevision',
            ApiSpec::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Removes a specified version and all of the resources that
     * it owns.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiVersionName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]');
     *     $registryClient->deleteApiVersion($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the version to delete.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, any child resources will also be deleted.
     *           (Otherwise, the request will only work if there are no child resources.)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteApiVersion($name, array $optionalArgs = [])
    {
        $request = new DeleteApiVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteApiVersion',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Removes a specified artifact.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->artifactName('[PROJECT]', '[LOCATION]', '[ARTIFACT]');
     *     $registryClient->deleteArtifact($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the artifact to delete.
     *                             Format: `{parent}/artifacts/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteArtifact($name, array $optionalArgs = [])
    {
        $request = new DeleteArtifactRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteArtifact',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a specified API.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiName('[PROJECT]', '[LOCATION]', '[API]');
     *     $response = $registryClient->getApi($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the API to retrieve.
     *                             Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\Api
     *
     * @throws ApiException if the remote call fails
     */
    public function getApi($name, array $optionalArgs = [])
    {
        $request = new GetApiRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetApi',
            Api::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a specified deployment.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiDeploymentName('[PROJECT]', '[LOCATION]', '[API]', '[DEPLOYMENT]');
     *     $response = $registryClient->getApiDeployment($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the deployment to retrieve.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/deployments/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiDeployment
     *
     * @throws ApiException if the remote call fails
     */
    public function getApiDeployment($name, array $optionalArgs = [])
    {
        $request = new GetApiDeploymentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetApiDeployment',
            ApiDeployment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a specified spec.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     $response = $registryClient->getApiSpec($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spec to retrieve.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/&#42;/specs/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiSpec
     *
     * @throws ApiException if the remote call fails
     */
    public function getApiSpec($name, array $optionalArgs = [])
    {
        $request = new GetApiSpecRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetApiSpec',
            ApiSpec::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the contents of a specified spec.
     * If specs are stored with GZip compression, the default behavior
     * is to return the spec uncompressed (the mime_type response field
     * indicates the exact format returned).
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     $response = $registryClient->getApiSpecContents($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spec whose contents should be retrieved.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/&#42;/specs/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     */
    public function getApiSpecContents($name, array $optionalArgs = [])
    {
        $request = new GetApiSpecContentsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetApiSpecContents',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a specified version.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiVersionName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]');
     *     $response = $registryClient->getApiVersion($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the version to retrieve.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiVersion
     *
     * @throws ApiException if the remote call fails
     */
    public function getApiVersion($name, array $optionalArgs = [])
    {
        $request = new GetApiVersionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetApiVersion',
            ApiVersion::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a specified artifact.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->artifactName('[PROJECT]', '[LOCATION]', '[ARTIFACT]');
     *     $response = $registryClient->getArtifact($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the artifact to retrieve.
     *                             Format: `{parent}/artifacts/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\Artifact
     *
     * @throws ApiException if the remote call fails
     */
    public function getArtifact($name, array $optionalArgs = [])
    {
        $request = new GetArtifactRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetArtifact',
            Artifact::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns the contents of a specified artifact.
     * If artifacts are stored with GZip compression, the default behavior
     * is to return the artifact uncompressed (the mime_type response field
     * indicates the exact format returned).
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->artifactName('[PROJECT]', '[LOCATION]', '[ARTIFACT]');
     *     $response = $registryClient->getArtifactContents($formattedName);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the artifact whose contents should be retrieved.
     *                             Format: `{parent}/artifacts/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     */
    public function getArtifactContents($name, array $optionalArgs = [])
    {
        $request = new GetArtifactContentsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetArtifactContents',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all revisions of a deployment.
     * Revisions are returned in descending order of revision creation time.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiDeploymentName('[PROJECT]', '[LOCATION]', '[API]', '[DEPLOYMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listApiDeploymentRevisions($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listApiDeploymentRevisions($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the deployment to list revisions for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApiDeploymentRevisions($name, array $optionalArgs = [])
    {
        $request = new ListApiDeploymentRevisionsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListApiDeploymentRevisions',
            $optionalArgs,
            ListApiDeploymentRevisionsResponse::class,
            $request
        );
    }

    /**
     * Returns matching deployments.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->apiName('[PROJECT]', '[LOCATION]', '[API]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listApiDeployments($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listApiDeployments($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of deployments.
     *                             Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that can be used to filter the list. Filters use the Common
     *           Expression Language and can refer to all message fields.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApiDeployments($parent, array $optionalArgs = [])
    {
        $request = new ListApiDeploymentsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListApiDeployments',
            $optionalArgs,
            ListApiDeploymentsResponse::class,
            $request
        );
    }

    /**
     * Lists all revisions of a spec.
     * Revisions are returned in descending order of revision creation time.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listApiSpecRevisions($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listApiSpecRevisions($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spec to list revisions for.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApiSpecRevisions($name, array $optionalArgs = [])
    {
        $request = new ListApiSpecRevisionsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListApiSpecRevisions',
            $optionalArgs,
            ListApiSpecRevisionsResponse::class,
            $request
        );
    }

    /**
     * Returns matching specs.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->apiVersionName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listApiSpecs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listApiSpecs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of specs.
     *                             Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that can be used to filter the list. Filters use the Common
     *           Expression Language and can refer to all message fields except contents.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApiSpecs($parent, array $optionalArgs = [])
    {
        $request = new ListApiSpecsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListApiSpecs',
            $optionalArgs,
            ListApiSpecsResponse::class,
            $request
        );
    }

    /**
     * Returns matching versions.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->apiName('[PROJECT]', '[LOCATION]', '[API]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listApiVersions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listApiVersions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of versions.
     *                             Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that can be used to filter the list. Filters use the Common
     *           Expression Language and can refer to all message fields.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApiVersions($parent, array $optionalArgs = [])
    {
        $request = new ListApiVersionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListApiVersions',
            $optionalArgs,
            ListApiVersionsResponse::class,
            $request
        );
    }

    /**
     * Returns matching APIs.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listApis($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listApis($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of APIs.
     *                             Format: `projects/&#42;/locations/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that can be used to filter the list. Filters use the Common
     *           Expression Language and can refer to all message fields.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApis($parent, array $optionalArgs = [])
    {
        $request = new ListApisRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListApis',
            $optionalArgs,
            ListApisResponse::class,
            $request
        );
    }

    /**
     * Returns matching artifacts.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedParent = $registryClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listArtifacts($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listArtifacts($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of artifacts.
     *                             Format: `{parent}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that can be used to filter the list. Filters use the Common
     *           Expression Language and can refer to all message fields except contents.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listArtifacts($parent, array $optionalArgs = [])
    {
        $request = new ListArtifactsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListArtifacts',
            $optionalArgs,
            ListArtifactsResponse::class,
            $request
        );
    }

    /**
     * Used to replace a specified artifact.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $artifact = new Artifact();
     *     $response = $registryClient->replaceArtifact($artifact);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param Artifact $artifact     Required. The artifact to replace.
     *
     *                               The `name` field is used to identify the artifact to replace.
     *                               Format: `{parent}/artifacts/*`
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\Artifact
     *
     * @throws ApiException if the remote call fails
     */
    public function replaceArtifact($artifact, array $optionalArgs = [])
    {
        $request = new ReplaceArtifactRequest();
        $requestParamHeaders = [];
        $request->setArtifact($artifact);
        $requestParamHeaders['artifact.name'] = $artifact->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReplaceArtifact',
            Artifact::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Sets the current revision to a specified prior
     * revision. Note that this creates a new revision with a new revision ID.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiDeploymentName('[PROJECT]', '[LOCATION]', '[API]', '[DEPLOYMENT]');
     *     $revisionId = 'revision_id';
     *     $response = $registryClient->rollbackApiDeployment($formattedName, $revisionId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The deployment being rolled back.
     * @param string $revisionId   Required. The revision ID to roll back to.
     *                             It must be a revision of the same deployment.
     *
     *                             Example: `c7cfa2a8`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiDeployment
     *
     * @throws ApiException if the remote call fails
     */
    public function rollbackApiDeployment(
        $name,
        $revisionId,
        array $optionalArgs = []
    ) {
        $request = new RollbackApiDeploymentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setRevisionId($revisionId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RollbackApiDeployment',
            ApiDeployment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Sets the current revision to a specified prior revision.
     * Note that this creates a new revision with a new revision ID.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     $revisionId = 'revision_id';
     *     $response = $registryClient->rollbackApiSpec($formattedName, $revisionId);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The spec being rolled back.
     * @param string $revisionId   Required. The revision ID to roll back to.
     *                             It must be a revision of the same spec.
     *
     *                             Example: `c7cfa2a8`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiSpec
     *
     * @throws ApiException if the remote call fails
     */
    public function rollbackApiSpec(
        $name,
        $revisionId,
        array $optionalArgs = []
    ) {
        $request = new RollbackApiSpecRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setRevisionId($revisionId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RollbackApiSpec',
            ApiSpec::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Adds a tag to a specified revision of a
     * deployment.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiDeploymentName('[PROJECT]', '[LOCATION]', '[API]', '[DEPLOYMENT]');
     *     $tag = 'tag';
     *     $response = $registryClient->tagApiDeploymentRevision($formattedName, $tag);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the deployment to be tagged, including the revision ID.
     * @param string $tag          Required. The tag to apply.
     *                             The tag should be at most 40 characters, and match `[a-z][a-z0-9-]{3,39}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiDeployment
     *
     * @throws ApiException if the remote call fails
     */
    public function tagApiDeploymentRevision(
        $name,
        $tag,
        array $optionalArgs = []
    ) {
        $request = new TagApiDeploymentRevisionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setTag($tag);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TagApiDeploymentRevision',
            ApiDeployment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Adds a tag to a specified revision of a spec.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $formattedName = $registryClient->apiSpecName('[PROJECT]', '[LOCATION]', '[API]', '[VERSION]', '[SPEC]');
     *     $tag = 'tag';
     *     $response = $registryClient->tagApiSpecRevision($formattedName, $tag);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spec to be tagged, including the revision ID.
     * @param string $tag          Required. The tag to apply.
     *                             The tag should be at most 40 characters, and match `[a-z][a-z0-9-]{3,39}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiSpec
     *
     * @throws ApiException if the remote call fails
     */
    public function tagApiSpecRevision($name, $tag, array $optionalArgs = [])
    {
        $request = new TagApiSpecRevisionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setTag($tag);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TagApiSpecRevision',
            ApiSpec::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Used to modify a specified API.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $api = new Api();
     *     $response = $registryClient->updateApi($api);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param Api   $api          Required. The API to update.
     *
     *                            The `name` field is used to identify the API to update.
     *                            Format: `projects/&#42;/locations/&#42;/apis/*`
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. If omitted, all fields are updated that
     *           are set in the request message (fields set to default values are ignored).
     *           If an asterisk "*" is specified, all fields are updated, including fields
     *           that are unspecified/default in the request.
     *     @type bool $allowMissing
     *           If set to true, and the API is not found, a new API will be created.
     *           In this situation, `update_mask` is ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\Api
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApi($api, array $optionalArgs = [])
    {
        $request = new UpdateApiRequest();
        $requestParamHeaders = [];
        $request->setApi($api);
        $requestParamHeaders['api.name'] = $api->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateApi',
            Api::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Used to modify a specified deployment.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $apiDeployment = new ApiDeployment();
     *     $response = $registryClient->updateApiDeployment($apiDeployment);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param ApiDeployment $apiDeployment Required. The deployment to update.
     *
     *                                     The `name` field is used to identify the deployment to update.
     *                                     Format: `projects/&#42;/locations/&#42;/apis/&#42;/deployments/*`
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. If omitted, all fields are updated that
     *           are set in the request message (fields set to default values are ignored).
     *           If an asterisk "*" is specified, all fields are updated, including fields
     *           that are unspecified/default in the request.
     *     @type bool $allowMissing
     *           If set to true, and the deployment is not found, a new deployment will be
     *           created. In this situation, `update_mask` is ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiDeployment
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApiDeployment(
        $apiDeployment,
        array $optionalArgs = []
    ) {
        $request = new UpdateApiDeploymentRequest();
        $requestParamHeaders = [];
        $request->setApiDeployment($apiDeployment);
        $requestParamHeaders['api_deployment.name'] = $apiDeployment->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateApiDeployment',
            ApiDeployment::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Used to modify a specified spec.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $apiSpec = new ApiSpec();
     *     $response = $registryClient->updateApiSpec($apiSpec);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param ApiSpec $apiSpec      Required. The spec to update.
     *
     *                              The `name` field is used to identify the spec to update.
     *                              Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/&#42;/specs/*`
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. If omitted, all fields are updated that
     *           are set in the request message (fields set to default values are ignored).
     *           If an asterisk "*" is specified, all fields are updated, including fields
     *           that are unspecified/default in the request.
     *     @type bool $allowMissing
     *           If set to true, and the spec is not found, a new spec will be created.
     *           In this situation, `update_mask` is ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiSpec
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApiSpec($apiSpec, array $optionalArgs = [])
    {
        $request = new UpdateApiSpecRequest();
        $requestParamHeaders = [];
        $request->setApiSpec($apiSpec);
        $requestParamHeaders['api_spec.name'] = $apiSpec->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateApiSpec',
            ApiSpec::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Used to modify a specified version.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $apiVersion = new ApiVersion();
     *     $response = $registryClient->updateApiVersion($apiVersion);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param ApiVersion $apiVersion   Required. The version to update.
     *
     *                                 The `name` field is used to identify the version to update.
     *                                 Format: `projects/&#42;/locations/&#42;/apis/&#42;/versions/*`
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated. If omitted, all fields are updated that
     *           are set in the request message (fields set to default values are ignored).
     *           If an asterisk "*" is specified, all fields are updated, including fields
     *           that are unspecified/default in the request.
     *     @type bool $allowMissing
     *           If set to true, and the version is not found, a new version will be
     *           created. In this situation, `update_mask` is ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ApigeeRegistry\V1\ApiVersion
     *
     * @throws ApiException if the remote call fails
     */
    public function updateApiVersion($apiVersion, array $optionalArgs = [])
    {
        $request = new UpdateApiVersionRequest();
        $requestParamHeaders = [];
        $request->setApiVersion($apiVersion);
        $requestParamHeaders['api_version.name'] = $apiVersion->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateApiVersion',
            ApiVersion::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $response = $registryClient->getLocation();
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $registryClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $registryClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $resource = 'resource';
     *     $response = $registryClient->getIamPolicy($resource);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $registryClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $registryClient = new RegistryClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $registryClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $registryClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
