<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/outputs.proto

namespace Google\Cloud\Video\LiveStream\V1\VideoStream;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * H265 codec settings.
 *
 * Generated from protobuf message <code>google.cloud.video.livestream.v1.VideoStream.H265CodecSettings</code>
 */
class H265CodecSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * Valid range is [320, 4096].
     *
     * Generated from protobuf field <code>int32 width_pixels = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $width_pixels = 0;
    /**
     * Optional. The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * Valid range is [180, 2160].
     *
     * Generated from protobuf field <code>int32 height_pixels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $height_pixels = 0;
    /**
     * Required. The target video frame rate in frames per second (FPS). Must be
     * less than or equal to 120. Will default to the input frame rate if larger
     * than the input frame rate. The API will generate an output FPS that is
     * divisible by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     *
     * Generated from protobuf field <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $frame_rate = 0.0;
    /**
     * Required. The video bitrate in bits per second. Minimum value is 10,000.
     * - For SD resolution (< 720p), must be <= 3,000,000 (3 Mbps).
     * - For HD resolution (<= 1080p), must be <= 15,000,000 (15 Mbps).
     * - For UHD resolution (<= 2160p), must be <= 25,000,000 (25 Mbps).
     *
     * Generated from protobuf field <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $bitrate_bps = 0;
    /**
     * Optional. Size of the Video Buffering Verifier (VBV) buffer in bits. Must
     * be greater than zero. The default is equal to
     * [bitrate_bps][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.bitrate_bps].
     *
     * Generated from protobuf field <code>int32 vbv_size_bits = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $vbv_size_bits = 0;
    /**
     * Optional. Initial fullness of the Video Buffering Verifier (VBV) buffer
     * in bits. Must be greater than zero. The default is equal to 90% of
     * [vbv_size_bits][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.vbv_size_bits].
     *
     * Generated from protobuf field <code>int32 vbv_fullness_bits = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $vbv_fullness_bits = 0;
    /**
     * Optional. Allow B-pyramid for reference frame selection. This may not be
     * supported on all decoders. The default is `false`.
     *
     * Generated from protobuf field <code>bool b_pyramid = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $b_pyramid = false;
    /**
     * Optional. The number of consecutive B-frames. Must be greater than or
     * equal to zero. Must be less than
     * [gop_frame_count][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.gop_frame_count]
     * if set. The default is 0.
     *
     * Generated from protobuf field <code>int32 b_frame_count = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $b_frame_count = 0;
    /**
     * Optional. Specify the intensity of the adaptive quantizer (AQ). Must be
     * between 0 and 1, where 0 disables the quantizer and 1 maximizes the
     * quantizer. A higher value equals a lower bitrate but smoother image. The
     * default is 0.
     *
     * Generated from protobuf field <code>double aq_strength = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $aq_strength = 0.0;
    protected $gop_mode;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $width_pixels
     *           Optional. The width of the video in pixels. Must be an even integer.
     *           When not specified, the width is adjusted to match the specified height
     *           and input aspect ratio. If both are omitted, the input width is used.
     *           Valid range is [320, 4096].
     *     @type int $height_pixels
     *           Optional. The height of the video in pixels. Must be an even integer.
     *           When not specified, the height is adjusted to match the specified width
     *           and input aspect ratio. If both are omitted, the input height is used.
     *           Valid range is [180, 2160].
     *     @type float $frame_rate
     *           Required. The target video frame rate in frames per second (FPS). Must be
     *           less than or equal to 120. Will default to the input frame rate if larger
     *           than the input frame rate. The API will generate an output FPS that is
     *           divisible by the input FPS, and smaller or equal to the target FPS. See
     *           [Calculating frame
     *           rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     *           more information.
     *     @type int $bitrate_bps
     *           Required. The video bitrate in bits per second. Minimum value is 10,000.
     *           - For SD resolution (< 720p), must be <= 3,000,000 (3 Mbps).
     *           - For HD resolution (<= 1080p), must be <= 15,000,000 (15 Mbps).
     *           - For UHD resolution (<= 2160p), must be <= 25,000,000 (25 Mbps).
     *     @type int $gop_frame_count
     *           Optional. Select the GOP size based on the specified frame count.
     *           If GOP frame count is set instead of GOP duration, GOP duration will be
     *           calculated by `gopFrameCount`/`frameRate`. The calculated GOP duration
     *           must satisfy the limitations on `gopDuration` as well.
     *           Valid range is [60, 600].
     *     @type \Google\Protobuf\Duration $gop_duration
     *           Optional. Select the GOP size based on the specified duration. The
     *           default is `2s`. Note that `gopDuration` must be less than or equal to
     *           [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration],
     *           and
     *           [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration]
     *           must be divisible by `gopDuration`. Valid range is [2s, 20s].
     *           All video streams in the same channel must have the same GOP size.
     *     @type int $vbv_size_bits
     *           Optional. Size of the Video Buffering Verifier (VBV) buffer in bits. Must
     *           be greater than zero. The default is equal to
     *           [bitrate_bps][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.bitrate_bps].
     *     @type int $vbv_fullness_bits
     *           Optional. Initial fullness of the Video Buffering Verifier (VBV) buffer
     *           in bits. Must be greater than zero. The default is equal to 90% of
     *           [vbv_size_bits][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.vbv_size_bits].
     *     @type bool $b_pyramid
     *           Optional. Allow B-pyramid for reference frame selection. This may not be
     *           supported on all decoders. The default is `false`.
     *     @type int $b_frame_count
     *           Optional. The number of consecutive B-frames. Must be greater than or
     *           equal to zero. Must be less than
     *           [gop_frame_count][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.gop_frame_count]
     *           if set. The default is 0.
     *     @type float $aq_strength
     *           Optional. Specify the intensity of the adaptive quantizer (AQ). Must be
     *           between 0 and 1, where 0 disables the quantizer and 1 maximizes the
     *           quantizer. A higher value equals a lower bitrate but smoother image. The
     *           default is 0.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Livestream\V1\Outputs::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * Valid range is [320, 4096].
     *
     * Generated from protobuf field <code>int32 width_pixels = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getWidthPixels()
    {
        return $this->width_pixels;
    }

    /**
     * Optional. The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * Valid range is [320, 4096].
     *
     * Generated from protobuf field <code>int32 width_pixels = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setWidthPixels($var)
    {
        GPBUtil::checkInt32($var);
        $this->width_pixels = $var;

        return $this;
    }

    /**
     * Optional. The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * Valid range is [180, 2160].
     *
     * Generated from protobuf field <code>int32 height_pixels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getHeightPixels()
    {
        return $this->height_pixels;
    }

    /**
     * Optional. The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * Valid range is [180, 2160].
     *
     * Generated from protobuf field <code>int32 height_pixels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setHeightPixels($var)
    {
        GPBUtil::checkInt32($var);
        $this->height_pixels = $var;

        return $this;
    }

    /**
     * Required. The target video frame rate in frames per second (FPS). Must be
     * less than or equal to 120. Will default to the input frame rate if larger
     * than the input frame rate. The API will generate an output FPS that is
     * divisible by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     *
     * Generated from protobuf field <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return float
     */
    public function getFrameRate()
    {
        return $this->frame_rate;
    }

    /**
     * Required. The target video frame rate in frames per second (FPS). Must be
     * less than or equal to 120. Will default to the input frame rate if larger
     * than the input frame rate. The API will generate an output FPS that is
     * divisible by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     *
     * Generated from protobuf field <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param float $var
     * @return $this
     */
    public function setFrameRate($var)
    {
        GPBUtil::checkDouble($var);
        $this->frame_rate = $var;

        return $this;
    }

    /**
     * Required. The video bitrate in bits per second. Minimum value is 10,000.
     * - For SD resolution (< 720p), must be <= 3,000,000 (3 Mbps).
     * - For HD resolution (<= 1080p), must be <= 15,000,000 (15 Mbps).
     * - For UHD resolution (<= 2160p), must be <= 25,000,000 (25 Mbps).
     *
     * Generated from protobuf field <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getBitrateBps()
    {
        return $this->bitrate_bps;
    }

    /**
     * Required. The video bitrate in bits per second. Minimum value is 10,000.
     * - For SD resolution (< 720p), must be <= 3,000,000 (3 Mbps).
     * - For HD resolution (<= 1080p), must be <= 15,000,000 (15 Mbps).
     * - For UHD resolution (<= 2160p), must be <= 25,000,000 (25 Mbps).
     *
     * Generated from protobuf field <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setBitrateBps($var)
    {
        GPBUtil::checkInt32($var);
        $this->bitrate_bps = $var;

        return $this;
    }

    /**
     * Optional. Select the GOP size based on the specified frame count.
     * If GOP frame count is set instead of GOP duration, GOP duration will be
     * calculated by `gopFrameCount`/`frameRate`. The calculated GOP duration
     * must satisfy the limitations on `gopDuration` as well.
     * Valid range is [60, 600].
     *
     * Generated from protobuf field <code>int32 gop_frame_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getGopFrameCount()
    {
        return $this->readOneof(7);
    }

    public function hasGopFrameCount()
    {
        return $this->hasOneof(7);
    }

    /**
     * Optional. Select the GOP size based on the specified frame count.
     * If GOP frame count is set instead of GOP duration, GOP duration will be
     * calculated by `gopFrameCount`/`frameRate`. The calculated GOP duration
     * must satisfy the limitations on `gopDuration` as well.
     * Valid range is [60, 600].
     *
     * Generated from protobuf field <code>int32 gop_frame_count = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setGopFrameCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Optional. Select the GOP size based on the specified duration. The
     * default is `2s`. Note that `gopDuration` must be less than or equal to
     * [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration],
     * and
     * [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration]
     * must be divisible by `gopDuration`. Valid range is [2s, 20s].
     * All video streams in the same channel must have the same GOP size.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration gop_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getGopDuration()
    {
        return $this->readOneof(8);
    }

    public function hasGopDuration()
    {
        return $this->hasOneof(8);
    }

    /**
     * Optional. Select the GOP size based on the specified duration. The
     * default is `2s`. Note that `gopDuration` must be less than or equal to
     * [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration],
     * and
     * [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration]
     * must be divisible by `gopDuration`. Valid range is [2s, 20s].
     * All video streams in the same channel must have the same GOP size.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration gop_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setGopDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Optional. Size of the Video Buffering Verifier (VBV) buffer in bits. Must
     * be greater than zero. The default is equal to
     * [bitrate_bps][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.bitrate_bps].
     *
     * Generated from protobuf field <code>int32 vbv_size_bits = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getVbvSizeBits()
    {
        return $this->vbv_size_bits;
    }

    /**
     * Optional. Size of the Video Buffering Verifier (VBV) buffer in bits. Must
     * be greater than zero. The default is equal to
     * [bitrate_bps][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.bitrate_bps].
     *
     * Generated from protobuf field <code>int32 vbv_size_bits = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setVbvSizeBits($var)
    {
        GPBUtil::checkInt32($var);
        $this->vbv_size_bits = $var;

        return $this;
    }

    /**
     * Optional. Initial fullness of the Video Buffering Verifier (VBV) buffer
     * in bits. Must be greater than zero. The default is equal to 90% of
     * [vbv_size_bits][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.vbv_size_bits].
     *
     * Generated from protobuf field <code>int32 vbv_fullness_bits = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getVbvFullnessBits()
    {
        return $this->vbv_fullness_bits;
    }

    /**
     * Optional. Initial fullness of the Video Buffering Verifier (VBV) buffer
     * in bits. Must be greater than zero. The default is equal to 90% of
     * [vbv_size_bits][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.vbv_size_bits].
     *
     * Generated from protobuf field <code>int32 vbv_fullness_bits = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setVbvFullnessBits($var)
    {
        GPBUtil::checkInt32($var);
        $this->vbv_fullness_bits = $var;

        return $this;
    }

    /**
     * Optional. Allow B-pyramid for reference frame selection. This may not be
     * supported on all decoders. The default is `false`.
     *
     * Generated from protobuf field <code>bool b_pyramid = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getBPyramid()
    {
        return $this->b_pyramid;
    }

    /**
     * Optional. Allow B-pyramid for reference frame selection. This may not be
     * supported on all decoders. The default is `false`.
     *
     * Generated from protobuf field <code>bool b_pyramid = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setBPyramid($var)
    {
        GPBUtil::checkBool($var);
        $this->b_pyramid = $var;

        return $this;
    }

    /**
     * Optional. The number of consecutive B-frames. Must be greater than or
     * equal to zero. Must be less than
     * [gop_frame_count][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.gop_frame_count]
     * if set. The default is 0.
     *
     * Generated from protobuf field <code>int32 b_frame_count = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getBFrameCount()
    {
        return $this->b_frame_count;
    }

    /**
     * Optional. The number of consecutive B-frames. Must be greater than or
     * equal to zero. Must be less than
     * [gop_frame_count][google.cloud.video.livestream.v1.VideoStream.H265CodecSettings.gop_frame_count]
     * if set. The default is 0.
     *
     * Generated from protobuf field <code>int32 b_frame_count = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setBFrameCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->b_frame_count = $var;

        return $this;
    }

    /**
     * Optional. Specify the intensity of the adaptive quantizer (AQ). Must be
     * between 0 and 1, where 0 disables the quantizer and 1 maximizes the
     * quantizer. A higher value equals a lower bitrate but smoother image. The
     * default is 0.
     *
     * Generated from protobuf field <code>double aq_strength = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getAqStrength()
    {
        return $this->aq_strength;
    }

    /**
     * Optional. Specify the intensity of the adaptive quantizer (AQ). Must be
     * between 0 and 1, where 0 disables the quantizer and 1 maximizes the
     * quantizer. A higher value equals a lower bitrate but smoother image. The
     * default is 0.
     *
     * Generated from protobuf field <code>double aq_strength = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setAqStrength($var)
    {
        GPBUtil::checkDouble($var);
        $this->aq_strength = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getGopMode()
    {
        return $this->whichOneof("gop_mode");
    }

}


