<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v2/cloud_speech.proto

namespace Google\Cloud\Speech\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for the
 * [CreateCustomClass][google.cloud.speech.v2.Speech.CreateCustomClass] method.
 *
 * Generated from protobuf message <code>google.cloud.speech.v2.CreateCustomClassRequest</code>
 */
class CreateCustomClassRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The CustomClass to create.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CustomClass custom_class = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $custom_class = null;
    /**
     * If set, validate the request and preview the CustomClass, but do not
     * actually create it.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     */
    protected $validate_only = false;
    /**
     * The ID to use for the CustomClass, which will become the final component of
     * the CustomClass's resource name.
     * This value should be 4-63 characters, and valid characters
     * are /[a-z][0-9]-/.
     *
     * Generated from protobuf field <code>string custom_class_id = 3;</code>
     */
    protected $custom_class_id = '';
    /**
     * Required. The project and location where this CustomClass will be created.
     * The expected format is `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';

    /**
     * @param string                              $parent        Required. The project and location where this CustomClass will be created.
     *                                                           The expected format is `projects/{project}/locations/{location}`. Please see
     *                                                           {@see SpeechClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Speech\V2\CustomClass $customClass   Required. The CustomClass to create.
     * @param string                              $customClassId The ID to use for the CustomClass, which will become the final component of
     *                                                           the CustomClass's resource name.
     *
     *                                                           This value should be 4-63 characters, and valid characters
     *                                                           are /[a-z][0-9]-/.
     *
     * @return \Google\Cloud\Speech\V2\CreateCustomClassRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Speech\V2\CustomClass $customClass, string $customClassId): self
    {
        return (new self())
            ->setParent($parent)
            ->setCustomClass($customClass)
            ->setCustomClassId($customClassId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Speech\V2\CustomClass $custom_class
     *           Required. The CustomClass to create.
     *     @type bool $validate_only
     *           If set, validate the request and preview the CustomClass, but do not
     *           actually create it.
     *     @type string $custom_class_id
     *           The ID to use for the CustomClass, which will become the final component of
     *           the CustomClass's resource name.
     *           This value should be 4-63 characters, and valid characters
     *           are /[a-z][0-9]-/.
     *     @type string $parent
     *           Required. The project and location where this CustomClass will be created.
     *           The expected format is `projects/{project}/locations/{location}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V2\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The CustomClass to create.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CustomClass custom_class = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Speech\V2\CustomClass|null
     */
    public function getCustomClass()
    {
        return $this->custom_class;
    }

    public function hasCustomClass()
    {
        return isset($this->custom_class);
    }

    public function clearCustomClass()
    {
        unset($this->custom_class);
    }

    /**
     * Required. The CustomClass to create.
     *
     * Generated from protobuf field <code>.google.cloud.speech.v2.CustomClass custom_class = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Speech\V2\CustomClass $var
     * @return $this
     */
    public function setCustomClass($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Speech\V2\CustomClass::class);
        $this->custom_class = $var;

        return $this;
    }

    /**
     * If set, validate the request and preview the CustomClass, but do not
     * actually create it.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * If set, validate the request and preview the CustomClass, but do not
     * actually create it.
     *
     * Generated from protobuf field <code>bool validate_only = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * The ID to use for the CustomClass, which will become the final component of
     * the CustomClass's resource name.
     * This value should be 4-63 characters, and valid characters
     * are /[a-z][0-9]-/.
     *
     * Generated from protobuf field <code>string custom_class_id = 3;</code>
     * @return string
     */
    public function getCustomClassId()
    {
        return $this->custom_class_id;
    }

    /**
     * The ID to use for the CustomClass, which will become the final component of
     * the CustomClass's resource name.
     * This value should be 4-63 characters, and valid characters
     * are /[a-z][0-9]-/.
     *
     * Generated from protobuf field <code>string custom_class_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomClassId($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_class_id = $var;

        return $this;
    }

    /**
     * Required. The project and location where this CustomClass will be created.
     * The expected format is `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The project and location where this CustomClass will be created.
     * The expected format is `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

}

