<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycentermanagement/v1/security_center_management.proto

namespace Google\Cloud\SecurityCenterManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an instance of a Security Health Analytics custom module,
 * including its full module name, display name, enablement state, and last
 * updated time. You can create a custom module at the organization, folder, or
 * project level. Custom modules that you create at the organization or folder
 * level are inherited by the descendant folders and projects.
 *
 * Generated from protobuf message <code>google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule</code>
 */
class SecurityHealthAnalyticsCustomModule extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The full resource name of the custom module, in one of the
     * following formats:
     * * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     * * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     * * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The display name of the Security Health Analytics custom module.
     * This display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and 128
     * characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. The enablement state of the custom module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enablement_state = 0;
    /**
     * Output only. The time at which the custom module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The editor that last updated the custom module.
     *
     * Generated from protobuf field <code>string last_editor = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_editor = '';
    /**
     * Output only. Specifies the organization or folder from which the custom
     * module is inherited. If empty, indicates that the custom module was created
     * in the organization, folder, or project in which you are viewing the custom
     * module.
     *
     * Generated from protobuf field <code>string ancestor_module = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $ancestor_module = '';
    /**
     * Optional. The user-specified custom configuration for the module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.CustomConfig custom_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $custom_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The full resource name of the custom module, in one of the
     *           following formats:
     *           * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     *           * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     *           * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     *     @type string $display_name
     *           Optional. The display name of the Security Health Analytics custom module.
     *           This display name becomes the finding category for all findings that are
     *           returned by this custom module. The display name must be between 1 and 128
     *           characters, start with a lowercase letter, and contain alphanumeric
     *           characters or underscores only.
     *     @type int $enablement_state
     *           Optional. The enablement state of the custom module.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the custom module was last updated.
     *     @type string $last_editor
     *           Output only. The editor that last updated the custom module.
     *     @type string $ancestor_module
     *           Output only. Specifies the organization or folder from which the custom
     *           module is inherited. If empty, indicates that the custom module was created
     *           in the organization, folder, or project in which you are viewing the custom
     *           module.
     *     @type \Google\Cloud\SecurityCenterManagement\V1\CustomConfig $custom_config
     *           Optional. The user-specified custom configuration for the module.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycentermanagement\V1\SecurityCenterManagement::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The full resource name of the custom module, in one of the
     * following formats:
     * * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     * * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     * * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The full resource name of the custom module, in one of the
     * following formats:
     * * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     * * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     * * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{custom_module}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The display name of the Security Health Analytics custom module.
     * This display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and 128
     * characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. The display name of the Security Health Analytics custom module.
     * This display name becomes the finding category for all findings that are
     * returned by this custom module. The display name must be between 1 and 128
     * characters, start with a lowercase letter, and contain alphanumeric
     * characters or underscores only.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. The enablement state of the custom module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getEnablementState()
    {
        return $this->enablement_state;
    }

    /**
     * Optional. The enablement state of the custom module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule.EnablementState enablement_state = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setEnablementState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenterManagement\V1\SecurityHealthAnalyticsCustomModule\EnablementState::class);
        $this->enablement_state = $var;

        return $this;
    }

    /**
     * Output only. The time at which the custom module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the custom module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The editor that last updated the custom module.
     *
     * Generated from protobuf field <code>string last_editor = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastEditor()
    {
        return $this->last_editor;
    }

    /**
     * Output only. The editor that last updated the custom module.
     *
     * Generated from protobuf field <code>string last_editor = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastEditor($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_editor = $var;

        return $this;
    }

    /**
     * Output only. Specifies the organization or folder from which the custom
     * module is inherited. If empty, indicates that the custom module was created
     * in the organization, folder, or project in which you are viewing the custom
     * module.
     *
     * Generated from protobuf field <code>string ancestor_module = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAncestorModule()
    {
        return $this->ancestor_module;
    }

    /**
     * Output only. Specifies the organization or folder from which the custom
     * module is inherited. If empty, indicates that the custom module was created
     * in the organization, folder, or project in which you are viewing the custom
     * module.
     *
     * Generated from protobuf field <code>string ancestor_module = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAncestorModule($var)
    {
        GPBUtil::checkString($var, True);
        $this->ancestor_module = $var;

        return $this;
    }

    /**
     * Optional. The user-specified custom configuration for the module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.CustomConfig custom_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\SecurityCenterManagement\V1\CustomConfig|null
     */
    public function getCustomConfig()
    {
        return $this->custom_config;
    }

    public function hasCustomConfig()
    {
        return isset($this->custom_config);
    }

    public function clearCustomConfig()
    {
        unset($this->custom_config);
    }

    /**
     * Optional. The user-specified custom configuration for the module.
     *
     * Generated from protobuf field <code>.google.cloud.securitycentermanagement.v1.CustomConfig custom_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\SecurityCenterManagement\V1\CustomConfig $var
     * @return $this
     */
    public function setCustomConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\SecurityCenterManagement\V1\CustomConfig::class);
        $this->custom_config = $var;

        return $this;
    }

}

