<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v2/data_retention_deletion_event.proto

namespace Google\Cloud\SecurityCenter\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details about data retention deletion violations, in which the data is
 * non-compliant based on their retention or deletion time, as defined in the
 * applicable data security policy. The Data Retention Deletion (DRD) control is
 * a control of the DSPM (Data Security Posture Management) suite that enables
 * organizations to manage data retention and deletion policies in compliance
 * with regulations, such as GDPR and CRPA. DRD supports two primary policy
 * types: maximum storage length (max TTL) and minimum storage length (min TTL).
 * Both are aimed at helping organizations meet regulatory and data management
 * commitments.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v2.DataRetentionDeletionEvent</code>
 */
class DataRetentionDeletionEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Timestamp indicating when the event was detected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_detection_time = 2;</code>
     */
    protected $event_detection_time = null;
    /**
     * Number of objects that violated the policy for this resource. If the number
     * is less than 1,000, then the value of this field is the exact number. If
     * the number of objects that violated the policy is greater than or equal to
     * 1,000, then the value of this field is 1000.
     *
     * Generated from protobuf field <code>int64 data_object_count = 3;</code>
     */
    protected $data_object_count = 0;
    /**
     * Maximum duration of retention allowed from the DRD control. This comes
     * from the DRD control where users set a max TTL for their data. For example,
     * suppose that a user sets the max TTL for a Cloud Storage bucket to 90 days.
     * However, an object in that bucket is 100 days old. In this case, a
     * DataRetentionDeletionEvent will be generated for that Cloud Storage bucket,
     * and the max_retention_allowed is 90 days.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_retention_allowed = 4;</code>
     */
    protected $max_retention_allowed = null;
    /**
     * Type of the DRD event.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v2.DataRetentionDeletionEvent.EventType event_type = 5;</code>
     */
    protected $event_type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $event_detection_time
     *           Timestamp indicating when the event was detected.
     *     @type int|string $data_object_count
     *           Number of objects that violated the policy for this resource. If the number
     *           is less than 1,000, then the value of this field is the exact number. If
     *           the number of objects that violated the policy is greater than or equal to
     *           1,000, then the value of this field is 1000.
     *     @type \Google\Protobuf\Duration $max_retention_allowed
     *           Maximum duration of retention allowed from the DRD control. This comes
     *           from the DRD control where users set a max TTL for their data. For example,
     *           suppose that a user sets the max TTL for a Cloud Storage bucket to 90 days.
     *           However, an object in that bucket is 100 days old. In this case, a
     *           DataRetentionDeletionEvent will be generated for that Cloud Storage bucket,
     *           and the max_retention_allowed is 90 days.
     *     @type int $event_type
     *           Type of the DRD event.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V2\DataRetentionDeletionEvent::initOnce();
        parent::__construct($data);
    }

    /**
     * Timestamp indicating when the event was detected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_detection_time = 2;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventDetectionTime()
    {
        return $this->event_detection_time;
    }

    public function hasEventDetectionTime()
    {
        return isset($this->event_detection_time);
    }

    public function clearEventDetectionTime()
    {
        unset($this->event_detection_time);
    }

    /**
     * Timestamp indicating when the event was detected.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_detection_time = 2;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventDetectionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_detection_time = $var;

        return $this;
    }

    /**
     * Number of objects that violated the policy for this resource. If the number
     * is less than 1,000, then the value of this field is the exact number. If
     * the number of objects that violated the policy is greater than or equal to
     * 1,000, then the value of this field is 1000.
     *
     * Generated from protobuf field <code>int64 data_object_count = 3;</code>
     * @return int|string
     */
    public function getDataObjectCount()
    {
        return $this->data_object_count;
    }

    /**
     * Number of objects that violated the policy for this resource. If the number
     * is less than 1,000, then the value of this field is the exact number. If
     * the number of objects that violated the policy is greater than or equal to
     * 1,000, then the value of this field is 1000.
     *
     * Generated from protobuf field <code>int64 data_object_count = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDataObjectCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->data_object_count = $var;

        return $this;
    }

    /**
     * Maximum duration of retention allowed from the DRD control. This comes
     * from the DRD control where users set a max TTL for their data. For example,
     * suppose that a user sets the max TTL for a Cloud Storage bucket to 90 days.
     * However, an object in that bucket is 100 days old. In this case, a
     * DataRetentionDeletionEvent will be generated for that Cloud Storage bucket,
     * and the max_retention_allowed is 90 days.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_retention_allowed = 4;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMaxRetentionAllowed()
    {
        return $this->max_retention_allowed;
    }

    public function hasMaxRetentionAllowed()
    {
        return isset($this->max_retention_allowed);
    }

    public function clearMaxRetentionAllowed()
    {
        unset($this->max_retention_allowed);
    }

    /**
     * Maximum duration of retention allowed from the DRD control. This comes
     * from the DRD control where users set a max TTL for their data. For example,
     * suppose that a user sets the max TTL for a Cloud Storage bucket to 90 days.
     * However, an object in that bucket is 100 days old. In this case, a
     * DataRetentionDeletionEvent will be generated for that Cloud Storage bucket,
     * and the max_retention_allowed is 90 days.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_retention_allowed = 4;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxRetentionAllowed($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->max_retention_allowed = $var;

        return $this;
    }

    /**
     * Type of the DRD event.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v2.DataRetentionDeletionEvent.EventType event_type = 5;</code>
     * @return int
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * Type of the DRD event.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v2.DataRetentionDeletionEvent.EventType event_type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V2\DataRetentionDeletionEvent\EventType::class);
        $this->event_type = $var;

        return $this;
    }

}

