<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/policysimulator/v1/simulator.proto

namespace Google\Cloud\PolicySimulator\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The result of replaying a single access tuple against a simulated state.
 *
 * Generated from protobuf message <code>google.cloud.policysimulator.v1.ReplayResult</code>
 */
class ReplayResult extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the `ReplayResult`, in the following format:
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     *
     * Generated from protobuf field <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     */
    protected $access_tuple = null;
    /**
     * The latest date this access tuple was seen in the logs.
     *
     * Generated from protobuf field <code>.google.type.Date last_seen_date = 4;</code>
     */
    protected $last_seen_date = null;
    protected $result;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\PolicySimulator\V1\ReplayDiff $diff
     *           The difference between the principal's access under the current
     *           (baseline) policies and the principal's access under the proposed
     *           (simulated) policies.
     *           This field is only included for access tuples that were successfully
     *           replayed and had different results under the current policies and the
     *           proposed policies.
     *     @type \Google\Rpc\Status $error
     *           The error that caused the access tuple replay to fail.
     *           This field is only included for access tuples that were not replayed
     *           successfully.
     *     @type string $name
     *           The resource name of the `ReplayResult`, in the following format:
     *           `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     *           where `{resource-id}` is the ID of the project, folder, or organization
     *           that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     *           Example:
     *           `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     *     @type string $parent
     *           The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     *           was included in.
     *     @type \Google\Cloud\PolicySimulator\V1\AccessTuple $access_tuple
     *           The access tuple that was replayed. This field includes information about
     *           the principal, resource, and permission that were involved in the access
     *           attempt.
     *     @type \Google\Type\Date $last_seen_date
     *           The latest date this access tuple was seen in the logs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Policysimulator\V1\Simulator::initOnce();
        parent::__construct($data);
    }

    /**
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     *
     * Generated from protobuf field <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     * @return \Google\Cloud\PolicySimulator\V1\ReplayDiff|null
     */
    public function getDiff()
    {
        return $this->readOneof(5);
    }

    public function hasDiff()
    {
        return $this->hasOneof(5);
    }

    /**
     * The difference between the principal's access under the current
     * (baseline) policies and the principal's access under the proposed
     * (simulated) policies.
     * This field is only included for access tuples that were successfully
     * replayed and had different results under the current policies and the
     * proposed policies.
     *
     * Generated from protobuf field <code>.google.cloud.policysimulator.v1.ReplayDiff diff = 5;</code>
     * @param \Google\Cloud\PolicySimulator\V1\ReplayDiff $var
     * @return $this
     */
    public function setDiff($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PolicySimulator\V1\ReplayDiff::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * The error that caused the access tuple replay to fail.
     * This field is only included for access tuples that were not replayed
     * successfully.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 6;</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->readOneof(6);
    }

    public function hasError()
    {
        return $this->hasOneof(6);
    }

    /**
     * The error that caused the access tuple replay to fail.
     * This field is only included for access tuples that were not replayed
     * successfully.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 6;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * The resource name of the `ReplayResult`, in the following format:
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the `ReplayResult`, in the following format:
     * `{projects|folders|organizations}/{resource-id}/locations/global/replays/{replay-id}/results/{replay-result-id}`,
     * where `{resource-id}` is the ID of the project, folder, or organization
     * that owns the [Replay][google.cloud.policysimulator.v1.Replay].
     * Example:
     * `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce1833c36/results/1234`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The [Replay][google.cloud.policysimulator.v1.Replay] that the access tuple
     * was included in.
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     *
     * Generated from protobuf field <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     * @return \Google\Cloud\PolicySimulator\V1\AccessTuple|null
     */
    public function getAccessTuple()
    {
        return $this->access_tuple;
    }

    public function hasAccessTuple()
    {
        return isset($this->access_tuple);
    }

    public function clearAccessTuple()
    {
        unset($this->access_tuple);
    }

    /**
     * The access tuple that was replayed. This field includes information about
     * the principal, resource, and permission that were involved in the access
     * attempt.
     *
     * Generated from protobuf field <code>.google.cloud.policysimulator.v1.AccessTuple access_tuple = 3;</code>
     * @param \Google\Cloud\PolicySimulator\V1\AccessTuple $var
     * @return $this
     */
    public function setAccessTuple($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PolicySimulator\V1\AccessTuple::class);
        $this->access_tuple = $var;

        return $this;
    }

    /**
     * The latest date this access tuple was seen in the logs.
     *
     * Generated from protobuf field <code>.google.type.Date last_seen_date = 4;</code>
     * @return \Google\Type\Date|null
     */
    public function getLastSeenDate()
    {
        return $this->last_seen_date;
    }

    public function hasLastSeenDate()
    {
        return isset($this->last_seen_date);
    }

    public function clearLastSeenDate()
    {
        unset($this->last_seen_date);
    }

    /**
     * The latest date this access tuple was seen in the logs.
     *
     * Generated from protobuf field <code>.google.type.Date last_seen_date = 4;</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setLastSeenDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->last_seen_date = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getResult()
    {
        return $this->whichOneof("result");
    }

}

