<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/managedkafka/schemaregistry/v1/schema_registry.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ManagedKafka\SchemaRegistry\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Api\HttpBody;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\CheckCompatibilityRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\CheckCompatibilityResponse;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\Context;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\CreateSchemaRegistryRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\CreateVersionRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\CreateVersionResponse;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\DeleteSchemaConfigRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\DeleteSchemaModeRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\DeleteSchemaRegistryRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\DeleteSubjectRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\DeleteVersionRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\GetContextRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\GetSchemaConfigRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\GetSchemaModeRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\GetSchemaRegistryRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\GetSchemaRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\GetVersionRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListContextsRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListReferencedSchemasRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSchemaRegistriesRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSchemaRegistriesResponse;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSchemaTypesRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSchemaVersionsRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSubjectsBySchemaIdRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListSubjectsRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ListVersionsRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\LookupVersionRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\Schema;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\SchemaConfig;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\SchemaMode;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\SchemaRegistry;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\SchemaVersion;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\UpdateSchemaConfigRequest;
use Google\Cloud\ManagedKafka\SchemaRegistry\V1\UpdateSchemaModeRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: SchemaRegistry is a service that allows users to manage schemas for their
 * Kafka clusters. It provides APIs to register, list, and delete schemas, as
 * well as to get the schema for a given schema id or a given version id under a
 * subject, to update the global or subject-specific compatibility mode, and to
 * check the compatibility of a schema against a subject or a version. The main
 * resource hierarchy is as follows:
 *
 * * SchemaRegistry
 * * SchemaRegistry/Context
 * * SchemaRegistry/Context/Schema
 * * SchemaRegistry/Context/Subject
 * * SchemaRegistry/Context/Subject/Version
 * * SchemaRegistry/Config
 * * SchemaRegistry/Mode
 *
 * **SchemaRegistry** is the root resource to represent a schema registry
 * instance. A customer can have multiple schema registry instances in a
 * project.
 *
 * **Context** is a context resource that represents a group of
 * schemas, subjects and versions. A schema registry instance can have multiple
 * contexts and always has a 'default' context. Contexts are independent of each
 * other. Context is optional and if not specified, it falls back to the
 * 'default' context.
 *
 * **Schema** is a schema resource that represents a unique schema in a context
 * of a schema registry instance. Each schema has a unique schema id, and can be
 * referenced by a version of a subject.
 *
 * **Subject** refers to the name under which the schema is registered. A
 * typical subject is the Kafka topic name. A schema registry instance can have
 * multiple subjects.
 *
 * **Version** represents a version of a subject. A subject can have multiple
 * versions. Creation of new version of a subject is guarded by the
 * compatibility mode configured globally or for the subject specifically.
 *
 * **Config** represents a config at global level cross all registry
 * instances or at subject level. Currently, only compatibility is supported in
 * config.
 *
 * **Mode** represents the mode of a schema registry or a specific subject.
 * Three modes are supported:
 * * READONLY: The schema registry is in read-only mode, no write operations
 * allowed..
 * * READWRITE: The schema registry is in read-write mode, which allows limited
 * write operations on the schema.
 * * IMPORT: The schema registry is in import mode, which allows more editing
 * operations on the schema for data importing purposes.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<CheckCompatibilityResponse> checkCompatibilityAsync(CheckCompatibilityRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaRegistry> createSchemaRegistryAsync(CreateSchemaRegistryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CreateVersionResponse> createVersionAsync(CreateVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaConfig> deleteSchemaConfigAsync(DeleteSchemaConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaMode> deleteSchemaModeAsync(DeleteSchemaModeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSchemaRegistryAsync(DeleteSchemaRegistryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> deleteSubjectAsync(DeleteSubjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> deleteVersionAsync(DeleteVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Context> getContextAsync(GetContextRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> getRawSchemaAsync(GetSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> getRawSchemaVersionAsync(GetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Schema> getSchemaAsync(GetSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaConfig> getSchemaConfigAsync(GetSchemaConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaMode> getSchemaModeAsync(GetSchemaModeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaRegistry> getSchemaRegistryAsync(GetSchemaRegistryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaVersion> getVersionAsync(GetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listContextsAsync(ListContextsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listReferencedSchemasAsync(ListReferencedSchemasRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListSchemaRegistriesResponse> listSchemaRegistriesAsync(ListSchemaRegistriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listSchemaTypesAsync(ListSchemaTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listSchemaVersionsAsync(ListSchemaVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listSubjectsAsync(ListSubjectsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listSubjectsBySchemaIdAsync(ListSubjectsBySchemaIdRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<HttpBody> listVersionsAsync(ListVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaVersion> lookupVersionAsync(LookupVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaConfig> updateSchemaConfigAsync(UpdateSchemaConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SchemaMode> updateSchemaModeAsync(UpdateSchemaModeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ManagedSchemaRegistryClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.managedkafka.schemaregistry.v1.ManagedSchemaRegistry';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'managedkafka.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'managedkafka.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/managed_schema_registry_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/managed_schema_registry_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/managed_schema_registry_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/managed_schema_registry_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     *
     * @return string The formatted project_location_schema_registry_config resource.
     */
    public static function projectLocationSchemaRegistryConfigName(
        string $project,
        string $location,
        string $schemaRegistry
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryConfig')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_context_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     *
     * @return string The formatted project_location_schema_registry_context_config resource.
     */
    public static function projectLocationSchemaRegistryContextConfigName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryContextConfig')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_context_mode resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     *
     * @return string The formatted project_location_schema_registry_context_mode resource.
     */
    public static function projectLocationSchemaRegistryContextModeName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryContextMode')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_context_schema resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     * @param string $schema
     *
     * @return string The formatted project_location_schema_registry_context_schema resource.
     */
    public static function projectLocationSchemaRegistryContextSchemaName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context,
        string $schema
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryContextSchema')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
            'schema' => $schema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_context_subject resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     * @param string $subject
     *
     * @return string The formatted project_location_schema_registry_context_subject resource.
     */
    public static function projectLocationSchemaRegistryContextSubjectName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context,
        string $subject
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryContextSubject')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
            'subject' => $subject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_context_subject_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     * @param string $subject
     * @param string $version
     *
     * @return string The formatted project_location_schema_registry_context_subject_version resource.
     */
    public static function projectLocationSchemaRegistryContextSubjectVersionName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context,
        string $subject,
        string $version
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryContextSubjectVersion')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
            'subject' => $subject,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_context_subject_versions resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     * @param string $subject
     *
     * @return string The formatted project_location_schema_registry_context_subject_versions resource.
     */
    public static function projectLocationSchemaRegistryContextSubjectVersionsName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context,
        string $subject
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryContextSubjectVersions')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
            'subject' => $subject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_mode resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     *
     * @return string The formatted project_location_schema_registry_mode resource.
     */
    public static function projectLocationSchemaRegistryModeName(
        string $project,
        string $location,
        string $schemaRegistry
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistryMode')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_schema resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $schema
     *
     * @return string The formatted project_location_schema_registry_schema resource.
     */
    public static function projectLocationSchemaRegistrySchemaName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $schema
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistrySchema')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'schema' => $schema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_subject resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $subject
     *
     * @return string The formatted project_location_schema_registry_subject resource.
     */
    public static function projectLocationSchemaRegistrySubjectName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $subject
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistrySubject')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'subject' => $subject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_subject_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $subject
     * @param string $version
     *
     * @return string The formatted project_location_schema_registry_subject_version resource.
     */
    public static function projectLocationSchemaRegistrySubjectVersionName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $subject,
        string $version
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistrySubjectVersion')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'subject' => $subject,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_schema_registry_subject_versions resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $subject
     *
     * @return string The formatted project_location_schema_registry_subject_versions resource.
     */
    public static function projectLocationSchemaRegistrySubjectVersionsName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $subject
    ): string {
        return self::getPathTemplate('projectLocationSchemaRegistrySubjectVersions')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'subject' => $subject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a schema
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $schema
     *
     * @return string The formatted schema resource.
     */
    public static function schemaName(string $project, string $location, string $schemaRegistry, string $schema): string
    {
        return self::getPathTemplate('schema')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'schema' => $schema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * schema_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     *
     * @return string The formatted schema_config resource.
     */
    public static function schemaConfigName(string $project, string $location, string $schemaRegistry): string
    {
        return self::getPathTemplate('schemaConfig')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * schema_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $context
     *
     * @return string The formatted schema_context resource.
     */
    public static function schemaContextName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $context
    ): string {
        return self::getPathTemplate('schemaContext')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a schema_mode
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     *
     * @return string The formatted schema_mode resource.
     */
    public static function schemaModeName(string $project, string $location, string $schemaRegistry): string
    {
        return self::getPathTemplate('schemaMode')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * schema_registry resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     *
     * @return string The formatted schema_registry resource.
     */
    public static function schemaRegistryName(string $project, string $location, string $schemaRegistry): string
    {
        return self::getPathTemplate('schemaRegistry')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * schema_subject resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $subject
     *
     * @return string The formatted schema_subject resource.
     */
    public static function schemaSubjectName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $subject
    ): string {
        return self::getPathTemplate('schemaSubject')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'subject' => $subject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * schema_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $schemaRegistry
     * @param string $subject
     * @param string $version
     *
     * @return string The formatted schema_version resource.
     */
    public static function schemaVersionName(
        string $project,
        string $location,
        string $schemaRegistry,
        string $subject,
        string $version
    ): string {
        return self::getPathTemplate('schemaVersion')->render([
            'project' => $project,
            'location' => $location,
            'schema_registry' => $schemaRegistry,
            'subject' => $subject,
            'version' => $version,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - projectLocationSchemaRegistryConfig: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/config
     * - projectLocationSchemaRegistryContextConfig: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/config
     * - projectLocationSchemaRegistryContextMode: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/mode
     * - projectLocationSchemaRegistryContextSchema: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/schemas/ids/{schema}
     * - projectLocationSchemaRegistryContextSubject: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}
     * - projectLocationSchemaRegistryContextSubjectVersion: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/subjects/{subject}/versions/{version}
     * - projectLocationSchemaRegistryContextSubjectVersions: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}/compatibility/subjects/{subject}/versions
     * - projectLocationSchemaRegistryMode: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/mode
     * - projectLocationSchemaRegistrySchema: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}
     * - projectLocationSchemaRegistrySubject: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}
     * - projectLocationSchemaRegistrySubjectVersion: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}
     * - projectLocationSchemaRegistrySubjectVersions: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/compatibility/subjects/{subject}/versions
     * - schema: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/schemas/ids/{schema}
     * - schemaConfig: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/config
     * - schemaContext: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/contexts/{context}
     * - schemaMode: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/mode
     * - schemaRegistry: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}
     * - schemaSubject: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}
     * - schemaVersion: projects/{project}/locations/{location}/schemaRegistries/{schema_registry}/subjects/{subject}/versions/{version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'managedkafka.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\ManagedKafka\SchemaRegistry\V1\ManagedSchemaRegistryClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ManagedSchemaRegistryClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Check compatibility of a schema with all versions or a specific version of
     * a subject.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::checkCompatibilityAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/check_compatibility.php
     *
     * @param CheckCompatibilityRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CheckCompatibilityResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function checkCompatibility(
        CheckCompatibilityRequest $request,
        array $callOptions = []
    ): CheckCompatibilityResponse {
        return $this->startApiCall('CheckCompatibility', $request, $callOptions)->wait();
    }

    /**
     * Create a schema registry instance.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::createSchemaRegistryAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/create_schema_registry.php
     *
     * @param CreateSchemaRegistryRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaRegistry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSchemaRegistry(CreateSchemaRegistryRequest $request, array $callOptions = []): SchemaRegistry
    {
        return $this->startApiCall('CreateSchemaRegistry', $request, $callOptions)->wait();
    }

    /**
     * Register a new version under a given subject with the given schema.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::createVersionAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/create_version.php
     *
     * @param CreateVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CreateVersionResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVersion(CreateVersionRequest $request, array $callOptions = []): CreateVersionResponse
    {
        return $this->startApiCall('CreateVersion', $request, $callOptions)->wait();
    }

    /**
     * Delete schema config for a subject.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::deleteSchemaConfigAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/delete_schema_config.php
     *
     * @param DeleteSchemaConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSchemaConfig(DeleteSchemaConfigRequest $request, array $callOptions = []): SchemaConfig
    {
        return $this->startApiCall('DeleteSchemaConfig', $request, $callOptions)->wait();
    }

    /**
     * Delete schema mode for a subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::deleteSchemaModeAsync()}
     * .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/delete_schema_mode.php
     *
     * @param DeleteSchemaModeRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaMode
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSchemaMode(DeleteSchemaModeRequest $request, array $callOptions = []): SchemaMode
    {
        return $this->startApiCall('DeleteSchemaMode', $request, $callOptions)->wait();
    }

    /**
     * Delete a schema registry instance.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::deleteSchemaRegistryAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/delete_schema_registry.php
     *
     * @param DeleteSchemaRegistryRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSchemaRegistry(DeleteSchemaRegistryRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSchemaRegistry', $request, $callOptions)->wait();
    }

    /**
     * Delete a subject.
     * The response will be an array of versions of the deleted subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::deleteSubjectAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/delete_subject.php
     *
     * @param DeleteSubjectRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSubject(DeleteSubjectRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('DeleteSubject', $request, $callOptions)->wait();
    }

    /**
     * Delete a version of a subject.
     * The response will be the deleted version id.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::deleteVersionAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/delete_version.php
     *
     * @param DeleteVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVersion(DeleteVersionRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('DeleteVersion', $request, $callOptions)->wait();
    }

    /**
     * Get the context.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getContextAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_context.php
     *
     * @param GetContextRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Context
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getContext(GetContextRequest $request, array $callOptions = []): Context
    {
        return $this->startApiCall('GetContext', $request, $callOptions)->wait();
    }

    /**
     * Get the schema string for the given schema id.
     * The response will be the schema string.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getRawSchemaAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_raw_schema.php
     *
     * @param GetSchemaRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRawSchema(GetSchemaRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('GetRawSchema', $request, $callOptions)->wait();
    }

    /**
     * Get the schema string only for a version of a subject.
     * The response will be the schema string.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::getRawSchemaVersionAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_raw_schema_version.php
     *
     * @param GetVersionRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRawSchemaVersion(GetVersionRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('GetRawSchemaVersion', $request, $callOptions)->wait();
    }

    /**
     * Get the schema for the given schema id.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getSchemaAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_schema.php
     *
     * @param GetSchemaRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Schema
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSchema(GetSchemaRequest $request, array $callOptions = []): Schema
    {
        return $this->startApiCall('GetSchema', $request, $callOptions)->wait();
    }

    /**
     * Get schema config at global level or for a subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getSchemaConfigAsync()}
     * .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_schema_config.php
     *
     * @param GetSchemaConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSchemaConfig(GetSchemaConfigRequest $request, array $callOptions = []): SchemaConfig
    {
        return $this->startApiCall('GetSchemaConfig', $request, $callOptions)->wait();
    }

    /**
     * Get mode at global level or for a subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getSchemaModeAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_schema_mode.php
     *
     * @param GetSchemaModeRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaMode
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSchemaMode(GetSchemaModeRequest $request, array $callOptions = []): SchemaMode
    {
        return $this->startApiCall('GetSchemaMode', $request, $callOptions)->wait();
    }

    /**
     * Get the schema registry instance.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::getSchemaRegistryAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_schema_registry.php
     *
     * @param GetSchemaRegistryRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaRegistry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSchemaRegistry(GetSchemaRegistryRequest $request, array $callOptions = []): SchemaRegistry
    {
        return $this->startApiCall('GetSchemaRegistry', $request, $callOptions)->wait();
    }

    /**
     * Get a versioned schema (schema with subject/version) of a subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getVersionAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_version.php
     *
     * @param GetVersionRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVersion(GetVersionRequest $request, array $callOptions = []): SchemaVersion
    {
        return $this->startApiCall('GetVersion', $request, $callOptions)->wait();
    }

    /**
     * List contexts for a schema registry.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::listContextsAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_contexts.php
     *
     * @param ListContextsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listContexts(ListContextsRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListContexts', $request, $callOptions)->wait();
    }

    /**
     * Get a list of IDs of schemas that reference the schema with the given
     * subject and version.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::listReferencedSchemasAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_referenced_schemas.php
     *
     * @param ListReferencedSchemasRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReferencedSchemas(ListReferencedSchemasRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListReferencedSchemas', $request, $callOptions)->wait();
    }

    /**
     * List schema registries.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::listSchemaRegistriesAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_schema_registries.php
     *
     * @param ListSchemaRegistriesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListSchemaRegistriesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSchemaRegistries(
        ListSchemaRegistriesRequest $request,
        array $callOptions = []
    ): ListSchemaRegistriesResponse {
        return $this->startApiCall('ListSchemaRegistries', $request, $callOptions)->wait();
    }

    /**
     * List the supported schema types.
     * The response will be an array of schema types.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::listSchemaTypesAsync()}
     * .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_schema_types.php
     *
     * @param ListSchemaTypesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSchemaTypes(ListSchemaTypesRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListSchemaTypes', $request, $callOptions)->wait();
    }

    /**
     * List the schema versions for the given schema id.
     * The response will be an array of subject-version pairs as:
     * [{"subject":"subject1", "version":1}, {"subject":"subject2", "version":2}].
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::listSchemaVersionsAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_schema_versions.php
     *
     * @param ListSchemaVersionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSchemaVersions(ListSchemaVersionsRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListSchemaVersions', $request, $callOptions)->wait();
    }

    /**
     * List subjects in the schema registry.
     * The response will be an array of subject names.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::listSubjectsAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_subjects.php
     *
     * @param ListSubjectsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSubjects(ListSubjectsRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListSubjects', $request, $callOptions)->wait();
    }

    /**
     * List subjects which reference a particular schema id.
     * The response will be an array of subject names.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::listSubjectsBySchemaIdAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_subjects_by_schema_id.php
     *
     * @param ListSubjectsBySchemaIdRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSubjectsBySchemaId(ListSubjectsBySchemaIdRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListSubjectsBySchemaId', $request, $callOptions)->wait();
    }

    /**
     * Get all versions of a subject.
     * The response will be an array of versions of the subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::listVersionsAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_versions.php
     *
     * @param ListVersionsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HttpBody
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVersions(ListVersionsRequest $request, array $callOptions = []): HttpBody
    {
        return $this->startApiCall('ListVersions', $request, $callOptions)->wait();
    }

    /**
     * Lookup a schema under the specified subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::lookupVersionAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/lookup_version.php
     *
     * @param LookupVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupVersion(LookupVersionRequest $request, array $callOptions = []): SchemaVersion
    {
        return $this->startApiCall('LookupVersion', $request, $callOptions)->wait();
    }

    /**
     * Update config at global level or for a subject.
     * Creates a SchemaSubject-level SchemaConfig if it does not exist.
     *
     * The async variant is
     * {@see ManagedSchemaRegistryClient::updateSchemaConfigAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/update_schema_config.php
     *
     * @param UpdateSchemaConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSchemaConfig(UpdateSchemaConfigRequest $request, array $callOptions = []): SchemaConfig
    {
        return $this->startApiCall('UpdateSchemaConfig', $request, $callOptions)->wait();
    }

    /**
     * Update mode at global level or for a subject.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::updateSchemaModeAsync()}
     * .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/update_schema_mode.php
     *
     * @param UpdateSchemaModeRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SchemaMode
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSchemaMode(UpdateSchemaModeRequest $request, array $callOptions = []): SchemaMode
    {
        return $this->startApiCall('UpdateSchemaMode', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::getLocationAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ManagedSchemaRegistryClient::listLocationsAsync()} .
     *
     * @example samples/V1/ManagedSchemaRegistryClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
