<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/functions/v2/functions.proto

namespace Google\Cloud\Functions\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Location of the source in an archive file in Google Cloud Storage.
 *
 * Generated from protobuf message <code>google.cloud.functions.v2.StorageSource</code>
 */
class StorageSource extends \Google\Protobuf\Internal\Message
{
    /**
     * Google Cloud Storage bucket containing the source (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Generated from protobuf field <code>string bucket = 1;</code>
     */
    protected $bucket = '';
    /**
     * Google Cloud Storage object containing the source.
     * This object must be a gzipped archive file (`.tar.gz`) containing source to
     * build.
     *
     * Generated from protobuf field <code>string object = 2;</code>
     */
    protected $object = '';
    /**
     * Google Cloud Storage generation for the object. If the generation is
     * omitted, the latest generation will be used.
     *
     * Generated from protobuf field <code>int64 generation = 3;</code>
     */
    protected $generation = 0;
    /**
     * When the specified storage bucket is a 1st gen function uploard url bucket,
     * this field should be set as the generated upload url for 1st gen
     * deployment.
     *
     * Generated from protobuf field <code>string source_upload_url = 4;</code>
     */
    protected $source_upload_url = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $bucket
     *           Google Cloud Storage bucket containing the source (see
     *           [Bucket Name
     *           Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *     @type string $object
     *           Google Cloud Storage object containing the source.
     *           This object must be a gzipped archive file (`.tar.gz`) containing source to
     *           build.
     *     @type int|string $generation
     *           Google Cloud Storage generation for the object. If the generation is
     *           omitted, the latest generation will be used.
     *     @type string $source_upload_url
     *           When the specified storage bucket is a 1st gen function uploard url bucket,
     *           this field should be set as the generated upload url for 1st gen
     *           deployment.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Functions\V2\Functions::initOnce();
        parent::__construct($data);
    }

    /**
     * Google Cloud Storage bucket containing the source (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Generated from protobuf field <code>string bucket = 1;</code>
     * @return string
     */
    public function getBucket()
    {
        return $this->bucket;
    }

    /**
     * Google Cloud Storage bucket containing the source (see
     * [Bucket Name
     * Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
     *
     * Generated from protobuf field <code>string bucket = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setBucket($var)
    {
        GPBUtil::checkString($var, True);
        $this->bucket = $var;

        return $this;
    }

    /**
     * Google Cloud Storage object containing the source.
     * This object must be a gzipped archive file (`.tar.gz`) containing source to
     * build.
     *
     * Generated from protobuf field <code>string object = 2;</code>
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * Google Cloud Storage object containing the source.
     * This object must be a gzipped archive file (`.tar.gz`) containing source to
     * build.
     *
     * Generated from protobuf field <code>string object = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setObject($var)
    {
        GPBUtil::checkString($var, True);
        $this->object = $var;

        return $this;
    }

    /**
     * Google Cloud Storage generation for the object. If the generation is
     * omitted, the latest generation will be used.
     *
     * Generated from protobuf field <code>int64 generation = 3;</code>
     * @return int|string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * Google Cloud Storage generation for the object. If the generation is
     * omitted, the latest generation will be used.
     *
     * Generated from protobuf field <code>int64 generation = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->generation = $var;

        return $this;
    }

    /**
     * When the specified storage bucket is a 1st gen function uploard url bucket,
     * this field should be set as the generated upload url for 1st gen
     * deployment.
     *
     * Generated from protobuf field <code>string source_upload_url = 4;</code>
     * @return string
     */
    public function getSourceUploadUrl()
    {
        return $this->source_upload_url;
    }

    /**
     * When the specified storage bucket is a 1st gen function uploard url bucket,
     * this field should be set as the generated upload url for 1st gen
     * deployment.
     *
     * Generated from protobuf field <code>string source_upload_url = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceUploadUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_upload_url = $var;

        return $this;
    }

}

