<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/engine.proto

namespace Google\Cloud\DiscoveryEngine\V1\Engine;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Additional config specs for a Media Recommendation engine.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig</code>
 */
class MediaRecommendationEngineConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The type of engine. e.g., `recommended-for-you`.
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     *
     * Generated from protobuf field <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $type = '';
    /**
     * The optimization objective. e.g., `cvr`.
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     * Currently supported
     * values: `ctr`, `cvr`.
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     * `recommended-for-you` => `ctr`
     * `others-you-may-like` => `ctr`
     *
     * Generated from protobuf field <code>string optimization_objective = 2;</code>
     */
    protected $optimization_objective = '';
    /**
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;</code>
     */
    protected $optimization_objective_config = null;
    /**
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;</code>
     */
    protected $training_state = 0;
    /**
     * Optional. Additional engine features config.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $engine_features_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $type
     *           Required. The type of engine. e.g., `recommended-for-you`.
     *           This field together with
     *           [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     *           describe engine metadata to use to control engine training and serving.
     *           Currently supported values: `recommended-for-you`, `others-you-may-like`,
     *           `more-like-this`, `most-popular-items`.
     *     @type string $optimization_objective
     *           The optimization objective. e.g., `cvr`.
     *           This field together with
     *           [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     *           describe engine metadata to use to control engine training and serving.
     *           Currently supported
     *           values: `ctr`, `cvr`.
     *            If not specified, we choose default based on engine type.
     *           Default depends on type of recommendation:
     *           `recommended-for-you` => `ctr`
     *           `others-you-may-like` => `ctr`
     *     @type \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\OptimizationObjectiveConfig $optimization_objective_config
     *           Name and value of the custom threshold for cvr optimization_objective.
     *           For target_field `watch-time`, target_field_value must be an integer
     *           value indicating the media progress time in seconds between (0, 86400]
     *           (excludes 0, includes 86400) (e.g., 90).
     *           For target_field `watch-percentage`, the target_field_value must be a
     *           valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     *           0.5).
     *     @type int $training_state
     *           The training state that the engine is in (e.g.
     *           `TRAINING` or `PAUSED`).
     *           Since part of the cost of running the service
     *           is frequency of training - this can be used to determine when to train
     *           engine in order to control cost. If not specified: the default value for
     *           `CreateEngine` method is `TRAINING`. The default value for
     *           `UpdateEngine` method is to keep the state the same as before.
     *     @type \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\EngineFeaturesConfig $engine_features_config
     *           Optional. Additional engine features config.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\Engine::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The type of engine. e.g., `recommended-for-you`.
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     *
     * Generated from protobuf field <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Required. The type of engine. e.g., `recommended-for-you`.
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     *
     * Generated from protobuf field <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The optimization objective. e.g., `cvr`.
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     * Currently supported
     * values: `ctr`, `cvr`.
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     * `recommended-for-you` => `ctr`
     * `others-you-may-like` => `ctr`
     *
     * Generated from protobuf field <code>string optimization_objective = 2;</code>
     * @return string
     */
    public function getOptimizationObjective()
    {
        return $this->optimization_objective;
    }

    /**
     * The optimization objective. e.g., `cvr`.
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     * Currently supported
     * values: `ctr`, `cvr`.
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     * `recommended-for-you` => `ctr`
     * `others-you-may-like` => `ctr`
     *
     * Generated from protobuf field <code>string optimization_objective = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setOptimizationObjective($var)
    {
        GPBUtil::checkString($var, True);
        $this->optimization_objective = $var;

        return $this;
    }

    /**
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\OptimizationObjectiveConfig|null
     */
    public function getOptimizationObjectiveConfig()
    {
        return $this->optimization_objective_config;
    }

    public function hasOptimizationObjectiveConfig()
    {
        return isset($this->optimization_objective_config);
    }

    public function clearOptimizationObjectiveConfig()
    {
        unset($this->optimization_objective_config);
    }

    /**
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\OptimizationObjectiveConfig $var
     * @return $this
     */
    public function setOptimizationObjectiveConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\OptimizationObjectiveConfig::class);
        $this->optimization_objective_config = $var;

        return $this;
    }

    /**
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;</code>
     * @return int
     */
    public function getTrainingState()
    {
        return $this->training_state;
    }

    /**
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setTrainingState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\TrainingState::class);
        $this->training_state = $var;

        return $this;
    }

    /**
     * Optional. Additional engine features config.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\EngineFeaturesConfig|null
     */
    public function getEngineFeaturesConfig()
    {
        return $this->engine_features_config;
    }

    public function hasEngineFeaturesConfig()
    {
        return isset($this->engine_features_config);
    }

    public function clearEngineFeaturesConfig()
    {
        unset($this->engine_features_config);
    }

    /**
     * Optional. Additional engine features config.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\EngineFeaturesConfig $var
     * @return $this
     */
    public function setEngineFeaturesConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\Engine\MediaRecommendationEngineConfig\EngineFeaturesConfig::class);
        $this->engine_features_config = $var;

        return $this;
    }

}


