<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/identity_mapping_store_service.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [IdentityMappingStoreService.CreateIdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStoreService.CreateIdentityMappingStore]
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest</code>
 */
class CreateIdentityMappingStoreRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The ID of the Identity Mapping Store to create.
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     *
     * Generated from protobuf field <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $identity_mapping_store_id = '';
    /**
     * Required. The Identity Mapping Store to create.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $identity_mapping_store = null;
    protected $cmek_options;

    /**
     * @param string                                                $parent                 Required. The parent collection resource name, such as
     *                                                                                      `projects/{project}/locations/{location}`. Please see
     *                                                                                      {@see IdentityMappingStoreServiceClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\DiscoveryEngine\V1\IdentityMappingStore $identityMappingStore   Required. The Identity Mapping Store to create.
     * @param string                                                $identityMappingStoreId Required. The ID of the Identity Mapping Store to create.
     *
     *                                                                                      The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *                                                                                      (_), and hyphens (-). The maximum length is 63 characters.
     *
     * @return \Google\Cloud\DiscoveryEngine\V1\CreateIdentityMappingStoreRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\DiscoveryEngine\V1\IdentityMappingStore $identityMappingStore, string $identityMappingStoreId): self
    {
        return (new self())
            ->setParent($parent)
            ->setIdentityMappingStore($identityMappingStore)
            ->setIdentityMappingStoreId($identityMappingStoreId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $cmek_config_name
     *           Resource name of the CmekConfig to use for protecting this Identity
     *           Mapping Store.
     *     @type bool $disable_cmek
     *           Identity Mapping Store without CMEK protections. If a default CmekConfig
     *           is set for the project, setting this field will override the default
     *           CmekConfig as well.
     *     @type string $parent
     *           Required. The parent collection resource name, such as
     *           `projects/{project}/locations/{location}`.
     *     @type string $identity_mapping_store_id
     *           Required. The ID of the Identity Mapping Store to create.
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     *           (_), and hyphens (-). The maximum length is 63 characters.
     *     @type \Google\Cloud\DiscoveryEngine\V1\IdentityMappingStore $identity_mapping_store
     *           Required. The Identity Mapping Store to create.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\IdentityMappingStoreService::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     *
     * Generated from protobuf field <code>string cmek_config_name = 5 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCmekConfigName()
    {
        return $this->readOneof(5);
    }

    public function hasCmekConfigName()
    {
        return $this->hasOneof(5);
    }

    /**
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     *
     * Generated from protobuf field <code>string cmek_config_name = 5 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCmekConfigName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Identity Mapping Store without CMEK protections. If a default CmekConfig
     * is set for the project, setting this field will override the default
     * CmekConfig as well.
     *
     * Generated from protobuf field <code>bool disable_cmek = 6;</code>
     * @return bool
     */
    public function getDisableCmek()
    {
        return $this->readOneof(6);
    }

    public function hasDisableCmek()
    {
        return $this->hasOneof(6);
    }

    /**
     * Identity Mapping Store without CMEK protections. If a default CmekConfig
     * is set for the project, setting this field will override the default
     * CmekConfig as well.
     *
     * Generated from protobuf field <code>bool disable_cmek = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableCmek($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The ID of the Identity Mapping Store to create.
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     *
     * Generated from protobuf field <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getIdentityMappingStoreId()
    {
        return $this->identity_mapping_store_id;
    }

    /**
     * Required. The ID of the Identity Mapping Store to create.
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     *
     * Generated from protobuf field <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setIdentityMappingStoreId($var)
    {
        GPBUtil::checkString($var, True);
        $this->identity_mapping_store_id = $var;

        return $this;
    }

    /**
     * Required. The Identity Mapping Store to create.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DiscoveryEngine\V1\IdentityMappingStore|null
     */
    public function getIdentityMappingStore()
    {
        return $this->identity_mapping_store;
    }

    public function hasIdentityMappingStore()
    {
        return isset($this->identity_mapping_store);
    }

    public function clearIdentityMappingStore()
    {
        unset($this->identity_mapping_store);
    }

    /**
     * Required. The Identity Mapping Store to create.
     *
     * Generated from protobuf field <code>.google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DiscoveryEngine\V1\IdentityMappingStore $var
     * @return $this
     */
    public function setIdentityMappingStore($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DiscoveryEngine\V1\IdentityMappingStore::class);
        $this->identity_mapping_store = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getCmekOptions()
    {
        return $this->whichOneof("cmek_options");
    }

}

